/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.PdfDecoderServer;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.ColorSpaceConvertor;

public class ConvertPagesToHiResImages
extends BaseImageExtraction {
    private float JPEGcompression = -1.0f;

    public static void main(String[] stringArray) throws PdfException {
        if (stringArray != null && stringArray.length > 2) {
            try {
                ConvertPagesToHiResImages.writeAllPagesAsHiResImagesToDir(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (PdfException pdfException) {
                throw new RuntimeException(pdfException.getMessage());
            }
        } else {
            System.out.println("wrong arguments entered");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    public static void writeAllPagesAsHiResImagesToDir(String string, String string2, String string3) throws PdfException {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING, 2);
        hashMap.put(JPedalSettings.EXTRACT_AT_PAGE_SIZE, new String[]{"2000", "1600"});
        hashMap.put(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE, Boolean.TRUE);
        PdfDecoderServer.modifyJPedalParameters(hashMap);
        ConvertPagesToHiResImages convertPagesToHiResImages = new ConvertPagesToHiResImages(string);
        convertPagesToHiResImages.setup(string3, string2);
        convertPagesToHiResImages.processFiles(string);
        convertPagesToHiResImages.closePDFfile();
    }

    public ConvertPagesToHiResImages(String string) {
        super(string);
        this.init();
    }

    public ConvertPagesToHiResImages(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        block8: {
            System.out.println(string);
            System.out.println(this.output_dir);
            if (!this.openPDFFile()) break block8;
            String string2 = System.getProperty("org.jpedal.separation");
            if (string2 != null) {
                Object[] objectArray = new Object[]{7, "", Boolean.FALSE};
                if (string2.equals("all")) {
                    objectArray = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int n = objectArray.length;
                for (int i = 0; i < n; i += 3) {
                    this.decode_pdf.setRenderMode((Integer)objectArray[i]);
                    try {
                        this.extractPagesAsImages(this.output_dir, this.imageType, "_" + objectArray[i + 1], (Boolean)objectArray[i + 2]);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new PdfException(iOException.getMessage());
                    }
                }
            } else {
                try {
                    this.extractPagesAsImages(this.output_dir, this.imageType, "", false);
                }
                catch (IOException iOException) {
                    throw new PdfException(iOException.getMessage());
                }
            }
        }
    }

    private void extractPagesAsImages(String string, String string2, String string3, boolean bl) throws PdfException, IOException {
        File file = new File(this.output_dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        int n = this.getPageCount();
        BufferedImage[] bufferedImageArray = new BufferedImage[1 + (n - 1)];
        String string4 = System.getProperty("org.jpedal.multipage_tiff");
        boolean bl2 = string4 != null && string4.equalsIgnoreCase("true");
        String string5 = System.getProperty("org.jpedal.compress_tiff");
        boolean bl3 = string5 != null && string5.equalsIgnoreCase("true");
        String string6 = System.getProperty("org.jpedal.compression_jpeg");
        if (string6 != null) {
            try {
                this.JPEGcompression = Float.parseFloat(string6);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
            throw new RuntimeException("JPEG compression is not currently implemented. Please do not use");
        }
        String string7 = System.getProperty("org.jpedal.jpeg_dpi");
        if (string7 != null) {
            throw new RuntimeException("JPEG dpi is not currently implemented. Please do not use");
        }
        for (int i = 1; i < n + 1; ++i) {
            Object object;
            int n2;
            Object object2;
            String string8;
            BufferedImage bufferedImage = this.getPageAsHiResImage(i, bl, null);
            this.decode_pdf.flushObjectValues(true);
            if (string2.equals("jpg")) {
                bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
            }
            if (bl2) {
                string8 = string + "allPages" + string3 + '.' + string2;
            } else {
                object2 = String.valueOf(i);
                String string9 = String.valueOf(n);
                n2 = string9.length() - ((String)object2).length();
                for (int j = 0; j < n2; ++j) {
                    object2 = '0' + (String)object2;
                }
                string8 = string + "page" + (String)object2 + string3 + '.' + string2;
            }
            object2 = this.decode_pdf.getPageInfo(1);
            int n3 = n2 = object2 != null ? 1 : 0;
            while (object2 != null && object2.hasNext()) {
                int n4 = (Integer)object2.next();
                if (n4 == 1568372915 || n4 == 391471749) continue;
                n2 = 0;
            }
            if (n2 != 0) {
                BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
                bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
                bufferedImage = bufferedImage2;
            }
            if (bl2) {
                bufferedImageArray[i - 1] = bufferedImage;
            }
            if (bufferedImage == null) continue;
            if (string2.startsWith("tif")) {
                File file2;
                object = new TiffEncoder();
                ((TiffEncoder)object).setCompressed(bl3);
                if (bl2) {
                    file2 = new File(string8);
                    if (i == 1 && file2.exists()) {
                        file2.delete();
                        file2.createNewFile();
                    }
                    ((TiffEncoder)object).append(bufferedImage, string8);
                } else {
                    file2 = new File(string8);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    ((TiffEncoder)object).write(bufferedImage, bufferedOutputStream);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
            } else {
                object = new BufferedOutputStream(new FileOutputStream(new File(string8)));
                ImageIO.write((RenderedImage)bufferedImage, string2, (OutputStream)object);
                ((BufferedOutputStream)object).flush();
                ((FilterOutputStream)object).close();
            }
            bufferedImage.flush();
        }
    }

    public BufferedImage getPageAsHiResImage(int n, boolean bl, Map map) throws PdfException {
        return this.decode_pdf.getPageAsHiRes(n, map, bl);
    }

    private void setup(String string, String string2) {
        if (!string2.endsWith(separator)) {
            string2 = string2 + separator;
        }
        this.imageType = string;
        this.output_dir = string2;
    }

    @Override
    void init() {
        FontMappings.setFontReplacements();
        this.type = BaseImageExtraction.ExtractTypes.RASTERIZED_PAGE;
        super.init();
    }
}

