/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.objects.PdfFileInformation;

public class ConvertPagesToImages
extends BaseImageExtraction {
    boolean isTransparent;
    private float pageScaling = 1.33f;
    private final String[] ocr = new String[]{"TeleForm"};
    public static boolean isTest;
    private float JPEGcompression = -1.0f;

    public static void writeAllPagesAsImagesToDir(String string, String string2, String string3, float f) throws PdfException {
        ConvertPagesToImages convertPagesToImages = new ConvertPagesToImages(string);
        convertPagesToImages.setup(string3, string2, f);
        convertPagesToImages.processFiles(string);
        convertPagesToImages.closePDFfile();
    }

    void setup(String string, String string2, float f) throws PdfException, RuntimeException {
        if (!string2.endsWith(separator)) {
            string2 = string2 + separator;
        }
        this.imageType = string;
        this.output_dir = string2;
        this.pageScaling = f;
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
    }

    @Override
    void processFiles(String string) throws PdfException, RuntimeException {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("File " + file + " not found");
        }
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            try {
                this.decodeFile(string);
            }
            catch (Exception exception) {
                System.err.println("8.Exception " + exception + " in pdf code in " + string);
            }
        } else {
            String[] stringArray = null;
            if (!string.endsWith(separator)) {
                string = string + separator;
            }
            try {
                File file2 = new File(string);
                if (!file2.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                } else {
                    stringArray = file2.list();
                }
            }
            catch (Exception exception) {
                throw new PdfException("Exception trying to access file " + exception.getMessage());
            }
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!string2.toLowerCase().endsWith(".pdf")) continue;
                    try {
                        this.decodeFile(string + string2);
                    }
                    catch (Exception exception) {
                        System.err.println("8.Exception " + exception + " in pdf code in " + string);
                    }
                }
            }
        }
    }

    public ConvertPagesToImages(String string) {
        super(string);
        this.init();
    }

    public ConvertPagesToImages(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        String string2 = "demo";
        int n = string.lastIndexOf(separator);
        if (n == -1) {
            n = string.lastIndexOf(47);
        }
        if (n != -1) {
            string2 = string.substring(n + 1, string.length() - 4);
        } else if (!isTest && string.toLowerCase().endsWith(".pdf")) {
            string2 = string.substring(0, string.length() - 4);
        }
        if (string2.startsWith(".")) {
            return;
        }
        if (this.output_dir == null) {
            this.output_dir = this.user_dir + "thumbnails" + separator;
        }
        this.decode_pdf.setExtractionMode(0, this.pageScaling);
        this.fileName = string;
        if (this.openPDFFile()) {
            String string3;
            File file = new File(this.output_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((string3 = System.getProperty("org.jpedal.separation")) != null) {
                Object[] objectArray = new Object[]{7, "", Boolean.FALSE};
                if (string3.equals("all")) {
                    objectArray = new Object[]{2, "image_and_shapes", Boolean.FALSE, 18, "image_without_shapes", Boolean.FALSE, 1, "text_and_shapes", Boolean.TRUE, 7, "all", Boolean.FALSE, 17, "text_without_shapes", Boolean.TRUE};
                }
                int n2 = objectArray.length;
                for (int i = 0; i < n2; i += 3) {
                    this.decode_pdf.setRenderMode((Integer)objectArray[i]);
                    this.extractPagesAsImages(string, this.output_dir, string2 + '_' + objectArray[i + 1], (Boolean)objectArray[i + 2]);
                }
            } else {
                this.extractPagesAsImages(string, this.output_dir, string2, this.isTransparent);
            }
        }
        this.closePDFfile();
    }

    private void extractPagesAsImages(String string, String string2, String string3, boolean bl) {
        String string4;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        boolean bl2 = (string4 = System.getProperty("org.jpedal.multipage_tiff")) != null && string4.equalsIgnoreCase("true");
        String string5 = System.getProperty("org.jpedal.compression_jpeg");
        if (string5 != null) {
            try {
                this.JPEGcompression = Float.parseFloat(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.JPEGcompression < 0.0f || this.JPEGcompression > 1.0f) {
                throw new RuntimeException("Invalid value for JPEG compression - must be between 0 and 1");
            }
        }
        String string6 = System.getProperty("org.jpedal.compress_tiff");
        String string7 = System.getProperty("org.jpedal.jpeg_dpi");
        boolean bl3 = string6 != null && string6.equalsIgnoreCase("true");
        int n = this.getPageCount();
        if (n > 10 && isTest) {
            n = 10;
        }
        try {
            for (int i = 1; i < n + 1; ++i) {
                this.getPage(string2, string3, bl, bl2, string5, string7, bl3, 1, n, i);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception " + exception.getMessage() + " with thumbnails on File=" + string);
        }
    }

    private void getPage(String string, String string2, boolean bl, boolean bl2, String string3, String string4, boolean bl3, int n, int n2, int n3) throws PdfException, IOException {
        Object object;
        int n4;
        int n5;
        Object object2;
        String string5 = String.valueOf(n3);
        String string6 = String.valueOf(n2);
        int n6 = string6.length() - string5.length();
        for (int i = 0; i < n6; ++i) {
            string5 = '0' + string5;
        }
        String string7 = bl2 ? string2 : string2 + "_page_" + string5;
        PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
        String[] stringArray = pdfFileInformation.getFieldValues();
        String[] stringArray2 = PdfFileInformation.getFieldNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].equals("Creator")) continue;
            object2 = this.ocr;
            n5 = ((String[])object2).length;
            for (n4 = 0; n4 < n5; ++n4) {
                object = object2[n4];
                if (!stringArray[i].equals(object)) continue;
                this.decode_pdf.setRenderMode(2);
            }
        }
        Object object3 = this.getPageAsImage(n3, bl);
        if (bl && object3 != null && this.imageType.toLowerCase().startsWith("jp")) {
            object2 = object3;
            n5 = ((BufferedImage)object2).getWidth();
            n4 = ((BufferedImage)object2).getHeight();
            object3 = new BufferedImage(n5, n4, 1);
            object = ((BufferedImage)object3).createGraphics();
            ((Graphics2D)object).setPaint(Color.WHITE);
            ((Graphics)object).fillRect(0, 0, n5, n4);
            ((Graphics)object).drawImage((Image)object2, 0, 0, null);
        }
        int n7 = n4 = (object2 = this.decode_pdf.getPageInfo(1)) != null ? 1 : 0;
        while (object2 != null && object2.hasNext()) {
            n5 = (Integer)object2.next();
            if (n5 == 1568372915 || n5 == 391471749) continue;
            n4 = 0;
        }
        if (n4 != 0) {
            object = new BufferedImage(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight(), 10);
            ((BufferedImage)object).getGraphics().drawImage((Image)object3, 0, 0, null);
            object3 = object;
        }
        if (object3 != null) {
            String string8;
            Object object4;
            Image image;
            int n8;
            object = System.getProperty("maxDimension");
            int n9 = -1;
            if (object != null) {
                n9 = Integer.parseInt((String)object);
            }
            if (n9 != -1) {
                int n10 = ((BufferedImage)object3).getWidth();
                n8 = ((BufferedImage)object3).getHeight();
                if (n9 != -1 && (n10 > n9 || n8 > n9)) {
                    if (n10 > n8) {
                        n10 = n9;
                        image = ((Image)object3).getScaledInstance(n10, -1, 4);
                    } else {
                        n8 = n9;
                        image = ((Image)object3).getScaledInstance(-1, n8, 4);
                    }
                } else {
                    image = ((Image)object3).getScaledInstance(n10, -1, 4);
                }
                object3 = this.imageType.toLowerCase().startsWith("jp") ? new BufferedImage(image.getWidth(null), image.getHeight(null), 1) : new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                object4 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object4).drawImage(image, 0, 0, null);
            }
            if ((string8 = System.getProperty("org.jpedal.imageType")) != null) {
                if (ConvertPagesToImages.isNumber(string8)) {
                    n8 = Integer.parseInt(string8);
                    if (n8 > -1 && n8 < 14) {
                        image = new BufferedImage(((BufferedImage)object3).getWidth(), ((BufferedImage)object3).getHeight(), n8);
                        object4 = ((BufferedImage)image).createGraphics();
                        ((Graphics2D)object4).drawImage((Image)object3, null, null);
                        object3 = image;
                    } else {
                        System.err.println("Image Type is not valid. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                    }
                } else {
                    System.err.println("Image Type provided is not an Integer. Value should be a digit between 0 - 13 based on the BufferedImage TYPE variables.");
                }
            }
            if (this.imageType.toLowerCase().startsWith("tif")) {
                boolean bl4 = n3 == n;
                object4 = new TiffEncoder();
                ((TiffEncoder)object4).setCompressed(bl3);
                if (bl2) {
                    String string9 = string + string7 + ".tif";
                    File file = new File(string9);
                    if (bl4 && file.exists()) {
                        file.delete();
                        file.createNewFile();
                    }
                    ((TiffEncoder)object4).append((BufferedImage)object3, string9);
                } else {
                    String string10 = string + string5 + string7 + ".tif";
                    File file = new File(string10);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    ((TiffEncoder)object4).write((BufferedImage)object3, bufferedOutputStream);
                    bufferedOutputStream.flush();
                    bufferedOutputStream.close();
                }
            } else {
                this.decode_pdf.getObjectStore().saveStoredImage(string + string7, (BufferedImage)object3, true, false, this.imageType);
            }
        }
        this.decode_pdf.flushObjectValues(true);
    }

    public static void main(String[] stringArray) {
        boolean bl;
        System.out.println("Simple demo to extract images from a page");
        int n = stringArray.length;
        boolean bl2 = bl = n != 2;
        if (bl) {
            if (n > 0) {
                System.out.println("wrong arguments entered");
                System.out.println("2 values expected - file and output location for images");
                StringBuilder stringBuilder = new StringBuilder();
                for (String string : stringArray) {
                    stringBuilder.append(string).append('\n');
                }
                System.out.println("you entered:\n" + stringBuilder + "as the arguments");
            }
        } else {
            try {
                ConvertPagesToImages.writeAllPagesAsImagesToDir(stringArray[0], stringArray[1], "png", 1.33f);
            }
            catch (PdfException pdfException) {
                throw new RuntimeException(pdfException.getMessage());
            }
        }
    }

    private static boolean isNumber(String string) {
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c < '0' | c > '9')) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    @Override
    void init() {
        if (!isTest) {
            FontMappings.setFontReplacements();
        }
        this.type = BaseImageExtraction.ExtractTypes.RASTERIZED_PAGE;
        super.init();
        this.decode_pdf.setExtractionMode(0, this.pageScaling);
    }

    public BufferedImage getPageAsImage(int n, boolean bl) throws PdfException {
        if (!bl) {
            return this.decode_pdf.getPageAsImage(n);
        }
        return this.decode_pdf.getPageAsTransparentImage(n);
    }
}

