/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jpedal.color.ColorSpaces;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractClippedImages
extends BaseImageExtraction {
    private static String inputDir = "";
    private static int outputCount;
    private static float[] outputSizes;
    private static String[] outputDirectories;
    private static final Color backgroundColor;

    public ExtractClippedImages(String string) {
        super(string);
        this.init();
    }

    public ExtractClippedImages(byte[] byArray) {
        super(byArray);
        this.init();
    }

    public BufferedImage getClippedImage(int n, int n2) throws PdfException {
        return this.getClippedImage(n, this.getImageName(n, n2));
    }

    public BufferedImage getClippedImage(int n, String string) throws PdfException {
        this.selectPage(n);
        return this.decode_pdf.getObjectStore().loadStoredImage("CLIP_" + string);
    }

    public static void writeAllClippedImagesToDirs(String string, String string2, String string3, String[] stringArray) throws PdfException {
        ExtractClippedImages extractClippedImages = new ExtractClippedImages(string);
        extractClippedImages.setup(string2, string3, stringArray);
        extractClippedImages.processFiles(string);
        extractClippedImages.closePDFfile();
    }

    private void setup(String string, String string2, String[] stringArray) throws PdfException {
        if (!string.endsWith(separator)) {
            string = string + separator;
        }
        this.imageType = string2;
        outputCount = stringArray.length / 2;
        outputSizes = new float[outputCount];
        outputDirectories = new String[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            try {
                ExtractClippedImages.outputSizes[i] = Float.parseFloat(stringArray[i * 2]);
            }
            catch (Exception exception) {
                throw new PdfException("Exception " + exception + " reading integer " + stringArray[i * 2]);
            }
            try {
                File file;
                ExtractClippedImages.outputDirectories[i] = string;
                if (!outputDirectories[i].endsWith("\\") && !outputDirectories[i].endsWith("/")) {
                    int n = i;
                    outputDirectories[n] = outputDirectories[n] + separator;
                }
                if ((file = new File(outputDirectories[i])).exists()) continue;
                file.mkdirs();
                continue;
            }
            catch (Exception exception) {
                throw new PdfException("Exception " + exception + " with directory " + stringArray[4 + i * 2]);
            }
        }
    }

    @Override
    void decodeFile(String string) throws PdfException {
        if (this.openPDFFile()) {
            int n = this.getPageCount();
            try {
                for (int i = 1; i < n + 1; ++i) {
                    float f;
                    int n2;
                    LogWriter.writeLog(Messages.getMessage("PdfViewerDecoding.page") + ' ' + i);
                    int n3 = this.getImageCount(i);
                    if (n3 > 0) {
                        LogWriter.writeLog("page " + i + "contains " + n3 + " images");
                    } else {
                        LogWriter.writeLog("No bitmapped images on page " + i);
                    }
                    LogWriter.writeLog("Writing out images");
                    float[] fArray = new float[n3];
                    float[] fArray2 = new float[n3];
                    float[] fArray3 = new float[n3];
                    float[] fArray4 = new float[n3];
                    float[] fArray5 = new float[n3];
                    float[] fArray6 = new float[n3];
                    float[] fArray7 = new float[n3];
                    String[] stringArray = new String[n3];
                    BufferedImage[] bufferedImageArray = new BufferedImage[n3];
                    boolean[] blArray = new boolean[n3];
                    for (int j = 0; j < n3; ++j) {
                        stringArray[j] = this.getImageName(i, j);
                        fArray[j] = this.pdf_images.getImageXCoord(j);
                        fArray5[j] = this.pdf_images.getImageXCoord(j);
                        fArray2[j] = this.pdf_images.getImageYCoord(j);
                        fArray6[j] = this.pdf_images.getImageYCoord(j);
                        fArray3[j] = this.pdf_images.getImageWidth(j);
                        fArray4[j] = this.pdf_images.getImageHeight(j);
                        fArray7[j] = this.pdf_images.getImageHeight(j);
                        bufferedImageArray[j] = this.getClippedImage(i, stringArray[j]);
                    }
                    int n4 = 1;
                    boolean[] blArray2 = new boolean[n3];
                    ArrayList[] arrayListArray = new ArrayList[n3];
                    while (n4 != 0) {
                        n4 = 0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            for (int j = 0; j < n3; ++j) {
                                float f2;
                                float f3;
                                if (n2 == j || blArray2[n2] || blArray2[j] || bufferedImageArray[n2] == null || bufferedImageArray[j] == null || !(fArray[n2] >= fArray[j]) || !(fArray[n2] <= fArray[j] + fArray3[j]) || !(fArray2[n2] >= fArray2[j]) || !(fArray2[n2] <= fArray2[j] + fArray4[j])) continue;
                                f = fArray[j];
                                float f4 = fArray2[j];
                                float f5 = fArray[n2] + fArray3[n2];
                                float f6 = fArray[j] + fArray3[j];
                                if (f5 < f6) {
                                    f5 = f6;
                                }
                                if ((f3 = fArray2[n2] + fArray4[n2]) < (f2 = fArray2[j] + fArray4[j])) {
                                    f3 = f2;
                                }
                                float f7 = f5 - f;
                                float f8 = f3 - f4;
                                fArray[j] = f;
                                fArray2[j] = f4;
                                fArray3[j] = f7;
                                fArray4[j] = f8;
                                blArray[j] = true;
                                if (arrayListArray[j] == null) {
                                    arrayListArray[j] = new ArrayList(n3);
                                    arrayListArray[j].add(j);
                                }
                                arrayListArray[j].add(n2);
                                blArray2[n2] = true;
                                if (arrayListArray[n2] != null) {
                                    arrayListArray[j].addAll(Arrays.asList(arrayListArray[n2].toArray()));
                                    blArray[n2] = false;
                                    arrayListArray[n2] = null;
                                }
                                n4 = 1;
                                n2 = n3;
                                j = n3;
                            }
                        }
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (arrayListArray[n2] == null) continue;
                        float f9 = fArray[n2];
                        f = fArray2[n2];
                        BufferedImage bufferedImage = new BufferedImage((int)fArray3[n2], (int)fArray4[n2], 2);
                        Graphics2D graphics2D = bufferedImage.createGraphics();
                        graphics2D.setRenderingHints(ColorSpaces.hints);
                        Collections.sort(arrayListArray[n2]);
                        int n5 = -1;
                        for (Object object : arrayListArray[n2].toArray()) {
                            int n6 = (Integer)object;
                            if (n5 == n6) continue;
                            int n7 = (int)(fArray[n6] - f9);
                            int n8 = bufferedImage.getHeight() + (int)(-fArray2[n6] - f - fArray4[n6]);
                            graphics2D.drawImage(bufferedImageArray[n6], n7, n8, (int)fArray3[n6], (int)fArray4[n6], null);
                            n5 = n6;
                            bufferedImageArray[n6] = null;
                        }
                        bufferedImageArray[n2] = bufferedImage;
                    }
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (bufferedImageArray[n4] == null) continue;
                        this.generateVersions(string, i, "<PAGELOCATION x1=\"" + fArray[n4] + "\" " + "y1=\"" + (fArray2[n4] + fArray4[n4]) + "\" " + "x2=\"" + (fArray[n4] + fArray3[n4]) + "\" " + "y2=\"" + fArray2[n4] + "\" />\n", stringArray[n4], bufferedImageArray[n4], n4);
                    }
                    this.decode_pdf.flushObjectValues(true);
                }
            }
            catch (Exception exception) {
                this.decode_pdf.closePdfFile();
                LogWriter.writeLog("Exception " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.decode_pdf.closePdfFile();
    }

    private void generateVersions(String string, int n, String string2, String string3, BufferedImage bufferedImage, int n2) {
        for (int i = 0; i < outputCount; ++i) {
            try {
                int n3;
                float f;
                String string4;
                BufferedImage bufferedImage2;
                block12: {
                    boolean bl;
                    Object object;
                    Object object2;
                    bufferedImage2 = bufferedImage;
                    if (bufferedImage2 == null) continue;
                    int n4 = string.lastIndexOf(92);
                    if (n4 == -1) {
                        n4 = string.lastIndexOf(47);
                    }
                    if (n4 == -1) {
                        n4 = 0;
                    }
                    String string5 = string.substring(n4, string.length() - 4);
                    string4 = outputDirectories[i] + string5 + '_' + n + '_' + n2;
                    f = 1.0f;
                    n3 = bufferedImage2.getHeight();
                    if (outputSizes[i] > 0.0f) {
                        f = outputSizes[i] / (float)n3;
                        if (f > 1.0f) {
                            f = 1.0f;
                        } else {
                            object2 = bufferedImage2.getScaledInstance(-1, (int)outputSizes[i], 4);
                            bufferedImage2 = new BufferedImage(((Image)object2).getWidth(null), ((Image)object2).getHeight(null), 2);
                            object = bufferedImage2.createGraphics();
                            ((Graphics)object).drawImage((Image)object2, 0, 0, null);
                        }
                    }
                    object2 = System.getProperty("org.jpedal.compress_tiff");
                    object = System.getProperty("org.jpedal.jpeg_dpi");
                    boolean bl2 = bl = object2 != null;
                    if (this.imageType.startsWith("jp")) {
                        int n5 = bufferedImage2.getWidth();
                        int n6 = bufferedImage2.getHeight();
                        BufferedImage bufferedImage3 = new BufferedImage(n5, n6, 1);
                        Graphics2D graphics2D = (Graphics2D)bufferedImage3.getGraphics();
                        graphics2D.setPaint(backgroundColor);
                        graphics2D.fillRect(0, 0, n5, n6);
                        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                        bufferedImage2 = bufferedImage3;
                    }
                    if (bufferedImage2.getType() == 0) {
                        bufferedImage2 = ColorSpaceConvertor.convertToARGB(bufferedImage2);
                    }
                    try {
                        DefaultImageHelper.write(bufferedImage2, this.imageType, string4 + '.' + this.imageType);
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block12;
                        LogWriter.writeLog("Exception in writing image " + iOException);
                    }
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string4 + ".xml"), "UTF-8");
                outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                outputStreamWriter.write("<!-- Pixel Location of image x1,y1,x2,y2\n");
                outputStreamWriter.write("(x1,y1 is top left corner)\n");
                outputStreamWriter.write("(origin is bottom left corner)  -->\n");
                outputStreamWriter.write("\n\n<META>\n");
                outputStreamWriter.write(string2);
                outputStreamWriter.write("<FILE>" + string + "</FILE>\n");
                outputStreamWriter.write("<ORIGINALHEIGHT>" + n3 + "</ORIGINALHEIGHT>\n");
                outputStreamWriter.write("<SCALEDHEIGHT>" + bufferedImage2.getHeight() + "</SCALEDHEIGHT>\n");
                outputStreamWriter.write("<SCALING>" + f + "</SCALING>\n");
                outputStreamWriter.write("</META>\n");
                outputStreamWriter.close();
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " in extracting images");
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = ExtractClippedImages.validateInputValues(stringArray);
        try {
            ExtractClippedImages.writeAllClippedImagesToDirs(stringArray[0], stringArray[1], stringArray[2], stringArray2);
        }
        catch (PdfException pdfException) {
            throw new RuntimeException(pdfException);
        }
    }

    private static String[] validateInputValues(String[] stringArray) throws RuntimeException {
        String[] stringArray2 = null;
        if (stringArray.length >= 5 && stringArray.length % 2 == 1) {
            LogWriter.writeLog("Values read");
            LogWriter.writeLog("inputDir=" + stringArray[0]);
            LogWriter.writeLog("processedDir=" + stringArray[1]);
            LogWriter.writeLog("logFile=" + stringArray[2]);
            LogWriter.writeLog("Directory and height pair values" + stringArray[3] + " <> " + stringArray[4] + '<');
            outputCount = (stringArray.length - 3) / 2;
            stringArray2 = new String[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                LogWriter.writeLog(stringArray[i + 3]);
                if (i % 2 == 0 && !stringArray[i + 3].matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+")) {
                    throw new RuntimeException("Invalid value: " + stringArray[i + 3]);
                }
                stringArray2[i] = stringArray[i + 3];
            }
        } else {
            if ((stringArray.length - 3) % 2 == 1) {
                throw new RuntimeException("Value/Directory pairs invalid");
            }
            System.out.println("Requires");
            System.out.println("inputDir processedDir imageOutputType");
            System.out.println("height Directory (as many pairs as you like)");
            throw new RuntimeException("Not enough parameters passed to software");
        }
        File file = new File(inputDir);
        if (!file.exists()) {
            throw new RuntimeException("Directory " + inputDir + " not found");
        }
        return stringArray2;
    }

    @Override
    void init() {
        this.type = BaseImageExtraction.ExtractTypes.CLIPPED_IMAGES;
        super.init();
    }

    public int getImageCount(int n) throws PdfException {
        this.selectPage(n);
        return this.pdf_images.getImageCount();
    }

    public String getImageName(int n, int n2) throws PdfException {
        this.selectPage(n);
        return this.pdf_images.getImageName(n2);
    }

    static {
        backgroundColor = Color.WHITE;
    }
}

