/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.images;

import com.idrsolutions.image.tiff.TiffEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.images.BaseImageExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.PdfImageData;
import org.jpedal.utils.TimeNow;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtractImages
extends BaseImageExtraction {
    private boolean outputPagesInSeparateDirs = true;
    private String defaultOutputDir;
    boolean writeOutMetadata = true;

    public ExtractImages(String string) {
        super(string);
        this.init();
    }

    public ExtractImages(byte[] byArray) {
        super(byArray);
        this.init();
    }

    private void setCreateMetsDataXMLfile(boolean bl) {
        this.writeOutMetadata = bl;
    }

    public static void writeAllImagesToDir(String string, String string2, String string3, boolean bl, boolean bl2) throws PdfException {
        ExtractImages extractImages = new ExtractImages(string);
        extractImages.setup(string2, string3, bl, bl2);
        extractImages.processFiles(string);
        extractImages.closePDFfile();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        if (this.openPDFFile()) {
            int n = this.getPageCount();
            this.output_dir = this.defaultOutputDir == null ? this.user_dir + "images" + separator + this.name + separator : this.defaultOutputDir;
            File file = new File(this.output_dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            for (int i = 1; i < n + 1; ++i) {
                int n2 = this.getImageCount(i);
                if (n2 > 0) {
                    File file2;
                    String string2 = this.output_dir;
                    if (this.outputPagesInSeparateDirs) {
                        string2 = this.output_dir + separator + i;
                    }
                    if (!(file2 = new File(string2)).exists()) {
                        file2.mkdirs();
                    }
                }
                try {
                    this.writeImagesFromPage(n2, i);
                }
                catch (Exception exception) {
                    throw new PdfException(exception.getMessage());
                }
                this.decode_pdf.flushObjectValues(true);
            }
        }
    }

    private void writeImagesFromPage(int n, int n2) throws Exception {
        String string = this.output_dir;
        if (this.outputPagesInSeparateDirs) {
            string = this.output_dir + n2 + separator;
        }
        for (int i = 0; i < n; ++i) {
            String string2 = this.getImageName(n2, i);
            BufferedImage bufferedImage = this.getImage(n2, string2, false);
            ExtractImages.saveImage(bufferedImage, string + 'R' + string2 + '.' + this.imageType, this.imageType);
            bufferedImage = this.getImage(n2, string2, true);
            if (bufferedImage != null) {
                ExtractImages.saveImage(bufferedImage, string + string2 + '.' + this.imageType, this.imageType);
            }
            if (!this.writeOutMetadata) continue;
            this.outputMetaDataToXML(this.fileName, n2, this.pdf_images, i, string2);
        }
    }

    @Override
    void init() {
        this.type = BaseImageExtraction.ExtractTypes.IMAGES;
        super.init();
    }

    private static void saveImage(BufferedImage bufferedImage, String string, String string2) throws Exception {
        if (string2.contains("tif")) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            String string3 = System.getProperty("org.jpedal.compress_tiff");
            boolean bl = string3 != null;
            TiffEncoder tiffEncoder = new TiffEncoder();
            tiffEncoder.setCompressed(bl);
            tiffEncoder.write(bufferedImage, fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        } else {
            DefaultImageHelper.write(bufferedImage, string2, string);
        }
    }

    private void outputMetaDataToXML(String string, int n, PdfImageData pdfImageData, int n2, String string2) {
        float f = pdfImageData.getImageXCoord(n2);
        float f2 = pdfImageData.getImageYCoord(n2);
        float f3 = pdfImageData.getImageWidth(n2);
        float f4 = pdfImageData.getImageHeight(n2);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("meta");
            document.appendChild(element);
            Comment comment = document.createComment("Created " + TimeNow.getShortTimeNow());
            document.appendChild(comment);
            Comment comment2 = document.createComment("Pixel Location of image x1,y1,x2,y2");
            document.appendChild(comment2);
            Comment comment3 = document.createComment("x1,y1 is top left corner origin is bottom left corner");
            document.appendChild(comment3);
            Element element2 = document.createElement("PAGELOCATION");
            element2.setAttribute("x1", String.valueOf(f));
            element2.setAttribute("y1", String.valueOf(f2 + f4));
            element2.setAttribute("x2", String.valueOf(f + f3));
            element2.setAttribute("y2", String.valueOf(f2));
            element.appendChild(element2);
            Element element3 = document.createElement("FILE");
            element3.setAttribute("value", string);
            element.appendChild(element3);
            InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/viewer/res/xmlstyle.xslt");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
            String string3 = this.output_dir;
            if (this.outputPagesInSeparateDirs) {
                string3 = this.output_dir + n + separator;
            }
            transformer.transform(new DOMSource(document), new StreamResult(string3 + string2 + ".xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example can take 3 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the images");
            System.out.println("Value 3 is image type (jpeg,tiff,png). Default is png");
            System.exit(0);
        } else if (n < 4) {
            try {
                ExtractImages.writeAllImagesToDir(stringArray[0], stringArray[1], stringArray[2], true, false);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        } else {
            System.out.println("too many arguments entered - run with no values to see defaults");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    private void setOutputPagesInSeparateDirs(boolean bl) {
        this.outputPagesInSeparateDirs = bl;
    }

    public BufferedImage getImage(int n, int n2, boolean bl) throws PdfException {
        return this.getImage(n, this.getImageName(n, n2), bl);
    }

    public BufferedImage getImage(int n, String string, boolean bl) throws PdfException {
        this.selectPage(n);
        if (bl) {
            return this.decode_pdf.getObjectStore().loadStoredImage(string);
        }
        return this.decode_pdf.getObjectStore().loadStoredImage('R' + string);
    }

    private void setup(String string, String string2, boolean bl, boolean bl2) {
        this.imageType = string2;
        if (string != null) {
            if (!string.endsWith(separator)) {
                string = string + separator;
            }
            this.defaultOutputDir = string;
        }
        this.setCreateMetsDataXMLfile(bl);
        this.setOutputPagesInSeparateDirs(bl2);
    }

    public int getImageCount(int n) throws PdfException {
        this.selectPage(n);
        return this.pdf_images.getImageCount();
    }

    public String getImageName(int n, int n2) throws PdfException {
        this.selectPage(n);
        return this.pdf_images.getImageName(n2);
    }
}

