/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.w3c.dom.Document;

public class ExtractOutline
extends BaseTextExtraction {
    public ExtractOutline(String string) {
        super(string);
        this.init();
    }

    public ExtractOutline(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        this.fileName = string;
        if (this.openPDFFile()) {
            Document document = this.getPDFTextOutline();
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/org/jpedal/examples/viewer/res/xmlstyle.xslt");
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
                String string2 = "demo";
                int n = string.lastIndexOf(separator);
                if (n != -1) {
                    string2 = string.substring(n + 1, string.length() - 4);
                }
                String string3 = this.output_dir + string2 + separator;
                DOMSource dOMSource = new DOMSource(document);
                if (dOMSource.getNode() != null) {
                    Object object;
                    File file = new File(string3 + "outline.txt");
                    if (!file.exists()) {
                        object = new File(string3);
                        ((File)object).mkdirs();
                        file.createNewFile();
                    }
                    object = new FileOutputStream(file);
                    StreamResult streamResult = new StreamResult((OutputStream)object);
                    transformer.transform(dOMSource, streamResult);
                }
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new PdfException(transformerConfigurationException.getMessage());
            }
            catch (TransformerException transformerException) {
                throw new PdfException(transformerException.getMessage());
            }
            catch (IOException iOException) {
                throw new PdfException(iOException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example takes 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the data as text files");
            System.exit(0);
        } else if (n == 2) {
            try {
                ExtractOutline.writeAllOutlinesToDir(stringArray[0], stringArray[1]);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        } else {
            System.out.println("too many arguments entered - run with no values to see defaults");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.OUTLINE;
        super.init();
    }

    public static void writeAllOutlinesToDir(String string, String string2) throws PdfException {
        ExtractOutline extractOutline = new ExtractOutline(string);
        extractOutline.setup(string2);
        extractOutline.processFiles(string);
        extractOutline.closePDFfile();
    }

    private void setup(String string) {
        if (!string.endsWith(separator)) {
            string = string + separator;
        }
        this.output_dir = string;
    }

    public Document getPDFTextOutline() {
        return this.decode_pdf.getOutlineAsXML();
    }
}

