/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;
import org.jpedal.utils.Strip;

public class ExtractTextAsWordlist
extends BaseTextExtraction {
    private int wordsExtracted;

    public ExtractTextAsWordlist(String string) {
        super(string);
        this.init();
    }

    public ExtractTextAsWordlist(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        this.fileName = string;
        if (this.openPDFFile()) {
            String string2 = "demo";
            int n = string.lastIndexOf(separator);
            if (n != -1) {
                string2 = string.substring(n + 1, string.length() - 4);
            }
            String string3 = this.output_dir + separator + string2 + separator;
            int n2 = this.getPageCount();
            if (n2 > 10 && this.maxCount > 0 && n2 > this.maxCount) {
                n2 = this.maxCount;
            }
            try {
                for (int i = 1; i < n2 + 1; ++i) {
                    this.selectPage(i);
                    int n3 = this.currentPageData.getMediaBoxX(i);
                    int n4 = this.currentPageData.getMediaBoxWidth(i) + n3;
                    int n5 = this.currentPageData.getMediaBoxX(i);
                    int n6 = this.currentPageData.getMediaBoxHeight(i) - n5;
                    List list = this.getWordsOnPage(i, n3, n6, n4, n5, "&:=()!;.,\\/\"\"''");
                    if (list != null) {
                        File file = new File(string3);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        int n7 = list.size() / 5;
                        this.wordsExtracted += n7;
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + "words-" + i + ".txt"), "UTF-8");
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            String string4 = (String)iterator.next();
                            string4 = Strip.convertToText(string4, this.decode_pdf.isXMLExtraction());
                            int n8 = (int)Float.parseFloat((String)iterator.next());
                            int n9 = (int)Float.parseFloat((String)iterator.next());
                            int n10 = (int)Float.parseFloat((String)iterator.next());
                            int n11 = (int)Float.parseFloat((String)iterator.next());
                            outputStreamWriter.write(string4 + ',' + n8 + ',' + n9 + ',' + n10 + ',' + n11 + '\n');
                        }
                        outputStreamWriter.close();
                    }
                    this.decode_pdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new PdfException(exception.getMessage());
            }
        }
    }

    public List getWordsOnPage(int n) throws PdfException {
        this.selectPage(n);
        int n2 = this.currentPageData.getMediaBoxX(n);
        int n3 = this.currentPageData.getMediaBoxWidth(n) + n2;
        int n4 = this.currentPageData.getMediaBoxX(n);
        int n5 = this.currentPageData.getMediaBoxHeight(n) - n4;
        return this.getWordsOnPage(n, n2, n5, n3, n4, "&:=()!;.,\\/\"\"''");
    }

    public List getWordsOnPage(int n, int n2, int n3, int n4, int n5, String string) throws PdfException {
        this.selectPage(n);
        return this.currentGrouping.extractTextAsWordlist(n2, n3, n4, n5, n, true, string);
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example takes 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the data as text files");
            System.exit(0);
        } else if (n == 2) {
            try {
                ExtractTextAsWordlist.writeAllWordlistsToDir(stringArray[0], stringArray[1], -1);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        } else {
            System.out.println("too many arguments entered - run with no values to see defaults");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.TEXT_AS_WORDLIST;
        super.init();
    }

    public static int writeAllWordlistsToDir(String string, String string2, int n) throws PdfException {
        ExtractTextAsWordlist extractTextAsWordlist = new ExtractTextAsWordlist(string);
        extractTextAsWordlist.setup(string2, n);
        extractTextAsWordlist.processFiles(string);
        extractTextAsWordlist.closePDFfile();
        return extractTextAsWordlist.getWordsExtractedCount();
    }

    private void setup(String string, int n) {
        if (!string.endsWith(separator)) {
            string = string + separator;
        }
        this.output_dir = string;
        this.maxCount = n;
    }

    private int getWordsExtractedCount() {
        return this.wordsExtracted;
    }
}

