/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.examples.text.ExtractTextAsWordlist;
import org.jpedal.exception.PdfException;

public class ExtractTextInRectangle
extends BaseTextExtraction {
    protected String text;
    public static boolean isTest = true;

    public ExtractTextInRectangle(String string) {
        super(string);
        this.init();
    }

    public ExtractTextInRectangle(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        this.fileName = string;
        if (this.openPDFFile()) {
            String string2 = "demo";
            int n = string.lastIndexOf(separator);
            if (n != -1) {
                string2 = string.substring(n + 1, string.length() - 4);
            }
            String string3 = this.user_dir + "text" + separator + string2 + separator;
            int n2 = this.getPageCount();
            if (n2 > 10 && this.maxCount > 0 && n2 > this.maxCount) {
                n2 = this.maxCount;
            }
            try {
                for (int i = 1; i < n2 + 1; ++i) {
                    this.selectPage(i);
                    int n3 = this.currentPageData.getMediaBoxX(i);
                    int n4 = this.currentPageData.getMediaBoxWidth(i) + n3;
                    int n5 = this.currentPageData.getMediaBoxY(i);
                    int n6 = this.currentPageData.getMediaBoxHeight(i) + n5;
                    this.text = this.getTextOnPage(i, n3, n6, n4, n5);
                    if (isTest && this.text != null) {
                        this.text = this.text + this.currentGrouping.extractTextInRectangle(n3, n6, n4, n5, i, true, true);
                    }
                    if (this.text != null) {
                        File file = new File(string3 + separator);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        String string4 = ".txt";
                        String string5 = System.getProperty("file.encoding");
                        if (isTest) {
                            string4 = ".xml";
                        }
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3 + i + string4), string5);
                        if (isTest) {
                            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
                            outputStreamWriter.write("<!-- Pixel Location of text x1,y1,x2,y2\n");
                            outputStreamWriter.write("(x1,y1 is top left corner)\n");
                            outputStreamWriter.write("(x1,y1 is bottom right corner)\n");
                            outputStreamWriter.write("(origin is bottom left corner)  -->\n");
                            outputStreamWriter.write("\n\n<ARTICLE>\n");
                            outputStreamWriter.write("<LOCATION x1=\"" + n3 + "\" " + "y1=\"" + n6 + "\" " + "x2=\"" + n4 + "\" " + "y2=\"" + n5 + "\" />\n");
                            outputStreamWriter.write("\n\n<TEXT>\n");
                            outputStreamWriter.write(this.text);
                            outputStreamWriter.write("\n\n</TEXT>\n");
                            outputStreamWriter.write("\n\n</ARTICLE>\n");
                        } else {
                            outputStreamWriter.write(this.text);
                        }
                        outputStreamWriter.close();
                    }
                    this.decode_pdf.flushObjectValues(false);
                }
            }
            catch (Exception exception) {
                throw new PdfException(exception.getMessage());
            }
        }
    }

    public String getTextOnPage(int n) throws PdfException {
        this.selectPage(n);
        int n2 = this.currentPageData.getMediaBoxX(n);
        int n3 = this.currentPageData.getMediaBoxWidth(n) + n2;
        int n4 = this.currentPageData.getMediaBoxY(n);
        int n5 = this.currentPageData.getMediaBoxHeight(n) + n4;
        return this.getTextOnPage(n, n2, n5, n3, n4);
    }

    public String getTextOnPage(int n, int n2, int n3, int n4, int n5) throws PdfException {
        this.selectPage(n);
        return this.currentGrouping.extractTextInRectangle(n2, n3, n4, n5, n, false, true);
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n == 0) {
            System.out.println("Example takes 2 parameters");
            System.out.println("Value 1 is the file name or directory of PDF files to process");
            System.out.println("Value 2 is Directory for writing the data as text files");
            System.exit(0);
        } else if (n == 2) {
            try {
                ExtractTextAsWordlist.writeAllWordlistsToDir(stringArray[0], stringArray[1], -1);
            }
            catch (PdfException pdfException) {
                pdfException.printStackTrace();
            }
        } else {
            System.out.println("too many arguments entered - run with no values to see defaults");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : stringArray) {
                stringBuilder.append(string).append('\n');
            }
            System.out.println("you entered:\n" + stringBuilder + "as the arguments");
        }
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.TEXT_IN_RECTANGLE;
        super.init();
    }

    public static void writeAllTextToDir(String string, String string2, int n) throws PdfException {
        ExtractTextInRectangle extractTextInRectangle = new ExtractTextInRectangle(string);
        extractTextInRectangle.setup(string2, n);
        extractTextInRectangle.processFiles(string);
        extractTextInRectangle.closePDFfile();
    }

    private void setup(String string, int n) {
        if (!string.endsWith(separator)) {
            string = string + separator;
        }
        this.output_dir = string;
        this.maxCount = n;
    }
}

