/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text;

import java.util.ArrayList;
import org.jpedal.examples.text.BaseTextExtraction;
import org.jpedal.exception.PdfException;

public class FindTextInRectangle
extends BaseTextExtraction {
    ArrayList co_ords = new ArrayList();
    private String textToFind;

    public FindTextInRectangle(String string) {
        super(string);
        this.init();
    }

    public FindTextInRectangle(byte[] byArray) {
        super(byArray);
        this.init();
    }

    @Override
    void decodeFile(String string) throws PdfException {
        this.fileName = string;
        if (this.openPDFFile()) {
            int n = 1;
            int n2 = this.getPageCount();
            try {
                for (int i = n; i <= n2; ++i) {
                    this.selectPage(i);
                    if (this.currentGrouping == null) continue;
                    int n3 = this.currentPageData.getMediaBoxX(i);
                    int n4 = this.currentPageData.getMediaBoxY(i);
                    float[] fArray = this.findTextOnPage(i, this.textToFind, 8);
                    this.co_ords.add(fArray);
                }
                this.decode_pdf.flushObjectValues(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
                throw new PdfException(exception.getMessage());
            }
        }
    }

    public float[] findTextOnPage(int n, String string, int n2) throws PdfException {
        this.selectPage(n);
        return this.currentGrouping.findText(new String[]{string}, n2);
    }

    public float[] findTextOnPage(int n, int n2, int n3, int n4, int n5, String string, int n6) throws PdfException {
        this.selectPage(n);
        return this.currentGrouping.findText(n2, n3, n4, n5, new String[]{string}, n6);
    }

    @Override
    void init() {
        this.type = BaseTextExtraction.ExtractTypes.FIND_TEXT_IN_RECTANGLE;
        super.init();
    }

    public static ArrayList findTextOnAllPages(String string, String string2) throws PdfException {
        FindTextInRectangle findTextInRectangle = new FindTextInRectangle(string);
        findTextInRectangle.setup(string2);
        findTextInRectangle.processFiles(string);
        findTextInRectangle.closePDFfile();
        return findTextInRectangle.getCoords();
    }

    private ArrayList getCoords() {
        return this.co_ords;
    }

    private void setup(String string) {
        this.textToFind = string;
    }
}

