/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.external;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.jpedal.FileAccess;
import org.jpedal.display.GUIModes;
import org.jpedal.external.AdditonalHandler;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.external.CustomMessageHandler;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.GlyphTracker;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.external.ShapeTracker;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormCreator;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.swing.PDFtoImageConvertorSwing;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.SwingDisplay;
import org.jpedal.utils.LogWriter;

public class ExternalHandlers {
    FormFactory userFormFactory;
    AdditonalHandler additionalHandler;
    AcroRenderer formRenderer;
    public static boolean throwMissingCIDError;
    private DynamicVectorRenderer customDVR;
    ImageHandler customImageHandler;
    private Object customSwingHandle;
    private Object customPluginHandle;
    private Object userExpressionEngine;
    boolean useXFA;
    private Javascript javascript;
    RenderChangeListener customRenderChangeListener;
    GlyphTracker customGlyphTracker;
    ShapeTracker customShapeTracker;
    private boolean alwaysUseXFA;
    private Map jpedalActionHandlers;
    ColorHandler customColorHandler;
    ErrorTracker customErrorTracker;
    private CustomFormPrint customFormPrint;
    private CustomMessageHandler customMessageHandler;
    Object swingGUI;
    private Enum modeSelected = GUIModes.SWING;
    private static ClassLoader loader;
    private static boolean isXFAPresent;
    private static final String xfaClassName = "org.jpedal.objects.acroforms.AcroRendererXFA";

    public ExternalHandlers() {
        if (isXFAPresent) {
            this.useXFA = true;
        }
    }

    public ExternalHandlers(GUIModes gUIModes) {
        this.modeSelected = gUIModes;
        if (isXFAPresent) {
            this.useXFA = true;
        }
    }

    public void addHandlers(PdfStreamDecoder pdfStreamDecoder) {
        pdfStreamDecoder.setObjectValue(-6, this.customImageHandler);
        pdfStreamDecoder.setObjectValue(12, this.customGlyphTracker);
        pdfStreamDecoder.setObjectValue(13, this.customShapeTracker);
        if (this.customErrorTracker != null) {
            pdfStreamDecoder.setObjectValue(31, this.customErrorTracker);
        }
    }

    public void addExternalHandler(Object object, int n) {
        switch (n) {
            case 39: {
                this.additionalHandler = (AdditonalHandler)object;
                break;
            }
            case 29: {
                this.alwaysUseXFA = (Boolean)object;
                break;
            }
            case 28: {
                this.useXFA = (Boolean)object;
                break;
            }
            case -4: {
                this.customPluginHandle = object;
                break;
            }
            case 4: {
                this.customSwingHandle = object;
                break;
            }
            case 31: {
                this.customErrorTracker = (ErrorTracker)object;
                break;
            }
            case 6: {
                this.userExpressionEngine = object;
                break;
            }
            case 3: {
                this.userFormFactory = (FormFactory)object;
                break;
            }
            case 11: {
                this.swingGUI = object;
                break;
            }
            case 1: {
                this.customImageHandler = (ImageHandler)object;
                break;
            }
            case 19: {
                this.customColorHandler = (ColorHandler)object;
                break;
            }
            case 12: {
                this.customGlyphTracker = (GlyphTracker)object;
                break;
            }
            case 13: {
                this.customShapeTracker = (ShapeTracker)object;
                break;
            }
            case 14: {
                this.customFormPrint = (CustomFormPrint)object;
                break;
            }
            case 9: {
                this.jpedalActionHandlers = (Map)object;
                break;
            }
            case 15: {
                this.customMessageHandler = (CustomMessageHandler)object;
                break;
            }
            case 20: {
                this.customDVR = (DynamicVectorRenderer)object;
                break;
            }
            default: {
                if (this.additionalHandler != null) {
                    this.additionalHandler.addExternalHandler(object, n);
                    break;
                }
                throw new IllegalArgumentException("Unknown type=" + n);
            }
        }
    }

    public Object getExternalHandler(int n) {
        switch (n) {
            case 3: {
                return this.formRenderer.getFormFactory();
            }
            case 4: {
                return this.customSwingHandle;
            }
            case -4: {
                return this.customPluginHandle;
            }
            case 6: {
                return this.userExpressionEngine;
            }
            case 31: {
                return this.customErrorTracker;
            }
            case 1: {
                return this.customImageHandler;
            }
            case 19: {
                return this.customColorHandler;
            }
            case 12: {
                return this.customGlyphTracker;
            }
            case 13: {
                return this.customShapeTracker;
            }
            case 14: {
                return this.customFormPrint;
            }
            case 11: {
                return this.swingGUI;
            }
            case 9: {
                return this.jpedalActionHandlers;
            }
            case 15: {
                return this.customMessageHandler;
            }
            case 20: {
                return this.customDVR;
            }
            case 21: {
                return this.customRenderChangeListener;
            }
            case 24: {
                return this.jpedalActionHandlers;
            }
        }
        if (n == 25) {
            return null;
        }
        if (this.additionalHandler != null) {
            return this.additionalHandler.getExternalHandler(n);
        }
        throw new IllegalArgumentException("Unknown type " + n);
    }

    public Javascript getJavaScript() {
        return this.javascript;
    }

    public FormFactory getUserFormFactory() {
        return this.userFormFactory;
    }

    public void dispose() {
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
        if (this.formRenderer != null) {
            this.formRenderer.dispose();
        }
        this.formRenderer = null;
    }

    public AcroRenderer getFormRenderer() {
        return this.formRenderer;
    }

    public void setJavaScript(Javascript javascript) {
        this.javascript = javascript;
    }

    public void useXFA(boolean bl) {
        this.useXFA = bl;
    }

    public void openPdfFile(Object object) {
        this.initObjects(object, new SwingFormCreator());
    }

    public static BufferedImage decode(PdfObject pdfObject, PdfObjectReader pdfObjectReader, PdfObject pdfObject2, int n, int n2, int n3, int n4, float f) {
        block3: {
            if (isXFAPresent) {
                try {
                    AcroRenderer acroRenderer = (AcroRenderer)loader.loadClass(xfaClassName).newInstance();
                    return acroRenderer.decode(pdfObject, pdfObjectReader, pdfObject2, n, n2, n3, n4, f);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("[PDF] Unable to instance XFA " + exception);
                }
            }
        }
        return null;
    }

    void initObjects(Object object, SwingFormCreator swingFormCreator) {
        if (isXFAPresent) {
            try {
                this.formRenderer = (AcroRenderer)loader.loadClass(xfaClassName).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Unable to instance XFA " + exception);
                }
                this.formRenderer = new AcroRenderer();
            }
        } else {
            this.formRenderer = new AcroRenderer();
        }
        this.formRenderer.useXFAIfAvailable(this.useXFA);
        this.formRenderer.init(swingFormCreator);
        this.formRenderer.alwaysuseXFA(this.alwaysUseXFA);
        FormFactory formFactory = this.userFormFactory;
        if (formFactory != null) {
            this.formRenderer.setFormFactory(formFactory);
        }
        this.javascript = new Javascript((ExpressionEngine)object, this.formRenderer, this.swingGUI);
    }

    public void setMode(Enum enum_) {
        this.modeSelected = enum_;
    }

    public Enum getMode() {
        return this.modeSelected;
    }

    public boolean isJavaFX() {
        return false;
    }

    public void setDVR(FileAccess fileAccess) {
        fileAccess.setDVR(new SwingDisplay(1, fileAccess.getObjectStore(), false));
    }

    public PDFtoImageConvertor getConverter(float f, DecoderOptions decoderOptions) {
        return new PDFtoImageConvertorSwing(f, decoderOptions);
    }

    static {
        loader = ExternalHandlers.class.getClassLoader();
        isXFAPresent = loader.getResource("org/jpedal/objects/acroforms/AcroRendererXFA.class") != null;
    }
}

