/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class TrueType
extends PdfFont {
    private boolean subfontAlreadyLoaded;
    private Map fontsLoaded;
    private Rectangle BBox;

    public TrueType() {
        this.fontsLoaded = new HashMap();
        this.init(null);
    }

    private void readFontData(byte[] byArray, FontData fontData) {
        if (this.subfontAlreadyLoaded) {
            this.glyphs = (PdfJavaGlyphs)this.fontsLoaded.get(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + byArray.length);
            this.fontTypes = this.glyphs.getType();
        } else {
            if (!this.isCIDFont && byArray != null) {
                this.fontsLoaded.put(this.substituteFont + '_' + this.glyphs.getBaseFontName() + ' ' + byArray.length, this.glyphs);
            }
            this.fontTypes = this.glyphs.readEmbeddedFont(this.TTstreamisCID, byArray, fontData);
        }
    }

    protected void substituteFontUsed(String string) throws PdfFontException {
        block10: {
            InputStream inputStream;
            block9: {
                inputStream = null;
                try {
                    inputStream = this.loader.getResourceAsStream("org/jpedal/res/fonts/" + string);
                    if (inputStream == null) {
                        inputStream = new FileInputStream(string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
                    }
                    if (!ExternalHandlers.throwMissingCIDError || exception.getMessage() == null || !exception.getMessage().contains("kochi")) break block9;
                    throw new Error(exception);
                }
            }
            if (inputStream == null) {
                throw new PdfFontException("Unable to load font " + string);
            }
            try {
                int n;
                FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                byte[] byArray = new byte[65535];
                while ((n = inputStream.read(byArray)) != -1) {
                    fastByteArrayOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                FontData fontData = null;
                this.readFontData(fastByteArrayOutputStream.toByteArray(), fontData);
                this.glyphs.setEncodingToUse(this.hasEncoding, this.getFontEncoding(false), this.isCIDFont);
                this.isFontEmbedded = true;
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " reading " + string + " Check cid  jar installed");
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception + " reading " + string + " Check cid  jar installed");
                }
                if (!ExternalHandlers.throwMissingCIDError || exception.getMessage() == null || !exception.getMessage().contains("kochi")) break block10;
                throw new Error(exception);
            }
        }
    }

    public TrueType(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new TTGlyphs();
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    @Override
    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        this.fontTypes = 1217103210;
        this.fontsLoaded = map;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject2);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfObject2);
        if (bl) {
            Object object;
            Object object2;
            if (pdfObject2 != null && this.substituteFont == null) {
                object2 = null;
                object = pdfObject2.getDictionary(2021292334);
                if (object == null && (object = pdfObject2.getDictionary(746093177)) == null) {
                    object = pdfObject2.getDictionary(2021292335);
                }
                if (object != null) {
                    object2 = this.currentPdfFile.readStream((PdfObject)object, true, true, false, false, false, ((PdfObject)object).getCacheName(this.currentPdfFile.getObjectReader()));
                }
                if (object2 != null) {
                    this.readEmbeddedFont((byte[])object2, null, this.hasEncoding);
                }
            }
            if (!this.isFontEmbedded && this.substituteFont != null) {
                this.subfontAlreadyLoaded = !this.isCIDFont && this.fontsLoaded.containsKey(this.substituteFont + '_' + this.glyphs.getBaseFontName());
                object = null;
                int n = 0;
                if (!this.subfontAlreadyLoaded) {
                    object2 = new File(this.substituteFont);
                    n = (int)((File)object2).length();
                }
                if (FontData.maxSizeAllowedInMemory >= 0 && n > FontData.maxSizeAllowedInMemory) {
                    if (!this.subfontAlreadyLoaded) {
                        object = new FontData(this.substituteFont);
                    }
                    this.readEmbeddedFont(null, (FontData)object, false);
                } else if (this.subfontAlreadyLoaded) {
                    this.readEmbeddedFont(null, null, false);
                } else {
                    int n2;
                    InputStream inputStream;
                    block18: {
                        inputStream = null;
                        try {
                            inputStream = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("1.Unable to open " + this.substituteFont + ' ' + exception);
                            }
                        }
                        catch (Error error) {
                            if (!LogWriter.isOutput()) break block18;
                            LogWriter.writeLog("1.Unable to open " + this.substituteFont + ' ' + error);
                        }
                    }
                    BufferedInputStream bufferedInputStream = inputStream == null ? new BufferedInputStream(new FileInputStream(this.substituteFont)) : new BufferedInputStream(inputStream);
                    FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                    byte[] byArray = new byte[65535];
                    while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                        fastByteArrayOutputStream.write(byArray, 0, n2);
                    }
                    bufferedInputStream.close();
                    this.readEmbeddedFont(fastByteArrayOutputStream.toByteArray(), null, false);
                }
                this.isFontSubstituted = true;
            }
        }
        this.readWidths(pdfObject, true);
        if (bl) {
            this.setFont(this.glyphs.fontName, 1);
        }
    }

    protected final void readEmbeddedFont(byte[] byArray, FontData fontData, boolean bl) {
        block3: {
            try {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Embedded TrueType font used");
                }
                this.readFontData(byArray, fontData);
                this.isFontEmbedded = true;
                this.glyphs.setFontEmbedded(true);
                this.glyphs.setEncodingToUse(bl, this.getFontEncoding(false), this.TTstreamisCID);
            }
            catch (Exception exception) {
                this.isFontEmbedded = false;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + exception + " processing TrueType font");
            }
        }
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            this.BBox = this.isFontEmbedded && !this.isFontSubstituted ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        }
        return this.BBox;
    }
}

