/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.Table;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.StringUtils;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    private Area[] cachedShapes;
    private AffineTransform[] cachedAt;
    public int[] CMAP_Translate;
    protected int glyphCount;
    public boolean isFontInstalled;
    public String defaultFont = "Lucida Sans";
    public String fontName = "default";
    public String logicalfontName = "default";
    Map chars = new HashMap();
    Map displayValues = new HashMap();
    Map embeddedChars = new HashMap();
    private boolean isIdentity;
    private boolean isFontEmbedded;
    private boolean hasWidths = true;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont;
    public boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    public boolean isCIDFont;
    public String font_family_name;
    public int style;
    int size;
    String weight;
    String testFont;
    public static final FontRenderContext frc = new FontRenderContext(null, true, true);
    private static String[] fontList;
    protected PdfGlyph[] cachedEmbeddedShapes;
    protected int localBias;
    protected int globalBias;

    public void flush() {
        this.cachedShapes = null;
        this.cachedAt = null;
    }

    @Override
    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String string) {
        this.baseFontName = string;
    }

    @Override
    public Area getStandardGlyph(float[][] fArray, int n, String string, float f, boolean bl) {
        Area area = this.getCachedShape(n);
        if (area == null) {
            AffineTransform affineTransform;
            double d = -1.0;
            double d2 = 1.0;
            double d3 = 0.0;
            if (fArray[1][0] < 0.0f && fArray[0][1] >= 0.0f || fArray[0][1] < 0.0f && fArray[1][0] >= 0.0f) {
                d2 = 1.0;
                d = -1.0;
            }
            if (bl) {
                area = this.getGlyph(n, string, f);
                if (area != null && n == 146 && this.isArialInstalledLocally) {
                    d3 = -(area.getBounds().height - area.getBounds().y);
                }
            } else {
                GlyphVector glyphVector = null;
                if (!this.isCIDFont || this.isFontInstalled) {
                    glyphVector = this.getUnscaledFont().createGlyphVector(frc, string);
                }
                if (glyphVector != null) {
                    double d4;
                    double d5;
                    area = new Area(glyphVector.getOutline());
                    double d6 = glyphVector.getOutline().getBounds2D().getX();
                    if (d6 < 0.0) {
                        d6 = -d6;
                        affineTransform = AffineTransform.getTranslateInstance(d6 * 2.0, 0.0);
                        area.transform(affineTransform);
                    }
                    if ((d5 = (double)f / (d4 = glyphVector.getVisualBounds().getWidth() + d6 * 2.0)) < 1.0) {
                        d2 *= d5;
                    }
                }
            }
            affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, d3);
            if (area != null) {
                area.transform(affineTransform);
            }
            this.setCachedShape(n, area, affineTransform);
        }
        return area;
    }

    public Area getGlyph(int n, String string, float f) {
        Object object;
        boolean bl = true;
        GlyphVector glyphVector = null;
        String string2 = string;
        if (!this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = string;
            bl = false;
        }
        if (this.isCIDFont && this.isFontEmbedded && bl) {
            glyphVector = null;
        } else if (bl) {
            glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
        } else {
            object = new Font(this.defaultFont, 0, 1);
            if (!((Font)object).canDisplay(string2.charAt(0))) {
                object = new Font("lucida", 0, 1);
            }
            if (((Font)object).canDisplay(string2.charAt(0))) {
                glyphVector = ((Font)object).createGlyphVector(frc, string2);
            }
        }
        object = null;
        if (glyphVector != null) {
            object = new Area(glyphVector.getOutline());
            double d = glyphVector.getOutline().getBounds2D().getX();
            double d2 = glyphVector.getOutline().getBounds2D().getWidth();
            if (!this.hasWidths) {
                float f2 = (float)((double)f - (d2 + d + d)) / 2.0f;
                if (f2 > 0.0f) {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, 0.0);
                    ((Area)object).transform(affineTransform);
                }
            } else {
                double d3;
                AffineTransform affineTransform;
                if (d < 0.0) {
                    d = -d;
                    affineTransform = AffineTransform.getTranslateInstance(d, 0.0);
                    ((Area)object).transform(affineTransform);
                }
                if ((d3 = (double)f / ((Area)object).getBounds2D().getWidth()) < 1.0) {
                    affineTransform = AffineTransform.getScaleInstance(d3, 1.0);
                    ((Area)object).transform(affineTransform);
                }
            }
        }
        return object;
    }

    public final void setCachedShape(int n, Area area, AffineTransform affineTransform) {
        Area[] areaArray = this.cachedShapes;
        AffineTransform[] affineTransformArray = this.cachedAt;
        if (areaArray == null) {
            this.cachedShapes = areaArray = new Area[this.maxCharCount];
            this.cachedAt = affineTransformArray = new AffineTransform[this.maxCharCount];
        }
        areaArray[n] = area == null ? null : area;
        if (area != null && affineTransform != null) {
            affineTransformArray[n] = affineTransform;
        }
    }

    public final AffineTransform getCachedTransform(int n) {
        AffineTransform[] affineTransformArray = this.cachedAt;
        if (affineTransformArray == null) {
            return null;
        }
        return affineTransformArray[n];
    }

    public final Area getCachedShape(int n) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            return null;
        }
        Area area = areaArray[n];
        if (area == null) {
            return null;
        }
        return area;
    }

    public void init(int n, boolean bl) {
        this.maxCharCount = n;
        this.isCIDFont = bl;
    }

    public final void setFont(String string, int n) {
        int n2;
        Object object;
        this.size = n;
        if (DecoderOptions.Helper != null && (object = DecoderOptions.Helper.setFont(this, StringUtils.convertHexChars(string), n)) != null) {
            this.style = ((Font)object).getStyle();
            this.font_family_name = ((Font)object).getFamily();
            this.unscaledFont = object;
            return;
        }
        this.font_family_name = string = StandardFonts.expandName(string);
        this.style = 0;
        object = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        this.testFont = this.font_family_name;
        if (this.font_family_name != null) {
            this.testFont = this.font_family_name.toLowerCase();
        }
        if ((n2 = this.font_family_name.indexOf(44)) == -1) {
            n2 = this.font_family_name.indexOf(45);
        }
        if (n2 != -1) {
            object = (String)FontMappings.fontSubstitutionAliasTable.get(this.testFont);
            this.weight = this.testFont.substring(n2 + 1, this.testFont.length());
            this.style = PdfJavaGlyphs.getWeight(this.weight);
            this.testFont = this.font_family_name = this.font_family_name.substring(0, n2).toLowerCase();
            if (this.testFont.endsWith("mt")) {
                this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
            }
        }
        if (object == null) {
            object = (String)FontMappings.fontSubstitutionAliasTable.get(this.testFont);
        }
        if (object != null && ((String)object).equals("arialbd")) {
            object = "arial-bold";
        }
        if (object != null) {
            this.font_family_name = object;
            n2 = this.font_family_name.indexOf(45);
            if (n2 != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                this.weight = this.font_family_name.substring(n2 + 1, this.font_family_name.length());
                this.style = PdfJavaGlyphs.getWeight(this.weight);
                this.font_family_name = this.font_family_name.substring(0, n2);
            }
            this.testFont = this.font_family_name.toLowerCase();
            if (this.testFont.endsWith("mt")) {
                this.testFont = this.testFont.substring(0, this.testFont.length() - 2);
            }
        }
    }

    private static int getWeight(String string) {
        int n = 0;
        if (string.endsWith("mt")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.contains("heavy")) {
            n = 1;
        } else if (string.contains("bold")) {
            n = 1;
        } else if (string.contains("roman")) {
            n = 0;
        }
        if (string.contains("italic")) {
            n += 2;
        } else if (string.contains("oblique")) {
            n += 2;
        }
        return n;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null && this.font_family_name != null) {
            int n;
            if (fontList == null) {
                fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (n = 0; n < fontList.length; ++n) {
                    PdfJavaGlyphs.fontList[n] = fontList[n].toLowerCase();
                }
            }
            if (fontList != null) {
                int n2;
                n = 0;
                int n3 = fontList.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (!fontList[n2].equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(fontList[n2]))) continue;
                    this.isFontInstalled = true;
                    this.font_family_name = fontList[n2];
                    n2 = n3;
                    n = 1;
                }
                if (n == 0) {
                    n3 = fontList.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (!fontList[n2].equals(this.testFont) && (this.weight != null || !this.testFont.startsWith(fontList[n2]))) continue;
                        this.isFontInstalled = true;
                        this.font_family_name = fontList[n2];
                        n2 = n3;
                    }
                }
                if (this.isFontInstalled && this.font_family_name.equals("arial")) {
                    this.isArialInstalledLocally = true;
                }
            }
            if (!this.isFontInstalled) {
                if (this.weight == null) {
                    String string = this.font_family_name.toLowerCase();
                    this.style = PdfJavaGlyphs.getWeight(string);
                }
                this.font_family_name = this.defaultFont;
            }
            this.unscaledFont = new Font(this.font_family_name, this.style, this.size);
        }
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    public final void setEmbeddedCachedShape(int n, PdfGlyph pdfGlyph) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            this.cachedEmbeddedShapes = pdfGlyphArray = new PdfGlyph[this.maxCharCount];
        }
        if (n < pdfGlyphArray.length) {
            pdfGlyphArray[n] = pdfGlyph;
        }
    }

    public final PdfGlyph getEmbeddedCachedShape(int n) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            return null;
        }
        if (n < pdfGlyphArray.length) {
            PdfGlyph pdfGlyph = pdfGlyphArray[n];
            if (pdfGlyph == null) {
                return null;
            }
            return pdfGlyph;
        }
        return null;
    }

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        return null;
    }

    public void setGIDtoCID(int[] nArray) {
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2) {
    }

    public int readEmbeddedFont(boolean bl, byte[] byArray, FontData fontData) {
        return 0;
    }

    public void setIsSubsetted(boolean bl) {
        this.isSubsetted = bl;
    }

    public void setT3Glyph(int n, int n2, PdfGlyph pdfGlyph) {
    }

    public void setCharString(String string, byte[] byArray, int n) {
    }

    public boolean is1C() {
        return false;
    }

    public void setis1C(boolean bl) {
    }

    public void setValuesForGlyph(int n, String string, String string2, String string3) {
        Integer n2 = n;
        this.chars.put(n2, string);
        this.displayValues.put(n2, string2);
        this.embeddedChars.put(n2, string3);
    }

    @Override
    public String getDisplayValue(Integer n) {
        return (String)this.displayValues.get(n);
    }

    @Override
    public String getCharGlyph(Integer n) {
        return (String)this.chars.get(n);
    }

    @Override
    public String getEmbeddedEnc(Integer n) {
        return (String)this.embeddedChars.get(n);
    }

    public Map getDisplayValues() {
        return Collections.unmodifiableMap(this.displayValues);
    }

    public Map getCharGlyphs() {
        return Collections.unmodifiableMap(this.chars);
    }

    public Map getEmbeddedEncs() {
        return Collections.unmodifiableMap(this.embeddedChars);
    }

    public void setDisplayValues(Map map) {
        this.displayValues = map;
    }

    public void setCharGlyphs(Map map) {
        this.chars = map;
    }

    public void setEmbeddedEncs(Map map) {
        this.embeddedChars = map;
    }

    public void setLocalBias(int n) {
        this.localBias = n;
    }

    public void setGlobalBias(int n) {
        this.globalBias = n;
    }

    public float getTTWidth(String string, int n, String string2, boolean bl) {
        return 0.0f;
    }

    public static String getPostName(int n) {
        return "notdef";
    }

    public int getConvertedGlyph(int n) {
        return -1;
    }

    public void setIsIdentity(boolean bl) {
        this.isIdentity = bl;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public float[] getFontBoundingBox() {
        return new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    }

    public void setFontEmbedded(boolean bl) {
        this.isFontEmbedded = bl;
    }

    public int getType() {
        return 0;
    }

    public void setHasWidths(boolean bl) {
        this.hasWidths = bl;
    }

    public int getCMAPValue(int n) {
        if (this.CMAP_Translate == null) {
            return -1;
        }
        return this.CMAP_Translate[n];
    }

    public boolean isCorrupted() {
        return false;
    }

    public void setCorrupted(boolean bl) {
    }

    public void setIndexForCharString(int n, String string) {
    }

    public String getIndexForCharString(int n) {
        return null;
    }

    public Map getCharStrings() {
        return null;
    }

    public void setGlyphCount(int n) {
        this.glyphCount = n;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public void setRenderer(DynamicVectorRenderer dynamicVectorRenderer) {
    }

    public Table getTable(int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

