/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectOutput;
import javafx.collections.ObservableList;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.jpedal.color.PdfTexturePaint;
import org.jpedal.fonts.glyph.BaseT1Glyph;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Path;

public class T1GlyphFX
extends BaseT1Glyph {
    private transient Vector_Path cached_current_path;
    private Paint strokePaint;
    float[] x;
    float[] y;
    float[] x2;
    float[] y2;
    float[] x3;
    float[] y3;
    float ymin;
    int end;
    int[] commands;
    Area glyphShape;
    int minX;
    int minY;
    int maxX;
    int maxY;

    public T1GlyphFX() {
    }

    public T1GlyphFX(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, float f, int n, int[] nArray) {
        this.x = fArray;
        this.y = fArray2;
        this.x2 = fArray3;
        this.y2 = fArray4;
        this.x3 = fArray5;
        this.y3 = fArray6;
        this.ymin = f;
        this.end = n;
        this.commands = nArray;
    }

    @Override
    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        if (this.cached_current_path != null) {
            GeneralPath[] generalPathArray;
            for (GeneralPath generalPath : generalPathArray = this.cached_current_path.get()) {
                if (generalPath == null) break;
                if (n == 2) {
                    Paint paint;
                    if (this.isStroked && !((paint = graphics2D.getPaint()) instanceof PdfTexturePaint) && ((Color)this.strokePaint).getRGB() != ((Color)paint).getRGB() && this.strokedPositions.containsKey(String.valueOf((int)graphics2D.getTransform().getTranslateX()) + '-' + (int)graphics2D.getTransform().getTranslateY())) {
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setPaint(this.strokePaint);
                        float f2 = (float)((double)f / graphics2D.getTransform().getScaleX());
                        if (f2 < 0.0f) {
                            f2 = -f2;
                        }
                        graphics2D.setStroke(new BasicStroke(f2));
                        graphics2D.draw(generalPath);
                        graphics2D.setPaint(paint);
                        graphics2D.setStroke(stroke);
                    }
                    graphics2D.fill(generalPath);
                }
                if (n != 1) continue;
                if (n != 2 && f > 1.0f) {
                    float f3 = (float)((double)f / graphics2D.getTransform().getScaleX());
                    if (f3 < 0.0f) {
                        f3 = -f3;
                    }
                    graphics2D.setStroke(new BasicStroke(f3));
                }
                graphics2D.draw(generalPath);
                this.strokePaint = graphics2D.getPaint();
                this.strokedPositions.put(String.valueOf((int)graphics2D.getTransform().getTranslateX()) + '-' + (int)graphics2D.getTransform().getTranslateY(), "x");
            }
        }
    }

    @Override
    public Area getShape() {
        if (this.cached_current_path != null && this.glyphShape == null) {
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n = generalPathArray.length;
            for (int i = 1; i < n && generalPathArray[i] != null; ++i) {
                generalPathArray[0].append(generalPathArray[i], false);
            }
            if (generalPathArray != null && generalPathArray[0] != null) {
                this.glyphShape = new Area(generalPathArray[0]);
            }
        }
        return this.glyphShape;
    }

    public void setPaths(Vector_Path vector_Path) {
        this.cached_current_path = vector_Path;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        if (this.cached_current_path != null) {
            int n;
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n2 = 0;
            for (n = 0; n < generalPathArray.length; ++n) {
                if (generalPathArray[n] != null) continue;
                n2 = n;
                break;
            }
            objectOutput.writeObject(n2);
            for (n = 0; n < n2; ++n) {
                PathIterator pathIterator = generalPathArray[n].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutput, pathIterator);
            }
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    public int getFontBB(int n) {
        if (this.minX == 0 && this.minY == 0 && this.maxX == 0 && this.maxY == 0 && this.cached_current_path != null) {
            GeneralPath[] generalPathArray = this.cached_current_path.get();
            int n2 = generalPathArray.length;
            for (int i = 0; i < n2 && generalPathArray[i] != null; ++i) {
                Rectangle rectangle = generalPathArray[i].getBounds();
                if (i == 0) {
                    this.minX = rectangle.x;
                    this.minY = rectangle.y;
                    this.maxX = rectangle.width;
                    this.maxY = rectangle.height;
                    continue;
                }
                if (this.minX > rectangle.x) {
                    this.minX = rectangle.x;
                }
                if (this.minY > rectangle.y) {
                    this.minY = rectangle.y;
                }
                if (this.maxX < rectangle.width) {
                    this.maxX = rectangle.width;
                }
                if (this.maxY >= rectangle.height) continue;
                this.maxY = rectangle.height;
            }
        }
        if (n == 1) {
            return this.minX;
        }
        if (n == 2) {
            return this.minY;
        }
        if (n == 3) {
            return this.maxX;
        }
        if (n == 4) {
            return this.minY;
        }
        return 0;
    }

    @Override
    public Path getPath() {
        Path path = new Path();
        path.setFillRule(FillRule.NON_ZERO);
        ObservableList observableList = path.getElements();
        observableList.add((Object)new MoveTo(0.0, 0.0));
        for (int i = 0; i < this.end; ++i) {
            if (this.commands[i] == 2) {
                observableList.add((Object)new LineTo((double)this.x[i], (double)(this.y[i] - this.ymin)));
                continue;
            }
            if (this.commands[i] == 3) {
                observableList.add((Object)new ClosePath());
                observableList.add((Object)new MoveTo(0.0, 0.0));
                continue;
            }
            if (this.commands[i] == 1) {
                observableList.add((Object)new MoveTo((double)this.x[i], (double)(this.y[i] - this.ymin)));
                continue;
            }
            if (this.commands[i] != 5) continue;
            observableList.add((Object)new CubicCurveTo((double)this.x[i], (double)(this.y[i] - this.ymin), (double)this.x2[i], (double)(this.y2[i] - this.ymin), (double)this.x3[i], (double)(this.y3[i] - this.ymin)));
        }
        return path;
    }
}

