/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.objects;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jpedal.utils.LogWriter;

public class FontData {
    private byte[] fontData;
    private boolean isInMemory;
    private int fullLength;
    private int offset;
    public static int maxSizeAllowedInMemory = -1;
    private int blockSize;
    private RandomAccessFile fontFile;

    public FontData(String string) {
        block3: {
            this.blockSize = 8192;
            try {
                this.fontFile = new RandomAccessFile(string, "r");
                this.fullLength = (int)this.fontFile.length();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        if (this.fullLength < maxSizeAllowedInMemory) {
            this.blockSize = maxSizeAllowedInMemory;
            this.adjustForCache(0);
            this.isInMemory = true;
        }
    }

    public byte getByte(int n) {
        if (!this.isInMemory) {
            n = this.adjustForCache(n);
        }
        if (n >= this.fontData.length) {
            return 0;
        }
        return this.fontData[n];
    }

    private int adjustForCache(int n) {
        if (this.fontData == null || n < this.offset || n >= this.offset + this.blockSize - 1) {
            block3: {
                try {
                    this.fontFile.seek(n);
                    this.fontData = new byte[this.blockSize];
                    this.fontFile.read(this.fontData);
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
            this.offset = n;
        }
        return n - this.offset;
    }

    private int adjustForCache(int n, int n2) {
        block2: {
            try {
                this.fontFile.seek(n);
                this.fontData = new byte[n2];
                this.fontFile.read(this.fontData);
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        this.offset = n;
        return n - this.offset;
    }

    public byte[] getBytes(int n, int n2) {
        if (!this.isInMemory) {
            n = this.adjustForCache(n, n2 + 1);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.fontData, n, byArray, 0, n2);
        return byArray;
    }

    public int length() {
        if (this.isInMemory) {
            return this.fontData.length;
        }
        return this.fullLength;
    }

    public void close() {
        block3: {
            if (this.fontFile != null) {
                try {
                    this.fontFile.close();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
        }
    }
}

