/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.util.HashSet;
import javafx.scene.shape.Path;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public abstract class BaseTTGlyph {
    transient Vector_Path paths = new Vector_Path(10);
    transient Path pathsFX;
    protected boolean ttHintingRequired;
    public static boolean useHinting = true;
    protected boolean containsBrokenGlyfData;
    protected short compMinX;
    protected short compMinY;
    protected short compMaxX;
    protected short compMaxY;
    protected short minX;
    protected short minY;
    protected short maxX;
    protected short maxY;
    protected int[] scaledX;
    protected int[] scaledY;
    protected int BPoint1;
    protected int BPoint2;
    protected final Vector_Int xtranslateValues = new Vector_Int(5);
    protected final Vector_Int ytranslateValues = new Vector_Int(5);
    protected final short leftSideBearing;
    protected final Vector_Double xscaleValues = new Vector_Double(5);
    protected final Vector_Double yscaleValues = new Vector_Double(5);
    protected final Vector_Double scale01Values = new Vector_Double(5);
    protected final Vector_Double scale10Values = new Vector_Double(5);
    protected double xscale = 1.0;
    protected double yscale = 1.0;
    protected double scale01;
    protected double scale10;
    protected int[] instructions;
    protected int xtranslate;
    protected int ytranslate;
    protected int currentInstructionDepth = Integer.MAX_VALUE;
    protected final Vector_Object glyfX = new Vector_Object(5);
    protected final Vector_Object glyfY = new Vector_Object(5);
    protected final Vector_Object curves = new Vector_Object(5);
    protected final Vector_Object contours = new Vector_Object(5);
    protected final Vector_Int endPtIndices = new Vector_Int(5);
    protected int contourCount;
    protected float unitsPerEm = 64.0f;
    public static boolean debug;
    protected int glyphNumber = -1;
    protected int compCount = 1;
    protected boolean isComposite;
    protected double pixelSize;
    private static final HashSet<String> testedFonts;
    int BP1x = -1;
    int BP2x = -1;
    int BP1y = -1;
    int BP2y = -1;
    int existingXTranslate;
    int existingYTranslate;
    int depth;
    public static boolean redecodePage;
    boolean isHinted;
    private TTVM vm;
    private String baseFontName;

    public BaseTTGlyph(Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, TTVM tTVM) {
        this.glyphNumber = n + 1;
        this.isHinted = true;
        this.leftSideBearing = hmtx.getLeftSideBearing(n);
        this.unitsPerEm = f;
        int n2 = glyf.getCharString(n);
        fontFile2.setPointer(n2);
        if (fontFile2.getBytesLeft() > 4) {
            this.readGlyph(glyf, fontFile2);
            this.vm = tTVM;
            this.createGlyph(this.isHinted);
        }
    }

    public BaseTTGlyph(Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, String string) {
        this.glyphNumber = n + 1;
        this.leftSideBearing = hmtx.getLeftSideBearing(n);
        this.unitsPerEm = f;
        this.baseFontName = string;
        int n2 = glyf.getCharString(n);
        fontFile2.setPointer(n2);
        if (fontFile2.getBytesLeft() > 4) {
            this.readGlyph(glyf, fontFile2);
            this.createGlyph(false);
        }
    }

    void createGlyph(boolean bl) {
        if (bl) {
            this.createHintedGlyph();
        } else {
            this.createUnhintedGlyph();
        }
    }

    void createUnhintedGlyph() {
        for (int i = 0; i < this.compCount; ++i) {
            int[] nArray = (int[])this.glyfX.elementAt(i);
            int[] nArray2 = (int[])this.glyfY.elementAt(i);
            boolean[] blArray = (boolean[])this.curves.elementAt(i);
            boolean[] blArray2 = (boolean[])this.contours.elementAt(i);
            int n = this.endPtIndices.elementAt(i);
            if (this.isComposite) {
                this.xtranslate = this.xtranslateValues.elementAt(i);
                this.ytranslate = this.ytranslateValues.elementAt(i);
                this.xscale = this.xscaleValues.elementAt(i);
                this.yscale = this.yscaleValues.elementAt(i);
                this.scale01 = this.scale01Values.elementAt(i);
                this.scale10 = this.scale10Values.elementAt(i);
                if (this.BPoint1 != -1 && this.BPoint2 != -1) {
                    if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                        this.BP1x = nArray[this.BPoint1];
                        this.BP1y = nArray2[this.BPoint1];
                    } else {
                        this.BP2x = nArray[this.BPoint2];
                        this.BP2y = nArray2[this.BPoint2];
                        int n2 = this.BP1x - this.BP2x;
                        int n3 = this.BP1y - this.BP2y;
                        int n4 = nArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            int n6 = n5;
                            nArray[n6] = nArray[n6] + n2;
                            if (debug) {
                                System.out.println(nArray2[n5] + " " + n3 + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                            }
                            int n7 = n5++;
                            nArray2[n7] = nArray2[n7] + n3;
                        }
                        this.BP1x = -1;
                        this.BP2x = -1;
                        this.BP1y = -1;
                        this.BP2y = -1;
                    }
                }
            }
            if (this.baseFontName != null && this.instructions != null && !testedFonts.contains(this.baseFontName)) {
                testedFonts.add(this.baseFontName);
                this.baseFontName = this.baseFontName.toLowerCase();
                if (this.baseFontName.contains("mingli") || this.baseFontName.contains("kai") || this.baseFontName.contains("huatian")) {
                    this.ttHintingRequired = true;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("TrueType hinting probably required for font " + this.baseFontName);
                    }
                }
            }
            this.createPaths(nArray, nArray2, blArray, blArray2, n);
        }
    }

    static int midPt(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    public float getmaxWidth() {
        return 0.0f;
    }

    public void setT3Colors(PdfPaint pdfPaint, PdfPaint pdfPaint2, boolean bl) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public void scaler(int[] nArray, int[] nArray2) {
        this.scaledX = new int[nArray.length];
        this.scaledY = new int[nArray2.length];
        double d = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        for (int i = 0; i < nArray.length; ++i) {
            this.scaledX[i] = (int)(d * (double)nArray[i] + 0.5);
            this.scaledY[i] = (int)(d * (double)nArray2[i] + 0.5);
        }
        this.scaledX[nArray.length - 2] = 0;
        this.scaledY[nArray2.length - 2] = 0;
        this.scaledX[nArray.length - 1] = (int)(d * (double)this.leftSideBearing + 0.5);
        this.scaledY[nArray2.length - 1] = 0;
    }

    public final void readComplexGlyph(Glyf glyf, FontFile2 fontFile2) {
        this.isComposite = true;
        this.xtranslateValues.pull();
        this.ytranslateValues.pull();
        this.xscaleValues.pull();
        this.yscaleValues.pull();
        this.scale01Values.pull();
        this.scale10Values.pull();
        this.BPoint1 = -1;
        this.BPoint2 = -1;
        boolean bl = false;
        int n = glyf.getGlypfCount();
        while (true) {
            int n2 = fontFile2.getNextUint16();
            int n3 = fontFile2.getNextUint16();
            if (debug) {
                System.err.println("Index=" + n3 + " flag=" + n2 + ' ' + n);
            }
            if (n3 >= n) {
                this.containsBrokenGlyfData = true;
                break;
            }
            boolean bl2 = (n2 & 1) == 1;
            boolean bl3 = (n2 & 2) == 2;
            boolean bl4 = (n2 & 8) == 8;
            boolean bl5 = (n2 & 0x40) == 64;
            boolean bl6 = (n2 & 0x80) == 128;
            boolean bl7 = bl = bl || (n2 & 0x100) == 256;
            if (bl2 && bl3) {
                this.xtranslate = fontFile2.getNextInt16();
                this.ytranslate = fontFile2.getNextInt16();
            } else if (!bl2 && bl3) {
                this.xtranslate = fontFile2.getNextint8();
                this.ytranslate = fontFile2.getNextint8();
            } else if (bl2 && !bl3) {
                this.BPoint1 = fontFile2.getNextUint16();
                this.BPoint2 = fontFile2.getNextUint16();
                this.xtranslate = 0;
                this.ytranslate = 0;
            } else if (!bl2 && !bl3) {
                this.BPoint1 = fontFile2.getNextUint8();
                this.BPoint2 = fontFile2.getNextUint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.scale10 = 0.0;
            this.yscale = 1.0;
            if (bl4 || bl5 || bl6) {
                if (bl4 && !bl5 && !bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = this.xscale;
                } else if (!bl4 && bl5 && !bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = fontFile2.getF2Dot14();
                } else if (!bl4 && !bl5 && bl6) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = fontFile2.getF2Dot14();
                    this.scale10 = fontFile2.getF2Dot14();
                    this.yscale = fontFile2.getF2Dot14();
                }
            }
            int n4 = this.xtranslate;
            int n5 = this.ytranslate;
            this.xtranslate += this.existingXTranslate;
            this.ytranslate += this.existingYTranslate;
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int n6 = fontFile2.getPointer();
            int n7 = glyf.getCharString(n3);
            if (n7 != -1) {
                if (n7 < 0) {
                    n7 = -n7;
                }
                fontFile2.setPointer(n7);
                this.existingXTranslate = this.xtranslate;
                this.existingYTranslate = this.ytranslate;
                ++this.depth;
                this.readGlyph(glyf, fontFile2);
                --this.depth;
                this.existingXTranslate -= n4;
                this.existingYTranslate -= n5;
            } else {
                System.err.println("Wrong value in complex");
            }
            fontFile2.setPointer(n6);
            if ((n2 & 0x20) == 0) {
                if (bl) {
                    int n8 = fontFile2.getNextUint16();
                    int[] nArray = new int[n8];
                    for (int i = 0; i < n8; ++i) {
                        nArray[i] = fontFile2.getNextUint8();
                    }
                    if (this.depth > this.currentInstructionDepth) break;
                    this.instructions = nArray;
                    this.currentInstructionDepth = this.depth;
                    break;
                }
                if (this.depth > this.currentInstructionDepth) break;
                this.instructions = new int[0];
                this.currentInstructionDepth = this.depth;
                break;
            }
            ++this.compCount;
        }
    }

    public void readSimpleGlyph(FontFile2 fontFile2) {
        block27: {
            int n = 1;
            Vector_Int vector_Int = new Vector_Int(50);
            Vector_Int vector_Int2 = new Vector_Int(50);
            Vector_Short vector_Short = new Vector_Short(50);
            Vector_Short vector_Short2 = new Vector_Short(50);
            if (debug) {
                System.out.println("endPoints");
                System.out.println("---------");
            }
            try {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.contourCount; ++n2) {
                    n3 = fontFile2.getNextUint16();
                    if (debug) {
                        System.out.println(n2 + " " + n3);
                    }
                    vector_Int2.addElement(n3);
                }
                if (fontFile2.hasValuesLeft()) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    n2 = fontFile2.getNextUint16();
                    int[] nArray = new int[n2];
                    for (n10 = 0; n10 < n2; ++n10) {
                        nArray[n10] = fontFile2.getNextUint8();
                    }
                    if (this.depth < this.currentInstructionDepth) {
                        this.instructions = nArray;
                    }
                    if (debug) {
                        System.out.println("Instructions");
                        System.out.println("------------");
                        System.out.println("count=" + n2);
                    }
                    n10 = n3 + 1;
                    for (n9 = 0; n9 < n10; ++n9) {
                        if (fontFile2.getBytesLeft() < 1) {
                            return;
                        }
                        n8 = fontFile2.getNextUint8();
                        vector_Int.addElement(n8);
                        ++n;
                        if ((n8 & 8) != 8) continue;
                        n7 = fontFile2.getNextUint8();
                        for (n6 = 1; n6 <= n7; ++n6) {
                            vector_Int.addElement(n8);
                            ++n;
                        }
                        n9 += n7;
                    }
                    for (n9 = 0; n9 < n10; ++n9) {
                        short s;
                        n8 = vector_Int.elementAt(n9);
                        if ((n8 & 0x10) != 0) {
                            if ((n8 & 2) != 0) {
                                s = (short)fontFile2.getNextUint8();
                                vector_Short.addElement(s);
                                continue;
                            }
                            vector_Short.addElement((short)0);
                            continue;
                        }
                        if ((n8 & 2) != 0) {
                            s = (short)(-fontFile2.getNextUint8());
                            vector_Short.addElement(s);
                            continue;
                        }
                        s = fontFile2.getNextSignedInt16();
                        vector_Short.addElement(s);
                    }
                    for (n9 = 0; n9 < n10; ++n9) {
                        n8 = vector_Int.elementAt(n9);
                        if ((n8 & 0x20) != 0) {
                            if ((n8 & 4) != 0) {
                                if (fontFile2.getBytesLeft() < 1) {
                                    return;
                                }
                                vector_Short2.addElement((short)fontFile2.getNextUint8());
                                continue;
                            }
                            vector_Short2.addElement((short)0);
                            continue;
                        }
                        if ((n8 & 4) != 0) {
                            vector_Short2.addElement((short)(-fontFile2.getNextUint8()));
                            continue;
                        }
                        n7 = fontFile2.getNextSignedInt16();
                        vector_Short2.addElement((short)n7);
                    }
                    n9 = 0;
                    n7 = 0;
                    n6 = 0;
                    int[] nArray2 = vector_Int.get();
                    int[] nArray3 = vector_Int2.get();
                    short[] sArray = vector_Short.get();
                    short[] sArray2 = vector_Short2.get();
                    n10 = sArray.length;
                    int[] nArray4 = new int[n10 + 2];
                    int[] nArray5 = new int[n10 + 2];
                    boolean[] blArray = new boolean[n10 + 2];
                    boolean[] blArray2 = new boolean[n10 + 2];
                    int n11 = 0;
                    if (debug) {
                        System.out.println("Points");
                        System.out.println("------");
                    }
                    for (n5 = 0; n5 < n10; ++n5) {
                        int n12 = n4 = nArray3[n9] == n5 ? 1 : 0;
                        if (n4 != 0) {
                            ++n9;
                            n11 = n5 + 1;
                        }
                        nArray4[n5] = n7 += sArray[n5];
                        nArray5[n5] = n6 += sArray2[n5];
                        blArray[n5] = n5 < n && (nArray2[n5] & 1) != 0;
                        blArray2[n5] = n4;
                        if (!debug) continue;
                        System.out.println(n5 + " " + nArray4[n5] + ' ' + nArray5[n5] + " on curve=" + blArray[n5] + " endOfContour[i]=" + blArray2[n5]);
                    }
                    for (n5 = 0; n5 < nArray4.length; ++n5) {
                        n4 = nArray4[n5];
                        int n13 = nArray5[n5];
                        nArray4[n5] = !this.isComposite ? (!useHinting ? (int)((float)n4 / this.unitsPerEm) : n4) : (!useHinting ? (int)(((double)n4 * this.xscale + (double)n13 * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm) : (int)((double)n4 * this.xscale + (double)n13 * this.scale10 + (double)this.xtranslate));
                        if (!this.isComposite) {
                            if (!useHinting) {
                                nArray5[n5] = (int)((float)n13 / this.unitsPerEm);
                                continue;
                            }
                            nArray5[n5] = n13;
                            continue;
                        }
                        nArray5[n5] = !useHinting ? (int)(((double)n4 * this.scale01 + (double)n13 * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) : (int)((double)n4 * this.scale01 + (double)n13 * this.yscale + (double)this.ytranslate);
                    }
                    this.glyfX.addElement(nArray4);
                    this.glyfY.addElement(nArray5);
                    this.curves.addElement(blArray);
                    this.contours.addElement(blArray2);
                    this.endPtIndices.addElement(n11);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block27;
                LogWriter.writeLog("Caught an Exception while reading TTGlyph bytes" + exception);
            }
        }
    }

    public void readGlyph(Glyf glyf, FontFile2 fontFile2) {
        this.contourCount = fontFile2.getNextUint16();
        this.minX = (short)fontFile2.getNextUint16();
        this.minY = (short)fontFile2.getNextUint16();
        this.maxX = (short)fontFile2.getNextUint16();
        this.maxY = (short)fontFile2.getNextUint16();
        if (this.minX > this.maxX || this.minY > this.maxY) {
            return;
        }
        if (debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("min=" + this.minX + ' ' + this.minY + " max=" + this.maxX + ' ' + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            if (this.contourCount > 0) {
                this.readSimpleGlyph(fontFile2);
            }
        } else {
            this.compMinX = this.minX;
            this.compMinY = this.minY;
            this.compMaxX = this.maxX;
            this.compMaxY = this.maxY;
            if (debug) {
                System.out.println("XXmain=" + this.minX + ' ' + this.minY + ' ' + this.maxX + ' ' + this.maxY);
            }
            this.readComplexGlyph(glyf, fontFile2);
        }
    }

    public boolean isTTHintingRequired() {
        return this.ttHintingRequired;
    }

    public void createPaths(int[] nArray, int[] nArray2, boolean[] blArray, boolean[] blArray2, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void clearPaths() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setWidth(float f) {
    }

    public int getFontBB(int n) {
        if (this.isComposite) {
            if (n == 1) {
                return this.compMinX;
            }
            if (n == 2) {
                return this.compMinY;
            }
            if (n == 3) {
                return this.compMaxX;
            }
            if (n == 4) {
                return this.compMaxY;
            }
            return 0;
        }
        if (n == 1) {
            return this.minX;
        }
        if (n == 2) {
            return this.minY;
        }
        if (n == 3) {
            return this.maxX;
        }
        if (n == 4) {
            return this.maxY;
        }
        return 0;
    }

    public void setStrokedOnly(boolean bl) {
    }

    public boolean containsBrokenData() {
        return this.containsBrokenGlyfData;
    }

    public Path getPath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getGlyphNumber() {
        return this.glyphNumber;
    }

    public void setGlyphNumber(int n) {
        this.glyphNumber = n;
    }

    public Area getShape() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void createHintedGlyph() {
        Object[] objectArray;
        Object[] objectArray2;
        int[] nArray;
        int n;
        for (n = 0; n < this.compCount; ++n) {
            nArray = (int[])this.glyfX.elementAt(n);
            int[] nArray2 = (int[])this.glyfY.elementAt(n);
            if (!this.isComposite) continue;
            this.xtranslate = this.xtranslateValues.elementAt(n);
            this.ytranslate = this.ytranslateValues.elementAt(n);
            this.xscale = this.xscaleValues.elementAt(n);
            this.yscale = this.yscaleValues.elementAt(n);
            this.scale01 = this.scale01Values.elementAt(n);
            this.scale10 = this.scale10Values.elementAt(n);
            if (this.BPoint1 == -1 || this.BPoint2 == -1) continue;
            if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                this.BP1x = nArray[this.BPoint1];
                this.BP1y = nArray2[this.BPoint1];
                continue;
            }
            this.BP2x = nArray[this.BPoint2];
            this.BP2y = nArray2[this.BPoint2];
            int n2 = this.BP1x - this.BP2x;
            int n3 = this.BP1y - this.BP2y;
            int n4 = nArray.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + n2;
                if (debug) {
                    System.out.println(nArray2[n5] + " " + n3 + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                }
                int n7 = n5++;
                nArray2[n7] = nArray2[n7] + n3;
            }
            this.BP1x = -1;
            this.BP2x = -1;
            this.BP1y = -1;
            this.BP2y = -1;
        }
        this.pixelSize = 1562.5;
        n = 2;
        nArray = new int[this.compCount];
        for (int i = 0; i < this.compCount; ++i) {
            n += this.endPtIndices.elementAt(i);
            nArray[i] = this.endPtIndices.elementAt(i);
        }
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int[] nArray6 = new int[n];
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n];
        int[] nArray7 = new int[this.compCount];
        int n8 = 0;
        for (int i = 0; i < this.compCount; ++i) {
            int[] nArray8 = (int[])this.glyfX.elementAt(i);
            int[] nArray9 = (int[])this.glyfY.elementAt(i);
            objectArray2 = (boolean[])this.curves.elementAt(i);
            objectArray = (boolean[])this.contours.elementAt(i);
            int n9 = this.endPtIndices.elementAt(i);
            if (nArray8 != null) {
                this.scaler(nArray8, nArray9);
            }
            for (int j = 0; j < nArray[i]; ++j) {
                nArray3[n8 + j] = this.scaledX[j];
                nArray4[n8 + j] = this.scaledY[j];
                nArray5[n8 + j] = nArray8[j];
                nArray6[n8 + j] = nArray9[j];
                blArray[n8 + j] = objectArray2[j];
                blArray2[n8 + j] = objectArray[j];
                nArray7[i] = n9;
            }
            n8 += nArray[i];
        }
        double d = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        nArray3[nArray3.length - 1] = (int)(d * (double)this.leftSideBearing + 0.5);
        this.vm.setScaleVars(d, this.pixelSize, this.pixelSize * 72.0 / 96.0);
        this.vm.processGlyph(this.instructions, nArray3, nArray4, blArray, blArray2);
        this.clearPaths();
        n8 = 0;
        for (int i = 0; i < this.compCount; ++i) {
            objectArray2 = (int[])this.glyfX.elementAt(i);
            objectArray = (int[])this.glyfY.elementAt(i);
            boolean[] blArray3 = (boolean[])this.curves.elementAt(i);
            boolean[] blArray4 = (boolean[])this.contours.elementAt(i);
            int n10 = nArray7[i];
            for (int j = 0; j < nArray[i]; ++j) {
                objectArray2[j] = nArray3[n8 + j];
                objectArray[j] = nArray4[n8 + j];
                blArray3[j] = blArray[n8 + j];
                blArray4[j] = blArray2[n8 + j];
            }
            this.createPaths((int[])objectArray2, (int[])objectArray, blArray3, blArray4, n10);
            n8 += nArray[i];
        }
    }

    static {
        testedFonts = new HashSet();
        String string = System.getProperty("org.jpedal.useTTFontHinting");
        if (string != null) {
            useHinting = string.equalsIgnoreCase("true");
        }
    }
}

