/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class CFF
extends Table {
    final PdfJavaGlyphs glyphs;
    boolean hasCFFdata;

    CFF(FontFile2 fontFile2, boolean bl) {
        block4: {
            int n;
            this.glyphs = new T1Glyphs(bl);
            if (bl) {
                this.glyphs.init(65536, true);
            }
            if ((n = fontFile2.selectTable(16)) != 0) {
                try {
                    int n2 = fontFile2.getTableSize(16);
                    byte[] byArray = fontFile2.readBytes(n, n2);
                    new Type1C(byArray, null, this.glyphs);
                    this.hasCFFdata = true;
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block4;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
    }

    public boolean hasCFFData() {
        return this.hasCFFdata;
    }

    public PdfGlyph getCFFGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        return this.glyphs.getEmbeddedGlyph(glyphFactory, string, fArray, n, string2, f, string3);
    }
}

