/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Loca
extends Table {
    int[] glyphIndexStart;
    boolean isCorrupted;
    public int format;
    public int glyphCount;
    public int glyfTableLength;

    public Loca(FontFile2 fontFile2, int n, int n2) {
        if (fontFile2 == null) {
            return;
        }
        this.format = n2;
        this.glyphCount = n;
        this.glyfTableLength = fontFile2.getOffset(4);
        int n3 = fontFile2.selectTable(3);
        int n4 = fontFile2.getOffset(3);
        this.glyphIndexStart = new int[n + 1];
        if (n3 != 0) {
            this.glyphIndexStart[0] = 0;
            if (n2 == 1 || n2 == 256) {
                if (LogWriter.isOutput() && n4 / 4 != n + 1) {
                    LogWriter.writeLog("Incorrect length");
                }
                for (int i = 0; i < n; ++i) {
                    this.glyphIndexStart[i] = fontFile2.getNextUint32();
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.glyphIndexStart[i] = fontFile2.getNextUint16() * 2;
                }
            }
            this.glyphIndexStart[n] = this.glyfTableLength;
        }
    }

    public int[] getIndices() {
        return this.glyphIndexStart;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public int getFormat() {
        return this.format;
    }

    public int getGlyphCount() {
        return this.glyphCount;
    }

    public int getGlyfTableLength() {
        return this.glyfTableLength;
    }
}

