/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Path;

public class TTGlyph
extends BaseTTGlyph
implements PdfGlyph,
Serializable {
    Area glyphShape;
    BufferedImage img;

    public void setPaths(Vector_Path vector_Path) {
        this.paths = vector_Path;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        if (this.paths != null) {
            int n;
            GeneralPath[] generalPathArray = this.paths.get();
            int n2 = 0;
            for (n = 0; n < generalPathArray.length; ++n) {
                if (generalPathArray[n] != null) continue;
                n2 = n;
                break;
            }
            objectOutput.writeObject(n2);
            for (n = 0; n < n2; ++n) {
                PathIterator pathIterator = generalPathArray[n].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutput, pathIterator);
            }
        }
    }

    public TTGlyph(Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, String string) {
        block6: {
            super(glyf, fontFile2, hmtx, n, f, string);
            if (debug) {
                try {
                    System.out.println("debugging" + n);
                    BufferedImage bufferedImage = new BufferedImage(700, 700, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    for (int i = 0; i < this.paths.size() - 1; ++i) {
                        if (i == 0) {
                            graphics2D.setColor(Color.red);
                        } else {
                            graphics2D.setColor(Color.blue);
                        }
                        graphics2D.fill(this.paths.elementAt(i));
                        graphics2D.draw(this.paths.elementAt(i).getBounds());
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
    }

    public TTGlyph(Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f, TTVM tTVM) {
        block6: {
            super(glyf, fontFile2, hmtx, n, f, tTVM);
            if (debug) {
                try {
                    System.out.println("debugging" + n);
                    BufferedImage bufferedImage = new BufferedImage(700, 700, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    for (int i = 0; i < this.paths.size() - 1; ++i) {
                        if (i == 0) {
                            graphics2D.setColor(Color.red);
                        } else {
                            graphics2D.setColor(Color.blue);
                        }
                        graphics2D.fill(this.paths.elementAt(i));
                        graphics2D.draw(this.paths.elementAt(i).getBounds());
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
    }

    @Override
    public void render(int n, Graphics2D graphics2D, float f, boolean bl) {
        AffineTransform affineTransform = graphics2D.getTransform();
        BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
        float f2 = basicStroke.getLineWidth();
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (useHinting) {
            graphics2D.scale(0.01, 0.01);
            f2 *= 100.0f;
        }
        graphics2D.setStroke(new BasicStroke(f2, 0, 1, basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()));
        for (int i = 0; i < this.paths.size() - 1; ++i) {
            if ((n & 2) == 2) {
                graphics2D.fill(this.paths.elementAt(i));
                continue;
            }
            if ((n & 1) != 1) continue;
            graphics2D.draw(this.paths.elementAt(i));
        }
        if (useHinting) {
            graphics2D.setStroke(basicStroke);
            graphics2D.setTransform(affineTransform);
        }
    }

    @Override
    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath generalPath = this.paths.elementAt(0);
            for (int i = 1; i < this.paths.size() - 1; ++i) {
                generalPath.append(this.paths.elementAt(i), false);
            }
            if (generalPath == null) {
                return null;
            }
            this.glyphShape = new Area(generalPath);
        }
        return this.glyphShape;
    }

    @Override
    public void createPaths(int[] nArray, int[] nArray2, boolean[] blArray, boolean[] blArray2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (blArray2 == null) {
            return;
        }
        int n7 = blArray2.length;
        int n8 = 0;
        int n9 = -1;
        for (n6 = 0; n6 < n7; ++n6) {
            if (blArray2[n6]) {
                if (!(n9 == -1 || blArray[n8] && blArray[n6])) {
                    int n10 = n9 - n8;
                    n5 = nArray.length;
                    int[] nArray3 = new int[n5];
                    System.arraycopy(nArray, 0, nArray3, 0, n5);
                    int[] nArray4 = new int[n5];
                    System.arraycopy(nArray2, 0, nArray4, 0, n5);
                    boolean[] blArray3 = new boolean[n5];
                    System.arraycopy(blArray, 0, blArray3, 0, n5);
                    for (n4 = n8; n4 < n6 + 1; ++n4) {
                        n3 = n4 + n10;
                        if (n3 > n6) {
                            n3 -= n6 - n8 + 1;
                        }
                        nArray[n4] = nArray3[n3];
                        nArray2[n4] = nArray4[n3];
                        blArray[n4] = blArray3[n3];
                    }
                }
                n8 = n6 + 1;
                n9 = -1;
                continue;
            }
            if (!blArray[n6] || n9 != -1) continue;
            n9 = n6;
        }
        n6 = 1;
        GeneralPath generalPath = new GeneralPath(1);
        n3 = nArray.length;
        n5 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray2[n2]) continue;
            n5 = n2 + 1;
            n2 = n3;
        }
        int n11 = 0;
        n4 = 0;
        int n12 = 0;
        int n13 = 0;
        n2 = nArray[0];
        int n14 = nArray2[0];
        if (debug) {
            System.out.println(nArray[0] + " " + nArray2[0] + " move to x1,y1=" + n2 + ' ' + n14);
        }
        generalPath.moveTo(n2, n14);
        if (debug) {
            System.out.println("first contour=" + n5 + "====================================" + nArray[0] + ' ' + nArray2[0]);
        }
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n18;
            int n19 = i % n5;
            int n20 = (i + 1) % n5;
            int n21 = (i + 2) % n5;
            int n22 = (i - 1) % n5;
            if (i == 0) {
                n22 = n5 - 1;
            }
            if (n20 < n17) {
                n20 += n17;
            }
            if (n21 < n17) {
                n21 += n17;
            }
            if (debug) {
                System.out.println("points=" + n17 + '/' + n5 + ' ' + n22 + ' ' + n19 + ' ' + n20 + ' ' + n21 + " j=" + i + " endOfContour[j]=" + blArray2[i]);
            }
            if (blArray2[i]) {
                bl = true;
                if (blArray[n5]) {
                    n15 = nArray[n5];
                    n16 = nArray2[n5];
                } else {
                    n15 = nArray[i + 1];
                    n16 = nArray2[i + 1];
                }
                n17 = n5;
                for (n18 = i + 1; n18 < n3; ++n18) {
                    if (!blArray2[n18]) continue;
                    n5 = n18 + 1;
                    n18 = n3;
                }
                if (debug) {
                    System.out.println("End of contour. next=" + i + ' ' + n5 + ' ' + n17);
                }
            }
            if (debug) {
                if (i > 0) {
                    System.out.println("curves=" + blArray[n19] + ' ' + blArray[n20] + ' ' + blArray[n21] + " EndOfContour j-1=" + blArray2[i - 1] + " j=" + blArray2[i] + " j+1=" + blArray2[i + 1]);
                } else {
                    System.out.println("curves=" + blArray[n19] + ' ' + blArray[n20] + ' ' + blArray[n21] + " EndOfContour j=" + blArray2[i] + " j+1=" + blArray2[i + 1]);
                }
            }
            if (n17 == n5 && blArray[n19]) {
                i = n3;
                if (!debug) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (debug) {
                System.out.println(n5 + " " + n22 + ' ' + n19 + ' ' + n20 + ' ' + n21);
            }
            if (blArray[n19] && blArray[n20]) {
                n12 = nArray[n20];
                n13 = nArray2[n20];
                generalPath.lineTo(n12, n13);
                if (debug) {
                    System.out.println(n19 + " pt,pt " + n12 + ' ' + n13 + " (lineTo)");
                }
                n6 = 0;
            } else if (i < n3 - 3 && (n5 - n17 > 1 || n5 == n17)) {
                n18 = 0;
                if (blArray[n19] && !blArray[n20] && blArray[n21]) {
                    n2 = nArray[n19];
                    n14 = nArray2[n19];
                    n11 = nArray[n20];
                    n4 = nArray2[n20];
                    n12 = nArray[n21];
                    n13 = nArray2[n21];
                    ++i;
                    n18 = 1;
                    if (debug) {
                        System.out.println(n19 + " pt,cv,pt " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (blArray[n19] && !blArray[n20] && !blArray[n21]) {
                    n2 = nArray[n19];
                    n14 = nArray2[n19];
                    n11 = nArray[n20];
                    n4 = nArray2[n20];
                    n12 = TTGlyph.midPt(nArray[n20], nArray[n21]);
                    n13 = TTGlyph.midPt(nArray2[n20], nArray2[n21]);
                    ++i;
                    n18 = 1;
                    if (debug) {
                        System.out.println(n19 + " pt,cv,cv " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (!(blArray[n19] || blArray[n20] || blArray2[n21] && n5 - n21 != 1)) {
                    n2 = TTGlyph.midPt(nArray[n22], nArray[n19]);
                    n14 = TTGlyph.midPt(nArray2[n22], nArray2[n19]);
                    n11 = nArray[n19];
                    n4 = nArray2[n19];
                    n12 = TTGlyph.midPt(nArray[n19], nArray[n20]);
                    n13 = TTGlyph.midPt(nArray2[n19], nArray2[n20]);
                    if (debug) {
                        System.out.println(n19 + " cv,cv1 " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                } else if (!blArray[n19] && blArray[n20]) {
                    n2 = TTGlyph.midPt(nArray[n22], nArray[n19]);
                    n14 = TTGlyph.midPt(nArray2[n22], nArray2[n19]);
                    n11 = nArray[n19];
                    n4 = nArray2[n19];
                    n12 = nArray[n20];
                    n13 = nArray2[n20];
                    if (debug) {
                        System.out.println(n19 + " cv,pt " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                    }
                }
                if (n6 != 0) {
                    generalPath.moveTo(n2, n14);
                    n6 = 0;
                    if (debug) {
                        System.out.println("first draw move to " + n2 + ' ' + n14);
                    }
                }
                if (!blArray2[n19] || n19 <= 0 || !blArray2[n19 - 1]) {
                    generalPath.curveTo(n2, n14, n11, n4, n12, n13);
                }
                if (debug) {
                    System.out.println("curveto " + n2 + ' ' + n14 + ' ' + n11 + ' ' + n4 + ' ' + n12 + ' ' + n13);
                }
                if (n18 != 0 && blArray2[i]) {
                    bl = true;
                    n15 = nArray[n5];
                    n16 = nArray2[n5];
                    n17 = n5;
                    for (int j = i + 1; j < n3; ++j) {
                        if (!blArray2[j]) continue;
                        n5 = j + 1;
                        j = n3;
                    }
                    if (debug) {
                        System.out.println("Curve");
                    }
                }
            }
            if (blArray2[n19]) {
                generalPath.closePath();
            }
            if (debug) {
                System.out.println("x2 " + n15 + ' ' + n16 + ' ' + bl);
            }
            if (bl) {
                generalPath.moveTo(n15, n16);
                bl = false;
                if (debug) {
                    System.out.println("Move to " + n15 + ' ' + n16);
                }
            }
            if (!debug) continue;
            try {
                if (this.img == null) {
                    this.img = new BufferedImage(800, 800, 2);
                }
                Graphics2D graphics2D = this.img.createGraphics();
                graphics2D.setColor(Color.green);
                graphics2D.draw(generalPath);
                String string = String.valueOf(n19);
                ShowGUIMessage.showGUIMessage(string, this.img, string);
                continue;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.paths.addElement(generalPath);
        if (debug) {
            System.out.println("Ends at " + n2 + ' ' + n14 + " x=" + this.minX + ',' + this.maxX + " y=" + this.minY + ',' + this.maxY + " glyph x=" + this.compMinX + ',' + this.compMaxX + " y=" + this.compMinY + ',' + this.compMaxY);
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    void clearPaths() {
        this.paths.clear();
    }
}

