/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.io.Serializable;
import org.jpedal.fonts.tt.hinting.TTVM;

public class TTGraphicsState
implements Cloneable,
Serializable {
    public static final int x_axis = 0x40000000;
    public static final int y_axis = 16384;
    public static final int hg = 104;
    public static final int g = 72;
    public static final int dg = 8;
    public static final int dtg = 68;
    public static final int utg = 64;
    public static final int off = -1;
    public boolean autoFlip = true;
    public int controlValueTableCutIn = 68;
    public int deltaBase = 9;
    public int deltaShift = 3;
    public int freedomVector = 0x40000000;
    public int projectionVector = 0x40000000;
    public int dualProjectionVector = 0x40000000;
    public int instructControl;
    public int loop = 1;
    public int minimumDistance = 1;
    public int roundState = 72;
    public double gridPeriod = 1.0;
    public int rp0;
    public int rp1;
    public int rp2;
    public int singleWidthCutIn;
    public int singleWidthValue;
    public int zp0 = 1;
    public int zp1 = 1;
    public int zp2 = 1;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public double round(double d) {
        if (this.roundState == -1) {
            return d;
        }
        boolean bl = d > 0.0;
        int n = this.roundState >> 6 & 3;
        double d2 = n == 0 ? this.gridPeriod / 2.0 : (n == 1 ? this.gridPeriod : this.gridPeriod * 2.0);
        n = this.roundState >> 4 & 3;
        double d3 = n == 0 ? 0.0 : (n == 1 ? d2 / 4.0 : (n == 2 ? d2 / 2.0 : 3.0 * d2 / 4.0));
        n = this.roundState & 0xF;
        if (n == 0) {
            double d4;
            for (d4 = d3; d4 < d; d4 += d2) {
            }
            return d4;
        }
        double d5 = (double)(n - 4) * d2 / 8.0;
        d -= d3;
        double d6 = 0.0;
        if (d > 0.0) {
            d += d5;
            while (d6 + d2 <= d) {
                d6 += d2;
            }
        } else {
            d -= d5;
            while (d6 - d2 >= d) {
                d6 -= d2;
            }
        }
        d = d6;
        d += d3;
        if (bl && d < 0.0) {
            d = d3 % d2;
        }
        if (!bl && d > 0.0) {
            d = (d3 - 10.0 * d2) % d2;
        }
        return d;
    }

    public int round(int n) {
        double d = TTVM.getDoubleFromF26Dot6(n);
        d = this.round(d);
        return TTVM.storeDoubleAsF26Dot6(d);
    }

    public int[] getFVMoveforPVDistance(int n) {
        if (n == 0) {
            return new int[]{0, 0};
        }
        int[] nArray = TTGraphicsState.getVectorComponents(this.freedomVector);
        nArray[0] = TTVM.storeDoubleAsF26Dot6(TTVM.getDoubleFromF2Dot14(nArray[0]));
        nArray[1] = TTVM.storeDoubleAsF26Dot6(TTVM.getDoubleFromF2Dot14(nArray[1]));
        double d = TTVM.getDoubleFromF26Dot6(TTGraphicsState.getCoordsOnVector(this.projectionVector, nArray[0], nArray[1]));
        if (d != 0.0) {
            double d2 = TTVM.getDoubleFromF26Dot6(n);
            nArray[0] = (int)((double)nArray[0] * d2 / d);
            nArray[1] = (int)((double)nArray[1] * d2 / d);
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
        return nArray;
    }

    static int[] getVectorComponents(int n) {
        return new int[]{n >> 16, n << 16 >> 16};
    }

    static int createVector(int n, int n2) {
        return ((n & 0xFFFF) << 16) + (n2 & 0xFFFF);
    }

    static int getCoordsOnVector(int n, int n2, int n3) {
        long l;
        int[] nArray = TTGraphicsState.getVectorComponents(n);
        long l2 = (long)nArray[0] * (long)n2;
        long l3 = l2 + (l = (long)nArray[1] * (long)n3);
        boolean bl = (l3 & 0x3FFFL) >= 127L;
        l3 >>= 14;
        if (bl) {
            ++l3;
        }
        return (int)l3;
    }

    public void resetForGlyph() {
        this.zp0 = 1;
        this.zp1 = 1;
        this.zp2 = 1;
        this.projectionVector = 0x40000000;
        this.dualProjectionVector = 0x40000000;
        this.freedomVector = 0x40000000;
        this.roundState = 72;
        this.loop = 1;
        this.controlValueTableCutIn = 68;
    }
}

