/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFExponential
extends PDFGenericFunction
implements PDFFunction {
    private float[] C0 = new float[]{0.0f};
    private float[] C1 = new float[]{1.0f};
    private final float N;
    final int returnValues;
    private final float[] diffs;

    public PDFExponential(float f, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        super(fArray3, fArray4);
        this.N = f;
        if (fArray != null) {
            this.C0 = fArray;
        }
        if (fArray2 != null) {
            this.C1 = fArray2;
        }
        this.returnValues = this.C0.length;
        this.diffs = new float[this.returnValues];
        for (int i = 0; i < this.diffs.length; ++i) {
            this.diffs[i] = this.C1[i] - this.C0[i];
        }
    }

    @Override
    public float[] computeStitch(float[] fArray) {
        return this.compute(fArray);
    }

    @Override
    public float[] compute(float[] fArray) {
        int n;
        float[] fArray2 = new float[this.returnValues];
        float f = PDFExponential.min(PDFExponential.max(fArray[0], this.domain[0]), this.domain[1]);
        if ((double)this.N != 1.0) {
            f = (float)Math.pow(f, this.N);
        }
        for (n = 0; n < this.C0.length; ++n) {
            fArray2[n] = this.C0[n] + f * this.diffs[n];
        }
        if (this.range != null) {
            for (n = 0; n < this.C0.length; ++n) {
                fArray2[n] = PDFExponential.min(PDFExponential.max(fArray2[n], this.range[n * 2]), this.range[n * 2 + 1]);
            }
        }
        return fArray2;
    }
}

