/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

public class ImageOps {
    private static final int[] bitCheck = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    private static byte[] invertByteImage(int n, int n2, int n3, byte[] byArray) {
        int n4 = byArray.length / (n * n2);
        if (n4 != n3) {
            n3 = n4;
        }
        int n5 = n * n3;
        int n6 = 0;
        for (int i = (n2 - 1) * n5; n6 < i; n6 += n5, i -= n5) {
            for (int j = 0; j < n5; j += n3) {
                for (int k = 0; k < n3; ++k) {
                    byte by = byArray[n6 + j + k];
                    byArray[n6 + j + k] = byArray[i + j + k];
                    byArray[i + j + k] = by;
                }
            }
        }
        return byArray;
    }

    private static byte[] invertOneBitImage(int n, int n2, byte[] byArray) {
        int n3 = (n + 7) / 8;
        int n4 = 0;
        for (int i = (n2 - 1) * n3; n4 < i; n4 += n3, i -= n3) {
            for (int j = 0; j < n3; ++j) {
                byte by = byArray[n4 + j];
                byArray[n4 + j] = byArray[i + j];
                byArray[i + j] = by;
            }
        }
        return byArray;
    }

    private static byte[] rotateOneBitImage(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = (n + 7) / 8;
        int n6 = (n4 + 7) / 8;
        byte[] byArray2 = new byte[n6 * n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n7 = (n2 - 1 - i) * n5 + (j >> 3);
                byte by = byArray[n7];
                if (by == 0) {
                    j += 7;
                    continue;
                }
                int n8 = j & 7;
                if ((by & bitCheck[n8]) != bitCheck[n8]) continue;
                int n9 = j * n6 + (i >> 3);
                byte by2 = byArray2[n9];
                int n10 = i & 7;
                byArray2[n9] = by2 = (byte)(by2 | bitCheck[n10]);
            }
        }
        return byArray2;
    }

    private static byte[] rotateByteImage(int n, int n2, int n3, byte[] byArray) {
        int n4 = byArray.length / (n * n2);
        if (n4 != n3) {
            n3 = n4;
        }
        int n5 = n * n3;
        int n6 = n2 * n3;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n5; j += n3) {
                int n7 = j / n3 * n6 + (n6 - i * n3 - n3);
                for (int k = 0; k < n3; ++k) {
                    byArray2[n7 + k] = byArray[i * n5 + (j + k)];
                }
            }
        }
        return byArray2;
    }

    public static byte[] invertImage(byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2) {
        if (n3 == 8) {
            if (byArray2 != null) {
                n4 = 1;
            } else {
                byArray = ImageOps.checkSize(byArray, n, n2, n4);
            }
            return ImageOps.invertByteImage(n, n2, n4, byArray);
        }
        if (n3 == 1) {
            return ImageOps.invertOneBitImage(n, n2, byArray);
        }
        return null;
    }

    public static byte[] rotateImage(byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2) {
        if (n3 == 8) {
            if (byArray2 != null) {
                n4 = 1;
            }
            return ImageOps.rotateByteImage(n, n2, n4, byArray);
        }
        if (n3 != 4 && n3 == 1) {
            return ImageOps.rotateOneBitImage(n, n2, byArray, n, n2);
        }
        return null;
    }

    public static byte[] checkSize(byte[] byArray, int n, int n2, int n3) {
        int n4 = n * n2 * n3;
        if (byArray.length < n4) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        return byArray;
    }
}

