/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.CMYKtoRGB;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.utils.LogWriter;

public class ColorSpaceConvertor {
    public static boolean isUsingARGB;

    public static BufferedImage convertFromICCCMYK(int n, int n2, byte[] byArray) {
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Converting ICC/CMYK colorspace to sRGB ");
        }
        try {
            int n3 = n * n2 * 4;
            if (byArray.length < n3) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            return ColorSpaceConvertor.profileConvertCMYKImageToRGB(byArray, n, n2);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception  " + exception + " converting from ICC colorspace");
            }
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedImage convertToRGB(BufferedImage bufferedImage) {
        if (bufferedImage.getType() != 1) {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                new ColorConvertOp(ColorSpaces.hints).filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + exception + " converting to RGB");
                }
            }
            catch (Error error) {
                error.printStackTrace();
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Error " + error + " converting to RGB");
                }
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    public static BufferedImage convertToARGB(BufferedImage bufferedImage) {
        block3: {
            if (bufferedImage.getType() != 2) {
                try {
                    BufferedImage bufferedImage2 = bufferedImage;
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
                    ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                    colorConvertOp.filter(bufferedImage2, bufferedImage);
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception " + exception + " creating argb image");
                }
            }
        }
        isUsingARGB = true;
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block4: {
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 4;
            double d = -1.0;
            double d2 = -1.12;
            double d3 = -1.12;
            double d4 = -1.21;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            int n4 = 0;
            for (int i = 0; i < n3; i += 4) {
                double d8 = (double)(byArray[i] & 0xFF) / 255.0;
                double d9 = (double)(byArray[i + 1] & 0xFF) / 255.0;
                double d10 = (double)(byArray[i + 2] & 0xFF) / 255.0;
                double d11 = (double)(byArray[i + 3] & 0xFF) / 255.0;
                if (d != d8 || d2 != d9 || d3 != d10 || d4 != d11) {
                    double d12 = ColorSpaceConvertor.clip01(d8 + d11);
                    double d13 = ColorSpaceConvertor.clip01(d9 + d11);
                    double d14 = ColorSpaceConvertor.clip01(d10 + d11);
                    double d15 = (1.0 - d12) * (1.0 - d13) * (1.0 - d14);
                    double d16 = d12 * (1.0 - d13) * (1.0 - d14);
                    double d17 = (1.0 - d12) * d13 * (1.0 - d14);
                    double d18 = (1.0 - d12) * (1.0 - d13) * d14;
                    double d19 = (1.0 - d12) * d13 * d14;
                    double d20 = d12 * (1.0 - d13) * d14;
                    double d21 = d12 * d13 * (1.0 - d14);
                    d5 = 255.0 * ColorSpaceConvertor.clip01(d15 + 0.9137 * d17 + 0.9961 * d18 + 0.9882 * d19);
                    d6 = 255.0 * ColorSpaceConvertor.clip01(d15 + 0.6196 * d16 + d18 + 0.5176 * d20);
                    d7 = 255.0 * ColorSpaceConvertor.clip01(d15 + 0.7804 * d16 + 0.5412 * d17 + 0.0667 * d19 + 0.2118 * d20 + 0.4863 * d21);
                    d = d8;
                    d2 = d9;
                    d3 = d10;
                    d4 = d11;
                }
                byArray2[n4++] = (byte)d5;
                byArray2[n4++] = (byte)d6;
                byArray2[n4++] = (byte)d7;
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage profileConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block4: {
            ColorSpace colorSpace = DeviceCMYKColorSpace.getColorSpaceInstance();
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 4;
            float f = -1.0f;
            float f2 = -1.0f;
            float f3 = -1.0f;
            float f4 = -1.0f;
            float[] fArray = new float[3];
            int n4 = 0;
            for (int i = 0; i < n3; i += 4) {
                float f5 = (float)(byArray[i] & 0xFF) / 255.0f;
                float f6 = (float)(byArray[i + 1] & 0xFF) / 255.0f;
                float f7 = (float)(byArray[i + 2] & 0xFF) / 255.0f;
                float f8 = (float)(byArray[i + 3] & 0xFF) / 255.0f;
                if (f != f5 || f2 != f6 || f3 != f7 || f4 != f8) {
                    fArray = colorSpace.toRGB(new float[]{f5, f6, f7, f8});
                    f = f5;
                    f2 = f6;
                    f3 = f7;
                    f4 = f8;
                }
                byArray2[n4++] = (byte)(fArray[0] * 255.0f);
                byArray2[n4++] = (byte)(fArray[1] * 255.0f);
                byArray2[n4++] = (byte)(fArray[2] * 255.0f);
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage algorithmicConvertYCbCrToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block11: {
            bufferedImage = null;
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 3;
            if (n3 > byArray.length) {
                n3 = byArray.length;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            for (int i = 0; i < n3; i += 3) {
                int n11 = byArray[i] & 0xFF;
                int n12 = byArray[1 + i] & 0xFF;
                int n13 = byArray[2 + i] & 0xFF;
                if (n7 != n11 || n8 != n12 || n9 != n13) {
                    float f = 298.082f * (float)n11;
                    n4 = (int)((double)((f + 408.583f * (float)n13) / 256.0f) - 222.921);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                    if ((n5 = (int)((f - 100.291f * (float)n12 - 208.12f * (float)n13) / 256.0f + 135.576f)) < 0) {
                        n5 = 0;
                    }
                    if (n5 > 255) {
                        n5 = 255;
                    }
                    if ((n6 = (int)((f + 516.412f * (float)n12) / 256.0f - 276.836f)) < 0) {
                        n6 = 0;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    n7 = n11;
                    n8 = n12;
                    n9 = n13;
                }
                byArray2[n10++] = (byte)n4;
                byArray2[n10++] = (byte)n5;
                byArray2[n10++] = (byte)n6;
            }
            try {
                bufferedImage = new BufferedImage(n, n2, 1);
                Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray2, n, n2);
                bufferedImage.setData(raster);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!LogWriter.isOutput()) break block11;
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        return bufferedImage;
    }

    public static BufferedImage convertIndexedToFlat(int n, int n2, int n3, byte[] byArray, byte[] byArray2, boolean bl, boolean bl2) {
        int[] nArray;
        int[] nArray2 = new int[]{0, 1, 2};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        int n4 = 3;
        if (bl) {
            nArray = nArray3;
            n4 = 4;
        } else {
            nArray = nArray2;
        }
        byte[] byArray3 = ColorSpaceConvertor.convertIndexToRGBByte(byArray2, n2, n3, n4, n, byArray, bl2, bl);
        BufferedImage bufferedImage = bl ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 1);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray3, byArray3.length);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2 * n4, n4, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public static byte[] normaliseTo8Bit(int n, int n2, int n3, byte[] byArray) throws RuntimeException {
        if (n != 8) {
            int n4 = n2 * n3;
            byte[] byArray2 = new byte[n4];
            switch (n) {
                case 1: {
                    ColorSpaceConvertor.flatten1bpc(n2, byArray, 0, null, false, n4, 0, byArray2);
                    break;
                }
                case 2: {
                    ColorSpaceConvertor.flatten2bpc(n2, byArray, null, false, n4, byArray2);
                    break;
                }
                case 4: {
                    ColorSpaceConvertor.flatten4bpc(n2, byArray, n4, byArray2);
                    break;
                }
                case 16: {
                    for (int i = 0; i < n4; ++i) {
                        byArray2[i] = byArray[i * 2];
                    }
                    break;
                }
                default: {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("unknown comp= " + n);
                }
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public static byte[] convertIndexToRGBByte(byte[] byArray, int n, int n2, int n3, int n4, byte[] byArray2, boolean bl, boolean bl2) {
        int n5 = 0;
        if (byArray != null) {
            n5 = byArray.length;
        }
        int n6 = n * n2 * n3;
        byte[] byArray3 = new byte[n6];
        int n7 = 0;
        float f = 0.0f;
        switch (n4) {
            case 8: {
                ColorSpaceConvertor.flatten8bpc(byArray2, bl, f, n7, n6, byArray3, byArray, n5, bl2);
                break;
            }
            case 4: {
                ColorSpaceConvertor.flatten4bpc(n, byArray2, byArray, bl2, n6, byArray3);
                break;
            }
            case 2: {
                ColorSpaceConvertor.flatten2bpc(n, byArray2, byArray, bl2, n6, byArray3);
                break;
            }
            case 1: {
                ColorSpaceConvertor.flatten1bpc(n, byArray2, n3, byArray, bl2, n6, 255, byArray3);
            }
        }
        return byArray3;
    }

    public static void flatten8bpc(byte[] byArray, boolean bl, float f, int n, int n2, byte[] byArray2, byte[] byArray3, int n3, boolean bl2) {
        int n4 = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (bl) {
                f = (float)(byArray[i] & 0xFF) / 255.0f;
            } else {
                n = (byArray[i] & 0xFF) * 3;
            }
            if (n4 >= n2) break;
            if (bl) {
                if (f > 0.0f) {
                    byArray2[n4++] = (byte)((float)(255 - byArray3[0]) * f);
                    byArray2[n4++] = (byte)((float)(255 - byArray3[1]) * f);
                    byArray2[n4++] = (byte)((float)(255 - byArray3[2]) * f);
                } else {
                    n4 += 3;
                }
            } else if (n < n3) {
                byArray2[n4++] = byArray3[n];
                byArray2[n4++] = byArray3[n + 1];
                byArray2[n4++] = byArray3[n + 2];
            }
            if (!bl2) continue;
            byArray2[n4++] = n == 0 && f == 0.0f ? -1 : 0;
        }
    }

    private static void flatten4bpc(int n, byte[] byArray, byte[] byArray2, boolean bl, int n2, byte[] byArray3) {
        int n3 = 0;
        int[] nArray = new int[]{4, 0};
        int n4 = 0;
        block0: for (byte by : byArray) {
            for (int i = 0; i < 2; ++i) {
                int n5 = (by >> nArray[i] & 0xF) * 3;
                if (n3 >= n2) continue block0;
                byArray3[n3++] = byArray2[n5];
                byArray3[n3++] = byArray2[n5 + 1];
                byArray3[n3++] = byArray2[n5 + 2];
                if (bl) {
                    byArray3[n3++] = n5 == 0 ? (byte)0 : 0;
                }
                if (++n4 != n) continue;
                n4 = 0;
                i = 8;
            }
        }
    }

    public static void flatten1bpc(int n, byte[] byArray, int n2, byte[] byArray2, boolean bl, int n3, int n4, byte[] byArray3) {
        int n5 = 0;
        int n6 = 0;
        block0: for (byte by : byArray) {
            for (int i = 0; i < 8; ++i) {
                int n7 = by >> 7 - i & 1;
                if (n5 >= n3) continue block0;
                if (bl) {
                    if ((n7 *= 3) == 0) {
                        byArray3[n5++] = byArray2[n7];
                        byArray3[n5++] = byArray2[n7 + 1];
                        byArray3[n5++] = byArray2[n7 + 2];
                        byArray3[n5++] = (byte)n4;
                    } else {
                        byArray3[n5++] = byArray2[n7];
                        byArray3[n5++] = byArray2[n7 + 1];
                        byArray3[n5++] = byArray2[n7 + 2];
                        byArray3[n5++] = 0;
                    }
                } else if (byArray2 == null) {
                    byArray3[n5++] = n7 == 1 ? -1 : 0;
                } else {
                    n7 *= n2;
                    for (int j = 0; j < n2; ++j) {
                        byArray3[n5++] = byArray2[n7 + j];
                    }
                }
                if (++n6 != n) continue;
                n6 = 0;
                i = 8;
            }
        }
    }

    public static void flatten2bpc(int n, byte[] byArray, byte[] byArray2, boolean bl, int n2, byte[] byArray3) {
        int n3 = 0;
        int[] nArray = new int[]{6, 4, 2, 0};
        int n4 = 0;
        for (byte by : byArray) {
            for (int i = 0; i < 4 && n3 < n2; ++i) {
                int n5;
                if (byArray2 == null) {
                    n5 = by << nArray[3 - i] & 0xC0;
                    if (n5 == 192) {
                        n5 = 255;
                    }
                    byArray3[n3++] = (byte)n5;
                } else {
                    n5 = (by >> nArray[i] & 3) * 3;
                    byArray3[n3++] = byArray2[n5];
                    byArray3[n3++] = byArray2[n5 + 1];
                    byArray3[n3++] = byArray2[n5 + 2];
                    if (bl) {
                        byArray3[n3++] = n5 == 0 ? (byte)0 : 0;
                    }
                }
                if (++n4 != n) continue;
                n4 = 0;
                i = 8;
            }
        }
    }

    public static BufferedImage iccConvertCMYKImageToRGB(byte[] byArray, int n, int n2) {
        int n3 = n * n2 * 4;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n3; i += 4) {
            int n11 = byArray[i] & 0xFF;
            int n12 = byArray[i + 1] & 0xFF;
            int n13 = byArray[i + 2] & 0xFF;
            int n14 = byArray[i + 3] & 0xFF;
            if (n11 != n4 || n12 != n5 || n13 != n6 || n14 != n7) {
                double d = (double)n11 + 1.402 * (double)n13 - 179.456;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 255.0) {
                    d = 255.0;
                }
                double d2 = (double)n11 - 0.34414 * (double)n12 - 0.71414 * (double)n13 + 135.45984;
                if (d2 < 0.0) {
                    d2 = 0.0;
                } else if (d2 > 255.0) {
                    d2 = 255.0;
                }
                double d3 = (double)n11 + 1.772 * (double)n12 - 226.816;
                if (d3 < 0.0) {
                    d3 = 0.0;
                } else if (d3 > 255.0) {
                    d3 = 255.0;
                }
                n8 = 255 - (int)d;
                n9 = 255 - (int)d2;
                n10 = 255 - (int)d3;
                n4 = n11;
                n5 = n12;
                n6 = n13;
                n7 = n14;
            }
            byArray[i] = (byte)n8;
            byArray[i + 1] = (byte)n9;
            byArray[i + 2] = (byte)n10;
        }
        return CMYKtoRGB.convert(byArray, n, n2);
    }

    public static BufferedImage convertColorspace(BufferedImage bufferedImage, int n) {
        block2: {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), n);
                ColorConvertOp colorConvertOp = new ColorConvertOp(null);
                colorConvertOp.filter(bufferedImage2, bufferedImage);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + exception + " converting image");
            }
        }
        return bufferedImage;
    }

    static double clip01(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    public static WritableRaster createCompatibleWritableRaaster(ColorModel colorModel, int n, int n2) {
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    public static Raster createInterleavedRaster(byte[] byArray, int n, int n2) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{0, 1, 2};
        return Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
    }

    public static void drawImage(Graphics2D graphics2D, BufferedImage bufferedImage, AffineTransform affineTransform, ImageObserver imageObserver) {
        graphics2D.drawImage(bufferedImage, affineTransform, imageObserver);
    }

    public static void flatten4bpc(int n, byte[] byArray, int n2, byte[] byArray2) {
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = 0;
        boolean bl = (n & 1) == 1;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            n5 += 2;
            byArray2[n4] = (byte)(by & 0xF0);
            if (byArray2[n4] == -16) {
                byArray2[n4] = -1;
            }
            ++n4;
            if (bl && n5 > n) {
                n5 = 0;
            } else {
                byArray2[n4] = (byte)((by & 0xF) << 4);
                if (byArray2[n4] == -16) {
                    byArray2[n4] = -1;
                }
                ++n4;
            }
            if (n4 != n2) continue;
            i = n3;
        }
    }

    public static BufferedImage createRGBImage(int n, int n2, byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{0, 1, 2};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public static BufferedImage createARGBImage(int n, int n2, byte[] byArray) {
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        int[] nArray = new int[]{0, 1, 2, 3};
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 4, 4, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

