/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.ArrayUtils;
import org.jpedal.objects.raw.OCObject;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class Array
extends ObjectDecoder {
    private float[] floatValues;
    private int[] intValues;
    private double[] doubleValues;
    private byte[][] mixedValues;
    private byte[][] keyValues;
    private byte[][] stringValues;
    private boolean[] booleanValues;
    private Object[] objectValues;
    private String ref;
    private int i;
    private final int endPoint;
    private final int type;
    private int keyReached = -1;
    private Object[] objectValuesArray;

    public Array(PdfFileReader pdfFileReader, int n, int n2, int n3) {
        super(pdfFileReader);
        this.i = n;
        this.endPoint = n2;
        this.type = n3;
    }

    public Array(PdfFileReader pdfFileReader, int n, int n2, int n3, Object[] objectArray, int n4) {
        super(pdfFileReader);
        this.i = n;
        this.endPoint = n2;
        this.type = n3;
        this.objectValuesArray = objectArray;
        this.keyReached = n4;
    }

    public int readArray(boolean bl, byte[] byArray, PdfObject pdfObject, int n) {
        boolean bl2;
        this.ref = pdfObject.getObjectRefAsString();
        if ((this.type != 14 || byArray[this.i] != 60) && byArray[this.i] != 91 && byArray[this.i] != 60) {
            ++this.i;
        }
        if (byArray[this.i] == 91 && byArray[this.i + 1] == 93) {
            return this.i + 1;
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        boolean bl3 = n == 456733763 || n == 1044338049;
        int n2 = 0;
        while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32) {
            ++this.i;
        }
        if (byArray[this.i] == 37) {
            this.i = ArrayUtils.skipComment(byArray, this.i);
        }
        int n3 = this.i;
        int n4 = this.i;
        byte[] byArray2 = byArray;
        boolean bl4 = bl2 = byArray[this.i] != 91 && byArray[this.i] != 40 && n != 489767739 && n != 9250 && byArray[0] != 0;
        if (byArray[this.i] == 110 && byArray[this.i + 1] == 117 && byArray[this.i + 2] == 108) {
            bl2 = false;
            n2 = 1;
        }
        if (bl2) {
            bl2 = ArrayUtils.handleIndirect(this.endPoint, byArray, this.i);
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        int n5 = -1;
        if ((byArray[this.i] == 47 || byArray[this.i] == 40 || byArray[this.i] == 60 || byArray[this.i] == 60 && byArray[this.i + 1] == 102 && byArray[this.i + 2] == 101 && byArray[this.i + 3] == 102 && byArray[this.i + 4] == 102) && this.type != 20 && n != 9250) {
            n2 = 1;
            bl5 = true;
        } else {
            int n6;
            int n7;
            int n8;
            int n9 = -1;
            if (bl2) {
                n8 = this.i;
                this.i = ArrayUtils.skipToEndOfRef(this.i, byArray);
                n7 = NumberUtils.parseInt(n3, this.i, byArray);
                while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32 || byArray[this.i] == 47 || byArray[this.i] == 60) {
                    ++this.i;
                }
                n3 = this.i;
                this.i = ArrayUtils.skipToEndOfRef(this.i, byArray);
                n6 = NumberUtils.parseInt(n3, this.i, byArray);
                while (byArray[this.i] == 10 || byArray[this.i] == 13 || byArray[this.i] == 32 || byArray[this.i] == 47 || byArray[this.i] == 60) {
                    ++this.i;
                }
                if (byArray[this.i] != 82) {
                    throw new RuntimeException(padding + "4. Unexpected value " + (char)byArray[this.i] + " in file - please send to IDRsolutions for analysis");
                }
                if (bl && !bl3) {
                    return this.i;
                }
                byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n7, n6), n7, n6);
                if (byArray2 == null) {
                    pdfObject.setFullyResolved(false);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (14)");
                    }
                    return byArray.length;
                }
                n4 = 0;
                while (byArray2[n4] != 91) {
                    if (byArray2[n4] == 37) {
                        n4 = ArrayUtils.skipComment(byArray2, n4);
                        --n4;
                    }
                    if (byArray2[n4] == 110 && byArray2[n4 + 1] == 117 && byArray2[n4 + 2] == 108 && byArray2[n4 + 3] == 108 || byArray2[n4] == 101 && byArray2[n4 + 1] == 110 && byArray2[n4 + 2] == 100 && byArray2[n4 + 3] == 111) break;
                    if (byArray2[n4] == 47) {
                        --n4;
                        bl6 = true;
                        break;
                    }
                    if (byArray2[n4] == 60 && byArray2[n4 + 1] == 60 || n4 + 4 < byArray2.length && byArray2[n4 + 3] == 60 && byArray2[n4 + 4] == 60) {
                        n9 = this.i;
                        n4 = n8;
                        byArray2 = byArray;
                        break;
                    }
                    ++n4;
                }
            }
            if (n4 < 0) {
                n4 = 0;
            }
            n8 = 0;
            while (byArray2[n4] == 10 || byArray2[n4] == 13 || byArray2[n4] == 32 || byArray2[n4] == 91 && n8 == 0) {
                if (byArray2[n4] == 91) {
                    n8 = 1;
                }
                ++n4;
            }
            n5 = n4;
            n6 = 1;
            int n10 = byArray2.length;
            while (n5 < n10 && byArray2[n5] != 93 && (byArray2[n4] != 101 || byArray2[n4 + 1] != 110 || byArray2[n4 + 2] != 100 || byArray2[n4 + 3] != 111)) {
                int n11;
                boolean bl8 = false;
                while (byArray2[n5] == 60 && byArray2[n5 + 1] == 60) {
                    n11 = 1;
                    ++n2;
                    while (n11 > 0) {
                        if (byArray2[++n5] == 60 && byArray2[n5 + 1] == 60) {
                            ++n5;
                            ++n11;
                            continue;
                        }
                        if (byArray2[n5] != 62 || byArray2[n5 - 1] != 62) continue;
                        ++n5;
                        --n11;
                    }
                    if (this.type != 14) continue;
                    --n5;
                }
                if (this.type != 18 && byArray2[n5] == 110 && byArray2[n5 + 1] == 117 && byArray2[n5 + 2] == 108 && byArray2[n5 + 3] == 108) {
                    n11 = 93;
                    if (n == 826881374 || n == 1110717793) {
                        for (int i = n5 + 3; i < byArray2.length; ++i) {
                            if (byArray2[i] == 10 || byArray2[i] == 13 || byArray2[i] == 32 || byArray2[i] == 9) continue;
                            n11 = byArray2[i];
                            i = byArray2.length;
                        }
                    }
                    if (n11 == 93) {
                        bl7 = true;
                        n2 = 1;
                        break;
                    }
                    bl7 = false;
                    n5 += 4;
                    n6 = 1;
                    continue;
                }
                if (bl6 && (byArray2[n5] == 32 || byArray2[n5] == 13 || byArray2[n5] == 10) || n9 != -1 && n5 > n9) break;
                if (this.type == 14) {
                    if (byArray2[n5] == 82 || (n == 9250 || n == 1248888446) && byArray2[n5] == 47) {
                        ++n2;
                    }
                } else if (byArray2[n5] == 40) {
                    ++n2;
                    while (byArray2[n5] != 41 || ObjectUtils.isEscaped(byArray2, n5)) {
                        ++n5;
                        n6 = 1;
                    }
                } else if (byArray2[n5] == 60) {
                    ++n2;
                    while (byArray2[n5] != 62) {
                        ++n5;
                        n6 = 1;
                    }
                } else if (byArray2[n5] == 91) {
                    ++n2;
                    n5 = Array.skipThroughRecursiveLevels(byArray2, n5);
                    bl8 = true;
                    n6 = 1;
                } else {
                    n7 = byArray2[n5] == 10 || byArray2[n5] == 13 || byArray2[n5] == 32 || byArray2[n5] == 47 ? 1 : 0;
                    n2 = this.handleSpace(hashMap, n2, byArray2, n5, n7 != 0, n6 != 0);
                    n6 = n7;
                }
                if (!bl8 && n5 < n10 && byArray2[n5] == 93 && this.type != 14) {
                    n11 = n5 - 1;
                    while (byArray2[n11] == 13 || byArray2[n11] == 10 || byArray2[n11] == 32) {
                        --n11;
                    }
                    if (byArray2[n11] != 91) break;
                    n2 = 0;
                    break;
                }
                ++n5;
            }
            if (n2 == 0) {
                // empty if block
            }
        }
        if (bl && !bl3) {
            return n5;
        }
        this.initObjectArray(n2);
        this.setValues(bl, byArray, pdfObject, n, hashMap, 0, n2, n4, byArray2, bl2, bl5, bl7, n5);
        if (this.i < byArray.length && (byArray[this.i] == 47 || byArray[this.i] == 62 || byArray[this.i] >= 48 && byArray[this.i] <= 57)) {
            --this.i;
        }
        return this.i;
    }

    static int skipThroughRecursiveLevels(byte[] byArray, int n) {
        int n2 = 1;
        while (++n != byArray.length) {
            if (byArray[n] == 93) {
                --n2;
            } else if (byArray[n] == 91) {
                ++n2;
            }
            if (n2 != 0) continue;
            break;
        }
        return n;
    }

    private int handleSpace(Map<Integer, String> map, int n, byte[] byArray, int n2, boolean bl, boolean bl2) {
        if (bl2 && !bl) {
            if ((this.type == 18 || this.type == 22) && byArray[n2] == 82 && byArray[n2 - 1] != 47) {
                map.put(--n - 1, "x");
            } else {
                ++n;
            }
        }
        return n;
    }

    private void setValues(boolean bl, byte[] byArray, PdfObject pdfObject, int n, Map<Integer, String> map, int n2, int n3, int n4, byte[] byArray2, boolean bl2, boolean bl3, boolean bl4, int n5) {
        if (byArray2[n4] == 110 && byArray2[n4 + 1] == 117 && byArray2[n4 + 2] == 108 && byArray2[n4 + 3] == 108 && bl4 && (this.type != 22 || n3 == 1)) {
            n4 += 3;
            if (this.type == 18) {
                this.mixedValues[n2] = null;
            } else if (this.type == 14) {
                this.keyValues[n2] = null;
            } else if (this.type == 20) {
                this.stringValues[n2] = null;
            } else if (this.type == 22) {
                this.objectValues[n2] = null;
            }
        } else {
            n4 = this.setValue(bl, byArray, pdfObject, n, map, n2, n3, n4, byArray2, bl3, n5);
        }
        if (!bl2) {
            this.i = n4;
        }
        if (this.type == 10) {
            pdfObject.setFloatArray(n, this.floatValues);
        } else if (this.type == 9) {
            pdfObject.setIntArray(n, this.intValues);
        } else if (this.type == 12) {
            pdfObject.setBooleanArray(n, this.booleanValues);
        } else if (this.type == 16) {
            pdfObject.setDoubleArray(n, this.doubleValues);
        } else if (this.type == 18) {
            pdfObject.setMixedArray(n, this.mixedValues);
        } else if (this.type == 14) {
            this.setKeyArrayValue(pdfObject, n, n3);
        } else if (this.type == 20) {
            pdfObject.setStringArray(n, this.stringValues);
        } else if (this.type == 22) {
            this.setObjectArrayValue(pdfObject, n, this.objectValuesArray, this.keyReached);
        }
    }

    private int setValue(boolean bl, byte[] byArray, PdfObject pdfObject, int n, Map<Integer, String> map, int n2, int n3, int n4, byte[] byArray2, boolean bl2, int n5) {
        while (byArray2[n4] != 93) {
            int n6;
            boolean bl3 = false;
            if (n5 > -1 && n4 >= n5) break;
            while (byArray2[n4] == 10 || byArray2[n4] == 13 || byArray2[n4] == 32 || byArray2[n4] == 47) {
                ++n4;
            }
            if (byArray2[n4] == 37) {
                while (n4 < byArray2.length && byArray2[++n4] != 10) {
                }
                while (byArray2[n4] == 10 || byArray2[n4] == 13 || byArray2[n4] == 32 || byArray2[n4] == 47) {
                    ++n4;
                }
            }
            int n7 = n4;
            boolean bl4 = byArray2[n4 - 1] == 47;
            boolean bl5 = false;
            if (this.type == 14 || (this.type == 18 || this.type == 22) && (map.containsKey(n2) || n == 1110717793 && byArray2[n4] >= 48 && byArray2[n4] <= 57 || byArray2[n4] == 60 && byArray2[n4 + 1] == 60)) {
                while (byArray2[n4] != 82 && byArray2[n4] != 93) {
                    if (byArray2[n4] == 60 && byArray2[n4 + 1] == 60) {
                        n6 = 1;
                        while (n6 > 0) {
                            if (byArray2[++n4] == 60 && byArray2[n4 + 1] == 60) {
                                ++n4;
                                ++n6;
                                continue;
                            }
                            if (byArray2[n4] != 62 || byArray2[n4 + 1] != 62) continue;
                            ++n4;
                            --n6;
                        }
                        break;
                    }
                    if (bl4 && n == 9250 && byArray2[n4 + 1] == 32) break;
                    ++n4;
                }
                ++n4;
            } else if (byArray2[n4] == 40) {
                n7 = n4 + 1;
                while (byArray2[n4] != 41 || ObjectUtils.isEscaped(byArray2, n4)) {
                    ++n4;
                }
                bl3 = false;
            } else if (byArray2[n4] == 91 && this.type == 18 && n == 826094945) {
                n7 = n4;
                while (byArray2[n4] != 93) {
                    ++n4;
                }
                ++n4;
            } else if (byArray2[n4] == 60) {
                bl3 = true;
                n7 = n4 + 1;
                while (byArray2[n4] != 62) {
                    if (byArray2[n4] == 47) {
                        bl3 = false;
                    }
                    ++n4;
                }
            } else if (byArray2[n4] == 91 && this.type == 22) {
                Array array;
                n6 = n4 + 1;
                int n8 = 1;
                while (++n6 != byArray2.length) {
                    if (byArray2[n6] == 93) {
                        --n8;
                    } else if (byArray2[n6] == 91) {
                        ++n8;
                    }
                    if (n8 != 0) continue;
                }
                if (byArray2[n4 = (array = new Array(this.objectReader, n4, ++n6, this.type, this.objectValues, n2)).readArray(bl, byArray2, pdfObject, n)] != 91) {
                    ++n4;
                }
                bl5 = true;
                while (n4 < byArray2.length && byArray2[n4] == 93) {
                    ++n4;
                }
            } else if (!bl4 && n3 - n2 == 1 && this.type == 18) {
                while (byArray2[n4] != 93 && byArray2[n4] != 47 && (byArray2[n4] != 62 || byArray2[n4 + 1] != 62)) {
                    ++n4;
                }
            } else {
                if (this.type == 22 && byArray2[n4] == 110 && byArray2[n4 + 1] == 117 && byArray2[n4 + 2] == 108 && byArray2[n4 + 3] == 108) {
                    n4 += 4;
                    this.objectValues[n2] = null;
                    ++n2;
                    continue;
                }
                while (byArray2[n4] != 10 && byArray2[n4] != 13 && byArray2[n4] != 32 && byArray2[n4] != 93 && byArray2[n4] != 47 && (byArray2[n4] != 62 || byArray2[n4 + 1] != 62) && ++n4 != byArray2.length) {
                }
            }
            if (this.type == 10) {
                this.floatValues[n2] = NumberUtils.parseFloat(n7, n4, byArray2);
            } else if (this.type == 9) {
                this.intValues[n2] = NumberUtils.parseInt(n7, n4, byArray2);
            } else if (this.type == 12) {
                if (byArray[n7] == 116 && byArray[n7 + 1] == 114 && byArray[n7 + 2] == 117 && byArray[n7 + 3] == 101) {
                    this.booleanValues[n2] = true;
                }
            } else if (this.type == 16) {
                this.doubleValues[n2] = NumberUtils.parseFloat(n7, n4, byArray2);
            } else if (!bl5) {
                n4 = this.setObjectArrayValue(pdfObject, n, bl3, n2, n3, n4, byArray2, bl2, n7);
            }
            if (++n2 != n3) continue;
            break;
        }
        return n4;
    }

    private int setObjectArrayValue(PdfObject pdfObject, int n, boolean bl, int n2, int n3, int n4, byte[] byArray, boolean bl2, int n5) {
        boolean bl3;
        boolean bl4 = bl3 = n == 6420;
        if (n5 > 0 && byArray[n5 - 1] == 47) {
            --n5;
        }
        if (n5 > 0 && byArray[n5] == 91 && n != 826094945 && n != 6420) {
            ++n5;
        }
        if (n == 1110717793 || n == 826881374) {
            while (byArray[n5] == 110 && byArray[n5 + 1] == 117 && byArray[n5 + 2] == 108 && byArray[n5 + 3] == 108) {
                n5 += 4;
                while (n5 >= 0 && (byArray[n5] == 32 || byArray[n5] == 10 || byArray[n5] == 13 || byArray[n5] == 9)) {
                    ++n5;
                }
            }
        }
        while (n5 >= 0 && (byArray[n5] == 10 || byArray[n5] == 13 || byArray[n5] == 9)) {
            ++n5;
        }
        byte[] byArray2 = ObjectUtils.readEscapedValue(n4, byArray, n5, bl3);
        if (n4 != byArray.length) {
            if (byArray[n4] == 62) {
                ++n4;
            } else if (byArray[n4] == 41) {
                block22: {
                    ++n4;
                    try {
                        if (!bl3 && !pdfObject.isInCompressedStream() && this.decryption != null) {
                            byArray2 = this.decryption.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (PdfSecurityException pdfSecurityException) {
                        if (!LogWriter.isOutput()) break block22;
                        LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
                    }
                }
                if (n == 1110717793) {
                    byArray2 = StringUtils.toBytes(StringUtils.getTextString(byArray2, false));
                }
            }
        }
        if (bl2) {
            this.i = n4;
        }
        if (this.type == 18) {
            this.mixedValues[n2] = bl ? ArrayUtils.handleHexString(byArray2, this.decryption, this.ref) : byArray2;
        } else if (this.type == 14) {
            this.keyValues[n2] = ObjectUtils.convertReturnsToSpaces(byArray2);
        } else if (this.type == 20) {
            this.stringValues[n2] = bl ? ArrayUtils.handleHexString(byArray2, this.decryption, this.ref) : byArray2;
        } else if (this.type == 22) {
            this.objectValues[n2] = bl ? (Object)ArrayUtils.handleHexString(byArray2, this.decryption, this.ref) : (Object)byArray2;
        }
        return n4;
    }

    private void initObjectArray(int n) {
        if (this.type == 10) {
            this.floatValues = new float[n];
        } else if (this.type == 9) {
            this.intValues = new int[n];
        } else if (this.type == 12) {
            this.booleanValues = new boolean[n];
        } else if (this.type == 16) {
            this.doubleValues = new double[n];
        } else if (this.type == 18) {
            this.mixedValues = new byte[n][];
        } else if (this.type == 14) {
            this.keyValues = new byte[n][];
        } else if (this.type == 20) {
            this.stringValues = new byte[n][];
        } else if (this.type == 22) {
            this.objectValues = new Object[n];
        }
    }

    private void setKeyArrayValue(PdfObject pdfObject, int n, int n2) {
        if (this.type == 14 && n2 == 1 && n == 1044338049) {
            PdfObject pdfObject2;
            byte[] byArray;
            int n3;
            byte[] byArray2 = this.keyValues[0];
            if (byArray2 != null && byArray2[(n3 = byArray2.length) - 1] == 82 && (byArray = this.objectReader.readObjectData(pdfObject2 = new PdfObject(new String(byArray2)))) != null) {
                int n4 = 0;
                int n5 = byArray.length;
                boolean bl = false;
                while (n4 < n5 && ++n4 != byArray.length) {
                    if (byArray[n4] == 91) {
                        bl = true;
                        break;
                    }
                    if (byArray[n4 - 1] != 60 || byArray[n4] != 60) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    Array array = new Array(this.objectReader, n4, n5, 14);
                    array.readArray(false, byArray, pdfObject, n);
                } else {
                    pdfObject.setKeyArray(n, this.keyValues);
                }
            }
        } else {
            pdfObject.setKeyArray(n, this.keyValues);
        }
    }

    private void setObjectArrayValue(PdfObject pdfObject, int n, Object[] objectArray, int n2) {
        int n3;
        byte[] byArray;
        if (n == 1110717793 && this.objectValues != null && this.objectValues.length == 1 && this.objectValues[0] instanceof byte[] && (byArray = (byte[])this.objectValues[0])[(n3 = byArray.length) - 1] == 82) {
            OCObject oCObject = new OCObject(new String(byArray));
            byte[] byArray2 = this.objectReader.readObjectData(oCObject);
            int n4 = 0;
            int n5 = byArray2.length;
            boolean bl = false;
            while (n4 < n5 && ++n4 != byArray2.length) {
                if (byArray2[n4] != 91) continue;
                bl = true;
                break;
            }
            if (bl) {
                Array array = new Array(this.objectReader, n4, n5, 22);
                array.readArray(false, byArray2, pdfObject, n);
            }
            this.objectValues = null;
        }
        if (objectArray != null) {
            objectArray[n2] = this.objectValues;
        } else if (this.objectValues != null) {
            pdfObject.setObjectArray(n, this.objectValues);
        }
    }

    private void showValues() {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (this.type == 10) {
            for (float f : this.floatValues) {
                stringBuilder.append(f).append(' ');
            }
        } else if (this.type == 16) {
            for (double d : this.doubleValues) {
                stringBuilder.append(d).append(' ');
            }
        } else if (this.type == 9) {
            for (int n : this.intValues) {
                stringBuilder.append(n).append(' ');
            }
        } else if (this.type == 12) {
            for (boolean bl : this.booleanValues) {
                stringBuilder.append(bl).append(' ');
            }
        } else if (this.type == 18) {
            for (byte[] byArray : this.mixedValues) {
                if (byArray == null) {
                    stringBuilder.append("null ");
                    continue;
                }
                stringBuilder.append(new String(byArray)).append(' ');
            }
        } else if (this.type == 14) {
            for (byte[] byArray : this.keyValues) {
                if (byArray == null) {
                    stringBuilder.append("null ");
                    continue;
                }
                stringBuilder.append(new String(byArray)).append(' ');
            }
        } else if (this.type == 20) {
            for (byte[] byArray : this.stringValues) {
                if (byArray == null) {
                    stringBuilder.append("null ");
                    continue;
                }
                stringBuilder.append(new String(byArray)).append(' ');
            }
        } else if (this.type == 22) {
            stringBuilder.append(ObjectUtils.showMixedValuesAsString(this.objectValues, ""));
        }
        stringBuilder.append(" ]");
        System.out.println(padding + "values=" + stringBuilder);
    }

    public static int processArray(PdfObject pdfObject, byte[] byArray, int n, int n2, PdfFileReader pdfFileReader) {
        int n3;
        for (n3 = n2; byArray[n3] != 93 && n3 <= byArray.length; ++n3) {
        }
        PdfObject pdfObject2 = ObjectFactory.createObject(n, null, pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(n);
        pdfObject.setDictionary(n, pdfObject2);
        pdfObject2.ignoreRecursion(pdfObject.ignoreRecursion());
        if (pdfObject2.isDataExternal()) {
            pdfObject2.isDataExternal(true);
            if (!Array.resolveFully(pdfObject2, pdfFileReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        int n4 = 9;
        if (n == 9250) {
            n4 = 14;
        }
        Array array = new Array(pdfFileReader, n2, n3, n4);
        int n5 = array.readArray(pdfObject.ignoreRecursion(), byArray, pdfObject2, n);
        return n5;
    }
}

