/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.DirectDictionaryToObject;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.Stream;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class ColorObjectDecoder {
    static final boolean debugColorspace = false;

    public static int handleColorSpaces(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        int n2 = byArray.length;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 91 || byArray[n] == 93) {
            if (byArray[n] == 91) {
                pdfObject.maybeIndirect(true);
            }
            ++n;
        }
        if (byArray[n] == 47) {
            int n3;
            ++n;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                ++n;
            }
            int n4 = n;
            int n5 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 91 && byArray[n] != 93) {
                ++n5;
                if (++n != n2) continue;
            }
            if ((n3 = pdfObject.setConstant(2087749783, n4, n5, byArray)) == 25) {
                n3 = 895578984;
            }
            n = ColorObjectDecoder.setColorspace(pdfObject, n, byArray, n3, pdfFileReader);
        } else if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n = ColorObjectDecoder.readObjectValue(pdfObject, n, byArray, pdfFileReader);
        } else if (byArray[n] == 37) {
            while (byArray[n] != 10 && byArray[n] != 13) {
                ++n;
            }
        } else {
            n = byArray[n] == 60 ? ColorObjectDecoder.readHexValue(pdfObject, n, byArray, decryptionFactory) : (byArray[n] == 40 ? ColorObjectDecoder.readStringValue(pdfObject, n, byArray, decryptionFactory) : ColorObjectDecoder.readColorObjectValue(pdfObject, n, byArray, pdfFileReader));
        }
        if (n < n2 && (byArray[n] == 47 || byArray[n] == 62)) {
            --n;
        }
        return n;
    }

    static int setColorspace(PdfObject pdfObject, int n, byte[] byArray, int n2, PdfFileReader pdfFileReader) {
        switch (n2) {
            case 1008872003: {
                n = ColorObjectDecoder.handleColorSpaces(pdfObject, n, byArray, pdfFileReader);
                ++n;
                break;
            }
            case 391471749: {
                n = ColorObjectDecoder.handleColorSpaces(pdfObject, n, byArray, pdfFileReader);
                ++n;
                break;
            }
            case 1498837125: {
                break;
            }
            case 1568372915: {
                break;
            }
            case 960981604: {
                n = ColorObjectDecoder.readDeviceNvalue(pdfObject, n, byArray, pdfFileReader);
                break;
            }
            case 1785221209: {
                break;
            }
            case 1247168582: {
                n = Dictionary.readDictionaryFromRefOrDirect(-1, pdfObject, "", n, byArray, 2087749783, pdfFileReader);
                break;
            }
            case 895578984: {
                n = ColorObjectDecoder.readIndexedColorspace(pdfObject, n, byArray, pdfFileReader);
                break;
            }
            case 1847602: {
                n = ColorObjectDecoder.handleColorSpaces(pdfObject, n, byArray, pdfFileReader);
                ++n;
                break;
            }
            case 1146450818: {
                ColorObjectDecoder.readPatternColorspace(pdfObject, n, byArray, pdfFileReader);
                break;
            }
            case -2073385820: {
                n = ColorObjectDecoder.readSeparationColorspace(pdfObject, n, byArray, pdfFileReader);
            }
        }
        return n;
    }

    static int readDeviceNvalue(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 93; ++n2) {
        }
        Array array = new Array(pdfFileReader, n, n2, 20);
        n = array.readArray(false, byArray, pdfObject, 1920898752);
        while (byArray[n] == 93 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
            ++n;
        }
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
        n = ColorObjectDecoder.handleColorSpaces(colorSpaceObject, n, byArray, pdfFileReader);
        pdfObject.setDictionary(-1247101998, colorSpaceObject);
        ++n;
        FunctionObject functionObject = new FunctionObject(-1, 0);
        n = ColorObjectDecoder.handleColorSpaces(functionObject, n, byArray, pdfFileReader);
        pdfObject.setDictionary(-1313946392, functionObject);
        for (int i = n; i < byArray.length && byArray[i] != 93; ++i) {
            if (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) continue;
            n = i;
            ColorSpaceObject colorSpaceObject2 = new ColorSpaceObject(-1, 0);
            n = ColorObjectDecoder.handleColorSpaces(colorSpaceObject2, n, byArray, pdfFileReader);
            pdfObject.setDictionary(861242754, colorSpaceObject2);
            --n;
            i = byArray.length;
        }
        return ++n;
    }

    static int readColorObjectValue(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        byte[] byArray2;
        int n2 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 93) {
            ++n;
        }
        int n3 = NumberUtils.parseInt(n2, n, byArray);
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
            ++n;
        }
        n2 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
        }
        int n4 = NumberUtils.parseInt(n2, n, byArray);
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
            ++n;
        }
        if (byArray[n] != 82) {
            throw new RuntimeException("3. Unexpected value in file " + (char)byArray[n] + " - please send to IDRsolutions for analysis");
        }
        ++n;
        if (pdfObject.getObjectRefID() == -1 || pdfObject.maybeIndirect()) {
            pdfObject.setRef(n3, n4);
        }
        if ((byArray2 = pdfFileReader.readObjectAsByteArray(pdfObject, pdfFileReader.isCompressed(n3, n4), n3, n4)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + n3 + ' ' + n4 + " R not yet available (9)");
            }
            n = byArray.length;
        } else if (byArray2[0] == 47) {
            ColorObjectDecoder.handleColorSpaces(pdfObject, 0, byArray2, pdfFileReader);
        } else {
            int n5 = 0;
            if (byArray2[0] != 91 && byArray2[0] != 60) {
                n5 = 3;
                while (byArray2[n5 - 1] != 106 && byArray2[n5 - 2] != 98 && byArray2[n5 - 3] != 111) {
                    ++n5;
                }
            }
            ColorObjectDecoder.handleColorSpaces(pdfObject, n5, byArray2, pdfFileReader);
        }
        return n;
    }

    static int readIndexedColorspace(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
        pdfObject.setDictionary(895578984, colorSpaceObject);
        for (n = ColorObjectDecoder.handleColorSpaces(colorSpaceObject, n, byArray, pdfFileReader); n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10 || byArray[n] == 93 || byArray[n] == 62); ++n) {
        }
        if (byArray[n = NumberValue.setNumberValue(pdfObject, n, byArray, 960901492, pdfFileReader)] != 40) {
            ++n;
        }
        while (n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10)) {
            ++n;
        }
        boolean bl = byArray[n] == 91 || byArray[n] == 40 || byArray[n] == 60;
        ColorSpaceObject colorSpaceObject2 = bl ? new ColorSpaceObject(pdfObject.getObjectRefAsString()) : new ColorSpaceObject(-1, 0);
        pdfObject.setDictionary(1060856191, colorSpaceObject2);
        n = ColorObjectDecoder.handleColorSpaces(colorSpaceObject2, n, byArray, pdfFileReader);
        return ++n;
    }

    static void readPatternColorspace(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        int n2;
        if (n == 8 && byArray.length == 8 && byArray[n - 1] == 110 && byArray[n - 2] == 114 && byArray[n - 3] == 101 && byArray[n - 4] == 116 && byArray[n - 5] == 116 && byArray[n - 6] == 97 && byArray[n - 7] == 80 && byArray[n - 8] == 47) {
            pdfObject.setConstant(2087749783, 1146450818);
            return;
        }
        for (n2 = n; n2 < byArray.length && byArray[n2] != 47 && byArray[n2] != 93; ++n2) {
        }
        if (byArray[n2] == 47) {
            ++n2;
            while (n2 < byArray.length && byArray[n2] != 47 && byArray[n2] != 93 && byArray[n2] != 32 && byArray[n2] != 13 && byArray[n2] != 10) {
                ++n2;
            }
            ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
            ColorObjectDecoder.handleColorSpaces(colorSpaceObject, n, byArray, pdfFileReader);
            pdfObject.setDictionary(-1247101998, colorSpaceObject);
        }
    }

    static int readSeparationColorspace(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        int n2 = n;
        while (byArray[n2] == 47 || byArray[n2] == 32 || byArray[n2] == 10 || byArray[n2] == 13) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < byArray.length && byArray[n2] != 47 && byArray[n2] != 32 && byArray[n2] != 13 && byArray[n2] != 10) {
            ++n2;
        }
        int n4 = n2 - n3;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, n4);
        pdfObject.setName(506543413, byArray2);
        n = n2;
        if (byArray[n] != 47) {
            ++n;
        }
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
        n = ColorObjectDecoder.handleColorSpaces(colorSpaceObject, n, byArray, pdfFileReader);
        pdfObject.setDictionary(-1247101998, colorSpaceObject);
        if (byArray[n] != 60) {
            ++n;
        }
        FunctionObject functionObject = new FunctionObject(-1, 0);
        n = ColorObjectDecoder.handleColorSpaces(functionObject, n, byArray, pdfFileReader);
        pdfObject.setDictionary(-1313946392, functionObject);
        return ++n;
    }

    static int readObjectValue(PdfObject pdfObject, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        n = DirectDictionaryToObject.convert(pdfObject, "", n, byArray, -1, pdfFileReader);
        if (pdfObject.hasStream()) {
            int n2 = byArray.length;
            int n3 = 0;
            for (int i = n; i < n2 - 5; ++i) {
                if (byArray[i] == 62 && byArray[i + 1] == 62) {
                    ++n3;
                }
                if (n3 == 2) break;
                if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
                Stream.readStreamIntoObject(pdfObject, i, byArray, pdfFileReader);
                i = n2;
            }
        }
        return n;
    }

    static int readHexValue(PdfObject pdfObject, int n, byte[] byArray, DecryptionFactory decryptionFactory) {
        byte[] byArray2;
        block20: {
            int n2 = ++n;
            int n3 = 0;
            while (byArray[n2] != 62) {
                if (byArray[n2] != 32 && byArray[n2] != 10 && byArray[n2] != 13) {
                    ++n3;
                }
                ++n2;
            }
            int n4 = n3 >> 1;
            byArray2 = new byte[n4];
            int n5 = 0;
            while (true) {
                if (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                    continue;
                }
                int n6 = byArray[n];
                if (n6 >= 65 && n6 <= 70) {
                    n6 -= 55;
                } else if (n6 >= 97 && n6 <= 102) {
                    n6 -= 87;
                } else if (n6 >= 48 && n6 <= 57) {
                    n6 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                while (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                }
                int n7 = byArray[n];
                if (n7 >= 65 && n7 <= 70) {
                    n7 -= 55;
                } else if (n7 >= 97 && n7 <= 102) {
                    n7 -= 87;
                } else if (n7 >= 48 && n7 <= 57) {
                    n7 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                int n8 = n7 + (n6 << 4);
                byArray2[n5] = (byte)n8;
                if (++n5 == n4) break;
            }
            try {
                if (decryptionFactory != null) {
                    byArray2 = decryptionFactory.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException pdfSecurityException) {
                if (!LogWriter.isOutput()) break block20;
                LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
            }
        }
        pdfObject.setDecodedStream(byArray2);
        return n;
    }

    static int readStringValue(PdfObject pdfObject, int n, byte[] byArray, DecryptionFactory decryptionFactory) {
        byte[] byArray2;
        block4: {
            int n2 = ++n;
            while (byArray[n] != 41 || ObjectUtils.isEscaped(byArray, n) && byArray[n - 1] != 0) {
                ++n;
            }
            byArray2 = ObjectUtils.readEscapedValue(n, byArray, n2, false);
            try {
                if (decryptionFactory != null) {
                    byArray2 = decryptionFactory.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException pdfSecurityException) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
            }
        }
        pdfObject.setDecodedStream(byArray2);
        return n;
    }

    static void showData(PdfObject pdfObject, byte[] byArray, int n) {
        System.out.println(ObjectDecoder.padding + "Reading colorspace into " + pdfObject + " ref=" + pdfObject.getObjectRefAsString() + " i=" + n + " chars=" + (char)byArray[n] + (char)byArray[n + 1] + (char)byArray[n + 2] + (char)byArray[n + 3] + (char)byArray[n + 4]);
        System.out.println(ObjectDecoder.padding + "------------>");
        for (int i = n; i < byArray.length; ++i) {
            System.out.print((char)byArray[i]);
            if (i <= 5 || byArray[i - 5] != 115 || byArray[i - 4] != 116 || byArray[i - 3] != 114 || byArray[i - 2] != 101 || byArray[i - 1] != 97 || byArray[i] != 109) continue;
            i = byArray.length;
        }
        System.out.println("<--------");
    }

    static int processColorSpace(PdfObject pdfObject, String string, int n, byte[] byArray, PdfFileReader pdfFileReader) {
        if (!pdfObject.ignoreRecursion()) {
            if (pdfObject.getObjectType() == 2087749783) {
                return ColorObjectDecoder.handleColorSpaces(pdfObject, n, byArray, pdfFileReader);
            }
            boolean bl = byArray[n] == 47;
            ColorSpaceObject colorSpaceObject = bl ? new ColorSpaceObject(string) : new ColorSpaceObject(-1, 0);
            pdfObject.setDictionary(2087749783, colorSpaceObject);
            if (colorSpaceObject.isDataExternal()) {
                colorSpaceObject.isDataExternal(true);
                if (!ObjectDecoder.resolveFully(colorSpaceObject, pdfFileReader)) {
                    pdfObject.setFullyResolved(false);
                }
            }
            return ColorObjectDecoder.handleColorSpaces(colorSpaceObject, n, byArray, pdfFileReader);
        }
        return n;
    }
}

