/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.BrokenRefTable;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.Trailer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class RefTable {
    PdfObject encryptObj;
    private byte[] ID;
    static final String pattern = "obj";
    private PdfObject infoObject;
    static final int UNSET = -1;
    static final int COMPRESSED = 1;
    static final int LEGACY = 2;
    private RandomAccessBuffer pdf_datafile;
    static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private final long eof;
    final Offsets offset;

    public RefTable(RandomAccessBuffer randomAccessBuffer, long l, Offsets offsets) {
        this.pdf_datafile = randomAccessBuffer;
        this.eof = l;
        this.offset = offsets;
    }

    private int readFirstStartRef() throws PdfException {
        this.offset.setRefTableInvalid(false);
        int n = -1;
        int n2 = 1019;
        StringBuilder stringBuilder = new StringBuilder(10);
        byte[] byArray = new byte[1024];
        int[] nArray = new int[]{37, 37, 69, 79};
        int n3 = 3;
        boolean bl = false;
        try {
            int n4;
            long l;
            block21: {
                l = this.eof;
                do {
                    byte[] byArray2 = this.getBytes(l - 255L, 255);
                    n4 = 0;
                    for (int i = 254; i > -1; --i) {
                        if (!bl) {
                            n3 = 3;
                        }
                        if (byArray2[i] == nArray[n3]) {
                            --n3;
                            bl = true;
                        } else {
                            bl = false;
                        }
                        --n4;
                        if (n3 >= 0) continue;
                        i = -1;
                    }
                    if (n3 >= 0) continue;
                    l -= (long)n4;
                    break block21;
                } while ((l -= 255L) >= 0L);
                l = this.eof;
            }
            int n5 = (int)(l - 1024L);
            if (n5 < 0) {
                n5 = 0;
                n4 = (int)this.eof;
                byArray = new byte[n4];
                n2 = n4 + 3;
            }
            byArray = this.getBytes(n5, byArray.length);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + exception + " reading last 1024 bytes");
            }
            throw new PdfException(exception + " reading last 1024 bytes");
        }
        int n6 = byArray.length;
        if (n2 > n6) {
            n2 = n6 - 5;
        }
        while (!(n2 <= -1 || (byArray[n2] == 116 && byArray[n2 + 1] == 120 || byArray[n2] == 114 && byArray[n2 + 1] == 116) && byArray[n2 + 2] == 114 && byArray[n2 + 3] == 101 && byArray[n2 + 4] == 102)) {
            --n2;
        }
        if (n2 == -1) {
            block22: {
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + iOException + " closing file");
                }
            }
            throw new PdfException("No Startxref found in last 1024 bytes ");
        }
        n2 += 5;
        while (n2 < 1024 && (byArray[n2] == 10 || byArray[n2] == 32 || byArray[n2] == 13)) {
            ++n2;
        }
        while (n2 < 1024 && byArray[n2] != 10 && byArray[n2] != 32 && byArray[n2] != 13) {
            stringBuilder.append((char)byArray[n2]);
            ++n2;
        }
        if (stringBuilder.length() > 0) {
            n = Integer.parseInt(stringBuilder.toString());
        }
        if (n == -1) {
            block23: {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Startref found in last 1024 bytes ");
                }
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block23;
                    LogWriter.writeLog("Exception " + iOException + " closing file");
                }
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return n;
    }

    public final PdfObject readReferenceTable(PdfObject pdfObject, PdfFileReader pdfFileReader, ObjectReader objectReader) throws PdfException {
        Object object;
        int n = -1;
        int n2 = (int)this.eof;
        boolean bl = false;
        if (pdfObject == null) {
            n = this.readFirstStartRef();
        } else {
            object = this.pdf_datafile.getPdfBuffer();
            int n3 = ((byte[])object).length;
            int n4 = 5;
            for (int i = 0; i < n3; ++i) {
                if (object[i] == 101 && object[i + 1] == 110 && object[i + 2] == 100 && object[i + 3] == 111 && object[i + 4] == 98 && object[i + 5] == 106) {
                    n4 = i + 6;
                }
                if (object[i] == 120 && object[i + 1] == 114 && object[i + 2] == 101 && object[i + 3] == 102) {
                    n = i;
                    i = n3;
                    continue;
                }
                if (object[i] != 88 || object[i + 1] != 82 || object[i + 2] != 101 || object[i + 3] != 102) continue;
                bl = true;
                n = n4;
                while (object[n] == 10 || object[n] == 13 || object[n] == 32) {
                    ++n;
                }
                i = n3;
            }
        }
        this.offset.addXref(n);
        object = null;
        if (n >= n2 || n == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            }
            this.offset.setRefTableInvalid(true);
            try {
                object = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            }
            catch (Error error) {
                throw new PdfException(error.getMessage() + " attempting to manually scan file for objects");
            }
            pdfFileReader.readObject((PdfObject)object);
            return object;
        }
        if (bl || this.isCompressedStream(n, n2)) {
            return this.readCompressedStream((PdfObject)object, n, pdfFileReader, objectReader, pdfObject);
        }
        return this.readLegacyReferenceTable((PdfObject)object, n, n2, pdfFileReader);
    }

    private PdfObject readLegacyReferenceTable(PdfObject pdfObject, int n, int n2, PdfFileReader pdfFileReader) throws PdfException {
        Object object;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 1024;
        do {
            byte[] byArray;
            try {
                byArray = Trailer.readTrailer(n6, n, n2, this.pdf_datafile);
            }
            catch (Exception exception) {
                block37: {
                    try {
                        this.closeFile();
                    }
                    catch (IOException iOException) {
                        if (!LogWriter.isOutput()) break block37;
                        LogWriter.writeLog("Exception " + exception + " closing file " + iOException);
                    }
                }
                throw new PdfException("Exception " + exception + " reading trailer");
            }
            if (byArray == null) break;
            n4 = byArray.length;
            for (n3 = 0; n3 < n4 && (byArray[n3] != 116 || byArray[n3 + 1] != 114 || byArray[n3 + 2] != 97 || byArray[n3 + 3] != 105 || byArray[n3 + 4] != 108 || byArray[n3 + 5] != 101 || byArray[n3 + 6] != 114); ++n3) {
            }
            int n7 = n3;
            if (n3 == byArray.length) break;
            while (byArray[n3] != 60 && byArray[n3 - 1] != 60) {
                ++n3;
            }
            object = new CompressedObject("1 0 R");
            Dictionary.readDictionary((PdfObject)object, ++n3, byArray, -1, true, pdfFileReader, false);
            int n8 = 0;
            while (true) {
                if (byArray[n3] == 60 && byArray[n3 - 1] == 60) {
                    ++n8;
                    ++n3;
                } else if (byArray[n3] == 91) {
                    ++n3;
                    while (byArray[n3] != 93 && ++n3 != byArray.length) {
                    }
                } else if (byArray[n3] == 62 && byArray[n3 - 1] == 62) {
                    --n8;
                    ++n3;
                }
                if (n8 == 0) break;
                ++n3;
            }
            int n9 = ((PdfObject)object).getInt(910911090);
            if (n9 != -1) {
                n = n9;
            } else {
                boolean bl = true;
                while (byArray[n3] == 10 || byArray[n3] == 13) {
                    ++n3;
                }
                while (byArray[n3] == 37) {
                    while (byArray[n3] != 10) {
                        ++n3;
                    }
                    ++n3;
                }
                while (byArray[n3] != 116 && byArray[n3 + 1] != 120 && byArray[n3 + 2] != 114 && byArray[n3 + 3] != 101 && byArray[n3 + 4] != 102) {
                    if (byArray[n3] == 111 && byArray[n3 + 1] == 98 && byArray[n3 + 2] == 106) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    n3 += 8;
                    while (n3 < n4 && (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 13)) {
                        ++n3;
                    }
                    int n10 = n3;
                    while (n3 < n4 && byArray[n3] != 10 && byArray[n3] != 32 && byArray[n3] != 13) {
                        ++n3;
                    }
                    if (n10 != n3) {
                        n = NumberUtils.parseInt(n10, n3, byArray);
                    }
                }
            }
            n3 = 0;
            while (byArray[n3] == 13 || byArray[n3] == 10 || byArray[n3] == 9) {
                ++n3;
            }
            if (n == -1) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (byArray[n3] == 120 && byArray[n3 + 1] == 114 && byArray[n3 + 2] == 101 && byArray[n3 + 3] == 102) {
                n3 = 5;
                while (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 13) {
                    ++n3;
                }
                n5 = this.offset.readXRefs(n5, byArray, n7, n3, n2, this.pdf_datafile);
                if (pdfObject == null) {
                    byte[][] byArray2;
                    pdfObject = ((PdfObject)object).getDictionary(574570308);
                    this.encryptObj = ((PdfObject)object).getDictionary(1113489015);
                    if (this.encryptObj != null && (byArray2 = ((PdfObject)object).getStringArray(6420)) != null && this.ID == null) {
                        this.ID = byArray2[0];
                    }
                    this.infoObject = ((PdfObject)object).getDictionary(423507519);
                }
                if ((n = ((PdfObject)object).getInt(541209926)) != -1 && (long)n < this.eof) {
                    n6 = 1024;
                    this.offset.addXref(n);
                    continue;
                }
                n = -1;
                continue;
            }
            n = -1;
            pdfObject = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            pdfFileReader.readObject(pdfObject);
            this.offset.setRefTableInvalid(true);
        } while (n != -1);
        if (this.encryptObj == null && pdfObject != null) {
            block38: {
                n3 = -1;
                n4 = pdfObject.getStatus();
                object = pdfObject.getUnresolvedData();
                try {
                    ObjectDecoder objectDecoder = new ObjectDecoder(pdfFileReader);
                    objectDecoder.checkResolved(pdfObject);
                    n3 = pdfObject.getParameterConstant(608780341);
                }
                catch (Exception exception) {
                    pdfObject.setStatus(n4);
                    pdfObject.setUnresolvedData((byte[])object, n4);
                    if (!LogWriter.isOutput()) break block38;
                    LogWriter.writeLog("[PDF] Exception reading type on root object " + exception);
                }
            }
            if (n3 == 373243460) {
                pdfObject = null;
            }
        }
        if (pdfObject == null) {
            this.offset.clear();
            this.offset.reuse();
            pdfObject = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            pdfFileReader.readObject(pdfObject);
            this.offset.setRefTableInvalid(true);
        }
        return pdfObject;
    }

    private PdfObject readCompressedStream(PdfObject pdfObject, int n, PdfFileReader pdfFileReader, ObjectReader objectReader, PdfObject pdfObject2) throws PdfException {
        while (n != -1) {
            int[] nArray;
            this.movePointer(n);
            byte[] byArray = objectReader.readObjectData(-1, null);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 32;
            int n3 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                char c = (char)byArray[i];
                if (c == '\n' || c == '\r') {
                    c = ' ';
                }
                if (c == ' ' && n2 == 32) {
                    n3 = 0;
                } else if (c == pattern.charAt(n3)) {
                    ++n3;
                } else {
                    n3 = 0;
                    stringBuilder.append(c);
                }
                if (n3 == 3) break;
                n2 = c;
            }
            stringBuilder.append('R');
            CompressedObject compressedObject = new CompressedObject(stringBuilder.toString());
            compressedObject.setCompressedStream(true);
            ObjectDecoder objectDecoder = new ObjectDecoder(pdfFileReader);
            objectDecoder.readDictionaryAsObject(compressedObject, 0, byArray);
            int[] nArray2 = ((PdfObject)compressedObject).getIntArray(39);
            byte[] byArray2 = compressedObject.getDecodedStream();
            if (byArray2 == null) {
                byArray2 = pdfFileReader.readStream(compressedObject, true, true, false, false, true, null);
            }
            if ((nArray = ((PdfObject)compressedObject).getIntArray(1043608929)) == null) {
                CompressedObjects.readCompressedOffsets(0, 0, ((PdfObject)compressedObject).getInt(590957109), nArray2, byArray2, this.offset, this.pdf_datafile);
            } else {
                int n4 = nArray.length;
                int n5 = 0;
                for (int i = 0; i < n4; i += 2) {
                    n5 = CompressedObjects.readCompressedOffsets(n5, nArray[i], nArray[i + 1], nArray2, byArray2, this.offset, this.pdf_datafile);
                }
            }
            if (pdfObject == null) {
                byte[][] byArray3;
                pdfObject = ((PdfObject)compressedObject).getDictionary(574570308);
                this.encryptObj = ((PdfObject)compressedObject).getDictionary(1113489015);
                if (this.encryptObj != null && (byArray3 = ((PdfObject)compressedObject).getStringArray(6420)) != null && this.ID == null) {
                    this.ID = byArray3[0];
                }
                this.infoObject = ((PdfObject)compressedObject).getDictionary(423507519);
            }
            if (pdfObject2 != null) {
                n = -1;
                continue;
            }
            n = ((PdfObject)compressedObject).getInt(541209926);
            if (this.isCompressedStream(n, (int)this.eof)) continue;
            return this.readLegacyReferenceTable(pdfObject, n, (int)this.eof, pdfFileReader);
        }
        return pdfObject;
    }

    byte[] getBytes(long l, int n) {
        byte[] byArray;
        block3: {
            byArray = new byte[n];
            if (l >= 0L) {
                try {
                    this.pdf_datafile.seek(l);
                    this.pdf_datafile.read(byArray);
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + iOException.getMessage());
                }
            }
        }
        return byArray;
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private boolean isCompressedStream(int n, int n2) throws PdfException {
        int n3 = 50;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[]{79, 98, 106, 83, 116, 109};
        int[] nArray2 = new int[]{88, 82, 101, 102};
        int n7 = -1;
        boolean bl = true;
        while (true) {
            if (n + n3 > n2) {
                n3 = n2 - n;
            }
            if (n3 < 0) {
                n3 = 50;
            }
            if (n < 0) {
                n += n3;
                continue;
            }
            byte[] byArray = this.getBytes(n, n3);
            if (bl && byArray[0] == 114 && byArray[1] == 101 && byArray[2] == 102) {
                n4 = 1;
            }
            bl = false;
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[i];
                if (by == oldPattern[n4] && n7 != 1) {
                    ++n4;
                    n7 = 2;
                } else if (by == nArray[n5] && (n5 == 0 || n7 == 1)) {
                    ++n5;
                    n7 = 1;
                } else if (by == nArray2[n6] && (n6 == 0 || n7 == 1)) {
                    ++n6;
                    n7 = 1;
                } else {
                    n4 = 0;
                    n5 = 0;
                    n6 = 0;
                    n7 = -1;
                }
                if (n4 == 3 || n5 == 4 || n6 == 3) break;
            }
            if (n4 == 3 || n5 == 4 || n6 == 3) break;
            n += n3;
        }
        if (n7 == -1) {
            block15: {
                try {
                    this.closeFile();
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block15;
                    LogWriter.writeLog("Exception 1 closing file " + iOException);
                }
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return n7 == 1;
    }

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public PdfObject getEncryptionObject() {
        return this.encryptObj;
    }

    public byte[] getID() {
        return this.ID;
    }

    public void movePointer(long l) {
        block5: {
            try {
                if (l > this.pdf_datafile.length()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Attempting to access ref outside file");
                    }
                } else {
                    this.pdf_datafile.seek(l);
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + exception + " moving pointer to  " + l + " in file.");
            }
        }
    }
}

