/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class JBIG2Data {
    private byte[] data;
    private RandomAccessFile rFile;
    private MappedByteBuffer memoryBuffer;

    public JBIG2Data(byte[] byArray) {
        this.data = byArray;
    }

    public JBIG2Data(File file) throws IOException {
        this.rFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = this.rFile.getChannel();
        this.memoryBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public byte getItemAt(int n) {
        if (this.data != null) {
            return this.data[n];
        }
        return this.memoryBuffer.get(n);
    }

    public int getDataLength() {
        if (this.data != null) {
            return this.data.length;
        }
        try {
            return (int)this.rFile.length();
        }
        catch (IOException iOException) {
            System.out.println("IOExcpetion " + iOException);
            return 0;
        }
    }
}

