/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.decoders;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jpedal.jbig2.JBIG2Data;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.io.StreamReader;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.SegmentHeader;
import org.jpedal.jbig2.segment.extensions.ExtensionSegment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.generic.GenericRegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionSegment;
import org.jpedal.jbig2.segment.region.refinement.RefinementRegionSegment;
import org.jpedal.jbig2.segment.region.text.TextRegionSegment;
import org.jpedal.jbig2.segment.stripes.EndOfStripeSegment;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionarySegment;
import org.jpedal.jbig2.segment.tables.CodeTableSegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class JBIG2StreamDecoder {
    private StreamReader reader;
    private boolean noOfPagesKnown;
    private boolean randomAccessOrganisation;
    private int noOfPages = -1;
    private final ArrayList<Segment> segments = new ArrayList();
    private final ArrayList<JBIG2Bitmap> bitmaps = new ArrayList();
    private JBIG2Data globalData;
    private ArithmeticDecoder arithmeticDecoder;
    private HuffmanDecoder huffmanDecoder;
    private MMRDecoder mmrDecoder;
    private File tempFile;
    private MappedByteBuffer memoryBuffer;
    private RandomAccessFile randomFile;
    private final HashMap<Integer, Integer> bitmapHolder = new HashMap();
    private boolean isBitmapsInFile;
    private static final String tempDir = "";
    private int minFileSize = -1;
    public static final boolean debug = false;

    public JBIG2StreamDecoder() {
    }

    public JBIG2StreamDecoder(boolean bl, String string) {
        this.isBitmapsInFile = bl;
        if (bl) {
            String string2 = System.currentTimeMillis() + "-" + System.nanoTime() + '-' + UUID.randomUUID().toString().substring(0, 4);
            try {
                this.tempFile = File.createTempFile(string2, ".jpedal", new File(string));
                this.randomFile = new RandomAccessFile(this.tempFile, "rw");
                FileChannel fileChannel = this.randomFile.getChannel();
                this.memoryBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileChannel.size());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public MappedByteBuffer getMemoryBuffer() {
        return this.memoryBuffer;
    }

    public void setMemoryBuffer(MappedByteBuffer mappedByteBuffer) {
        this.memoryBuffer = mappedByteBuffer;
    }

    public RandomAccessFile getRandomFile() {
        return this.randomFile;
    }

    public HashMap<Integer, Integer> getBitmapHolder() {
        return this.bitmapHolder;
    }

    public JBIG2StreamDecoder(String string, int n) {
        this.minFileSize = n;
    }

    public void movePointer(int n) {
        this.reader.movePointer(n);
    }

    public void setGlobalData(byte[] byArray) {
        this.globalData = new JBIG2Data(byArray);
    }

    public void setGlobalData(File file) throws IOException {
        this.globalData = new JBIG2Data(file);
    }

    public void decodeJBIG2(JBIG2Data jBIG2Data) throws IOException, JBIG2Exception {
        this.reader = new StreamReader(jBIG2Data);
        this.resetDecoder();
        boolean bl = this.checkHeader();
        if (!bl) {
            this.noOfPagesKnown = true;
            this.randomAccessOrganisation = false;
            this.noOfPages = 1;
            if (this.globalData != null) {
                this.reader = new StreamReader(this.globalData);
                this.huffmanDecoder = new HuffmanDecoder(this.reader);
                this.mmrDecoder = new MMRDecoder(this.reader);
                this.arithmeticDecoder = new ArithmeticDecoder(this.reader);
                this.readSegments();
                this.reader = new StreamReader(jBIG2Data);
            } else {
                this.reader.movePointer(-8);
            }
        } else {
            this.setFileHeaderFlags();
            if (this.noOfPagesKnown) {
                this.noOfPages = this.getNoOfPages();
            }
        }
        this.huffmanDecoder = new HuffmanDecoder(this.reader);
        this.mmrDecoder = new MMRDecoder(this.reader);
        this.arithmeticDecoder = new ArithmeticDecoder(this.reader);
        this.readSegments();
    }

    public HuffmanDecoder getHuffmanDecoder() {
        return this.huffmanDecoder;
    }

    public MMRDecoder getMMRDecoder() {
        return this.mmrDecoder;
    }

    public ArithmeticDecoder getArithmeticDecoder() {
        return this.arithmeticDecoder;
    }

    private void resetDecoder() {
        this.noOfPagesKnown = false;
        this.randomAccessOrganisation = false;
        this.noOfPages = -1;
        this.segments.clear();
        this.bitmaps.clear();
    }

    private void readSegments() throws IOException, JBIG2Exception {
        boolean bl = false;
        block23: while (this.reader.bytesRemaining() && !bl) {
            SegmentHeader segmentHeader = new SegmentHeader();
            this.readSegmentHeader(segmentHeader);
            Segment segment = null;
            int n = segmentHeader.getSegmentType();
            int[] nArray = segmentHeader.getReferredToSegments();
            int n2 = segmentHeader.getReferredToSegmentCount();
            switch (n) {
                case 0: {
                    segment = new SymbolDictionarySegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 4: {
                    segment = new TextRegionSegment(this, false);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 6: {
                    segment = new TextRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 7: {
                    segment = new TextRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 16: {
                    segment = new PatternDictionarySegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 20: {
                    segment = new HalftoneRegionSegment(this, false);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 22: {
                    segment = new HalftoneRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 23: {
                    segment = new HalftoneRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 36: {
                    segment = new GenericRegionSegment(this, false);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 38: {
                    segment = new GenericRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 39: {
                    segment = new GenericRegionSegment(this, true);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 40: {
                    segment = new RefinementRegionSegment(this, false, nArray, n2);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 42: {
                    segment = new RefinementRegionSegment(this, true, nArray, n2);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 43: {
                    segment = new RefinementRegionSegment(this, true, nArray, n2);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 48: {
                    segment = new PageInformationSegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 49: {
                    continue block23;
                }
                case 50: {
                    segment = new EndOfStripeSegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 51: {
                    bl = true;
                    continue block23;
                }
                case 52: {
                    break;
                }
                case 53: {
                    segment = new CodeTableSegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                case 62: {
                    segment = new ExtensionSegment(this);
                    segment.setSegmentHeader(segmentHeader);
                    break;
                }
                default: {
                    System.out.println("Unknown Segment type in JBIG2 stream");
                }
            }
            if (!this.randomAccessOrganisation) {
                segment.readSegment();
            }
            this.segments.add(segment);
        }
        if (this.randomAccessOrganisation) {
            for (Segment segment : this.segments) {
                segment.readSegment();
            }
        }
    }

    public PageInformationSegment findPageSegment(int n) {
        for (Segment segment : this.segments) {
            SegmentHeader segmentHeader = segment.getSegmentHeader();
            if (segmentHeader.getSegmentType() != 48 || segmentHeader.getPageAssociation() != n) continue;
            return (PageInformationSegment)segment;
        }
        return null;
    }

    public Segment findSegment(int n) {
        for (Segment segment : this.segments) {
            if (segment.getSegmentHeader().getSegmentNumber() != n) continue;
            return segment;
        }
        return null;
    }

    private void readSegmentHeader(SegmentHeader segmentHeader) throws JBIG2Exception {
        this.handleSegmentNumber(segmentHeader);
        this.handleSegmentHeaderFlags(segmentHeader);
        this.handleSegmentReferredToCountAndRetentionFlags(segmentHeader);
        this.handleReferredToSegmentNumbers(segmentHeader);
        this.handlePageAssociation(segmentHeader);
        if (segmentHeader.getSegmentType() != 51) {
            this.handleSegmentDataLength(segmentHeader);
        }
    }

    private void handlePageAssociation(SegmentHeader segmentHeader) {
        int n;
        boolean bl = segmentHeader.isPageAssociationSizeSet();
        if (bl) {
            short[] sArray = new short[4];
            this.reader.readByte(sArray);
            n = BinaryOperation.getInt32(sArray);
        } else {
            n = this.reader.readByte();
        }
        segmentHeader.setPageAssociation(n);
    }

    private void handleSegmentNumber(SegmentHeader segmentHeader) {
        short[] sArray = new short[4];
        this.reader.readByte(sArray);
        int n = BinaryOperation.getInt32(sArray);
        segmentHeader.setSegmentNumber(n);
    }

    private void handleSegmentHeaderFlags(SegmentHeader segmentHeader) {
        short s = this.reader.readByte();
        segmentHeader.setSegmentHeaderFlags(s);
    }

    private void handleSegmentReferredToCountAndRetentionFlags(SegmentHeader segmentHeader) throws JBIG2Exception {
        short s = this.reader.readByte();
        int n = (s & 0xE0) >> 5;
        short s2 = (short)(s & 0x1F);
        if (n <= 4) {
            short[] sArray = new short[]{s2};
        } else if (n == 7) {
            int n2;
            short[] sArray = new short[4];
            sArray[0] = s2;
            for (n2 = 1; n2 < 4; ++n2) {
                sArray[n2] = this.reader.readByte();
            }
            n = BinaryOperation.getInt32(sArray);
            n2 = (int)Math.ceil(4.0 + (double)(n + 1) / 8.0);
            int n3 = n2 - 4;
            short[] sArray2 = new short[n3];
            this.reader.readByte(sArray2);
        } else {
            throw new JBIG2Exception("Error, 3 bit Segment count field = " + n);
        }
        segmentHeader.setReferredToSegmentCount(n);
    }

    private void handleReferredToSegmentNumbers(SegmentHeader segmentHeader) {
        int n = segmentHeader.getReferredToSegmentCount();
        int[] nArray = new int[n];
        int n2 = segmentHeader.getSegmentNumber();
        if (n2 <= 256) {
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.reader.readByte();
            }
        } else if (n2 <= 65536) {
            short[] sArray = new short[2];
            for (int i = 0; i < n; ++i) {
                this.reader.readByte(sArray);
                nArray[i] = BinaryOperation.getInt16(sArray);
            }
        } else {
            short[] sArray = new short[4];
            for (int i = 0; i < n; ++i) {
                this.reader.readByte(sArray);
                nArray[i] = BinaryOperation.getInt32(sArray);
            }
        }
        segmentHeader.setReferredToSegments(nArray);
    }

    private int getNoOfPages() {
        short[] sArray = new short[4];
        this.reader.readByte(sArray);
        return BinaryOperation.getInt32(sArray);
    }

    private void handleSegmentDataLength(SegmentHeader segmentHeader) {
        short[] sArray = new short[4];
        this.reader.readByte(sArray);
        int n = BinaryOperation.getInt32(sArray);
        segmentHeader.setDataLength(n);
    }

    private void setFileHeaderFlags() {
        int n;
        short s = this.reader.readByte();
        if ((s & 0xFC) != 0) {
            System.out.println("Warning, reserved bits (2-7) of file header flags are not zero " + s);
        }
        this.randomAccessOrganisation = (n = s & 1) == 0;
        int n2 = s & 2;
        this.noOfPagesKnown = n2 == 0;
    }

    private boolean checkHeader() {
        short[] sArray = new short[]{151, 74, 66, 50, 13, 10, 26, 10};
        short[] sArray2 = new short[8];
        this.reader.readByte(sArray2);
        return Arrays.equals(sArray, sArray2);
    }

    public int readBits(int n) {
        return this.reader.readBits(n);
    }

    public int readBit() {
        return this.reader.readBit();
    }

    public void readByte(short[] sArray) {
        this.reader.readByte(sArray);
    }

    public void consumeRemainingBits() {
        this.reader.consumeRemainingBits();
    }

    public short readByte() {
        return this.reader.readByte();
    }

    public void appendBitmap(JBIG2Bitmap jBIG2Bitmap) {
        this.bitmaps.add(jBIG2Bitmap);
    }

    public JBIG2Bitmap findBitmap(int n) {
        for (JBIG2Bitmap jBIG2Bitmap : this.bitmaps) {
            if (jBIG2Bitmap.getBitmapNumber() != n) continue;
            return jBIG2Bitmap;
        }
        return null;
    }

    public boolean isNumberOfPagesKnown() {
        return this.noOfPagesKnown;
    }

    public int getNumberOfPages() {
        return this.noOfPages;
    }

    public ArrayList<Segment> getAllSegments() {
        return this.segments;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public boolean isBitmapsInFile() {
        return this.isBitmapsInFile;
    }

    public List<JBIG2Bitmap> getBitMaps() {
        return this.bitmaps;
    }

    public File getTempFile() {
        return this.tempFile;
    }
}

