/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.examples.jai;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.jpedal.jbig2.examples.jai.CfgDialog;
import org.jpedal.jbig2.examples.jai.PicPanel;

public class JBIG2ReaderPluginTester
extends JFrame {
    private static final String appTitle = "JBIG2 Reader Plug-in Tester";
    static final int FORMAT_NAME = 0;
    static final int INPUT = 1;
    static final int MIME_TYPE = 2;
    static final int SUFFIX = 3;
    private BufferedImage biImage;
    private int dstOffX;
    private int dstOffY;
    private int height;
    private int width;
    private int srcX;
    private int srcY;
    private int srcWidth;
    private int srcHeight = 1;
    private int xSS = 1;
    private int ySS = 1;
    private JLabel lblStatus;
    private int method;
    private PicPanel pp;
    private JScrollPane jsp;

    private JBIG2ReaderPluginTester(String string) {
        super(string);
        this.setDefaultCloseOperation(3);
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open...");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFileChooser.setSelectedFile(null);
                if (jFileChooser.showOpenDialog(JBIG2ReaderPluginTester.this) != 0) {
                    return;
                }
                if (JBIG2ReaderPluginTester.this.doOpen(jFileChooser.getSelectedFile())) {
                    return;
                }
                JBIG2ReaderPluginTester.this.lblStatus.setText("Width: " + JBIG2ReaderPluginTester.this.width + ", Height: " + JBIG2ReaderPluginTester.this.height + ", File: " + jFileChooser.getSelectedFile().getAbsolutePath());
                JBIG2ReaderPluginTester.this.pp.setBufferedImage(JBIG2ReaderPluginTester.this.biImage);
                JBIG2ReaderPluginTester.this.jsp.getHorizontalScrollBar().setValue(0);
                JBIG2ReaderPluginTester.this.jsp.getVerticalScrollBar().setValue(0);
            }
        };
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Configure...");
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CfgDialog cfgDialog = new CfgDialog(JBIG2ReaderPluginTester.this, JBIG2ReaderPluginTester.this.dstOffX, JBIG2ReaderPluginTester.this.dstOffY, JBIG2ReaderPluginTester.this.method, JBIG2ReaderPluginTester.this.srcX, JBIG2ReaderPluginTester.this.srcY, JBIG2ReaderPluginTester.this.srcWidth, JBIG2ReaderPluginTester.this.srcHeight, JBIG2ReaderPluginTester.this.xSS, JBIG2ReaderPluginTester.this.ySS);
                cfgDialog.setVisible(true);
                if (cfgDialog.isCanceled()) {
                    return;
                }
                JBIG2ReaderPluginTester.this.dstOffX = cfgDialog.getDstOffX();
                JBIG2ReaderPluginTester.this.dstOffY = cfgDialog.getDstOffY();
                JBIG2ReaderPluginTester.this.method = cfgDialog.getMethod();
                JBIG2ReaderPluginTester.this.srcX = cfgDialog.getSrcX();
                JBIG2ReaderPluginTester.this.srcY = cfgDialog.getSrcY();
                JBIG2ReaderPluginTester.this.srcWidth = cfgDialog.getSrcWidth();
                JBIG2ReaderPluginTester.this.srcHeight = cfgDialog.getSrcHeight();
                JBIG2ReaderPluginTester.this.xSS = cfgDialog.getXSS();
                JBIG2ReaderPluginTester.this.ySS = cfgDialog.getYSS();
            }
        };
        jMenuItem2.addActionListener(actionListener2);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("Exit");
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
        jMenuItem3.addActionListener(actionListener3);
        jMenu.add(jMenuItem3);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.pp = new PicPanel(null);
        this.jsp = new JScrollPane(this.pp);
        this.getContentPane().add(this.jsp);
        this.lblStatus = new JLabel(" ");
        this.lblStatus.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.lblStatus, "South");
        this.pack();
        this.setVisible(true);
    }

    boolean doOpen(File file) {
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist!", appTitle, 0);
            return true;
        }
        try {
            String string = file.getAbsolutePath().toLowerCase();
            if (!string.endsWith(".jbig2") && !string.endsWith(".jb2")) {
                JOptionPane.showMessageDialog(this, "Incorrect file extension!", appTitle, 0);
                return true;
            }
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iterator = this.method == 0 ? ImageIO.getImageReadersByFormatName("jbig2") : (this.method == 2 ? ImageIO.getImageReadersByMIMEType("image/x-jbig2") : (this.method == 3 ? ImageIO.getImageReadersBySuffix("jbig2") : ImageIO.getImageReaders(imageInputStream)));
            if (!iterator.hasNext()) {
                JOptionPane.showMessageDialog(this, "Unable to obtain reader!", appTitle, 0);
                return true;
            }
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream, true);
            ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
            if (this.dstOffX != 0 || this.dstOffY != 0) {
                imageReadParam.setDestinationOffset(new Point(this.dstOffX, this.dstOffY));
            }
            if (this.srcWidth != 0) {
                imageReadParam.setSourceRegion(new Rectangle(this.srcX, this.srcY, this.srcWidth, this.srcHeight));
            }
            if (this.xSS != 1 || this.ySS != 1) {
                imageReadParam.setSourceSubsampling(this.xSS, this.ySS, 0, 0);
            }
            this.biImage = imageReader.read(0, imageReadParam);
            this.width = imageReader.getWidth(0);
            this.height = imageReader.getHeight(0);
            imageReader.dispose();
            return false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), appTitle, 0);
            return true;
        }
    }

    public static void main(String[] stringArray) {
        new JBIG2ReaderPluginTester(appTitle);
    }
}

