/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import org.jpedal.jbig2.JBIG2DataWriter;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.BitmapPointer;

public final class JBIG2Bitmap {
    private int height;
    private final int width;
    private final int line;
    private int bitmapNumber;
    private final JBIG2DataWriter jBIG2DataWriter;
    private final ArithmeticDecoder arithmeticDecoder;
    private final HuffmanDecoder huffmanDecoder;
    private final MMRDecoder mmrDecoder;
    private final JBIG2StreamDecoder decoder;
    private final int bytesNeeded;

    public JBIG2Bitmap(int n, int n2, ArithmeticDecoder arithmeticDecoder, HuffmanDecoder huffmanDecoder, MMRDecoder mMRDecoder, JBIG2StreamDecoder jBIG2StreamDecoder) {
        this.width = n;
        this.height = n2;
        this.arithmeticDecoder = arithmeticDecoder;
        this.huffmanDecoder = huffmanDecoder;
        this.mmrDecoder = mMRDecoder;
        this.line = n + 7 >> 3;
        this.decoder = jBIG2StreamDecoder;
        this.bytesNeeded = this.line * (n2 + 1);
        this.jBIG2DataWriter = jBIG2StreamDecoder.isBitmapsInFile() ? new JBIG2DataWriter(jBIG2StreamDecoder, this.bytesNeeded) : new JBIG2DataWriter(new byte[this.bytesNeeded]);
    }

    public void readBitmap(int n, boolean bl, boolean bl2, JBIG2Bitmap jBIG2Bitmap, short[] sArray, short[] sArray2) {
        int n2;
        JBIG2DataWriter jBIG2DataWriter;
        BitmapPointer bitmapPointer = new BitmapPointer(this);
        BitmapPointer bitmapPointer2 = new BitmapPointer(this);
        BitmapPointer bitmapPointer3 = new BitmapPointer(this);
        BitmapPointer bitmapPointer4 = new BitmapPointer(this);
        BitmapPointer bitmapPointer5 = new BitmapPointer(this);
        BitmapPointer bitmapPointer6 = new BitmapPointer(this);
        long l = 0L;
        if (bl) {
            switch (n) {
                case 0: {
                    l = 14675L;
                    break;
                }
                case 1: {
                    l = 1946L;
                    break;
                }
                case 2: {
                    l = 227L;
                    break;
                }
                case 3: {
                    l = 394L;
                }
            }
        }
        boolean bl3 = false;
        if (bl2) {
            jBIG2DataWriter = jBIG2Bitmap.jBIG2DataWriter;
            n2 = jBIG2Bitmap.line;
        } else {
            jBIG2DataWriter = null;
            n2 = 0;
        }
        block12: for (int i = 0; i < this.height; ++i) {
            int n3;
            if (bl) {
                n3 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.genericRegionStats);
                if (n3 != 0) {
                    boolean bl4 = bl3 = !bl3;
                }
                if (bl3) {
                    this.duplicateRow(i, i - 1);
                    continue;
                }
            }
            switch (n) {
                case 0: {
                    long l2;
                    int n4;
                    bitmapPointer.setPointer(0, i - 2);
                    long l3 = bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                    bitmapPointer2.setPointer(0, i - 1);
                    long l4 = bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    long l5 = 0L;
                    bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                    bitmapPointer4.setPointer(sArray[1], i + sArray2[1]);
                    bitmapPointer5.setPointer(sArray[2], i + sArray2[2]);
                    bitmapPointer6.setPointer(sArray[3], i + sArray2[3]);
                    for (n4 = 0; n4 < this.width; ++n4) {
                        l2 = l3 << 13 & 0xFFFFFFFFL | l4 << 8 & 0xFFFFFFFFL | l5 << 4 & 0xFFFFFFFFL | (long)(bitmapPointer3.nextPixel() << 3) | (long)(bitmapPointer4.nextPixel() << 2) | (long)(bitmapPointer5.nextPixel() << 1) | (long)bitmapPointer6.nextPixel();
                        if (bl2 && JBIG2Bitmap.getPixel(n4, i, n2, jBIG2DataWriter) != 0) {
                            n3 = 0;
                        } else {
                            n3 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                            if (n3 != 0) {
                                this.setPixel(n4, i, 1);
                            }
                        }
                        l3 = (l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel()) & 7L;
                        l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                        l5 = (l5 << 1 & 0xFFFFFFFFL | (long)n3) & 0xFL;
                    }
                    continue block12;
                }
                case 1: {
                    long l2;
                    int n4;
                    bitmapPointer.setPointer(0, i - 2);
                    long l3 = bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                    bitmapPointer2.setPointer(0, i - 1);
                    long l4 = bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    long l5 = 0L;
                    bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                    for (n4 = 0; n4 < this.width; ++n4) {
                        l2 = l3 << 9 & 0xFFFFFFFFL | l4 << 4 & 0xFFFFFFFFL | l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                        if (bl2 && JBIG2Bitmap.getPixel(n4, i, n2, jBIG2DataWriter) != 0) {
                            n3 = 0;
                        } else {
                            n3 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                            if (n3 != 0) {
                                this.setPixel(n4, i, 1);
                            }
                        }
                        l3 = (l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel()) & 0xFL;
                        l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                        l5 = (l5 << 1 & 0xFFFFFFFFL | (long)n3) & 7L;
                    }
                    continue block12;
                }
                case 2: {
                    long l2;
                    int n4;
                    bitmapPointer.setPointer(0, i - 2);
                    long l3 = bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                    bitmapPointer2.setPointer(0, i - 1);
                    long l4 = bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    long l5 = 0L;
                    bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                    for (n4 = 0; n4 < this.width; ++n4) {
                        l2 = l3 << 7 & 0xFFFFFFFFL | l4 << 3 & 0xFFFFFFFFL | l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                        if (bl2 && JBIG2Bitmap.getPixel(n4, i, n2, jBIG2DataWriter) != 0) {
                            n3 = 0;
                        } else {
                            n3 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                            if (n3 != 0) {
                                this.setPixel(n4, i, 1);
                            }
                        }
                        l3 = (l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel()) & 7L;
                        l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 0xFL;
                        l5 = (l5 << 1 & 0xFFFFFFFFL | (long)n3) & 3L;
                    }
                    continue block12;
                }
                case 3: {
                    long l2;
                    int n4;
                    bitmapPointer2.setPointer(0, i - 1);
                    long l4 = bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    long l5 = 0L;
                    bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                    for (n4 = 0; n4 < this.width; ++n4) {
                        l2 = l4 << 5 & 0xFFFFFFFFL | l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                        if (bl2 && JBIG2Bitmap.getPixel(n4, i, n2, jBIG2DataWriter) != 0) {
                            n3 = 0;
                        } else {
                            n3 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                            if (n3 != 0) {
                                this.setPixel(n4, i, 1);
                            }
                        }
                        l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                        l5 = (l5 << 1 & 0xFFFFFFFFL | (long)n3) & 0xFL;
                    }
                    continue block12;
                }
            }
        }
    }

    public void readBitmapWithMMR(int n) {
        this.mmrDecoder.reset();
        int[] nArray = new int[this.width + 2];
        int[] nArray2 = new int[this.width + 2];
        nArray2[0] = this.width;
        nArray2[1] = this.width;
        for (int i = 0; i < this.height; ++i) {
            int n2;
            int n3;
            int n4 = 0;
            while (nArray2[n4] < this.width) {
                nArray[n4] = nArray2[n4];
                ++n4;
            }
            nArray[n4] = this.width;
            nArray[n4 + 1] = this.width;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            block13: do {
                n3 = this.mmrDecoder.get2DCode();
                switch (n3) {
                    case 0: {
                        if (nArray[n5] >= this.width) break;
                        n7 = nArray[n5 + 1];
                        n5 += 2;
                        break;
                    }
                    case 1: {
                        int n8;
                        if (n6 & true) {
                            n3 = 0;
                            do {
                                n8 = this.mmrDecoder.getBlackCode();
                                n3 += n8;
                            } while (n8 >= 64);
                            n2 = 0;
                            do {
                                n8 = this.mmrDecoder.getWhiteCode();
                                n2 += n8;
                            } while (n8 >= 64);
                        } else {
                            n3 = 0;
                            do {
                                n8 = this.mmrDecoder.getWhiteCode();
                                n3 += n8;
                            } while (n8 >= 64);
                            n2 = 0;
                            do {
                                n8 = this.mmrDecoder.getBlackCode();
                                n2 += n8;
                            } while (n8 >= 64);
                        }
                        if (n3 <= 0 && n2 <= 0) continue block13;
                        nArray2[n6] = n7 += n3;
                        nArray2[++n6] = n7 += n2;
                        ++n6;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 2: {
                        nArray2[n6] = n7 = nArray[n5];
                        ++n6;
                        if (nArray[n5] >= this.width) break;
                        ++n5;
                        break;
                    }
                    case 3: {
                        nArray2[n6] = n7 = nArray[n5] + 1;
                        ++n6;
                        if (nArray[n5] >= this.width) break;
                        ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 5: {
                        nArray2[n6] = n7 = nArray[n5] + 2;
                        ++n6;
                        if (nArray[n5] >= this.width) break;
                        ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 7: {
                        nArray2[n6] = n7 = nArray[n5] + 3;
                        ++n6;
                        if (nArray[n5] >= this.width) break;
                        ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 4: {
                        nArray2[n6] = n7 = nArray[n5] - 1;
                        ++n6;
                        n5 = n5 > 0 ? --n5 : ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 6: {
                        nArray2[n6] = n7 = nArray[n5] - 2;
                        ++n6;
                        n5 = n5 > 0 ? --n5 : ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        continue block13;
                    }
                    case 8: {
                        nArray2[n6] = n7 = nArray[n5] - 3;
                        ++n6;
                        n5 = n5 > 0 ? --n5 : ++n5;
                        while (nArray[n5] <= n7 && nArray[n5] < this.width) {
                            n5 += 2;
                        }
                        break block0;
                    }
                }
            } while (n7 < this.width);
            nArray2[n6] = this.width;
            n3 = 0;
            while (nArray2[n3] < this.width) {
                for (n2 = nArray2[n3]; n2 < nArray2[n3 + 1]; ++n2) {
                    this.setPixel(n2, i, 1);
                }
                n3 += 2;
            }
        }
        if (n >= 0) {
            this.mmrDecoder.skipTo(n);
        } else if (this.mmrDecoder.get24Bits() != 4097L) {
            // empty if block
        }
    }

    public void readGenericRefinementRegion(int n, boolean bl, JBIG2Bitmap jBIG2Bitmap, int n2, int n3, short[] sArray, short[] sArray2) {
        BitmapPointer bitmapPointer;
        BitmapPointer bitmapPointer2;
        BitmapPointer bitmapPointer3;
        BitmapPointer bitmapPointer4;
        BitmapPointer bitmapPointer5;
        BitmapPointer bitmapPointer6;
        BitmapPointer bitmapPointer7;
        BitmapPointer bitmapPointer8;
        BitmapPointer bitmapPointer9;
        BitmapPointer bitmapPointer10;
        long l;
        if (n != 0) {
            l = 8L;
            bitmapPointer10 = new BitmapPointer(this);
            bitmapPointer9 = new BitmapPointer(this);
            bitmapPointer8 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer7 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer6 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer5 = new BitmapPointer(this);
            bitmapPointer4 = new BitmapPointer(this);
            bitmapPointer3 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer2 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer = new BitmapPointer(jBIG2Bitmap);
        } else {
            l = 16L;
            bitmapPointer10 = new BitmapPointer(this);
            bitmapPointer9 = new BitmapPointer(this);
            bitmapPointer8 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer7 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer6 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer5 = new BitmapPointer(this);
            bitmapPointer4 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer3 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer2 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer = new BitmapPointer(jBIG2Bitmap);
        }
        boolean bl2 = false;
        for (int i = 0; i < this.height; ++i) {
            long l2;
            int n4;
            int n5;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            if (n != 0) {
                bitmapPointer10.setPointer(0, i - 1);
                l8 = bitmapPointer10.nextPixel();
                bitmapPointer9.setPointer(-1, i);
                bitmapPointer8.setPointer(-n2, i - 1 - n3);
                bitmapPointer7.setPointer(-1 - n2, i - n3);
                l7 = bitmapPointer7.nextPixel();
                l7 = l7 << 1 & 0xFFFFFFFFL | (long)bitmapPointer7.nextPixel();
                bitmapPointer6.setPointer(-n2, i + 1 - n3);
                l6 = bitmapPointer6.nextPixel();
                l5 = 0L;
                l4 = 0L;
                l3 = 0L;
                if (bl) {
                    bitmapPointer3.setPointer(-1 - n2, i - 1 - n3);
                    l5 = bitmapPointer3.nextPixel();
                    l5 = l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                    l5 = l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                    bitmapPointer2.setPointer(-1 - n2, i - n3);
                    l4 = bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                    bitmapPointer.setPointer(-1 - n2, i + 1 - n3);
                    l3 = bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                    l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                }
                for (n5 = 0; n5 < this.width; ++n5) {
                    l8 = (l8 << 1 & 0xFFFFFFFFL | (long)bitmapPointer10.nextPixel()) & 7L;
                    l7 = (l7 << 1 & 0xFFFFFFFFL | (long)bitmapPointer7.nextPixel()) & 7L;
                    l6 = (l6 << 1 & 0xFFFFFFFFL | (long)bitmapPointer6.nextPixel()) & 3L;
                    if (bl) {
                        l5 = (l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel()) & 7L;
                        l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 7L;
                        l3 = (l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel()) & 7L;
                        n4 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.refinementRegionStats);
                        if (n4 != 0) {
                            boolean bl3 = bl2 = !bl2;
                        }
                        if (l5 == 0L && l4 == 0L && l3 == 0L) {
                            this.setPixel(n5, i, 0);
                            continue;
                        }
                        if (l5 == 7L && l4 == 7L && l3 == 7L) {
                            this.setPixel(n5, i, 1);
                            continue;
                        }
                    }
                    if ((n4 = this.arithmeticDecoder.decodeBit(l2 = l8 << 7 & 0xFFFFFFFFL | (long)(bitmapPointer9.nextPixel() << 6) | (long)(bitmapPointer8.nextPixel() << 5) | l7 << 2 & 0xFFFFFFFFL | l6, this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                    this.setPixel(n5, i, 1);
                }
                continue;
            }
            bitmapPointer10.setPointer(0, i - 1);
            l8 = bitmapPointer10.nextPixel();
            bitmapPointer9.setPointer(-1, i);
            bitmapPointer8.setPointer(-n2, i - 1 - n3);
            long l9 = bitmapPointer8.nextPixel();
            bitmapPointer7.setPointer(-1 - n2, i - n3);
            l7 = bitmapPointer7.nextPixel();
            l7 = l7 << 1 & 0xFFFFFFFFL | (long)bitmapPointer7.nextPixel();
            bitmapPointer6.setPointer(-1 - n2, i + 1 - n3);
            l6 = bitmapPointer6.nextPixel();
            l6 = l6 << 1 & 0xFFFFFFFFL | (long)bitmapPointer6.nextPixel();
            bitmapPointer5.setPointer(sArray[0], i + sArray2[0]);
            bitmapPointer4.setPointer(sArray[1] - n2, i + sArray2[1] - n3);
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            if (bl) {
                bitmapPointer3.setPointer(-1 - n2, i - 1 - n3);
                l5 = bitmapPointer3.nextPixel();
                l5 = l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                l5 = l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel();
                bitmapPointer2.setPointer(-1 - n2, i - n3);
                l4 = bitmapPointer2.nextPixel();
                l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                l4 = l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel();
                bitmapPointer.setPointer(-1 - n2, i + 1 - n3);
                l3 = bitmapPointer.nextPixel();
                l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
                l3 = l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel();
            }
            for (n5 = 0; n5 < this.width; ++n5) {
                l8 = (l8 << 1 & 0xFFFFFFFFL | (long)bitmapPointer10.nextPixel()) & 3L;
                l9 = (l9 << 1 & 0xFFFFFFFFL | (long)bitmapPointer8.nextPixel()) & 3L;
                l7 = (l7 << 1 & 0xFFFFFFFFL | (long)bitmapPointer7.nextPixel()) & 7L;
                l6 = (l6 << 1 & 0xFFFFFFFFL | (long)bitmapPointer6.nextPixel()) & 7L;
                if (bl) {
                    l5 = (l5 << 1 & 0xFFFFFFFFL | (long)bitmapPointer3.nextPixel()) & 7L;
                    l4 = (l4 << 1 & 0xFFFFFFFFL | (long)bitmapPointer2.nextPixel()) & 7L;
                    l3 = (l3 << 1 & 0xFFFFFFFFL | (long)bitmapPointer.nextPixel()) & 7L;
                    n4 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.refinementRegionStats);
                    if (n4 == 1) {
                        boolean bl4 = bl2 = !bl2;
                    }
                    if (l5 == 0L && l4 == 0L && l3 == 0L) {
                        this.setPixel(n5, i, 0);
                        continue;
                    }
                    if (l5 == 7L && l4 == 7L && l3 == 7L) {
                        this.setPixel(n5, i, 1);
                        continue;
                    }
                }
                if ((n4 = this.arithmeticDecoder.decodeBit(l2 = l8 << 11 & 0xFFFFFFFFL | (long)(bitmapPointer9.nextPixel() << 10) | l9 << 8 & 0xFFFFFFFFL | l7 << 5 & 0xFFFFFFFFL | l6 << 2 & 0xFFFFFFFFL | (long)(bitmapPointer5.nextPixel() << 1) | (long)bitmapPointer4.nextPixel(), this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                this.setPixel(n5, i, 1);
            }
        }
    }

    public void readTextRegion(boolean bl, boolean bl2, int n, int n2, int n3, int[][] nArray, int n4, JBIG2Bitmap[] jBIG2BitmapArray, int n5, int n6, boolean bl3, int n7, int n8, int[][] nArray2, int[][] nArray3, int[][] nArray4, int[][] nArray5, int[][] nArray6, int[][] nArray7, int[][] nArray8, int n9, short[] sArray, short[] sArray2, JBIG2StreamDecoder jBIG2StreamDecoder) {
        int n10 = 1 << n2;
        this.clear(n5);
        int n11 = bl ? this.huffmanDecoder.decodeInt(nArray4).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
        n11 *= -n10;
        int n12 = 0;
        block12: for (int i = 0; i < n; ++i) {
            int n13 = bl ? this.huffmanDecoder.decodeInt(nArray4).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
            n11 += n13 * n10;
            int n14 = bl ? this.huffmanDecoder.decodeInt(nArray2).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iafsStats).intResult();
            int n15 = n12 += n14;
            while (true) {
                JBIG2Bitmap jBIG2Bitmap;
                int n16;
                int n17;
                n13 = n10 == 1 ? 0 : (bl ? jBIG2StreamDecoder.readBits(n2) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaitStats).intResult());
                int n18 = n11 + n13;
                long l = bl ? (nArray != null ? (long)this.huffmanDecoder.decodeInt(nArray).intResult() : (long)jBIG2StreamDecoder.readBits(n4)) : this.arithmeticDecoder.decodeIAID(n4, this.arithmeticDecoder.iaidStats);
                if (l >= (long)n3) continue block12;
                int n19 = bl2 ? (bl ? jBIG2StreamDecoder.readBit() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iariStats).intResult()) : 0;
                boolean bl4 = false;
                if (n19 != 0) {
                    int n20;
                    int n21;
                    if (bl) {
                        n17 = this.huffmanDecoder.decodeInt(nArray5).intResult();
                        n16 = this.huffmanDecoder.decodeInt(nArray6).intResult();
                        n21 = this.huffmanDecoder.decodeInt(nArray7).intResult();
                        n20 = this.huffmanDecoder.decodeInt(nArray8).intResult();
                        jBIG2StreamDecoder.consumeRemainingBits();
                        this.arithmeticDecoder.start();
                    } else {
                        n17 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardwStats).intResult();
                        n16 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardhStats).intResult();
                        n21 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                        n20 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                    }
                    n21 = (n17 >= 0 ? n17 : n17 - 1) / 2 + n21;
                    n20 = (n16 >= 0 ? n16 : n16 - 1) / 2 + n20;
                    jBIG2Bitmap = new JBIG2Bitmap(n17 + jBIG2BitmapArray[(int)l].width, n16 + jBIG2BitmapArray[(int)l].height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, jBIG2StreamDecoder);
                    bl4 = true;
                    jBIG2Bitmap.readGenericRefinementRegion(n9, false, jBIG2BitmapArray[(int)l], n21, n20, sArray, sArray2);
                } else {
                    jBIG2Bitmap = jBIG2BitmapArray[(int)l];
                }
                n17 = jBIG2Bitmap.width - 1;
                n16 = jBIG2Bitmap.height - 1;
                if (bl3) {
                    switch (n7) {
                        case 0: {
                            this.combine(jBIG2Bitmap, n18, n15, n6);
                            break;
                        }
                        case 1: {
                            this.combine(jBIG2Bitmap, n18, n15, n6);
                            break;
                        }
                        case 2: {
                            this.combine(jBIG2Bitmap, n18 - n17, n15, n6);
                            break;
                        }
                        case 3: {
                            this.combine(jBIG2Bitmap, n18 - n17, n15, n6);
                        }
                    }
                    n15 += n16;
                } else {
                    switch (n7) {
                        case 0: {
                            this.combine(jBIG2Bitmap, n15, n18 - n16, n6);
                            break;
                        }
                        case 1: {
                            this.combine(jBIG2Bitmap, n15, n18, n6);
                            break;
                        }
                        case 2: {
                            this.combine(jBIG2Bitmap, n15, n18 - n16, n6);
                            break;
                        }
                        case 3: {
                            this.combine(jBIG2Bitmap, n15, n18, n6);
                        }
                    }
                    n15 += n17;
                }
                if (!bl4 || jBIG2Bitmap == null) continue block12;
                jBIG2Bitmap.jBIG2DataWriter.clearResources();
                DecodeIntResult decodeIntResult = bl ? this.huffmanDecoder.decodeInt(nArray3) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadsStats);
                if (!decodeIntResult.booleanResult()) continue block12;
                n14 = decodeIntResult.intResult();
                n15 += n8 + n14;
            }
        }
    }

    public void clear(int n) {
        int n2 = n == 0 ? 0 : -1;
        int n3 = 1024;
        int n4 = this.jBIG2DataWriter.getDataLength();
        int n5 = n4 / n3;
        int n6 = n4 % n3;
        int n7 = 0;
        for (int i = 0; i <= n5; ++i) {
            int n8 = i == n5 ? n6 : n3;
            byte[] byArray = new byte[n8];
            if (n2 != 0) {
                for (int j = 0; j < byArray.length; ++j) {
                    byArray[j] = n2;
                }
            }
            this.jBIG2DataWriter.putBytes(byArray, n7, n8);
            n7 += n3;
        }
    }

    public void combine(JBIG2Bitmap jBIG2Bitmap, int n, int n2, long l) {
        int n3 = jBIG2Bitmap.width;
        int n4 = jBIG2Bitmap.height;
        int n5 = jBIG2Bitmap.line;
        int n6 = 0;
        int n7 = 0;
        int n8 = (int)l;
        JBIG2DataWriter jBIG2DataWriter = jBIG2Bitmap.jBIG2DataWriter;
        if (n % 8 == 0) {
            int n9;
            int n10;
            int n11;
            int n12 = (n + n3) / 8 * 8;
            for (n11 = n2; n11 < n2 + n4; ++n11) {
                n10 = n6 * n5;
                for (n9 = n / 8; n9 < n12 / 8; ++n9) {
                    int n13 = n11 * this.line + n9;
                    if (n13 < this.jBIG2DataWriter.getDataLength() && n13 >= 0) {
                        switch (n8) {
                            case 0: {
                                this.jBIG2DataWriter.setItemAt(n13, (byte)(this.jBIG2DataWriter.getItemAt(n13) | jBIG2DataWriter.getItemAt(n10 + n7)));
                                break;
                            }
                            case 1: {
                                this.jBIG2DataWriter.setItemAt(n13, (byte)(this.jBIG2DataWriter.getItemAt(n13) & jBIG2DataWriter.getItemAt(n10 + n7)));
                                break;
                            }
                            case 2: {
                                this.jBIG2DataWriter.setItemAt(n13, (byte)(this.jBIG2DataWriter.getItemAt(n13) ^ jBIG2DataWriter.getItemAt(n10 + n7)));
                                break;
                            }
                            case 3: {
                                this.jBIG2DataWriter.setItemAt(n13, (byte)(this.jBIG2DataWriter.getItemAt(n13) ^ jBIG2DataWriter.getItemAt(n10 + n7)));
                                this.jBIG2DataWriter.setItemAt(n13, (byte)(this.jBIG2DataWriter.getItemAt(n13) ^ 0xFF));
                                break;
                            }
                            case 4: {
                                this.jBIG2DataWriter.setItemAt(n13, jBIG2DataWriter.getItemAt(n10 + n7));
                            }
                        }
                    }
                    ++n7;
                }
                n7 = 0;
                ++n6;
            }
            n6 = 0;
            n7 = n12 - n;
            for (n11 = n2; n11 < n2 + n4; ++n11) {
                for (n10 = n12; n10 < n + n3; ++n10) {
                    n9 = JBIG2Bitmap.getPixel(n7, n6, n5, jBIG2DataWriter);
                    switch (n8) {
                        case 0: {
                            this.setPixel(n10, n11, JBIG2Bitmap.getPixel(n10, n11, this.line, this.jBIG2DataWriter) | n9);
                            break;
                        }
                        case 1: {
                            this.setPixel(n10, n11, JBIG2Bitmap.getPixel(n10, n11, this.line, this.jBIG2DataWriter) & n9);
                            break;
                        }
                        case 2: {
                            this.setPixel(n10, n11, JBIG2Bitmap.getPixel(n10, n11, this.line, this.jBIG2DataWriter) ^ n9);
                            break;
                        }
                        case 3: {
                            if (JBIG2Bitmap.getPixel(n10, n11, this.line, this.jBIG2DataWriter) == 1 && n9 == 1 || JBIG2Bitmap.getPixel(n10, n11, this.line, this.jBIG2DataWriter) == 0 && n9 == 0) {
                                this.setPixel(n10, n11, 1);
                                break;
                            }
                            this.setPixel(n10, n11, 0);
                            break;
                        }
                        case 4: {
                            this.setPixel(n10, n11, n9);
                        }
                    }
                    ++n7;
                }
                n7 = n12 - n;
                ++n6;
            }
        } else {
            for (int i = n2; i < n2 + n4; ++i) {
                for (int j = n; j < n + n3; ++j) {
                    int n14 = JBIG2Bitmap.getPixel(n7, n6, n5, jBIG2DataWriter);
                    switch (n8) {
                        case 0: {
                            this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter) | n14);
                            break;
                        }
                        case 1: {
                            this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter) & n14);
                            break;
                        }
                        case 2: {
                            this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter) ^ n14);
                            break;
                        }
                        case 3: {
                            if (JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter) == 1 && n14 == 1 || JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter) == 0 && n14 == 0) {
                                this.setPixel(j, i, 1);
                                break;
                            }
                            this.setPixel(j, i, 0);
                            break;
                        }
                        case 4: {
                            this.setPixel(j, i, n14);
                        }
                    }
                    ++n7;
                }
                n7 = 0;
                ++n6;
            }
        }
    }

    private void duplicateRow(int n, int n2) {
        for (int i = 0; i < this.width; ++i) {
            this.setPixel(i, n, JBIG2Bitmap.getPixel(i, n2, this.line, this.jBIG2DataWriter));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLine() {
        return this.line;
    }

    public byte[] getData() {
        return this.jBIG2DataWriter.getData();
    }

    public JBIG2DataWriter getDataWriter() {
        return this.jBIG2DataWriter;
    }

    public byte[] getWriteSafeData(boolean bl) {
        byte[] byArray = new byte[this.jBIG2DataWriter.getDataLength()];
        System.arraycopy(this.jBIG2DataWriter.getData(), 0, byArray, 0, this.jBIG2DataWriter.getDataLength());
        if (bl) {
            int n = 0;
            while (n < byArray.length) {
                int n2 = n++;
                byArray[n2] = (byte)(byArray[n2] ^ 0xFF);
            }
        }
        return byArray;
    }

    public void putWriteSafeDataIntoStream(boolean bl, OutputStream outputStream) throws IOException {
        int n = 1024;
        int n2 = this.jBIG2DataWriter.getDataLength();
        int n3 = n2 / n;
        int n4 = n2 % n;
        int n5 = 0;
        for (int i = 0; i <= n3; ++i) {
            int n6 = i == n3 ? n4 : n;
            byte[] byArray = this.jBIG2DataWriter.readBytes(n5, n6);
            if (bl) {
                int n7 = 0;
                while (n7 < byArray.length) {
                    int n8 = n7++;
                    byArray[n8] = (byte)(byArray[n8] ^ 0xFF);
                }
            }
            outputStream.write(byArray);
            n5 += n;
        }
    }

    public JBIG2Bitmap getSlice(int n, int n2, int n3, int n4) {
        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(n3, n4, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                jBIG2Bitmap.setPixel(n6, n5, JBIG2Bitmap.getPixel(j, i, this.line, this.jBIG2DataWriter));
                ++n6;
            }
            n6 = 0;
            ++n5;
        }
        return jBIG2Bitmap;
    }

    public void setPixel(int n, int n2, int n3) {
        int n4 = n2 * this.line + n / 8;
        if (n4 >= this.jBIG2DataWriter.getDataLength() || n4 < 0) {
            return;
        }
        int n5 = this.jBIG2DataWriter.getItemAt(n4);
        n5 = n3 == 0 ? (n5 &= ~(1 << 7 - n % 8)) : (n5 |= 1 << 7 - n % 8);
        this.jBIG2DataWriter.setItemAt(n4, (byte)n5);
    }

    private static int getPixel(int n, int n2, int n3, JBIG2DataWriter jBIG2DataWriter) {
        int n4 = n2 * n3 + (n >> 3);
        if (n4 < jBIG2DataWriter.getDataLength() && n4 >= 0) {
            return (jBIG2DataWriter.getItemAt(n4) & 1 << 7 - (n & 7)) != 0 ? 1 : 0;
        }
        return 0;
    }

    public int getPixel(int n, int n2) {
        return (this.jBIG2DataWriter.getItemAt(n2 * this.line + (n >> 3)) & 1 << 7 - (n & 7)) != 0 ? 1 : 0;
    }

    public void expand(int n) {
        byte[] byArray = new byte[n * this.line];
        if (this.jBIG2DataWriter.getData() != null) {
            this.jBIG2DataWriter.bulkCopy(this.jBIG2DataWriter.getData(), 0, byArray, 0, this.height * this.line);
            this.height = n;
            this.jBIG2DataWriter.setData(byArray);
        } else {
            JBIG2DataWriter jBIG2DataWriter = new JBIG2DataWriter(this.decoder, n * this.line);
            for (int i = 0; i < this.jBIG2DataWriter.getDataLength(); ++i) {
                jBIG2DataWriter.setItemAt(i, this.jBIG2DataWriter.getItemAt(i));
            }
            this.jBIG2DataWriter.setID(jBIG2DataWriter.getID());
        }
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public BufferedImage getBufferedImage() {
        byte[] byArray = this.getWriteSafeData(true);
        if (byArray == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, 1, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

