/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.io;

import org.jpedal.jbig2.JBIG2Data;

public class StreamReader {
    private final JBIG2Data jBIG2Data;
    private int bitPointer = 7;
    private int bytePointer;

    public StreamReader(JBIG2Data jBIG2Data) {
        this.jBIG2Data = jBIG2Data;
    }

    public short readByte() {
        short s = 0;
        if (this.jBIG2Data.getDataLength() > this.bytePointer) {
            s = (short)(this.jBIG2Data.getItemAt(this.bytePointer++) & 0xFF);
        }
        return s;
    }

    public void readByte(short[] sArray) {
        if (this.bytePointer + sArray.length >= this.jBIG2Data.getDataLength()) {
            this.bytePointer = this.jBIG2Data.getDataLength();
            return;
        }
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)(this.jBIG2Data.getItemAt(this.bytePointer++) & 0xFF);
        }
    }

    public int readBit() {
        short s = this.readByte();
        short s2 = (short)(1 << this.bitPointer);
        int n = (s & s2) >> this.bitPointer;
        --this.bitPointer;
        if (this.bitPointer == -1) {
            this.bitPointer = 7;
        } else {
            this.movePointer(-1);
        }
        return n;
    }

    public int readBits(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = n2 << 1 | this.readBit();
        }
        return n2;
    }

    public void movePointer(int n) {
        this.bytePointer += n;
    }

    public void consumeRemainingBits() {
        if (this.bitPointer != 7) {
            this.readBits(this.bitPointer + 1);
        }
    }

    public boolean bytesRemaining() {
        return this.bytePointer != this.jBIG2Data.getDataLength();
    }
}

