/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.generic;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.generic.GenericRegionFlags;

public class GenericRegionSegment
extends RegionSegment {
    private final GenericRegionFlags genericRegionFlags = new GenericRegionFlags();
    private final boolean inlineImage;
    private boolean unknownLength;

    public GenericRegionSegment(JBIG2StreamDecoder jBIG2StreamDecoder, boolean bl) {
        super(jBIG2StreamDecoder);
        this.inlineImage = bl;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        int n;
        super.readSegment();
        this.readGenericRegionFlags();
        boolean bl = this.genericRegionFlags.getFlagValue("MMR") != 0;
        int n2 = this.genericRegionFlags.getFlagValue("GB_TEMPLATE");
        short[] sArray = new short[4];
        short[] sArray2 = new short[4];
        if (!bl) {
            if (n2 == 0) {
                sArray[0] = this.readATValue();
                sArray2[0] = this.readATValue();
                sArray[1] = this.readATValue();
                sArray2[1] = this.readATValue();
                sArray[2] = this.readATValue();
                sArray2[2] = this.readATValue();
                sArray[3] = this.readATValue();
                sArray2[3] = this.readATValue();
            } else {
                sArray[0] = this.readATValue();
                sArray2[0] = this.readATValue();
            }
            this.arithmeticDecoder.resetGenericStats(n2, null);
            this.arithmeticDecoder.start();
        }
        boolean bl2 = this.genericRegionFlags.getFlagValue("TPGDON") != 0;
        int n3 = this.segmentHeader.getSegmentDataLength();
        if (n3 == -1) {
            short s;
            int n4;
            this.unknownLength = true;
            if (bl) {
                n4 = 0;
                s = 0;
            } else {
                n4 = 255;
                s = 172;
            }
            int n5 = 0;
            while (true) {
                n = this.decoder.readByte();
                ++n5;
                if (n != n4) continue;
                short s2 = this.decoder.readByte();
                ++n5;
                if (s2 == s) break;
            }
            this.decoder.movePointer(-n5);
        }
        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        jBIG2Bitmap.clear(0);
        if (bl) {
            jBIG2Bitmap.readBitmapWithMMR(0);
        } else {
            jBIG2Bitmap.readBitmap(n2, bl2, false, null, sArray, sArray2);
        }
        if (this.inlineImage) {
            PageInformationSegment pageInformationSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap jBIG2Bitmap2 = pageInformationSegment.getPageBitmap();
            n = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
            if (pageInformationSegment.getPageBitmapHeight() == -1 && this.regionBitmapYLocation + this.regionBitmapHeight > jBIG2Bitmap2.getHeight()) {
                jBIG2Bitmap2.expand(this.regionBitmapYLocation + this.regionBitmapHeight);
            }
            jBIG2Bitmap2.combine(jBIG2Bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, n);
            jBIG2Bitmap.getDataWriter().clearResources();
        } else {
            jBIG2Bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(jBIG2Bitmap);
        }
        if (this.unknownLength) {
            this.decoder.movePointer(4);
        }
    }

    private void readGenericRegionFlags() {
        short s = this.decoder.readByte();
        this.genericRegionFlags.setFlags(s);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

