/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.symboldictionary;

import java.io.IOException;
import java.util.ArrayList;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoderStats;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.symboldictionary.SymbolDictionaryFlags;
import org.jpedal.jbig2.segment.tables.CodeTableSegment;
import org.jpedal.jbig2.util.BinaryOperation;

public class SymbolDictionarySegment
extends Segment {
    private int noOfExportedSymbols;
    private int noOfNewSymbols;
    private final short[] symbolDictionaryAdaptiveTemplateX = new short[4];
    private final short[] symbolDictionaryAdaptiveTemplateY = new short[4];
    private final short[] symbolDictionaryRAdaptiveTemplateX = new short[2];
    private final short[] symbolDictionaryRAdaptiveTemplateY = new short[2];
    private JBIG2Bitmap[] bitmaps;
    private final SymbolDictionaryFlags symbolDictionaryFlags = new SymbolDictionaryFlags();
    private ArithmeticDecoderStats genericRegionStats;
    private ArithmeticDecoderStats refinementRegionStats;

    public SymbolDictionarySegment(JBIG2StreamDecoder jBIG2StreamDecoder) {
        super(jBIG2StreamDecoder);
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        this.readSymbolDictionaryFlags();
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n7 = 0;
        int n8 = this.segmentHeader.getReferredToSegmentCount();
        int[] nArray = this.segmentHeader.getReferredToSegments();
        for (n6 = 0; n6 < n8; ++n6) {
            Segment segment = this.decoder.findSegment(nArray[n6]);
            int n9 = segment.getSegmentHeader().getSegmentType();
            if (n9 == 0) {
                n7 += ((SymbolDictionarySegment)segment).noOfExportedSymbols;
                continue;
            }
            if (n9 != 53) continue;
            arrayList.add(segment);
        }
        n6 = 0;
        for (n5 = 1; n5 < n7 + this.noOfNewSymbols; n5 <<= 1) {
            ++n6;
        }
        JBIG2Bitmap[] jBIG2BitmapArray = new JBIG2Bitmap[n7 + this.noOfNewSymbols];
        int n10 = 0;
        SymbolDictionarySegment symbolDictionarySegment = null;
        for (n5 = 0; n5 < n8; ++n5) {
            object = this.decoder.findSegment(nArray[n5]);
            if (((Segment)object).getSegmentHeader().getSegmentType() != 0) continue;
            symbolDictionarySegment = (SymbolDictionarySegment)object;
            for (int i = 0; i < symbolDictionarySegment.noOfExportedSymbols; ++i) {
                jBIG2BitmapArray[n10++] = symbolDictionarySegment.bitmaps[i];
            }
        }
        object = null;
        int[][] nArray2 = null;
        int[][] nArray3 = null;
        int[][] nArray4 = null;
        boolean bl = this.symbolDictionaryFlags.getFlagValue("SD_HUFF") != 0;
        int n11 = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_DH");
        int n12 = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_DW");
        int n13 = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_BM_SIZE");
        int n14 = this.symbolDictionaryFlags.getFlagValue("SD_HUFF_AGG_INST");
        n5 = 0;
        if (bl) {
            object = n11 == 0 ? (Object)HuffmanDecoder.huffmanTableD : (n11 == 1 ? HuffmanDecoder.huffmanTableE : ((CodeTableSegment)arrayList.get(n5++)).getHuffTable());
            nArray2 = n12 == 0 ? HuffmanDecoder.huffmanTableB : (n12 == 1 ? HuffmanDecoder.huffmanTableC : ((CodeTableSegment)arrayList.get(n5++)).getHuffTable());
            nArray3 = n13 == 0 ? HuffmanDecoder.huffmanTableA : ((CodeTableSegment)arrayList.get(n5++)).getHuffTable();
            nArray4 = n14 == 0 ? HuffmanDecoder.huffmanTableA : ((CodeTableSegment)arrayList.get(n5)).getHuffTable();
        }
        int n15 = this.symbolDictionaryFlags.getFlagValue("BITMAP_CC_USED");
        int n16 = this.symbolDictionaryFlags.getFlagValue("SD_TEMPLATE");
        if (!bl) {
            if (n15 != 0 && symbolDictionarySegment != null) {
                this.arithmeticDecoder.resetGenericStats(n16, symbolDictionarySegment.genericRegionStats);
            } else {
                this.arithmeticDecoder.resetGenericStats(n16, null);
            }
            this.arithmeticDecoder.resetIntStats(n6);
            this.arithmeticDecoder.start();
        }
        int n17 = this.symbolDictionaryFlags.getFlagValue("SD_REF_AGG");
        int n18 = this.symbolDictionaryFlags.getFlagValue("SD_R_TEMPLATE");
        if (n17 != 0) {
            if (n15 != 0 && symbolDictionarySegment != null) {
                this.arithmeticDecoder.resetRefinementStats(n18, symbolDictionarySegment.refinementRegionStats);
            } else {
                this.arithmeticDecoder.resetRefinementStats(n18, null);
            }
        }
        int[] nArray5 = new int[this.noOfNewSymbols];
        int n19 = 0;
        n5 = 0;
        while (n5 < this.noOfNewSymbols) {
            Object object2;
            int n20;
            int n21;
            Object object3;
            n4 = bl ? this.huffmanDecoder.decodeInt((int[][])object).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadhStats).intResult();
            if (n4 >= 0 || -n4 >= n19) {
                // empty if block
            }
            n19 += n4;
            n3 = 0;
            n2 = 0;
            n = n5;
            while (((DecodeIntResult)(object3 = bl ? this.huffmanDecoder.decodeInt(nArray2) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadwStats))).booleanResult()) {
                n21 = ((DecodeIntResult)object3).intResult();
                if (n21 >= 0 || -n21 >= n3) {
                    // empty if block
                }
                n3 += n21;
                if (bl && n17 == 0) {
                    nArray5[n5] = n3;
                    n2 += n3;
                } else if (n17 == 1) {
                    int n22 = bl ? this.huffmanDecoder.decodeInt(nArray4).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaaiStats).intResult();
                    if (n22 == 1) {
                        int n23;
                        int n24;
                        if (bl) {
                            n24 = this.decoder.readBits(n6);
                            n20 = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            n23 = this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableO).intResult();
                            this.decoder.consumeRemainingBits();
                            this.arithmeticDecoder.start();
                        } else {
                            n24 = (int)this.arithmeticDecoder.decodeIAID(n6, this.arithmeticDecoder.iaidStats);
                            n20 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                            n23 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                        }
                        object2 = jBIG2BitmapArray[n24];
                        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(n3, n19, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                        jBIG2Bitmap.readGenericRefinementRegion(n18, false, (JBIG2Bitmap)object2, n20, n23, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY);
                        jBIG2BitmapArray[n7 + n5] = jBIG2Bitmap;
                    } else {
                        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(n3, n19, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                        jBIG2Bitmap.readTextRegion(bl, true, n22, 0, n7 + n5, null, n6, jBIG2BitmapArray, 0, 0, false, 1, 0, HuffmanDecoder.huffmanTableF, HuffmanDecoder.huffmanTableH, HuffmanDecoder.huffmanTableK, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, HuffmanDecoder.huffmanTableO, n18, this.symbolDictionaryRAdaptiveTemplateX, this.symbolDictionaryRAdaptiveTemplateY, this.decoder);
                        jBIG2BitmapArray[n7 + n5] = jBIG2Bitmap;
                    }
                } else {
                    JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(n3, n19, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
                    jBIG2Bitmap.readBitmap(n16, false, false, null, this.symbolDictionaryAdaptiveTemplateX, this.symbolDictionaryAdaptiveTemplateY);
                    jBIG2BitmapArray[n7 + n5] = jBIG2Bitmap;
                }
                ++n5;
            }
            if (!bl || n17 != 0) continue;
            n21 = this.huffmanDecoder.decodeInt(nArray3).intResult();
            this.decoder.consumeRemainingBits();
            object3 = new JBIG2Bitmap(n2, n19, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            if (n21 == 0) {
                int n25;
                int n26;
                int n27 = n2 % 8;
                int n28 = (int)Math.ceil((double)n2 / 8.0);
                n20 = n19 * (n2 + 7 >> 3);
                short[] sArray = new short[n20];
                this.decoder.readByte(sArray);
                object2 = new short[n19][n28];
                int n29 = 0;
                for (n26 = 0; n26 < n19; ++n26) {
                    for (n25 = 0; n25 < n28; ++n25) {
                        object2[n26][n25] = sArray[n29];
                        ++n29;
                    }
                }
                n26 = 0;
                n25 = 0;
                for (int i = 0; i < n19; ++i) {
                    for (int j = 0; j < n28; ++j) {
                        int n30;
                        short s;
                        int n31;
                        Object object4;
                        if (j == n28 - 1) {
                            object4 = object2[i][j];
                            for (n31 = 7; n31 >= n27; --n31) {
                                s = (short)(1 << n31);
                                n30 = (object4 & s) >> n31;
                                ((JBIG2Bitmap)object3).setPixel(n25, n26, n30);
                                ++n25;
                            }
                            ++n26;
                            n25 = 0;
                            continue;
                        }
                        object4 = object2[i][j];
                        for (n31 = 7; n31 >= 0; --n31) {
                            s = (short)(1 << n31);
                            n30 = (object4 & s) >> n31;
                            ((JBIG2Bitmap)object3).setPixel(n25, n26, n30);
                            ++n25;
                        }
                    }
                }
            } else {
                ((JBIG2Bitmap)object3).readBitmapWithMMR(n21);
            }
            int n32 = 0;
            while (n < n5) {
                jBIG2BitmapArray[n7 + n] = ((JBIG2Bitmap)object3).getSlice(n32, 0, nArray5[n], n19);
                n32 += nArray5[n];
                ++n;
            }
            ((JBIG2Bitmap)object3).getDataWriter().clearResources();
        }
        this.bitmaps = new JBIG2Bitmap[this.noOfExportedSymbols];
        n5 = 0;
        n4 = 0;
        n3 = 0;
        while (n5 < n7 + this.noOfNewSymbols) {
            n2 = bl ? this.huffmanDecoder.decodeInt(HuffmanDecoder.huffmanTableA).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaexStats).intResult();
            if (n3 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.bitmaps[n4++] = jBIG2BitmapArray[n5++];
                }
            } else {
                n5 += n2;
            }
            n3 = n3 == 0 ? 1 : 0;
        }
        n2 = this.symbolDictionaryFlags.getFlagValue("BITMAP_CC_RETAINED");
        if (!bl && n2 == 1) {
            this.genericRegionStats = this.genericRegionStats.copy();
            if (n17 == 1) {
                this.refinementRegionStats = this.refinementRegionStats.copy();
            }
        }
        this.decoder.consumeRemainingBits();
    }

    private void readSymbolDictionaryFlags() {
        int n;
        int n2;
        short[] sArray = new short[2];
        this.decoder.readByte(sArray);
        int n3 = BinaryOperation.getInt16(sArray);
        this.symbolDictionaryFlags.setFlags(n3);
        int n4 = this.symbolDictionaryFlags.getFlagValue("SD_HUFF");
        int n5 = this.symbolDictionaryFlags.getFlagValue("SD_TEMPLATE");
        if (n4 == 0) {
            if (n5 == 0) {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[1] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[2] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateX[3] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[3] = this.readATValue();
            } else {
                this.symbolDictionaryAdaptiveTemplateX[0] = this.readATValue();
                this.symbolDictionaryAdaptiveTemplateY[0] = this.readATValue();
            }
        }
        int n6 = this.symbolDictionaryFlags.getFlagValue("SD_REF_AGG");
        int n7 = this.symbolDictionaryFlags.getFlagValue("SD_R_TEMPLATE");
        if (n6 != 0 && n7 == 0) {
            this.symbolDictionaryRAdaptiveTemplateX[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[0] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateX[1] = this.readATValue();
            this.symbolDictionaryRAdaptiveTemplateY[1] = this.readATValue();
        }
        short[] sArray2 = new short[4];
        this.decoder.readByte(sArray2);
        this.noOfExportedSymbols = n2 = BinaryOperation.getInt32(sArray2);
        short[] sArray3 = new short[4];
        this.decoder.readByte(sArray3);
        this.noOfNewSymbols = n = BinaryOperation.getInt32(sArray3);
    }

    public int getNoOfExportedSymbols() {
        return this.noOfExportedSymbols;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }
}

