/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javafx.collections.ObservableList;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import org.jpedal.objects.PdfShape;

public class JavaFXShape
implements Serializable,
PdfShape {
    int complexClipCount;
    private boolean isClip;
    private Path path = new Path();
    ObservableList<PathElement> elements = this.path.getElements();
    private FillRule windingRule;
    private final float[] currentPos = new float[2];
    private boolean isClosed;

    @Override
    public final void closeShape() {
        this.elements.add((Object)new ClosePath());
    }

    @Override
    public final void addBezierCurveC(float f, float f2, float f3, float f4, float f5, float f6) {
        this.elements.add((Object)new CubicCurveTo((double)f, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6));
        this.currentPos[0] = f5;
        this.currentPos[1] = f6;
    }

    @Override
    public final void setNONZEROWindingRule() {
        this.setWindingRule(FillRule.NON_ZERO);
    }

    @Override
    public final void lineTo(float f, float f2) {
        this.elements.add((Object)new LineTo((double)f, (double)f2));
        this.currentPos[0] = f;
        this.currentPos[1] = f2;
    }

    @Override
    public final void addBezierCurveV(float f, float f2, float f3, float f4) {
        this.elements.add((Object)new CubicCurveTo((double)this.currentPos[0], (double)this.currentPos[1], (double)f, (double)f2, (double)f3, (double)f4));
        this.currentPos[0] = f3;
        this.currentPos[1] = f4;
    }

    @Override
    public final Shape generateShapeFromPath(float[][] fArray, float f, int n, int n2) {
        return new GeneralPath();
    }

    @Override
    public final void appendRectangle(float f, float f2, float f3, float f4) {
        this.moveTo(f, f2);
        this.lineTo(f + f3, f2);
        this.lineTo(f + f3, f2 + f4);
        this.lineTo(f, f2 + f4);
        this.lineTo(f, f2);
        this.closeShape();
    }

    @Override
    public final void moveTo(float f, float f2) {
        this.elements.add((Object)new MoveTo((double)f, (double)f2));
        this.currentPos[0] = f;
        this.currentPos[1] = f2;
    }

    @Override
    public final void addBezierCurveY(float f, float f2, float f3, float f4) {
        this.elements.add((Object)new QuadCurveTo((double)f, (double)f2, (double)f3, (double)f4));
        this.currentPos[0] = f3;
        this.currentPos[1] = f4;
    }

    @Override
    public final void resetPath() {
        this.path = new Path();
        this.elements = this.path.getElements();
        this.windingRule = FillRule.NON_ZERO;
    }

    @Override
    public final void setEVENODDWindingRule() {
        this.setWindingRule(FillRule.EVEN_ODD);
    }

    public final void setWindingRule(FillRule fillRule) {
        this.windingRule = fillRule;
        this.path.setFillRule(this.windingRule);
    }

    @Override
    public int getSegmentCount() {
        if (this.path == null) {
            return 0;
        }
        return this.elements.size();
    }

    @Override
    public void setClip(boolean bl) {
        this.isClip = bl;
    }

    @Override
    public boolean isClip() {
        return this.isClip;
    }

    @Override
    public int getComplexClipCount() {
        return this.complexClipCount;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean adjustLineWidth() {
        throw new RuntimeException("JavaFX should not call JavaFXShape.adjustLineWidth()");
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

