/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpedal.external.CustomFormPrint;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;

public class GUIData {
    protected boolean rasterizeForms;
    protected boolean forceRedraw;
    protected int userX;
    protected int userY;
    protected int widestPageNR;
    protected int widestPageR;
    protected int displayView;
    public float dpi = 72.0f;
    protected final Map rawFormData = new HashMap();
    protected Map componentsToIgnore = new HashMap();
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected int indent;
    protected int[] cropOtherY;
    protected float displayScaling;
    protected int rotation;
    protected float lastScaling = -1.0f;
    protected float oldRotation;
    protected float oldIndent;
    protected int startPage;
    protected int currentPage;
    protected int endPage;
    protected int[] xReached;
    protected int[] yReached;
    protected List<FormObject>[] formsUnordered;
    protected List<FormObject>[] formsOrdered;
    private int formCount;
    protected PdfLayerList layers;
    protected FormFactory formFactory;

    public void setLayerData(PdfLayerList pdfLayerList) {
        this.layers = pdfLayerList;
    }

    public void setRasterizeForms(boolean bl) {
        this.rasterizeForms = bl;
    }

    protected void setListForPage(int n, List<FormObject> list, boolean bl) {
        if (bl) {
            this.formsOrdered[n] = list;
        } else {
            this.formsUnordered[n] = list;
        }
    }

    protected Object checkGUIObjectResolved(FormObject formObject) {
        Object object = null;
        if (formObject != null) {
            object = formObject.getGUIComponent();
        }
        if (formObject != null && object == null && (object = this.resolveGUIComponent(formObject)) != null) {
            this.setGUIComp(formObject, object);
        }
        return object;
    }

    protected Object resolveGUIComponent(FormObject formObject) {
        Object object = null;
        int n = formObject.getParameterConstant(1147962727);
        boolean[] blArray = formObject.getFieldFlags();
        if (n == 1197118) {
            boolean bl = false;
            boolean bl2 = false;
            if (blArray != null) {
                bl = blArray[17];
                bl2 = blArray[16];
            }
            object = bl ? this.formFactory.pushBut(formObject) : (bl2 ? this.formFactory.radioBut(formObject) : this.formFactory.checkBoxBut(formObject));
        } else if (n == 9288) {
            boolean bl = false;
            boolean bl3 = false;
            if (blArray != null) {
                bl = blArray[13] || formObject.getTextString() != null && formObject.getTextString().indexOf(10) != -1;
                bl3 = blArray[14];
            }
            object = bl ? (bl3 ? this.formFactory.multiLinePassword(formObject) : this.formFactory.multiLineText(formObject)) : (bl3 ? this.formFactory.singleLinePassword(formObject) : this.formFactory.singleLineText(formObject));
        } else if (n == 4920) {
            boolean bl = false;
            if (blArray != null) {
                bl = blArray[18];
            }
            object = bl ? this.formFactory.comboBox(formObject) : this.formFactory.listField(formObject);
        } else {
            object = n == 2308407 ? this.formFactory.signature(formObject) : this.formFactory.annotationButton(formObject);
        }
        if (object != null) {
            formObject.setGUIComponent(object, this.formFactory.getType());
            this.setGUIComp(formObject, object);
        }
        return object;
    }

    public void dispose() {
    }

    protected void displayComponent(FormObject formObject, Object object) {
        throw new RuntimeException("base method displayComponent( ) should not be called");
    }

    protected void displayComponents(int n, int n2) {
        if (this.rasterizeForms || this.formsOrdered == null) {
            return;
        }
        this.startPage = n;
        this.endPage = n2;
        if (n > 1) {
            this.removeHiddenForms(1, n);
        }
        for (int i = n; i < n2; ++i) {
            if (this.formsOrdered[i] == null) continue;
            for (FormObject formObject : this.formsOrdered[i]) {
                FormObject formObject2;
                Object object;
                if (formObject == null || (object = this.checkGUIObjectResolved(formObject2 = formObject)) == null) continue;
                this.displayComponent(formObject2, object);
            }
        }
        this.removeHiddenForms(n2, this.pageData.getPageCount() + 1);
    }

    void removeHiddenForms(int n, int n2) {
    }

    public boolean hasformsOnPageDecoded(int n) {
        return this.formsOrdered != null && this.formsOrdered.length > n && this.formsOrdered[n] != null;
    }

    protected void initParametersForPage(PdfPageData pdfPageData, int n, FormFactory formFactory, float f) {
        int n2;
        int n3;
        if (this.cropOtherY == null || this.cropOtherY.length <= n) {
            this.resetComponents(0, pdfPageData.getPageCount(), false);
        }
        this.cropOtherY[n] = (n3 = pdfPageData.getMediaBoxHeight(n)) != (n2 = pdfPageData.getCropBoxHeight(n) + pdfPageData.getCropBoxY(n)) ? n3 - n2 : 0;
        this.currentPage = n;
        this.formFactory = formFactory;
        this.dpi = f;
    }

    public void resetComponents(int n, int n2, boolean bl) {
        if (bl && this.formCount > n) {
            return;
        }
        this.formCount = n;
        if (!bl) {
            if (this.formsUnordered == null) {
                this.formsUnordered = new List[n2 + 1];
                this.formsOrdered = new List[n2 + 1];
            }
            this.cropOtherY = new int[n2 + 1];
            this.yReached = null;
            this.xReached = null;
        }
    }

    public void setPageValues(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.rotation = n;
        this.displayScaling = f;
        this.indent = n2;
        this.userX = n3;
        this.userY = n4;
        this.displayView = n5;
        this.widestPageNR = n6;
        this.widestPageR = n7;
    }

    protected void setPageData(PdfPageData pdfPageData, int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
        this.pageData = pdfPageData;
    }

    public void setPageDisplacements(int[] nArray, int[] nArray2) {
        this.xReached = nArray;
        this.yReached = nArray2;
        this.forceRedraw = true;
    }

    public void setForceRedraw(boolean bl) {
        this.forceRedraw = bl;
    }

    protected void storeRawData(FormObject formObject) {
        String string = formObject.getObjectRefAsString();
        this.rawFormData.put(string, formObject);
    }

    protected void flushFormData() {
        this.rawFormData.clear();
        this.formsOrdered = null;
        this.formsUnordered = null;
        this.oldIndent = -this.oldIndent;
    }

    protected Map getRawFormData() {
        return Collections.unmodifiableMap(this.rawFormData);
    }

    protected void setGUIComp(FormObject formObject, Object object) {
        throw new RuntimeException("Should never be called");
    }

    public List getFormComponents(String string, ReturnValues returnValues, int n) {
        Iterator iterator = this.rawFormData.keySet().iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block6: while (iterator.hasNext()) {
            FormObject formObject = (FormObject)this.rawFormData.get(iterator.next());
            boolean bl = n == -1 || formObject.getPageNumber() == n;
            String string2 = formObject.getTextStreamValue(36);
            switch (returnValues) {
                case GUI_FORMS_FROM_NAME: {
                    if (!bl || string != null && (string2 == null || !string2.equals(string))) continue block6;
                    arrayList.add(this.checkGUIObjectResolved(formObject));
                    continue block6;
                }
                case FORMOBJECTS_FROM_NAME: {
                    if (!bl || string != null && (string2 == null || !string2.equals(string))) continue block6;
                    arrayList.add(formObject);
                    continue block6;
                }
                case FORMOBJECTS_FROM_REF: {
                    if (!bl || string != null && !formObject.getObjectRefAsString().equals(string)) continue block6;
                    arrayList.add(formObject);
                    continue block6;
                }
                case FORM_NAMES: {
                    if (!bl || string2 == null || string2.isEmpty() || arrayList.contains(string2)) continue block6;
                    arrayList.add(string2);
                    continue block6;
                }
            }
            throw new RuntimeException("value " + (Object)((Object)returnValues) + " not implemented");
        }
        return arrayList;
    }

    public void resetAfterPrinting() {
        this.forceRedraw = true;
    }

    public static int calculateFontSize(int n, int n2, boolean bl, String string) {
        int n3;
        double d;
        double d2;
        double d3;
        double d4 = (float)n * 0.8f;
        if (string == null || string.isEmpty()) {
            return (int)d4;
        }
        char[] cArray = string.toCharArray();
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        char c = '\u0000';
        for (char c2 : cArray) {
            switch (c2) {
                case '\n': 
                case '\r': {
                    if (c2 == '\r' && c == '\n' || c2 != '\n' || c == '\r') {
                        // empty if block
                    }
                    ++n6;
                    if (n4 < n5) {
                        n4 = n5;
                    }
                    n5 = 0;
                    break;
                }
                default: {
                    ++n5;
                }
            }
            c = c2;
        }
        if (n4 < n5) {
            n4 = n5;
        }
        if ((d3 = d4 / (double)n6) > (d2 = (d = (double)((float)n2 * 0.8f)) / (double)n4) * 2.0) {
            n3 = (int)d2 * 2;
        } else {
            if (bl && d3 > 14.0) {
                double d5 = 14.0;
                while (true) {
                    double d6;
                    if ((d6 = (double)n / d5) < 5.0) {
                        return (int)d5;
                    }
                    d5 *= 1.1;
                }
            }
            n3 = (int)d3;
        }
        if (bl && (n3 < 4 || n3 > 14)) {
            n3 = 12;
        }
        return n3;
    }

    public boolean formsRasterizedForDisplay() {
        return this.rasterizeForms;
    }

    protected static int getFontSize(FormObject formObject, int n, float f) {
        int n2;
        int n3 = formObject.getTextSize();
        if (n3 == -1) {
            n3 = 0;
        }
        if (n3 == 0) {
            Rectangle rectangle = formObject.getBoundingRectangle();
            int n4 = rectangle.width;
            int n5 = rectangle.height;
            if (n == 90 || n == 270) {
                int n6 = n5;
                n5 = n4;
                n4 = n6;
            }
            n3 = (int)((double)n5 * 0.85);
            String string = formObject.getTextString();
            int n7 = formObject.getFormType();
            if (n7 == FormFactory.MULTILINETEXT || n7 == FormFactory.MULTILINEPASSWORD) {
                n3 = GUIData.calculateFontSize(n5, n4, true, string);
            } else if (n7 == FormFactory.SINGLELINETEXT || n7 == FormFactory.SINGLELINEPASSWORD) {
                n3 = GUIData.calculateFontSize(n5, n4, false, string);
            } else if (string != null) {
                n3 = GUIData.calculateFontSize(n5, n4, false, string);
            }
        }
        if ((n2 = (int)((float)n3 * f)) < 1) {
            n2 = 1;
        }
        return n2;
    }

    protected void removeAllComponentsFromScreen() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAutoFontSize(FormObject formObject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void renderFormsOntoG2(Object object, int n, int n2, int n3, Map map, FormFactory formFactory, int n4) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCustomPrintInterface(CustomFormPrint customFormPrint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resetScaledLocation(float f, int n, int n2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRootDisplayComponent(Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List[] getFormList(boolean bl) {
        if (bl) {
            return this.formsOrdered;
        }
        return this.formsUnordered;
    }

    public void renderFormsOntoG2InHeadless(Object object, int n, int n2, Map map, FormFactory formFactory, int n3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

