/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions.JavaFX;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;

public class JavaFXControlListener {
    private static final boolean debug = false;
    private final Control comp;
    private final EventHandler<MouseEvent> mouseHandler;
    private final EventHandler<TouchEvent> touchHandler;
    private final EventHandler<KeyEvent> keyHandler;
    private final ChangeListener<Boolean> focusHandler;
    private List<EventHandler<MouseEvent>> pressed;
    private List<EventHandler<MouseEvent>> clicked;
    private List<EventHandler<MouseEvent>> released;
    private List<EventHandler<MouseEvent>> entered;
    private List<EventHandler<MouseEvent>> exited;
    private List<EventHandler<MouseEvent>> dragged;
    private List<EventHandler<MouseEvent>> moved;
    private List<EventHandler<TouchEvent>> touchPressed;
    private List<EventHandler<TouchEvent>> touchReleased;
    private List<EventHandler<KeyEvent>> keyReleased;
    private List<EventHandler<KeyEvent>> keyPressed;
    private List<ChangeListener<Boolean>> focusEvents;

    public JavaFXControlListener(Control control) {
        this.comp = control;
        this.mouseHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                JavaFXControlListener.this.handleMouseEvent(mouseEvent);
            }
        };
        this.touchHandler = new EventHandler<TouchEvent>(){

            public void handle(TouchEvent touchEvent) {
                JavaFXControlListener.this.handleTouchEvent(touchEvent);
            }
        };
        this.keyHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                JavaFXControlListener.this.handleKeyEvent(keyEvent);
            }
        };
        this.focusHandler = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                JavaFXControlListener.this.handleFocusEvent((ObservableValue<? extends Boolean>)observableValue, bl, bl2);
            }
        };
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
            JavaFXControlListener.executeMouseEvent(this.clicked, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_ENTERED)) {
            JavaFXControlListener.executeMouseEvent(this.entered, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_EXITED)) {
            JavaFXControlListener.executeMouseEvent(this.exited, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
            JavaFXControlListener.executeMouseEvent(this.pressed, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
            JavaFXControlListener.executeMouseEvent(this.released, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
            JavaFXControlListener.executeMouseEvent(this.dragged, mouseEvent);
        } else if (mouseEvent.getEventType().equals(MouseEvent.MOUSE_MOVED)) {
            JavaFXControlListener.executeMouseEvent(this.moved, mouseEvent);
        }
    }

    private static void executeMouseEvent(List<EventHandler<MouseEvent>> list, MouseEvent mouseEvent) {
        if (list != null) {
            for (EventHandler<MouseEvent> eventHandler : list) {
                eventHandler.handle((Event)mouseEvent);
            }
        }
    }

    private void handleTouchEvent(TouchEvent touchEvent) {
        if (touchEvent.getEventType().equals(TouchEvent.TOUCH_PRESSED)) {
            JavaFXControlListener.executeTouchEvent(this.touchPressed, touchEvent);
        } else if (touchEvent.getEventType().equals(TouchEvent.TOUCH_RELEASED)) {
            JavaFXControlListener.executeTouchEvent(this.touchReleased, touchEvent);
        }
    }

    private static void executeTouchEvent(List<EventHandler<TouchEvent>> list, TouchEvent touchEvent) {
        if (list != null) {
            for (EventHandler<TouchEvent> eventHandler : list) {
                eventHandler.handle((Event)touchEvent);
            }
        }
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
            JavaFXControlListener.executeKeyEvent(this.keyPressed, keyEvent);
        } else if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            JavaFXControlListener.executeKeyEvent(this.keyReleased, keyEvent);
        }
    }

    private static void executeKeyEvent(List<EventHandler<KeyEvent>> list, KeyEvent keyEvent) {
        if (list != null) {
            for (EventHandler<KeyEvent> eventHandler : list) {
                eventHandler.handle((Event)keyEvent);
            }
        }
    }

    private void handleFocusEvent(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
        if (this.focusEvents != null) {
            for (ChangeListener<Boolean> changeListener : this.focusEvents) {
                changeListener.changed(observableValue, (Object)bl, (Object)bl2);
            }
        }
    }

    public void addMouseListener(EventHandler<MouseEvent> eventHandler) {
        this.addOnMouseClickedListener(eventHandler);
        this.addOnMouseEnteredListener(eventHandler);
        this.addOnMouseExitedListener(eventHandler);
        this.addOnMousePressedListener(eventHandler);
        this.addOnMouseReleasedListener(eventHandler);
        this.addOnMouseDraggedListener(eventHandler);
        this.addOnMouseMovedListener(eventHandler);
    }

    public void addOnMouseClickedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.clicked == null) {
            this.clicked = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseClicked(this.mouseHandler);
        }
        this.clicked.add(eventHandler);
    }

    public void addOnMousePressedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.pressed == null) {
            this.pressed = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMousePressed(this.mouseHandler);
        }
        this.pressed.add(eventHandler);
    }

    public void addOnMouseReleasedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.released == null) {
            this.released = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseReleased(this.mouseHandler);
        }
        this.released.add(eventHandler);
    }

    public void addOnMouseEnteredListener(EventHandler<MouseEvent> eventHandler) {
        if (this.entered == null) {
            this.entered = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseEntered(this.mouseHandler);
        }
        this.entered.add(eventHandler);
    }

    public void addOnMouseExitedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.exited == null) {
            this.exited = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.exited.add(eventHandler);
    }

    public void addOnMouseDraggedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.dragged == null) {
            this.dragged = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.dragged.add(eventHandler);
    }

    public void addOnMouseMovedListener(EventHandler<MouseEvent> eventHandler) {
        if (this.moved == null) {
            this.moved = new ArrayList<EventHandler<MouseEvent>>();
            this.comp.setOnMouseExited(this.mouseHandler);
        }
        this.moved.add(eventHandler);
    }

    public void addOnTouchPressedListener(EventHandler<TouchEvent> eventHandler) {
        if (this.touchPressed == null) {
            this.touchPressed = new ArrayList<EventHandler<TouchEvent>>();
            this.comp.setOnTouchPressed(this.touchHandler);
        }
        this.touchPressed.add(eventHandler);
    }

    public void addOnTouchReleasedListener(EventHandler<TouchEvent> eventHandler) {
        if (this.touchReleased == null) {
            this.touchReleased = new ArrayList<EventHandler<TouchEvent>>();
            this.comp.setOnTouchReleased(this.touchHandler);
        }
        this.touchReleased.add(eventHandler);
    }

    public void addKeyListener(EventHandler<KeyEvent> eventHandler) {
        this.addOnKeyPressedListener(eventHandler);
        this.addOnKeyReleasedListener(eventHandler);
    }

    public void addOnKeyReleasedListener(EventHandler<KeyEvent> eventHandler) {
        if (this.keyReleased == null) {
            this.keyReleased = new ArrayList<EventHandler<KeyEvent>>();
            this.comp.setOnKeyReleased(this.keyHandler);
        }
        this.keyReleased.add(eventHandler);
    }

    public void addOnKeyPressedListener(EventHandler<KeyEvent> eventHandler) {
        if (this.keyPressed == null) {
            this.keyPressed = new ArrayList<EventHandler<KeyEvent>>();
            this.comp.setOnKeyPressed(this.keyHandler);
        }
        this.keyPressed.add(eventHandler);
    }

    public void addFocusEvent(ChangeListener<Boolean> changeListener) {
        if (this.focusEvents == null) {
            this.focusEvents = new ArrayList<ChangeListener<Boolean>>();
            this.comp.focusedProperty().addListener(this.focusHandler);
        }
        this.focusEvents.add(changeListener);
    }
}

