/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.actions.JavaFX;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.PDFListener;
import org.jpedal.objects.raw.FormObject;

public class JavaFXFormsListener
extends PDFListener {
    private boolean debug;
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            JavaFXFormsListener.this.handleMouseEvent(mouseEvent);
        }
    };
    private EventHandler<TouchEvent> touchHandler;
    private final ChangeListener<Boolean> focusHandler = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
            JavaFXFormsListener.this.handleFocusEvent(bl2);
        }
    };
    private final EventHandler<KeyEvent> keyHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent keyEvent) {
            JavaFXFormsListener.this.handleKeyEvent(keyEvent);
        }
    };

    public JavaFXFormsListener(FormObject formObject, ActionHandler actionHandler) {
        super(formObject, actionHandler);
    }

    public EventHandler<MouseEvent> getMouseHandler() {
        return this.mouseHandler;
    }

    public EventHandler<TouchEvent> getTouchHandler() {
        return this.touchHandler;
    }

    public ChangeListener<Boolean> getFocusHandler() {
        return this.focusHandler;
    }

    public EventHandler<KeyEvent> getKeyHandler() {
        return this.keyHandler;
    }

    private void handleMouseEvent(MouseEvent mouseEvent) {
        if (this.debug) {
            System.out.println("JavaFXFormsMouseListener event: " + mouseEvent.getEventType().getName());
        }
        if (mouseEvent.getEventType() == MouseEvent.MOUSE_CLICKED) {
            super.mouseClicked(mouseEvent);
        } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
            super.mousePressed(mouseEvent);
        } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
            super.mouseReleased(mouseEvent);
        } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.handler.A(mouseEvent, this.formObject, 4);
            this.handler.E(mouseEvent, this.formObject);
            if (this.formObject.getCharacteristics()[8]) {
                ((Node)this.formObject.getGUIComponent()).setVisible(true);
            }
        } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_EXITED) {
            this.handler.A(mouseEvent, this.formObject, 5);
            this.handler.X(mouseEvent, this.formObject);
            if (this.formObject.getCharacteristics()[8]) {
                ((Node)this.formObject.getGUIComponent()).setVisible(false);
            }
        }
    }

    private void handleFocusEvent(boolean bl) {
        if (bl) {
            super.focusGained(null);
        } else {
            super.focusLost(null);
        }
    }

    private void handleKeyEvent(KeyEvent keyEvent) {
        if (!keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            super.keyReleased(keyEvent);
        }
    }
}

