/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class PopupFactory {
    public static BufferedImage getIcon(PdfObject pdfObject) {
        BufferedImage bufferedImage = null;
        switch (pdfObject.getParameterConstant(1147962727)) {
            case 607471684: {
                bufferedImage = PopupFactory.getTextIcon(pdfObject);
                break;
            }
            case 1919840408: {
                bufferedImage = PopupFactory.getHightlightIcon(pdfObject);
            }
        }
        return bufferedImage;
    }

    private static BufferedImage getHightlightIcon(PdfObject pdfObject) {
        Object object;
        float[] fArray = pdfObject.getFloatArray(19);
        Color color = new Color(0);
        if (fArray != null) {
            switch (fArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    color = new Color(fArray[0], fArray[0], fArray[0], 0.5f);
                    break;
                }
                case 3: {
                    color = new Color(fArray[0], fArray[1], fArray[2], 0.5f);
                    break;
                }
                case 4: {
                    object = new DeviceCMYKColorSpace();
                    ((DeviceCMYKColorSpace)object).setColor(fArray, 4);
                    color = new Color(((GenericColorSpace)object).getColor().getRGB());
                    color = new Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), 0.5f);
                    break;
                }
            }
        }
        if ((object = pdfObject.getFloatArray(1785890247)) != null) {
            Rectangle rectangle = ((FormObject)pdfObject).getBoundingRectangle();
            if (rectangle.getWidth() == 0.0 && rectangle.getHeight() == 0.0) {
                for (int i = 0; i != ((Object)object).length; ++i) {
                    if (i % 2 == 0) {
                        if ((float)rectangle.x > object[i]) {
                            rectangle.x = (int)object[i];
                        }
                        if (!((float)(rectangle.x + rectangle.width) < object[i])) continue;
                        rectangle.width = (int)(object[i] - (float)rectangle.x);
                        continue;
                    }
                    if ((float)rectangle.y > object[i]) {
                        rectangle.y = (int)object[i];
                    }
                    if (!((float)(rectangle.y + rectangle.height) < object[i])) continue;
                    rectangle.height = (int)(object[i] - (float)rectangle.y);
                }
            }
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
            Graphics graphics = bufferedImage.getGraphics();
            if (((Object)object).length >= 8) {
                for (int i = 0; i != ((Object)object).length; i += 8) {
                    int n = (int)object[i] - rectangle.x;
                    int n2 = (int)object[i + 5] - rectangle.y;
                    n2 = rectangle.height - n2 - (int)(object[i + 1] - object[i + 5]);
                    int n3 = (int)(object[i + 2] - object[i]);
                    int n4 = (int)(object[i + 1] - object[i + 5]);
                    Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
                    graphics.setColor(color);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            return bufferedImage;
        }
        return null;
    }

    private static BufferedImage getTextIcon(PdfObject pdfObject) {
        BufferedImage bufferedImage;
        block6: {
            String string = pdfObject.getTextStreamValue(506543413);
            if (string == null) {
                string = "Note";
            }
            String string2 = string.equals("Comment") ? "/org/jpedal/objects/acroforms/res/comment.png" : (string.equals("Check") ? "/org/jpedal/objects/acroforms/res/Check.png" : (string.equals("Checkmark") ? "/org/jpedal/objects/acroforms/res/Checkmark.png" : (string.equals("Circle") ? "/org/jpedal/objects/acroforms/res/Circle.png" : (string.equals("Cross") ? "/org/jpedal/objects/acroforms/res/Cross.png" : (string.equals("CrossHairs") ? "/org/jpedal/objects/acroforms/res/CrossHairs.png" : (string.equals("Help") ? "/org/jpedal/objects/acroforms/res/Help.png" : (string.equals("Insert") ? "/org/jpedal/objects/acroforms/res/InsertText.png" : (string.equals("Key") ? "/org/jpedal/objects/acroforms/res/Key.png" : (string.equals("NewParagraph") ? "/org/jpedal/objects/acroforms/res/NewParagraph.png" : (string.equals("Paragraph") ? "/org/jpedal/objects/acroforms/res/Paragraph.png" : (string.equals("RightArrow") ? "/org/jpedal/objects/acroforms/res/RightArrow.png" : (string.equals("RightPointer") ? "/org/jpedal/objects/acroforms/res/RightPointer.png" : (string.equals("Star") ? "/org/jpedal/objects/acroforms/res/Star.png" : (string.equals("UpLeftArrow") ? "/org/jpedal/objects/acroforms/res/Up-LeftArrow.png" : (string.equals("UpArrow") ? "/org/jpedal/objects/acroforms/res/UpArrow.png" : "/org/jpedal/objects/acroforms/res/TextNote.png")))))))))))))));
            bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(PopupFactory.class.getResource(string2));
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
        float[] fArray = pdfObject.getFloatArray(19);
        if (fArray == null) {
            fArray = new float[]{1.0f, 1.0f, 1.0f};
        }
        Color color = new Color(fArray[0], fArray[1], fArray[2]);
        int n = color.getRGB();
        for (int i = 0; i != bufferedImage.getWidth(); ++i) {
            for (int j = 0; j != bufferedImage.getHeight(); ++j) {
                if (bufferedImage.getRGB(i, j) != -256) continue;
                bufferedImage.setRGB(i, j, n);
            }
        }
        return bufferedImage;
    }

    public static void renderFlattenedAnnotation(PdfObject pdfObject, DynamicVectorRenderer dynamicVectorRenderer, int n, int n2) {
        BufferedImage bufferedImage = PopupFactory.getIcon(pdfObject);
        if (bufferedImage != null) {
            GraphicsState graphicsState = new GraphicsState();
            int n3 = bufferedImage.getHeight();
            int n4 = bufferedImage.getWidth();
            float[] fArray = pdfObject.getFloatArray(573911876);
            if (pdfObject.getParameterConstant(1147962727) == 607471684) {
                fArray[2] = fArray[0] + (float)n4;
                fArray[1] = fArray[3] - (float)n3;
                pdfObject.setFloatArray(573911876, fArray);
            }
            switch (n2 % 360) {
                case 0: {
                    graphicsState.CTM = new float[][]{{n4, 0.0f, 1.0f}, {0.0f, n3, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = fArray[0];
                    graphicsState.y = fArray[3] - (float)n3;
                    graphicsState.CTM[2][0] = fArray[0];
                    graphicsState.CTM[2][1] = fArray[3] - (float)n3;
                    break;
                }
                case 90: {
                    graphicsState.CTM = new float[][]{{0.0f, n4, 1.0f}, {-n3, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = fArray[0] + (float)n3;
                    graphicsState.y = fArray[3];
                    graphicsState.CTM[2][0] = fArray[0] + (float)n3;
                    graphicsState.CTM[2][1] = fArray[3];
                    break;
                }
                case 180: {
                    graphicsState.CTM = new float[][]{{-n4, 0.0f, 1.0f}, {0.0f, -n3, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = fArray[0];
                    graphicsState.y = fArray[3] + (float)n3;
                    graphicsState.CTM[2][0] = fArray[0];
                    graphicsState.CTM[2][1] = fArray[3] + (float)n3;
                    break;
                }
                case 270: {
                    graphicsState.CTM = new float[][]{{0.0f, -n4, 1.0f}, {n3, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    graphicsState.x = fArray[0] - (float)n3;
                    graphicsState.y = fArray[3];
                    graphicsState.CTM[2][0] = fArray[0] - (float)n3;
                    graphicsState.CTM[2][1] = fArray[3];
                }
            }
            if (pdfObject.getParameterConstant(1147962727) == 1919840408) {
                dynamicVectorRenderer.setGraphicsState(1, graphicsState.getAlpha(1), 1111181679);
                dynamicVectorRenderer.setGraphicsState(2, graphicsState.getAlpha(2), 1111181679);
            }
            dynamicVectorRenderer.drawImage(n, bufferedImage, graphicsState, false, pdfObject.getObjectRefAsString(), 0, -1);
            if (pdfObject.getParameterConstant(1147962727) == 1919840408) {
                dynamicVectorRenderer.setGraphicsState(1, graphicsState.getAlpha(1), 1111314299);
                dynamicVectorRenderer.setGraphicsState(2, graphicsState.getAlpha(2), 1111314299);
            }
        }
    }
}

