/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.SwingData;
import org.jpedal.objects.acroforms.actions.SwingDownIconListener;
import org.jpedal.objects.acroforms.actions.SwingFormButtonListener;
import org.jpedal.objects.acroforms.actions.SwingListener;
import org.jpedal.objects.acroforms.creation.ComboColorRenderer;
import org.jpedal.objects.acroforms.creation.ComboListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.creation.ListListener;
import org.jpedal.objects.acroforms.creation.PopupFactory;
import org.jpedal.objects.acroforms.creation.RadioListener;
import org.jpedal.objects.acroforms.creation.TextDocumentListener;
import org.jpedal.objects.acroforms.overridingImplementations.FixImageIcon;
import org.jpedal.objects.acroforms.overridingImplementations.PdfSwingPopup;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class SwingFormFactory
extends GenericFormFactory
implements FormFactory {
    private JButton setupAnnotationButton(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        return jButton;
    }

    private JButton createAnntoationHighlight(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        jButton.setBackground(new Color(0, 0, 0, 0));
        jButton.setIcon(new FixImageIcon(formObject, PopupFactory.getIcon(formObject), 0));
        return jButton;
    }

    private JButton createAnnotationFreeText(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        jButton.setText("<html>" + formObject.getTextStreamValue(1216184967) + "</html>");
        Font font = new Font("TimesRoman", 0, 12);
        formObject.setTextSize(12);
        jButton.setFont(font);
        formObject.setFontName("TimesRoman");
        formObject.setTextFont(font);
        return jButton;
    }

    private JButton createAnnotationText(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        int n = this.pageData.getRotation(formObject.getPageNumber());
        BufferedImage bufferedImage = PopupFactory.getIcon(formObject);
        if (bufferedImage != null) {
            float[] fArray = formObject.getFloatArray(573911876);
            fArray[1] = fArray[3] - (float)bufferedImage.getHeight();
            fArray[2] = fArray[0] + (float)bufferedImage.getWidth();
            formObject.setFloatArray(573911876, fArray);
        }
        jButton.setIcon(new FixImageIcon(formObject, bufferedImage, n));
        return jButton;
    }

    private JComponent createAnnotationPopup(FormObject formObject) {
        JComponent jComponent = (JComponent)this.getPopupComponent(formObject, this.pageData.getCropBoxWidth(formObject.getPageNumber()));
        formObject.setGUIComponent(jComponent, 1);
        jComponent.setVisible(formObject.getBoolean(524301630));
        return jComponent;
    }

    private JButton createAnnotationUnderline(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        Color color = this.getAnnotationColor(formObject);
        jButton.setBounds(formObject.getBoundingRectangle());
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray == null) {
            fArray = formObject.getFloatArray(573911876);
        }
        BufferedImage bufferedImage = new BufferedImage(formObject.getBoundingRectangle().width, formObject.getBoundingRectangle().height, 6);
        Graphics graphics = bufferedImage.getGraphics();
        if (fArray.length >= 8) {
            for (int i = 0; i != fArray.length; i += 8) {
                int n = (int)fArray[i] - formObject.getBoundingRectangle().x;
                int n2 = (int)fArray[i + 5] - formObject.getBoundingRectangle().y;
                n2 = formObject.getBoundingRectangle().height - n2 - (int)(fArray[i + 1] - fArray[i + 5]);
                int n3 = (int)(fArray[i + 2] - fArray[i]);
                int n4 = (int)(fArray[i + 1] - fArray[i + 5]);
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                try {
                    graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.width, 1);
                    jButton.setBackground(new Color(0, 0, 0, 0));
                    jButton.setIcon(new FixImageIcon(formObject, bufferedImage, 0));
                    continue;
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return jButton;
    }

    private JButton createAnnotationInk(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        jButton.setToolTipText(formObject.getTextStreamValue(1216184967));
        Object[] objectArray = formObject.getObjectArray(475169151);
        float[] fArray = SwingFormFactory.scanInkListTree(objectArray, formObject, null);
        formObject.setFloatArray(573911876, new float[]{fArray[0], fArray[1], fArray[2], fArray[3]});
        BufferedImage bufferedImage = new BufferedImage(formObject.getBoundingRectangle().width, formObject.getBoundingRectangle().height, 6);
        SwingFormFactory.scanInkListTree(objectArray, formObject, bufferedImage.getGraphics());
        jButton.setBackground(new Color(0, 0, 0, 0));
        jButton.setIcon(new FixImageIcon(formObject, bufferedImage, 0));
        return jButton;
    }

    private JButton createAnnotationStrikeOut(FormObject formObject) {
        JButton jButton = this.setupAnnotationButton(formObject);
        Color color = this.getAnnotationColor(formObject);
        float[] fArray = formObject.getFloatArray(1785890247);
        if (fArray == null) {
            fArray = formObject.getFloatArray(573911876);
        }
        BufferedImage bufferedImage = new BufferedImage(formObject.getBoundingRectangle().width, formObject.getBoundingRectangle().height, 6);
        Graphics graphics = bufferedImage.getGraphics();
        if (fArray.length >= 8) {
            for (int i = 0; i != fArray.length; i += 8) {
                int n = (int)fArray[i] - formObject.getBoundingRectangle().x;
                int n2 = (int)fArray[i + 5] - formObject.getBoundingRectangle().y;
                n2 = formObject.getBoundingRectangle().height - n2 - (int)(fArray[i + 1] - fArray[i + 5]);
                int n3 = (int)(fArray[i + 2] - fArray[i]);
                int n4 = (int)(fArray[i + 1] - fArray[i + 5]);
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                try {
                    graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                    graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, 1);
                    jButton.setBackground(new Color(0, 0, 0, 0));
                    jButton.setIcon(new FixImageIcon(formObject, bufferedImage, 0));
                    continue;
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        return jButton;
    }

    private Color getAnnotationColor(FormObject formObject) {
        float[] fArray = formObject.getFloatArray(19);
        Color color = new Color(0);
        if (fArray != null) {
            switch (fArray.length) {
                case 0: {
                    break;
                }
                case 1: {
                    color = new Color(fArray[0], fArray[0], fArray[0], 1.0f);
                    break;
                }
                case 3: {
                    color = new Color(fArray[0], fArray[1], fArray[2], 1.0f);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace deviceCMYKColorSpace = new DeviceCMYKColorSpace();
                    deviceCMYKColorSpace.setColor(fArray, 4);
                    int n = deviceCMYKColorSpace.getColor().getRGB();
                    int n2 = n >> 16 & 0xFF;
                    int n3 = n >> 8 & 0xFF;
                    int n4 = n & 0xFF;
                    color = new Color(n2, n3, n4, 1);
                    break;
                }
            }
        }
        return color;
    }

    @Override
    public Object annotationButton(FormObject formObject) {
        int n = formObject.getParameterConstant(1147962727);
        if (n == 1061176672) {
            return this.createAnnotationPopup(formObject);
        }
        if (!formObject.isAppearanceUsed()) {
            switch (n) {
                case 607471684: {
                    return this.createAnnotationText(formObject);
                }
                case 980909433: {
                    return this.createAnnotationFreeText(formObject);
                }
                case 1919840408: {
                    return this.createAnntoationHighlight(formObject);
                }
                case 2053993372: {
                    return this.createAnnotationUnderline(formObject);
                }
                case 1654331: {
                    return this.createAnnotationInk(formObject);
                }
                case 2036432546: {
                    return this.createAnnotationStrikeOut(formObject);
                }
            }
        }
        return this.setupAnnotationButton(formObject);
    }

    static float[] curveInk(float[] fArray) {
        int n = 0;
        float[] fArray2 = new float[(fArray.length - 2) / 2 * 8];
        for (int i = 0; i < fArray.length; i += 2) {
            double[] dArray;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            if (i == 0) {
                d8 = fArray[i];
                d7 = fArray[i + 1];
                d6 = fArray[i];
                d5 = fArray[i + 1];
                d4 = fArray[i + 2];
                d3 = fArray[i + 3];
                d2 = fArray[i + 4];
                d = fArray[i + 5];
                dArray = SwingFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
                fArray2[n] = (float)d6;
                fArray2[++n] = (float)d5;
                fArray2[++n] = (float)dArray[0];
                fArray2[++n] = (float)dArray[1];
                fArray2[++n] = (float)dArray[2];
                fArray2[++n] = (float)dArray[3];
                fArray2[++n] = (float)d4;
                fArray2[++n] = (float)d3;
                ++n;
            }
            if (i + 6 >= fArray.length) {
                d8 = fArray[i];
                d7 = fArray[i + 1];
                d6 = fArray[i + 2];
                d5 = fArray[i + 3];
                d4 = fArray[i + 4];
                d3 = fArray[i + 5];
                d2 = fArray[i + 4];
                d = fArray[i + 5];
                dArray = SwingFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
                fArray2[n] = (float)d6;
                fArray2[++n] = (float)d5;
                fArray2[++n] = (float)dArray[0];
                fArray2[++n] = (float)dArray[1];
                fArray2[++n] = (float)dArray[2];
                fArray2[++n] = (float)dArray[3];
                fArray2[++n] = (float)d4;
                fArray2[++n] = (float)d3;
                break;
            }
            d8 = fArray[i];
            d7 = fArray[i + 1];
            d6 = fArray[i + 2];
            d5 = fArray[i + 3];
            d4 = fArray[i + 4];
            d3 = fArray[i + 5];
            d2 = fArray[i + 6];
            d = fArray[i + 7];
            dArray = SwingFormFactory.findControlPoint(d8, d7, d6, d5, d4, d3, d2, d, 1.0);
            fArray2[n] = (float)d6;
            fArray2[++n] = (float)d5;
            fArray2[++n] = (float)dArray[0];
            fArray2[++n] = (float)dArray[1];
            fArray2[++n] = (float)dArray[2];
            fArray2[++n] = (float)dArray[3];
            fArray2[++n] = (float)d4;
            fArray2[++n] = (float)d3;
            ++n;
        }
        return fArray2;
    }

    private static double[] findControlPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = (d + d3) / 2.0;
        double d11 = (d2 + d4) / 2.0;
        double d12 = (d3 + d5) / 2.0;
        double d13 = (d4 + d6) / 2.0;
        double d14 = (d5 + d7) / 2.0;
        double d15 = (d6 + d8) / 2.0;
        double d16 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d17 = Math.sqrt((d5 - d3) * (d5 - d3) + (d6 - d4) * (d6 - d4));
        double d18 = Math.sqrt((d7 - d5) * (d7 - d5) + (d8 - d6) * (d8 - d6));
        double d19 = d16 / (d16 + d17);
        double d20 = d17 / (d17 + d18);
        double d21 = d10 + (d12 - d10) * d19;
        double d22 = d11 + (d13 - d11) * d19;
        double d23 = d12 + (d14 - d12) * d20;
        double d24 = d13 + (d15 - d13) * d20;
        double d25 = d21 + (d12 - d21) * d9 + d3 - d21;
        double d26 = d22 + (d13 - d22) * d9 + d4 - d22;
        double d27 = d23 + (d12 - d23) * d9 + d5 - d23;
        double d28 = d24 + (d13 - d24) * d9 + d6 - d24;
        return new double[]{d25, d26, d27, d28};
    }

    private static float[] scanInkListTree(Object[] objectArray, FormObject formObject, Graphics graphics) {
        Object object;
        float f;
        Object object2;
        float f2;
        block43: {
            float f3;
            int n;
            Graphics2D graphics2D;
            float[] fArray;
            block44: {
                float f4;
                int n2;
                f2 = 0.0f;
                object2 = 0.0f;
                f = 0.0f;
                object = 0.0f;
                fArray = null;
                graphics2D = (Graphics2D)graphics;
                if (objectArray != null) {
                    Object object3;
                    Object object4;
                    n2 = objectArray.length;
                    n = 1;
                    if (graphics != null) {
                        float[] fArray2 = formObject.getFloatArray(19);
                        object4 = new Color(0);
                        if (fArray2 != null) {
                            switch (fArray2.length) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    object4 = new Color(fArray2[0], fArray2[0], fArray2[0], 1.0f);
                                    break;
                                }
                                case 3: {
                                    object4 = new Color(fArray2[0], fArray2[1], fArray2[2], 1.0f);
                                    break;
                                }
                                case 4: {
                                    object3 = new DeviceCMYKColorSpace();
                                    ((DeviceCMYKColorSpace)object3).setColor(fArray2, 4);
                                    object4 = new Color(((GenericColorSpace)object3).getColor().getRGB());
                                    break;
                                }
                            }
                        }
                        graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                        graphics2D.fillRect(0, 0, formObject.getBoundingRectangle().width, formObject.getBoundingRectangle().height);
                        graphics2D.setColor((Color)object4);
                        graphics2D.setPaint((Paint)object4);
                    }
                    for (int i = 0; i < n2; ++i) {
                        if (objectArray[i] instanceof byte[]) {
                            object4 = (byte[])objectArray[i];
                            if (fArray == null) {
                                fArray = new float[n2];
                            }
                            if (object4 == null) continue;
                            object3 = new String((byte[])object4);
                            float f5 = Float.parseFloat((String)object3);
                            switch (i % 2) {
                                case 0: {
                                    if (n != 0) {
                                        f2 = f5;
                                        f = f5;
                                    } else {
                                        if (f5 < f2) {
                                            f2 = f5;
                                        }
                                        if (f5 > f) {
                                            f = f5;
                                        }
                                    }
                                    fArray[i] = f4 = f5 - (float)formObject.getBoundingRectangle().x;
                                    break;
                                }
                                case 1: {
                                    if (n != 0) {
                                        object2 = f5;
                                        object = f5;
                                        n = 0;
                                    } else {
                                        if (f5 < object2) {
                                            object2 = f5;
                                        }
                                        if (f5 > object) {
                                            object = f5;
                                        }
                                    }
                                    fArray[i] = f3 = (float)formObject.getBoundingRectangle().height - (f5 - (float)formObject.getBoundingRectangle().y);
                                }
                            }
                            continue;
                        }
                        object4 = SwingFormFactory.scanInkListTree((Object[])objectArray[i], formObject, graphics);
                        if (n != 0) {
                            f2 = (float)object4[0];
                            f = (float)object4[2];
                            object2 = object4[1];
                            object = object4[3];
                            n = 0;
                            continue;
                        }
                        if (object4[0] < f2) {
                            f2 = (float)object4[0];
                        }
                        if (object4[2] > f) {
                            f = (float)object4[2];
                        }
                        if (object4[1] < object2) {
                            object2 = object4[1];
                        }
                        if (!(object4[3] > object)) continue;
                        object = object4[3];
                    }
                }
                if (fArray == null) break block43;
                if (fArray.length >= 6) break block44;
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    if (n2 % 2 == 0) {
                        if (fArray[n2] < f2) {
                            f2 = fArray[n2];
                        }
                        if (!(fArray[n2] > f)) continue;
                        f = fArray[n2];
                        continue;
                    }
                    if (fArray[n2] < object2) {
                        object2 = fArray[n2];
                    }
                    if (!(fArray[n2] > object)) continue;
                    object = fArray[n2];
                }
                float f6 = 0.0f;
                f4 = 0.0f;
                if (f2 < 0.0f) {
                    f6 = Math.abs(f2);
                }
                if (object2 < 0.0f) {
                    f4 = Math.abs(object2);
                }
                f2 += f6;
                f += f6;
                object2 += f4;
                object += f4;
                if (graphics2D == null) break block43;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setStroke(new BasicStroke(1.52f, 1, 1));
                for (int i = 0; i < fArray.length; i += 4) {
                    Line2D.Float float_ = new Line2D.Float(fArray[0], fArray[1], fArray[2], fArray[3]);
                    graphics2D.draw(float_);
                }
                break block43;
            }
            float[] fArray3 = SwingFormFactory.curveInk(fArray);
            for (int i = 0; i < fArray3.length; ++i) {
                if (i % 2 == 0) {
                    if (fArray3[i] < f2) {
                        f2 = fArray3[i];
                    }
                    if (!(fArray3[i] > f)) continue;
                    f = fArray3[i];
                    continue;
                }
                if (fArray3[i] < object2) {
                    object2 = fArray3[i];
                }
                if (!(fArray3[i] > object)) continue;
                object = fArray3[i];
            }
            float f7 = 0.0f;
            f3 = 0.0f;
            if (f2 < 0.0f) {
                f7 = Math.abs(f2);
            }
            if (object2 < 0.0f) {
                f3 = Math.abs(object2);
            }
            f2 += f7;
            f += f7;
            object2 += f3;
            object += f3;
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setStroke(new BasicStroke(1.52f, 1, 1));
                for (n = 0; n < fArray3.length; n += 8) {
                    CubicCurve2D.Double double_ = new CubicCurve2D.Double(fArray3[n] + f7, fArray3[n + 1] + f3, fArray3[n + 2] + f7, fArray3[n + 3] + f3, fArray3[n + 4] + f7, fArray3[n + 5] + f3, fArray3[n + 6] + f7, fArray3[n + 7] + f3);
                    graphics2D.draw(double_);
                }
            }
        }
        return new float[]{f2, object2, f, object};
    }

    @Override
    public Object comboBox(FormObject formObject) {
        Object object;
        JComboBox<Object> jComboBox;
        String[] stringArray = formObject.getItemsList();
        if (stringArray == null) {
            jComboBox = new JComboBox();
        } else {
            jComboBox = new JComboBox<String>(stringArray);
            object = FormObject.generateColor(formObject.getDictionary(7451).getFloatArray(4631));
            if (object != null) {
                ComboColorRenderer comboColorRenderer = new ComboColorRenderer((Color)object);
                jComboBox.setRenderer(comboColorRenderer);
            }
        }
        object = formObject.getSelectedItem();
        if (formObject.getValuesMap(true) != null) {
            jComboBox.setSelectedItem(formObject.getValuesMap(true).get(object));
        } else {
            jComboBox.setSelectedItem(object);
        }
        int n = jComboBox.getSelectedIndex();
        formObject.setSelection(jComboBox.getSelectedObjects(), (String)jComboBox.getSelectedItem(), new int[]{n}, n);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray[19]) {
            jComboBox.setEditable(true);
        } else {
            jComboBox.setEditable(false);
        }
        this.setupUniversalFeatures(jComboBox, formObject);
        if (blArray[1]) {
            jComboBox.setEditable(false);
            jComboBox.setEnabled(false);
        }
        jComboBox.addItemListener(new ComboListener(jComboBox, formObject));
        return jComboBox;
    }

    @Override
    public Object checkBoxBut(FormObject formObject) {
        boolean[] blArray;
        JCheckBox jCheckBox = new JCheckBox();
        this.setupButton(jCheckBox, formObject);
        this.setupUniversalFeatures(jCheckBox, formObject);
        if (jCheckBox.getBorder() != null) {
            jCheckBox.setBorderPainted(true);
        }
        if ((blArray = formObject.getFieldFlags()) != null && blArray[1]) {
            jCheckBox.setEnabled(false);
            jCheckBox.setDisabledIcon(jCheckBox.getIcon());
            jCheckBox.setDisabledSelectedIcon(jCheckBox.getSelectedIcon());
        }
        return jCheckBox;
    }

    @Override
    public Object listField(FormObject formObject) {
        String[] stringArray = formObject.getItemsList();
        JList<Object> jList = stringArray != null ? new JList<String>(stringArray) : new JList();
        if (!formObject.getFieldFlags()[22]) {
            jList.setSelectionMode(0);
        }
        if (formObject.getSelectionIndices() != null) {
            jList.setSelectedIndices(formObject.getSelectionIndices());
        } else if (formObject.getValuesMap(true) != null) {
            jList.setSelectedValue(formObject.getValuesMap(true).get(formObject.getSelectedItem()), true);
        } else {
            jList.setSelectedValue(formObject.getSelectedItem(), true);
        }
        formObject.setSelection(jList.getSelectedValues(), (String)jList.getSelectedValue(), jList.getSelectedIndices(), jList.getSelectedIndex());
        this.setupUniversalFeatures(jList, formObject);
        jList.addListSelectionListener(new ListListener(jList, formObject));
        return jList;
    }

    @Override
    public Object multiLinePassword(FormObject formObject) {
        String string = formObject.getTextString();
        int n = formObject.getInt(1209815663);
        JPasswordField jPasswordField = n != -1 ? new JPasswordField(string, n) : new JPasswordField(string);
        jPasswordField.setEchoChar('*');
        this.setupUniversalFeatures(jPasswordField, formObject);
        SwingFormFactory.setupTextFeatures(jPasswordField, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jPasswordField.setEditable(false);
        }
        SwingFormFactory.setToolTip(formObject, jPasswordField);
        return jPasswordField;
    }

    @Override
    public Object multiLineText(FormObject formObject) {
        JTextPane jTextPane;
        boolean[] blArray = formObject.getFieldFlags();
        boolean[] blArray2 = formObject.getCharacteristics();
        String string = formObject.getTextString();
        if (blArray != null && blArray[1] || blArray2 != null && blArray2[9]) {
            JTextPane jTextPane2 = new JTextPane();
            jTextPane2.setText(string);
            jTextPane2.setEditable(false);
            if (formObject.getAlignment() != -1) {
                StyledDocument styledDocument = jTextPane2.getStyledDocument();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                switch (formObject.getAlignment()) {
                    case 0: {
                        StyleConstants.setAlignment(simpleAttributeSet, 1);
                        break;
                    }
                    case 4: {
                        StyleConstants.setAlignment(simpleAttributeSet, 2);
                    }
                }
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            }
            jTextPane2.getDocument().addDocumentListener(new TextDocumentListener(jTextPane2, formObject));
            jTextPane = jTextPane2;
        } else {
            JTextPane jTextPane3 = new JTextPane();
            jTextPane3.setText(string);
            if (formObject.getAlignment() != -1) {
                StyledDocument styledDocument = jTextPane3.getStyledDocument();
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                switch (formObject.getAlignment()) {
                    case 0: {
                        StyleConstants.setAlignment(simpleAttributeSet, 1);
                        break;
                    }
                    case 4: {
                        StyleConstants.setAlignment(simpleAttributeSet, 2);
                    }
                }
                styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            }
            jTextPane3.getDocument().addDocumentListener(new TextDocumentListener(jTextPane3, formObject));
            jTextPane = jTextPane3;
        }
        SwingFormFactory.setToolTip(formObject, jTextPane);
        this.setupUniversalFeatures(jTextPane, formObject);
        return jTextPane;
    }

    @Override
    public Object signature(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        if (!formObject.isAppearanceUsed()) {
            jButton.setOpaque(false);
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setPaint(new Color(221, 228, 255, 175));
            graphics2D.fillRect(0, 0, 1, 1);
            jButton.setIcon(new FixImageIcon(formObject, bufferedImage, 0));
        }
        return jButton;
    }

    @Override
    public Object pushBut(FormObject formObject) {
        JButton jButton = new JButton();
        this.setupButton(jButton, formObject);
        this.setupUniversalFeatures(jButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jButton.setEnabled(false);
            jButton.setDisabledIcon(jButton.getIcon());
            jButton.setDisabledSelectedIcon(jButton.getSelectedIcon());
        }
        return jButton;
    }

    @Override
    public Object radioBut(FormObject formObject) {
        JRadioButton jRadioButton = new JRadioButton();
        this.setupButton(jRadioButton, formObject);
        this.setupUniversalFeatures(jRadioButton, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jRadioButton.setEnabled(false);
            jRadioButton.setDisabledIcon(jRadioButton.getIcon());
            jRadioButton.setDisabledSelectedIcon(jRadioButton.getSelectedIcon());
        }
        return jRadioButton;
    }

    @Override
    public Object singleLinePassword(FormObject formObject) {
        JPasswordField jPasswordField = new JPasswordField(formObject.getTextString());
        jPasswordField.setEchoChar('*');
        int n = formObject.getInt(1209815663);
        if (n != -1) {
            jPasswordField.setColumns(n);
        }
        this.setupUniversalFeatures(jPasswordField, formObject);
        SwingFormFactory.setupTextFeatures(jPasswordField, formObject);
        boolean[] blArray = formObject.getFieldFlags();
        if (blArray != null && blArray[1]) {
            jPasswordField.setEditable(false);
        }
        SwingFormFactory.setToolTip(formObject, jPasswordField);
        return jPasswordField;
    }

    @Override
    public Object singleLineText(FormObject formObject) {
        JTextField jTextField;
        boolean[] blArray = formObject.getFieldFlags();
        boolean[] blArray2 = formObject.getCharacteristics();
        String string = this.readAPimagesForText(formObject);
        if (string != null && string.contains("&#")) {
            string = Strip.stripXML(string, true).toString();
        }
        if (string != null && !string.equals(formObject.getTextStreamValue(38))) {
            formObject.setTextStreamValue(38, string);
        }
        if (blArray != null && blArray[1] || blArray2 != null && blArray2[9]) {
            if (formObject.isXFAObject()) {
                JTextField jTextField2 = new JTextField(formObject.getTextString());
                SwingFormFactory.setupTextFeatures(jTextField2, formObject);
                SwingFormFactory.setToolTip(formObject, jTextField2);
                jTextField2.setEditable(false);
                jTextField = jTextField2;
            } else {
                JTextField jTextField3 = new JTextField(formObject.getTextString());
                SwingFormFactory.setupTextFeatures(jTextField3, formObject);
                SwingFormFactory.setToolTip(formObject, jTextField3);
                jTextField3.setEditable(false);
                jTextField = jTextField3;
            }
        } else {
            JTextField jTextField4 = new JTextField(formObject.getTextString());
            SwingFormFactory.setupTextFeatures(jTextField4, formObject);
            SwingFormFactory.setToolTip(formObject, jTextField4);
            jTextField = jTextField4;
        }
        this.setupUniversalFeatures(jTextField, formObject);
        return jTextField;
    }

    static void setupTextFeatures(JTextField jTextField, FormObject formObject) {
        if (formObject.getAlignment() != -1) {
            jTextField.setHorizontalAlignment(formObject.getAlignment());
        }
        jTextField.getDocument().addDocumentListener(new TextDocumentListener(jTextField, formObject));
    }

    private void setupButton(AbstractButton abstractButton, FormObject formObject) {
        int n;
        Object object;
        ButtonGroup buttonGroup;
        String string = formObject.getTextStreamValue(36);
        if (string == null) {
            string = "";
        }
        if ((buttonGroup = (ButtonGroup)this.groups.get(string)) == null) {
            buttonGroup = new ButtonGroup();
            this.groups.put(string, buttonGroup);
            this.firstButtons.put(string, abstractButton);
        } else {
            object = (AbstractButton)this.firstButtons.get(string);
            if (object != null) {
                this.firstButtons.remove(string);
                buttonGroup.add((AbstractButton)object);
            }
            buttonGroup.add(abstractButton);
        }
        object = formObject.getDictionary(7451).getTextStreamValue(4881);
        abstractButton.setText((String)object);
        abstractButton.setContentAreaFilled(false);
        String string2 = formObject.getDictionary(7451).getTextStreamValue(4371);
        String string3 = formObject.getDictionary(7451).getTextStreamValue(8723);
        if (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty()) {
            abstractButton.addMouseListener(new SwingFormButtonListener((String)object, string3, string2));
        }
        if (formObject.isAppearanceUsed()) {
            this.setAPImages(formObject, abstractButton);
        }
        if ((n = formObject.getTextPosition()) != -1) {
            switch (n) {
                case 0: {
                    abstractButton.setIcon(null);
                    abstractButton.setText((String)object);
                    break;
                }
                case 1: {
                    abstractButton.setText(null);
                    break;
                }
                case 2: {
                    abstractButton.setVerticalTextPosition(3);
                    break;
                }
                case 3: {
                    abstractButton.setVerticalTextPosition(1);
                    break;
                }
                case 4: {
                    abstractButton.setHorizontalTextPosition(4);
                    break;
                }
                case 5: {
                    abstractButton.setHorizontalTextPosition(2);
                    break;
                }
                case 6: {
                    abstractButton.setText(null);
                }
            }
        }
        Insets insets = new Insets(0, 0, 0, 0);
        abstractButton.setMargin(insets);
        abstractButton.addMouseListener((MouseListener)this.formsActionHandler.setHoverCursor());
        abstractButton.addChangeListener(new RadioListener(abstractButton, formObject));
    }

    private void setAPImages(FormObject formObject, Object object) {
        PdfObject pdfObject;
        Object object2;
        AbstractButton abstractButton = (AbstractButton)object;
        PdfObject pdfObject2 = formObject.getDictionary(4384).getDictionary(30);
        PdfObject pdfObject3 = formObject.getDictionary(4384).getDictionary(20);
        PdfObject pdfObject4 = formObject.getDictionary(4384).getDictionary(34);
        PdfObject pdfObject5 = null;
        PdfObject pdfObject6 = null;
        PdfObject pdfObject7 = null;
        PdfObject pdfObject8 = null;
        PdfObject pdfObject9 = null;
        PdfObject pdfObject10 = null;
        int n = 0;
        int n2 = formObject.getParameterConstant(1147962727);
        if (pdfObject2 != null || formObject.getDictionary(7451).getDictionary(25) != null) {
            if (pdfObject2.getDictionary(2045494) != null) {
                pdfObject5 = pdfObject2.getDictionary(2045494);
            } else if (formObject.getDictionary(7451).getDictionary(25) != null && formObject.getDictionary(7451).getDictionary(6422) == null) {
                pdfObject5 = formObject.getDictionary(7451).getDictionary(25);
            } else if (pdfObject2.getDecodedStream() != null) {
                pdfObject5 = pdfObject2;
            }
            if (pdfObject5 != null) {
                abstractButton.setText(null);
                abstractButton.setIcon(new FixImageIcon(formObject, pdfObject5, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0));
            }
            if (pdfObject2.getDictionary(7998) != null) {
                pdfObject6 = pdfObject2.getDictionary(7998);
                formObject.setNormalOnState("On");
            } else {
                object2 = pdfObject2.getOtherDictionaries();
                if (object2 != null && !object2.isEmpty()) {
                    for (String string : object2.keySet()) {
                        pdfObject6 = pdfObject = (PdfObject)object2.get(string);
                        formObject.setNormalOnState(string);
                    }
                }
            }
            if (pdfObject6 != null) {
                abstractButton.setText(null);
                abstractButton.setSelectedIcon(new FixImageIcon(formObject, pdfObject6, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0));
                if (abstractButton.getIcon() == null) {
                    abstractButton.setIcon(new FixImageIcon(formObject, null, formObject.getDictionary(7451).getInt(34)));
                }
            }
        }
        if (formObject.hasNoDownIcon()) {
            abstractButton.setPressedIcon(abstractButton.getIcon());
        } else {
            if (formObject.hasOffsetDownIcon()) {
                n = 1;
            } else if (formObject.hasInvertDownIcon()) {
                n = 2;
            }
            if (n != 0) {
                if (pdfObject5 != null) {
                    if (pdfObject6 != null) {
                        pdfObject7 = pdfObject5;
                        pdfObject8 = pdfObject6;
                    } else {
                        pdfObject7 = pdfObject5;
                    }
                } else if (pdfObject6 != null) {
                    pdfObject7 = pdfObject6;
                }
            }
            if (pdfObject3 != null) {
                if (pdfObject3.getDecodedStream() != null) {
                    pdfObject7 = pdfObject3;
                } else if (pdfObject3.getDictionary(2045494) != null) {
                    pdfObject7 = pdfObject3.getDictionary(2045494);
                }
                if (pdfObject3.getDictionary(7998) != null) {
                    pdfObject8 = pdfObject3.getDictionary(7998);
                } else {
                    object2 = pdfObject3.getOtherDictionaries();
                    if (object2 != null && !object2.isEmpty()) {
                        for (String string : object2.keySet()) {
                            pdfObject8 = pdfObject = (PdfObject)object2.get(string);
                        }
                    }
                }
            }
            if (pdfObject7 == null || pdfObject8 == null) {
                if (pdfObject7 != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(formObject, pdfObject7, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, n));
                } else if (pdfObject8 != null) {
                    abstractButton.setText(null);
                    abstractButton.setPressedIcon(new FixImageIcon(formObject, pdfObject8, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, n));
                }
            } else {
                abstractButton.setPressedIcon(new FixImageIcon(formObject, pdfObject8, pdfObject7, formObject.getDictionary(7451).getInt(34), abstractButton.isSelected() ? 1 : 0, this.currentPdfFile, n2, n));
                abstractButton.addActionListener(new SwingDownIconListener());
            }
        }
        if (pdfObject4 != null) {
            if (pdfObject4.getDecodedStream() != null) {
                pdfObject9 = pdfObject4;
            } else if (pdfObject4.getDictionary(2045494) != null) {
                pdfObject9 = pdfObject4.getDictionary(2045494);
            }
            if (pdfObject9 != null) {
                abstractButton.setRolloverEnabled(true);
                abstractButton.setText(null);
                abstractButton.setRolloverIcon(new FixImageIcon(formObject, pdfObject9, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0));
            }
            if (pdfObject4.getDictionary(7998) != null) {
                pdfObject10 = pdfObject4.getDictionary(7998);
            } else {
                object2 = pdfObject4.getOtherDictionaries();
                if (object2 != null && !object2.isEmpty()) {
                    for (String string : object2.keySet()) {
                        pdfObject10 = pdfObject = (PdfObject)object2.get(string);
                    }
                }
            }
            if (pdfObject10 != null) {
                abstractButton.setRolloverEnabled(true);
                abstractButton.setText(null);
                abstractButton.setRolloverSelectedIcon(new FixImageIcon(formObject, pdfObject10, formObject.getDictionary(7451).getInt(34), this.currentPdfFile, n2, 0));
                if (abstractButton.getRolloverIcon() == null) {
                    abstractButton.setRolloverIcon(new FixImageIcon(formObject, null, formObject.getDictionary(7451).getInt(34)));
                }
            }
        }
        if (formObject.isSelected()) {
            abstractButton.setSelected(true);
            if (abstractButton instanceof JToggleButton && (object2 = abstractButton.getPressedIcon()) instanceof FixImageIcon) {
                ((FixImageIcon)object2).swapImage(true);
            }
        }
    }

    private void setupUniversalFeatures(JComponent jComponent, FormObject formObject) {
        jComponent.setOpaque(false);
        Font font = formObject.getTextFont();
        if (font != null) {
            jComponent.setFont(font);
        }
        jComponent.setForeground(formObject.getTextColor());
        Border border = (Border)SwingData.generateBorderfromForm(formObject, 1.0f);
        jComponent.setBorder(border);
        Color color = FormObject.generateColor(formObject.getDictionary(7451).getFloatArray(4631));
        if (color != null) {
            jComponent.setBackground(color);
            jComponent.setOpaque(true);
        } else if (DecoderOptions.isRunningOnMac && jComponent instanceof JButton) {
            ((JButton)jComponent).setBorderPainted(false);
            jComponent.setBorder(null);
        }
        this.setupMouseListener(jComponent, formObject);
    }

    private void setupMouseListener(Component component, FormObject formObject) {
        String string;
        boolean[] blArray = formObject.getCharacteristics();
        if (blArray[0] || blArray[1] || blArray[5]) {
            component.setVisible(false);
        }
        SwingListener swingListener = new SwingListener(formObject, this.formsActionHandler);
        if (component instanceof JComboBox) {
            ((JComboBox)component).getComponent(0).addMouseListener(swingListener);
            ((JComboBox)component).getComponent(0).addKeyListener(swingListener);
            ((JComboBox)component).getComponent(0).addFocusListener(swingListener);
            ((JComboBox)component).addActionListener(swingListener);
        }
        if (component instanceof JList) {
            ((JList)component).addListSelectionListener(swingListener);
        }
        component.addMouseListener(swingListener);
        component.addMouseMotionListener(swingListener);
        component.addKeyListener(swingListener);
        component.addFocusListener(swingListener);
        PdfObject pdfObject = formObject.getDictionary(17);
        if (!(pdfObject == null || pdfObject.getNameAsConstant(35) != 2433561 || (string = System.getProperty("org.jpedal.noURLaccess")) != null && string.equals("true"))) {
            String string2 = pdfObject.getTextStreamValue(2433561);
            ((JComponent)component).setToolTipText(string2);
        }
    }

    private static void setToolTip(FormObject formObject, JComponent jComponent) {
        String string = formObject.getTextStreamValue(9253);
        if (string != null) {
            jComponent.setToolTipText(string);
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new SwingData();
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void setAnnotOrder(Map<String, String> map) {
    }

    public Object getPopupComponent(FormObject formObject, int n) {
        return new PdfSwingPopup(formObject, n);
    }
}

