/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.javascript.AformDefaultJSscript;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.PDF2JS;
import org.jpedal.objects.javascript.defaultactions.DisplayJavascriptActions;
import org.jpedal.objects.javascript.defaultactions.JpedalDefaultJavascript;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.layers.Layer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoParser
extends DefaultParser
implements ExpressionEngine {
    private static final String viewerSettings = AformDefaultJSscript.getViewerSettings() + AformDefaultJSscript.getstaticScript();
    private Context cx;
    private Scriptable scope;
    private String functions = "";
    private boolean javascriptRunning;
    private final Javascript JSObj;

    public RhinoParser(Javascript javascript) {
        this.JSObj = javascript;
    }

    @Override
    public void flush() {
        block5: {
            if (this.acro != null && this.acro.getFormFactory() != null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.flushJS();
                } else {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            RhinoParser.this.flushJS();
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block5;
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
            }
        }
    }

    public void flushJS() {
        this.functions = "";
        if (this.cx != null) {
            try {
                Context.exit();
                this.cx = null;
            }
            catch (IllegalStateException illegalStateException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + illegalStateException.getMessage());
                }
                illegalStateException.printStackTrace();
            }
        }
    }

    public void setJavaScriptEnded() {
        this.javascriptRunning = false;
    }

    public void executeFunctions(final String string, final FormObject formObject, final AcroRenderer acroRenderer) {
        this.javascriptRunning = true;
        if (acroRenderer.getFormFactory().getType() == 1) {
            block8: {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.executeJS(string, formObject, acroRenderer);
                } else {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            RhinoParser.this.executeJS(string, formObject, acroRenderer);
                        }
                    };
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block8;
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
            }
            while (this.javascriptRunning) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJS(String string, FormObject formObject, AcroRenderer acroRenderer) {
        try {
            if (string.isEmpty() && this.functions.isEmpty()) {
                return;
            }
            Object object = "";
            int n = string.indexOf("function ");
            while (n != -1) {
                int n2 = n + 8;
                int n3 = 0;
                char c = string.charAt(n2);
                while (true) {
                    if (c == '{') {
                        ++n3;
                    }
                    if (c == '}' && --n3 == 0) break;
                    c = string.charAt(n2++);
                }
                int n4 = string.lastIndexOf(13, n);
                int n5 = string.lastIndexOf(10, n);
                int n6 = (n5 < n4 ? n4 : n5) + 1;
                n4 = string.indexOf(13, n2);
                if (n4 == -1) {
                    n4 = string.length();
                }
                if ((n5 = string.indexOf(10, n2)) == -1) {
                    n5 = string.length();
                }
                int n7 = (n5 < n4 ? n5 : n4) + 1;
                object = (String)object + string.substring(n6, n7);
                string = string.substring(0, n6) + string.substring(n7);
                n = string.indexOf("function ");
            }
            if (!((String)object).isEmpty()) {
                this.addCode((String)object);
            }
            string = RhinoParser.preParseCode(string);
            if (this.cx == null) {
                this.cx = Context.enter();
                this.scope = this.cx.initStandardObjects();
                this.addStdObject(acroRenderer);
            }
            if (formObject != null) {
                String string2 = formObject.getTextStreamValue(36);
                Object object2 = Context.javaToJS((Object)new PDF2JS(formObject), (Scriptable)this.scope);
                ScriptableObject.putProperty((Scriptable)this.scope, (String)"event", (Object)object2);
                if (string2 != null) {
                    ScriptableObject.putProperty((Scriptable)this.scope, (String)string2, (Object)object2);
                }
            }
            String string3 = viewerSettings + this.functions;
            this.cx.evaluateString(this.scope, string3, "<JS viewer Settings>", 1, null);
            this.cx.evaluateString(this.scope, string, "<javascript>", 1, null);
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        finally {
            PdfLayerList pdfLayerList = acroRenderer.getActionHandler().getLayerHandler();
            if (pdfLayerList != null && pdfLayerList.getChangesMade()) {
                if (Layer.debugLayer) {
                    System.out.println("changed");
                }
                try {
                    acroRenderer.getActionHandler().getPDFDecoder().decodePage(-1);
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    exception.printStackTrace();
                }
            }
            this.javascriptRunning = false;
        }
    }

    private static String preParseCode(String string) {
        int n;
        String[] stringArray = new String[]{"= (\"%.2f\",", "this.ADBE", " getField(", "\ngetField(", "\rgetField(", "(getField(", "this.getField(", "this.resetForm(", "this.pageNum", " this.getOCGs(", "\nthis.getOCGs(", "\rthis.getOCGs(", " getOCGs(", "\ngetOCGs(", "\rgetOCGs(", ".state="};
        String[] stringArray2 = new String[]{"= util.z(\"%.2f\",", "ADBE", " acro.getField(", "\nacro.getField(", "\racro.getField(", "(acro.getField(", "acro.getField(", "acro.resetForm(", "acro.pageNum", " layers.getOCGs(", "\nlayers.getOCGs(", "\rlayers.getOCGs(", " layers.getOCGs(", "\nlayers.getOCGs(", "\rlayers.getOCGs(", "\rlayers.getOCGs("};
        for (n = 0; n < stringArray.length; ++n) {
            string = RhinoParser.checkAndReplaceCode(stringArray[n], stringArray2[n], string);
        }
        n = string.indexOf("printf");
        if (n != -1) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string.lastIndexOf(59, n);
            int n4 = string.lastIndexOf(123, n);
            if (n3 == -1 || n4 != -1 && n4 > n3) {
                n3 = n4;
            }
            stringBuilder.append(string.substring(0, n3 + 1));
            int n5 = string.indexOf(34, n);
            n5 = string.indexOf(34, n5 + 1);
            while (string.charAt(n5 - 1) == '\\') {
                n5 = string.indexOf(34, n5);
            }
            int n6 = string.indexOf(44, n5);
            String string2 = string.substring(n6 + 1, n2 = string.indexOf(41, n6));
            if (!string2.equals("printfArgs")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                stringBuilder.append("var printfArgs=new Array();\n");
                int n7 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuilder.append("printfArgs[");
                    stringBuilder.append(n7++);
                    stringBuilder.append("]=");
                    stringBuilder.append(stringTokenizer.nextToken());
                    stringBuilder.append(";\n");
                }
                stringBuilder.append(string.substring(n3 + 1, n6 + 1));
                stringBuilder.append("printfArgs");
                stringBuilder.append(string.substring(n2));
                string = stringBuilder.toString();
            }
        }
        string = RhinoParser.checkAndReplaceCode("event.value=AFMakeNumber(acro.getField(\"sum\").value)(8)", "", string);
        string = RhinoParser.checkAndReplaceCode("calculate = false", "calculate = 0", string);
        string = RhinoParser.checkAndReplaceCode("calculate = true", "calculate = 1", string);
        string = RhinoParser.checkAndReplaceCode("calculate=false", "calculate=0", string);
        string = RhinoParser.checkAndReplaceCode("calculate=true", "calculate=1", string);
        return string;
    }

    private static String checkAndReplaceCode(String string, String string2, String string3) {
        int n = string3.indexOf(string);
        if (n != -1) {
            StringBuilder stringBuilder = new StringBuilder(string3.length());
            stringBuilder.append(string3.substring(0, n));
            stringBuilder.append(string2);
            stringBuilder.append(RhinoParser.checkAndReplaceCode(string, string2, string3.substring(n + string.length(), string3.length())));
            string3 = stringBuilder.toString();
        }
        return string3;
    }

    private void addStdObject(AcroRenderer acroRenderer) {
        Object object = Context.javaToJS((Object)new JpedalDefaultJavascript(this.scope, this.cx), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"util", (Object)object);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"app", (Object)object);
        Scriptable scriptable = this.cx.newObject(this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"global", (Object)scriptable);
        Scriptable scriptable2 = this.cx.newObject(this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"ADBE", (Object)scriptable2);
        object = Context.javaToJS((Object)new DisplayJavascriptActions(), (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"display", (Object)object);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"color", (Object)object);
        PdfLayerList pdfLayerList = acroRenderer.getActionHandler().getLayerHandler();
        if (pdfLayerList != null) {
            object = Context.javaToJS((Object)pdfLayerList, (Scriptable)this.scope);
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"layers", (Object)object);
        }
        object = Context.javaToJS((Object)acroRenderer, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"acro", (Object)object);
    }

    @Override
    public int addCode(String string) {
        this.functions = this.functions + RhinoParser.preParseCode(string);
        return 0;
    }

    public Object generateJStype(String string, boolean bl) {
        if (bl) {
            return this.cx.newObject(this.scope, "String", new Object[]{string});
        }
        if (string != null && !string.isEmpty() && StringUtils.isNumber(string) && (string.length() != 1 || string.indexOf(46) == -1)) {
            Double d = Double.valueOf(string);
            return this.cx.newObject(this.scope, "Number", new Object[]{d});
        }
        return this.cx.newObject(this.scope, "String", new Object[]{string});
    }

    @Override
    public int execute(FormObject formObject, int n, Object object, int n2, char c) {
        int n3;
        String string = (String)object;
        String[] stringArray = JSFunction.convertToArray(string);
        String string2 = stringArray[0];
        if (string2.startsWith("AF")) {
            n3 = this.handleAFCommands(formObject, string2, string, stringArray, n2, c);
        } else {
            this.executeFunctions(string, formObject, this.acro);
            n3 = 3;
        }
        if (n == 22) {
            this.calcualteEvent();
            n3 = 3;
        }
        return n3;
    }

    private void calcualteEvent() {
        Object[] objectArray;
        List list = this.acro.getCompData().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1);
        for (Object object : objectArray = list.toArray()) {
            FormObject formObject = (FormObject)object;
            String string = formObject.getObjectRefAsString();
            String string2 = formObject.getTextStreamValue(36);
            String string3 = (String)this.JSObj.getJavascriptCommand(string2 != null ? string2 : string, 4866);
            if (string3 == null) continue;
            this.execute(formObject, 4866, string3, 6, ' ');
        }
    }
}

