/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.Iterator;
import org.jpedal.parser.PdfStreamDecoder;

public class DecoderResults {
    private boolean imagesProcessedFully = true;
    private boolean hasNonEmbeddedCIDFonts;
    private boolean hasYCCKimages;
    private boolean pageSuccessful;
    private boolean ttHintingRequired;
    private Iterator colorSpacesUsed;
    private String nonEmbeddedCIDFonts = "";
    private boolean tooManyShapes;
    private boolean hasEmbeddedFonts;

    public boolean getImagesProcessedFully() {
        return this.imagesProcessedFully;
    }

    public void update(PdfStreamDecoder pdfStreamDecoder, boolean bl) {
        this.colorSpacesUsed = (Iterator)pdfStreamDecoder.getObjectValue(1);
        this.nonEmbeddedCIDFonts = (String)pdfStreamDecoder.getObjectValue(4);
        this.hasYCCKimages = pdfStreamDecoder.getBooleanValue(8);
        this.pageSuccessful = pdfStreamDecoder.getBooleanValue(1);
        this.imagesProcessedFully = pdfStreamDecoder.getBooleanValue(2);
        this.tooManyShapes = pdfStreamDecoder.getBooleanValue(64);
        this.hasNonEmbeddedCIDFonts = pdfStreamDecoder.getBooleanValue(4);
        this.ttHintingRequired = pdfStreamDecoder.getBooleanValue(32);
        if (bl) {
            this.hasEmbeddedFonts = pdfStreamDecoder.getBooleanValue(-1);
        }
    }

    public boolean getPageDecodeStatus(int n) {
        switch (n) {
            case 4: {
                return this.hasNonEmbeddedCIDFonts;
            }
            case 2: {
                return this.imagesProcessedFully;
            }
            case 1: {
                return this.pageSuccessful;
            }
            case 8: {
                return this.hasYCCKimages;
            }
            case 64: {
                return this.tooManyShapes;
            }
            case 32: {
                return this.ttHintingRequired;
            }
        }
        throw new RuntimeException("Unknown parameter " + n);
    }

    public Iterator getPageInfo(int n) {
        switch (n) {
            case 1: {
                return this.colorSpacesUsed;
            }
        }
        return null;
    }

    public String getPageDecodeStatusReport(int n) {
        if (n == 4) {
            return this.nonEmbeddedCIDFonts;
        }
        throw new RuntimeException("Unknown parameter");
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public void resetColorSpaces() {
        this.colorSpacesUsed = null;
    }
}

