/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.StringUtils;

public class PdfObjectCache {
    public static final int ColorspacesUsed = 1;
    public static final int Colorspaces = 2;
    public static final int ColorspacesObjects = 3;
    public static final int GlobalShadings = 4;
    public static final int LocalShadings = 5;
    private static final int initSize = 50;
    private final Map colorspacesUsed = new HashMap(50);
    private final Map colorspacesObjects = new HashMap(50);
    private Map colorspaces = new HashMap(50);
    private Map globalXObjects = new HashMap(50);
    private Map localXObjects = new HashMap(50);
    public final Map XObjectColorspaces = new HashMap(50);
    public final Map patterns = new HashMap(50);
    private final Map globalShadings = new HashMap(50);
    private Map localShadings = new HashMap(50);
    final Map imposedImages = new HashMap(50);
    public PdfObject groupObj;
    public Map unresolvedFonts = new HashMap(50);
    public Map directFonts = new HashMap(50);
    public Map resolvedFonts = new HashMap(50);
    Map GraphicsStates = new HashMap(50);

    public PdfObjectCache copy() {
        PdfObjectCache pdfObjectCache = new PdfObjectCache();
        pdfObjectCache.localShadings = this.localShadings;
        pdfObjectCache.unresolvedFonts = this.unresolvedFonts;
        pdfObjectCache.GraphicsStates = this.GraphicsStates;
        pdfObjectCache.directFonts = this.directFonts;
        pdfObjectCache.resolvedFonts = this.resolvedFonts;
        pdfObjectCache.colorspaces = this.colorspaces;
        pdfObjectCache.localXObjects = this.localXObjects;
        pdfObjectCache.globalXObjects = this.globalXObjects;
        pdfObjectCache.groupObj = this.groupObj;
        return pdfObjectCache;
    }

    public void put(int n, int n2, Object object) {
        switch (n) {
            case 1: {
                this.colorspacesUsed.put(n2, object);
                break;
            }
            case 3: {
                this.colorspacesObjects.put(n2, object);
            }
        }
    }

    public void put(int n, String string, Object object) {
        switch (n) {
            case 1: {
                this.colorspacesUsed.put(string, object);
                break;
            }
            case 3: {
                this.colorspacesObjects.put(string, object);
            }
        }
    }

    public boolean containsKey(int n, Object object) {
        boolean bl = true;
        switch (n) {
            case 3: {
                bl = this.colorspacesObjects.containsKey(n);
            }
        }
        return bl;
    }

    public Iterator iterator(int n) {
        Iterator iterator = null;
        switch (n) {
            case 1: {
                iterator = this.colorspacesUsed.keySet().iterator();
                break;
            }
            case 3: {
                iterator = this.colorspacesObjects.keySet().iterator();
            }
        }
        return iterator;
    }

    public Object get(int n, Object object) {
        Object var3_3 = null;
        switch (n) {
            case 1: {
                var3_3 = this.colorspacesUsed.get(object);
                break;
            }
            case 2: {
                var3_3 = this.colorspaces.get(object);
                break;
            }
            case 3: {
                var3_3 = this.colorspacesObjects.get(object);
                break;
            }
            case 4: {
                var3_3 = this.globalShadings.get(object);
                break;
            }
            case 5: {
                var3_3 = this.localShadings.get(object);
            }
        }
        return var3_3;
    }

    public void resetFonts() {
        this.resolvedFonts.clear();
        this.unresolvedFonts.clear();
        this.directFonts.clear();
    }

    public PdfObject getXObjects(String string) {
        PdfObject pdfObject = (PdfObject)this.localXObjects.get(string);
        if (pdfObject == null) {
            pdfObject = (PdfObject)this.globalXObjects.get(string);
        }
        return pdfObject;
    }

    public void readResources(PdfObject pdfObject, boolean bl) throws PdfException {
        String[] stringArray = new String[]{"ColorSpace", "ExtGState", "Font", "Pattern", "Shading", "XObject"};
        int[] nArray = new int[]{2087749783, -1938465939, 373243460, 1146450818, 878474856, 979194486};
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] == 373243460 || nArray[i] == 979194486) {
                this.readArrayPairs(pdfObject, bl, nArray[i]);
                continue;
            }
            this.readArrayPairs(pdfObject, false, nArray[i]);
        }
    }

    private void readArrayPairs(PdfObject pdfObject, boolean bl, int n) {
        PdfObject pdfObject2;
        if (pdfObject != null && (pdfObject2 = pdfObject.getDictionary(n)) != null) {
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                String string = pdfKeyPairsIterator.getNextKeyAsString();
                String string2 = pdfKeyPairsIterator.getNextValueAsString();
                PdfObject pdfObject3 = pdfKeyPairsIterator.getNextValueAsDictionary();
                if (pdfObject.isDataExternal()) {
                    if (pdfObject3 == null && string2 == null) {
                        pdfObject.setFullyResolved(false);
                        return;
                    }
                    if (pdfObject3 == null) {
                        PdfObject pdfObject4 = ObjectFactory.createObject(n, string2, n, -1);
                        pdfObject4.setStatus(2);
                        pdfObject4.setUnresolvedData(StringUtils.toBytes(string2), n);
                        if (n == 373243460) {
                            this.directFonts.put(string, pdfObject4);
                        }
                    }
                }
                switch (n) {
                    case 2087749783: {
                        this.colorspaces.put(string, pdfObject3);
                        break;
                    }
                    case -1938465939: {
                        this.GraphicsStates.put(string, pdfObject3);
                        break;
                    }
                    case 373243460: {
                        this.unresolvedFonts.put(string, pdfObject3);
                        break;
                    }
                    case 1146450818: {
                        this.patterns.put(string, pdfObject3);
                        break;
                    }
                    case 878474856: {
                        if (bl) {
                            this.globalShadings.put(string, pdfObject3);
                            break;
                        }
                        this.localShadings.put(string, pdfObject3);
                        break;
                    }
                    case 979194486: {
                        if (bl) {
                            this.globalXObjects.put(string, pdfObject3);
                            break;
                        }
                        this.localXObjects.put(string, pdfObject3);
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
        }
    }

    public void reset(PdfObjectCache pdfObjectCache) {
        this.localShadings = new HashMap(50);
        this.resolvedFonts = new HashMap(50);
        this.unresolvedFonts = new HashMap(50);
        this.directFonts = new HashMap(50);
        this.colorspaces = new HashMap(50);
        this.GraphicsStates = new HashMap(50);
        this.localXObjects = new HashMap(50);
        for (Object k : pdfObjectCache.GraphicsStates.keySet()) {
            this.GraphicsStates.put(k, pdfObjectCache.GraphicsStates.get(k));
        }
        for (Object k : pdfObjectCache.colorspaces.keySet()) {
            this.colorspaces.put(k, pdfObjectCache.colorspaces.get(k));
        }
        for (Object k : pdfObjectCache.localXObjects.keySet()) {
            this.localXObjects.put(k, pdfObjectCache.localXObjects.get(k));
        }
        for (Object k : pdfObjectCache.globalXObjects.keySet()) {
            this.globalXObjects.put(k, pdfObjectCache.globalXObjects.get(k));
        }
        if (this.unresolvedFonts.isEmpty()) {
            for (Object k : pdfObjectCache.unresolvedFonts.keySet()) {
                this.unresolvedFonts.put(k, pdfObjectCache.unresolvedFonts.get(k));
            }
        }
    }

    public void restore(PdfObjectCache pdfObjectCache) {
        this.directFonts = pdfObjectCache.directFonts;
        this.unresolvedFonts = pdfObjectCache.unresolvedFonts;
        this.resolvedFonts = pdfObjectCache.resolvedFonts;
        this.GraphicsStates = pdfObjectCache.GraphicsStates;
        this.colorspaces = pdfObjectCache.colorspaces;
        this.localShadings = pdfObjectCache.localShadings;
        this.localXObjects = pdfObjectCache.localXObjects;
        this.globalXObjects = pdfObjectCache.globalXObjects;
        this.groupObj = pdfObjectCache.groupObj;
    }

    public void setImposedKey(String string, int n) {
        if (this.imposedImages != null) {
            this.imposedImages.put(string, n);
        }
    }
}

