/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.gs;

import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.TextState;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Object;

public class GraphicsStates {
    private boolean isStackInitialised;
    private Vector_Object graphicsStateStack;
    private Vector_Object strokeColorStateStack;
    private Vector_Object nonstrokeColorStateStack;
    private Vector_Object textStateStack;
    int depth;
    ParserOptions parserOptions = new ParserOptions();

    public GraphicsStates(ParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    public void pushGraphicsState(GraphicsState graphicsState, DynamicVectorRenderer dynamicVectorRenderer) {
        if (!this.isStackInitialised) {
            this.isStackInitialised = true;
            this.graphicsStateStack = new Vector_Object(10);
            this.textStateStack = new Vector_Object(10);
            this.strokeColorStateStack = new Vector_Object(20);
            this.nonstrokeColorStateStack = new Vector_Object(20);
        }
        ++this.depth;
        this.graphicsStateStack.push(graphicsState.clone());
        this.textStateStack.push(graphicsState.getTextState().clone());
        this.nonstrokeColorStateStack.push(graphicsState.nonstrokeColorSpace.clone());
        this.strokeColorStateStack.push(graphicsState.strokeColorSpace.clone());
        dynamicVectorRenderer.resetOnColorspaceChange();
    }

    public GraphicsState restoreGraphicsState(GraphicsState graphicsState, DynamicVectorRenderer dynamicVectorRenderer) {
        if (!this.isStackInitialised) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No GraphicsState saved to retrieve");
            }
            graphicsState = new GraphicsState();
            graphicsState.setTextState(new TextState());
        } else if (this.depth > 0) {
            --this.depth;
            graphicsState = (GraphicsState)this.graphicsStateStack.pull();
            graphicsState.setTextState((TextState)this.textStateStack.pull());
            graphicsState.strokeColorSpace = (GenericColorSpace)this.strokeColorStateStack.pull();
            graphicsState.nonstrokeColorSpace = (GenericColorSpace)this.nonstrokeColorStateStack.pull();
            if (graphicsState.strokeColorSpace.getID() == -2073385820) {
                graphicsState.strokeColorSpace.restoreColorStatus();
            }
            if (graphicsState.nonstrokeColorSpace.getID() == -2073385820) {
                graphicsState.nonstrokeColorSpace.restoreColorStatus();
            }
        }
        if (this.parserOptions.isRenderPage()) {
            dynamicVectorRenderer.drawClip(graphicsState, this.parserOptions.defaultClip, false);
            dynamicVectorRenderer.resetOnColorspaceChange();
            dynamicVectorRenderer.drawFillColor(graphicsState.getNonstrokeColor());
            dynamicVectorRenderer.drawStrokeColor(graphicsState.getStrokeColor());
            dynamicVectorRenderer.setGraphicsState(2, graphicsState.getAlpha(2), graphicsState.getBMValue());
            dynamicVectorRenderer.setGraphicsState(1, graphicsState.getAlpha(1), graphicsState.getBMValue());
        }
        return graphicsState;
    }

    public int getDepth() {
        return this.depth;
    }

    public void correctDepth(int n, GraphicsState graphicsState, DynamicVectorRenderer dynamicVectorRenderer) {
        while (this.depth > n) {
            this.restoreGraphicsState(graphicsState, dynamicVectorRenderer);
        }
    }
}

