/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.FunctionFactory;
import org.jpedal.function.PDFFunction;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;

public class ImageCommands {
    public static final int ID = 0;
    public static final int XOBJECT = 2;
    static boolean sharpenDownsampledImages;
    public static boolean trackImages;
    public static boolean rejectSuperimposedImages;

    static BufferedImage makeBlackandWhiteTransparent(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        boolean bl = false;
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{255, 0, 0, 0};
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl2;
                writableRaster.getPixels(j, i, 1, 1, nArray);
                boolean bl3 = nArray[0] > 245 && nArray[1] > 245 && nArray[2] > 245;
                boolean bl4 = bl2 = nArray[0] < 10 && nArray[1] < 10 && nArray[2] < 10;
                if (bl3 || bl2) {
                    bufferedImage2.getRaster().setPixels(j, i, 1, 1, nArray2);
                    continue;
                }
                bl = true;
                int[] nArray3 = new int[4];
                nArray3[3] = 255;
                nArray3[0] = nArray[0];
                nArray3[1] = nArray[1];
                nArray3[2] = nArray[2];
                bufferedImage2.getRaster().setPixels(j, i, 1, 1, nArray3);
            }
        }
        if (bl) {
            return bufferedImage2;
        }
        return null;
    }

    static BufferedImage simulateOP(BufferedImage bufferedImage, boolean bl) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage = ColorSpaceConvertor.convertToARGB(bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl2 = false;
        int[] nArray = new int[]{255, 0, 0, 0};
        int[] nArray2 = new int[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                boolean bl3;
                writableRaster.getPixel(j, i, nArray2);
                if (bl) {
                    bl3 = nArray2[0] > 243 && nArray2[1] > 243 && nArray2[2] > 243;
                } else {
                    boolean bl4 = bl3 = nArray2[1] < 3 && nArray2[2] < 3 && nArray2[3] < 3;
                }
                if (bl3) {
                    bufferedImage.getRaster().setPixel(j, i, nArray);
                    continue;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            return bufferedImage;
        }
        return null;
    }

    static void getMaskColor(byte[] byArray, GraphicsState graphicsState) {
        int n = graphicsState.nonstrokeColorSpace.getColor().getRGB();
        byArray[0] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n & 0xFF);
    }

    static boolean isRepeatingLine(byte[] byArray, int n) {
        if (byArray.length % n != 0) {
            return false;
        }
        int n2 = byArray.length / n;
        for (int i = 0; i < byArray.length / n - 1; ++i) {
            for (int j = n2; j < byArray.length - 1; j += n2) {
                if (byArray[i] == byArray[j]) continue;
                return false;
            }
        }
        return true;
    }

    static BufferedImage simulateOverprint(GenericColorSpace genericColorSpace, byte[] byArray, boolean bl, boolean bl2, BufferedImage bufferedImage, int n, DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        if ((n == 1498837125 || n == 1247168582) && graphicsState.getOPM() == 1.0f) {
            boolean bl3 = false;
            byte[] byArray2 = genericColorSpace.getIndexedMap();
            if (byArray2 == null && dynamicVectorRenderer.hasObjectsBehind(graphicsState.CTM)) {
                bl3 = true;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 0) continue;
                    i = byArray.length;
                    bl3 = false;
                }
            }
            if (bl3) {
                bufferedImage.flush();
                bufferedImage = null;
            } else if (graphicsState.getNonStrokeOP()) {
                if (bl || bl2) {
                    bufferedImage = ImageCommands.simulateOP(bufferedImage, false);
                } else if (graphicsState.getNonStrokeOP()) {
                    bufferedImage = n == 1498837125 ? ImageCommands.simulateOP(bufferedImage, false) : ImageCommands.simulateOP(bufferedImage, bufferedImage.getType() == 1);
                }
            }
        }
        return bufferedImage;
    }

    static BufferedImage addBackgroundToMask(BufferedImage bufferedImage, boolean bl) {
        if (bl) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        return bufferedImage;
    }

    static BufferedImage applyTR(BufferedImage bufferedImage, PdfObject pdfObject, PdfObjectReader pdfObjectReader) {
        Object object;
        PDFFunction[] pDFFunctionArray = new PDFFunction[4];
        boolean bl = false;
        int n = 0;
        byte[][] byArray = pdfObject.getKeyArray(9250);
        if (byArray != null) {
            n = byArray.length;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == null) continue;
            object = new String(byArray[i]);
            FunctionObject functionObject = new FunctionObject((String)object);
            byte[] byArray2 = byArray[i];
            if (byArray2 != null && byArray2.length > 4 && byArray2[0] == 47 && byArray2[1] == 73 && byArray2[2] == 100 && byArray2[3] == 101) {
                functionObject = null;
            } else {
                pdfObjectReader.readObject(functionObject);
            }
            if (functionObject == null) continue;
            pDFFunctionArray[i] = FunctionFactory.getFunction(functionObject, pdfObjectReader);
            bl = true;
        }
        if (!bl) {
            return bufferedImage;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        object = new int[4];
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                writableRaster.getPixels(j, i, 1, 1, (int[])object);
                for (int k = 0; k < 3; ++k) {
                    float[] fArray = new float[]{(float)object[k] / 255.0f};
                    if (pDFFunctionArray[k] == null) continue;
                    float[] fArray2 = pDFFunctionArray[k].compute(fArray);
                    object[k] = (int)(255.0f * fArray2[0]);
                }
                bufferedImage.getRaster().setPixels(j, i, 1, 1, (int[])object);
            }
        }
        return bufferedImage;
    }

    static void applyDecodeArray(byte[] byArray, int n, float[] fArray, int n2) {
        block17: {
            int n3;
            int n4;
            int n5;
            block16: {
                n5 = fArray.length;
                n4 = 0;
                for (float f : fArray) {
                    if (!((float)n4 < f)) continue;
                    n4 = (int)f;
                }
                boolean bl = true;
                int n6 = fArray.length;
                for (n3 = 0; n3 < n6; n3 += 2) {
                    if (fArray[n3] == 0.0f && (fArray[n3 + 1] == 1.0f || fArray[n3 + 1] == 255.0f)) continue;
                    bl = false;
                    n3 = n6;
                }
                if (bl) {
                    return;
                }
                if (n != 1) break block16;
                if (!(fArray[0] > fArray[1])) break block17;
                n3 = byArray.length;
                for (int i = 0; i < n3; ++i) {
                    byArray[i] = ~byArray[i];
                }
                break block17;
            }
            if (n == 8 && n4 > 1 && (n2 == 1785221209 || n2 == 1008872003 || n2 == 1498837125)) {
                n3 = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    int n7 = byArray[i] & 0xFF;
                    if ((float)n7 < fArray[n3]) {
                        n7 = (int)fArray[n3];
                    } else if ((float)n7 > fArray[n3 + 1]) {
                        n7 = (int)fArray[n3 + 1];
                    }
                    if ((n3 += 2) == fArray.length) {
                        n3 = 0;
                    }
                    byArray[i] = (byte)n7;
                }
            } else {
                n4 = n << 1;
                n3 = n4 - 1;
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 1;
                    for (int j = 7; j > -1; --j) {
                        int n12 = by >> j & 1;
                        if ((n12 = (int)(fArray[n10] + (float)n12 * ((fArray[n11] - fArray[n10]) / (float)n3))) > n4) {
                            n12 = n4;
                        }
                        if (n12 < 0) {
                            n12 = 0;
                        }
                        n12 = (n12 & 1) << j;
                        n9 += n12;
                        if ((n8 += 2) == n5) {
                            n8 = 0;
                            n10 = 0;
                            n11 = 1;
                            continue;
                        }
                        n10 += 2;
                        n11 += 2;
                    }
                    byArray[i] = (byte)n9;
                }
            }
        }
    }

    static boolean isExtractionAllowed(PdfObjectReader pdfObjectReader) {
        PdfFileReader pdfFileReader = pdfObjectReader.getObjectReader();
        DecryptionFactory decryptionFactory = pdfFileReader.getDecryptionObject();
        return decryptionFactory == null || decryptionFactory.getBooleanValue(103);
    }

    static {
        String string;
        String string2;
        rejectSuperimposedImages = true;
        String string3 = System.getProperty("org.jpedal.rejectsuperimposedimages");
        if (string3 != null) {
            rejectSuperimposedImages = string3.toLowerCase().contains("true");
        }
        if ((string2 = System.getProperty("org.jpedal.trackImages")) != null) {
            trackImages = string2.toLowerCase().contains("true");
        }
        if ((string = System.getProperty("org.jpedal.sharpendownsampledimages")) != null) {
            sharpenDownsampledImages = string.toLowerCase().contains("true");
        }
    }
}

