/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ImageDataHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.images.ImageOps;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.BinaryImage;
import org.jpedal.parser.image.EightBitDownSampler;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.IndexedImage;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.MaskDataDecoder;
import org.jpedal.parser.image.MaskDecoder;
import org.jpedal.parser.image.OneBitDownSampler;
import org.jpedal.parser.image.OneBitImage;
import org.jpedal.parser.image.SMaskDecoder;
import org.jpedal.parser.image.ThreeComponentImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.utils.ArrayUtils;
import org.jpedal.parser.image.utils.ConvertImageToShape;
import org.jpedal.parser.image.utils.ConvertMaskToImage;
import org.jpedal.parser.image.utils.ConvertMaskToShape;
import org.jpedal.parser.image.utils.JPegImageDecoder;
import org.jpedal.render.RenderUtils;
import org.jpedal.utils.LogWriter;

public class ImageDecoder
extends BaseDecoder {
    public static boolean allowPrintTransparency;
    final PdfImageData pdfImages;
    private boolean getSamplingOnly;
    boolean isMask = true;
    String imagesInFile;
    PdfObjectCache cache;
    boolean isPrinting;
    final ImageHandler customImageHandler;
    boolean useHiResImageForDisplay;
    boolean isType3Font;
    final int formLevel;
    final PdfPageData pageData;
    final ObjectStore objectStoreStreamRef;
    boolean clippedImagesExtracted = true;
    private boolean extractRawCMYK;
    boolean finalImagesExtracted = true;
    boolean createScaledVersion = true;
    boolean renderImages;
    boolean rawImagesExtracted = true;
    int optionsApplied;
    String currentImage = "";
    final String formName;
    final ErrorTracker errorTracker;
    final PdfObjectReader currentPdfFile;
    public final int imageCount;

    public ImageDecoder(int n, PdfObjectReader pdfObjectReader, ErrorTracker errorTracker, ImageHandler imageHandler, ObjectStore objectStore, PdfImageData pdfImageData, int n2, PdfPageData pdfPageData, String string, String string2) {
        this.imageCount = n;
        this.currentPdfFile = pdfObjectReader;
        this.errorTracker = errorTracker;
        this.formName = string2;
        this.customImageHandler = imageHandler;
        this.objectStoreStreamRef = objectStore;
        this.pdfImages = pdfImageData;
        this.formLevel = n2;
        this.pageData = pdfPageData;
        this.imagesInFile = string;
    }

    private GenericColorSpace setupXObjectColorspace(PdfObject pdfObject, ImageData imageData) {
        Object object;
        byte[] byArray;
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        PdfObject pdfObject2 = pdfObject.getDictionary(2087749783);
        GenericColorSpace genericColorSpace = new DeviceRGBColorSpace();
        if (pdfObject2 != null) {
            genericColorSpace = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, pdfObject2, this.cache.XObjectColorspaces);
            genericColorSpace.setPrinting(this.isPrinting);
            this.cache.put(1, genericColorSpace.getID(), (Object)"x");
            if (n3 == 1 && genericColorSpace.getID() == 1785221209 && pdfObject.getDictionary(489767739) == null) {
                byArray = genericColorSpace.getIndexedMap();
                if (genericColorSpace.getIndexedMap() == null || byArray.length == 6 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0) {
                    genericColorSpace = new DeviceGrayColorSpace();
                }
            }
        }
        byArray = genericColorSpace.getIndexedMap();
        if (n3 == 8) {
            int[] nArray;
            PdfObject pdfObject3;
            object = imageData.getObjectData();
            if (byArray != null && genericColorSpace.getID() == 1785221209 && n * n2 == ((byte[])object).length && (pdfObject3 = pdfObject.getDictionary(489767739)) != null && (nArray = pdfObject3.getIntArray(489767739)) != null && nArray.length == 2 && nArray[0] == 255 && nArray[0] == nArray[1] && genericColorSpace.getIndexedMap() != null && genericColorSpace.getIndexedMap().length == 768) {
                boolean bl = true;
                for (int i = 0; i < 768; ++i) {
                    if (byArray[i] == 0) continue;
                    bl = false;
                    i = 768;
                }
                if (bl) {
                    genericColorSpace = new DeviceGrayColorSpace();
                }
            }
        }
        if ((object = (Object)pdfObject.getDictionary(1888135062)) != null) {
            genericColorSpace.setDecodeParms((PdfObject)object);
        }
        return genericColorSpace;
    }

    public BufferedImage processImageXObject(PdfObject pdfObject, String string, byte[] byArray, boolean bl, String string2) throws PdfException {
        BufferedImage bufferedImage = null;
        string = this.parserOptions.getFileName() + '-' + string;
        PdfObject pdfObject2 = pdfObject.getDictionary(489767774);
        PdfObject pdfObject3 = pdfObject.getDictionary(489767739);
        ImageData imageData = new ImageData(pdfObject, byArray, 2);
        imageData.getFilter(pdfObject);
        GenericColorSpace genericColorSpace = this.setupXObjectColorspace(pdfObject, imageData);
        imageData.setCompCount(genericColorSpace.getColorSpace().getNumComponents());
        byte[] byArray2 = pdfObject.getConvertedData();
        if (byArray2 != null) {
            byArray = byArray2;
            genericColorSpace = new DeviceRGBColorSpace();
            imageData = null;
        } else if (!(pdfObject2 == null && pdfObject3 == null || pdfObject2 != null && pdfObject.getInt(959726687) == 1 && pdfObject.getInt(959926393) == 1 && pdfObject.getInt(-1344207655) == 8)) {
            if (imageData.isDCT()) {
                byArray = JPEGDecoder.getBytesFromJPEG(byArray, genericColorSpace, pdfObject);
                imageData.setObjectData(byArray);
                pdfObject.setMixedArray(1011108731, null);
                pdfObject.setDecodedStream(byArray);
            } else if (imageData.isJPX()) {
                byArray = JPeg2000ImageDecoder.getBytesFromJPEG2000(byArray, genericColorSpace, pdfObject);
                imageData.setObjectData(byArray);
                pdfObject.setMixedArray(1011108731, null);
                pdfObject.setDecodedStream(byArray);
                genericColorSpace = new DeviceRGBColorSpace();
            }
            if (pdfObject2 != null) {
                ImageData imageData2 = new ImageData(pdfObject2, null, 2);
                imageData2.getFilter(pdfObject2);
                GenericColorSpace genericColorSpace2 = this.setupXObjectColorspace(pdfObject2, imageData2);
                byte[] byArray3 = this.currentPdfFile.readStream(pdfObject2, true, true, false, false, false, pdfObject2.getCacheName(this.currentPdfFile.getObjectReader()));
                return SMaskDecoder.applyJPX_JBIG_Smask(imageData, imageData2, byArray3, pdfObject, pdfObject2, genericColorSpace, genericColorSpace2);
            }
            byte[] byArray4 = genericColorSpace.getIndexedMap();
            int[] nArray = pdfObject3.getIntArray(489767739);
            if (byArray4 != null) {
                byArray4 = genericColorSpace.convertIndexToRGB(byArray4);
                if (nArray != null) {
                    return ImageDecoder.geIndexedMaskImage(byArray4, imageData, nArray);
                }
                byArray = ColorSpaceConvertor.convertIndexToRGBByte(byArray4, imageData.getWidth(), imageData.getHeight(), imageData.getCompCount(), imageData.getDepth(), byArray, false, false);
                genericColorSpace = new DeviceRGBColorSpace();
                imageData.setObjectData(byArray);
                genericColorSpace.setIndex(null, 0);
            }
            ImageData imageData3 = new ImageData(pdfObject3, byArray, 2);
            if (nArray != null) {
                return MaskDataDecoder.applyMaskArray(imageData, nArray);
            }
            byte[] byArray5 = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false, pdfObject3.getCacheName(this.currentPdfFile.getObjectReader()));
            byArray5 = MaskDataDecoder.getSMaskData(byArray5, imageData3, pdfObject3, this.setupXObjectColorspace(pdfObject3, imageData3));
            byArray = MaskDecoder.applyMask(imageData, genericColorSpace, pdfObject3, pdfObject, byArray5);
            pdfObject.setConvertedData(byArray);
            genericColorSpace = new DeviceRGBColorSpace();
            pdfObject.setDictionary(489767739, null);
            imageData = null;
        }
        if (imageData == null) {
            imageData = new ImageData(pdfObject, byArray, 2);
            genericColorSpace = new DeviceRGBColorSpace(true);
            imageData.setCompCount(4);
            pdfObject2 = null;
        }
        this.isMask = pdfObject.getBoolean(1516403337);
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Processing XObject: " + string + ' ' + pdfObject.getObjectRefAsString() + " width=" + imageData.getWidth() + " Height=" + imageData.getHeight() + " Depth=" + imageData.getDepth() + " colorspace=" + genericColorSpace);
        }
        if (this.customImageHandler != null && !(this.customImageHandler instanceof ImageDataHandler)) {
            bufferedImage = this.customImageHandler.processImageData(this.gs, pdfObject);
        }
        if (pdfObject2 != null && pdfObject.getInt(959726687) == 1 && pdfObject.getInt(959926393) == 1 && pdfObject.getInt(-1344207655) == 8) {
            bufferedImage = ConvertMaskToImage.convert(pdfObject2, this.currentPdfFile);
        } else if (this.customImageHandler == null || bufferedImage == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            bufferedImage = this.processImage(genericColorSpace, string, imageData, this.isMask, pdfObject, bl);
        }
        if (ImageCommands.trackImages && bufferedImage != null && string2 != null) {
            this.setImageInfo(imageData, string2, genericColorSpace, bufferedImage);
        }
        return bufferedImage;
    }

    private static BufferedImage geIndexedMaskImage(byte[] byArray, ImageData imageData, int[] nArray) {
        int n;
        int n2 = imageData.getDepth();
        int n3 = 0;
        int n4 = 0;
        boolean[] blArray = new boolean[1 << n2];
        for (int i = 0; i < nArray.length; i += 2) {
            n = nArray[i];
            int n5 = nArray[i + 1];
            if (n == n5) {
                blArray[n] = true;
                continue;
            }
            for (int j = n; j < n5; ++j) {
                blArray[j] = true;
            }
        }
        int[] nArray2 = new int[byArray.length / 3];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0xFF000000 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
        }
        BitReader bitReader = new BitReader(imageData.getObjectData(), n2 < 8);
        BufferedImage bufferedImage = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] nArray3 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n6 = imageData.getWidth() * imageData.getHeight();
        int n7 = imageData.getWidth();
        int n8 = 0;
        for (int i = 0; i < n6; ++i) {
            int n9 = bitReader.getPositive(n2);
            if (!blArray[n9]) {
                nArray3[n3++] = nArray2[n9];
            } else {
                ++n3;
            }
            if (++n8 != n7) continue;
            int n10 = 8 - bitReader.getPointer() % 8;
            n8 = 0;
            if (n10 == 8) continue;
            bitReader.getPositive(n10);
        }
        return bufferedImage;
    }

    private void setImageInfo(ImageData imageData, String string, GenericColorSpace genericColorSpace, BufferedImage bufferedImage) {
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        float f = this.gs.CTM[0][0];
        if (f == 0.0f) {
            f = this.gs.CTM[0][1];
        }
        if (f < 0.0f) {
            f = -f;
        }
        f = (int)((float)n / f * 100.0f);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" w=");
        stringBuilder.append(n);
        stringBuilder.append(" h=");
        stringBuilder.append(n2);
        stringBuilder.append(' ');
        stringBuilder.append((int)f);
        stringBuilder.append(' ');
        stringBuilder.append(ColorSpaces.IDtoString(genericColorSpace.getID()));
        stringBuilder.append(" (");
        stringBuilder.append(bufferedImage.getWidth());
        stringBuilder.append(' ');
        stringBuilder.append(bufferedImage.getHeight());
        stringBuilder.append(" type=");
        stringBuilder.append(bufferedImage.getType());
        stringBuilder.append(')');
        if (this.imagesInFile.isEmpty()) {
            this.imagesInFile = stringBuilder.toString();
        } else {
            stringBuilder.append('\n');
            stringBuilder.append(this.imagesInFile);
            this.imagesInFile = stringBuilder.toString();
        }
    }

    public void setSamplingOnly(boolean bl) {
        this.getSamplingOnly = bl;
    }

    public String getImagesInFile() {
        return this.imagesInFile;
    }

    public void setParameters(boolean bl, int n, int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.isPrinting = bl2;
        this.isType3Font = bl3;
        this.useHiResImageForDisplay = bl4;
        this.renderImages = bl && (n & 2) == 2;
        this.finalImagesExtracted = (n2 & 4) == 4;
        this.extractRawCMYK = (n2 & 0x80) == 128;
        this.clippedImagesExtracted = (n2 & 0x20) == 32;
        this.rawImagesExtracted = (n2 & 2) == 2;
        this.createScaledVersion = this.finalImagesExtracted || this.renderImages;
        String string = System.getProperty("org.jpedal.printTransparency");
        if (string != null) {
            allowPrintTransparency = bl2 && string.equalsIgnoreCase("true");
        }
    }

    public void generateTransformedImage(BufferedImage bufferedImage, String string) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (bufferedImage != null) {
            String string2;
            boolean bl;
            ImageTransformerDouble imageTransformerDouble = null;
            boolean bl2 = this.current.isHTMLorSVG();
            if (bl2) {
                this.current.drawImage(this.parserOptions.getPageNumber(), bufferedImage, this.gs, false, string, this.optionsApplied, -3);
            }
            int n = this.pageData.getRotation(this.parserOptions.getPageNumber());
            boolean bl3 = bl = bl2 && ((this.optionsApplied & 2) == 2 || this.useHiResImageForDisplay && n == 90);
            if (!bl) {
                if (!bl2) {
                    imageTransformerDouble = new ImageTransformerDouble(this.gs, bufferedImage, this.createScaledVersion, 1.0f, n);
                }
                if (imageTransformerDouble != null) {
                    imageTransformerDouble.doubleScaleTransformShear();
                    bufferedImage = imageTransformerDouble.getImage();
                }
            }
            if (!bl2) {
                string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                if (string2 == null) {
                    string2 = "tif";
                }
                BufferedImage bufferedImage2 = bufferedImage;
                if (this.isMask) {
                    int n2 = this.gs.nonstrokeColorSpace.getColor().getRGB();
                    int[] nArray = new int[]{n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF, 255};
                    BufferedImage bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                    WritableRaster writableRaster = bufferedImage2.getRaster();
                    WritableRaster writableRaster2 = bufferedImage3.getRaster();
                    int[] nArray2 = new int[4];
                    for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
                        for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                            writableRaster.getPixel(j, i, nArray2);
                            if (nArray2[3] <= 2) continue;
                            writableRaster2.setPixel(j, i, nArray);
                        }
                    }
                    bufferedImage2 = bufferedImage3;
                }
                if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, bufferedImage2, false, false, string2)) {
                    this.errorTracker.addPageFailureMessage("Problem saving " + bufferedImage);
                }
            }
            if (bl2) {
                if (bufferedImage != null) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    this.current.drawImage(this.parserOptions.getPageNumber(), bufferedImage, this.gs, false, string, this.optionsApplied, -2);
                }
            } else {
                if (this.finalImagesExtracted || this.renderImages) {
                    imageTransformerDouble.doubleScaleTransformScale();
                }
                imageTransformerDouble.completeImage();
                f = imageTransformerDouble.getImageX();
                f2 = imageTransformerDouble.getImageY();
                float f3 = imageTransformerDouble.getImageW();
                float f4 = imageTransformerDouble.getImageH();
                bufferedImage = imageTransformerDouble.getImage();
                if (bufferedImage != null) {
                    if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
                        this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), f, f2, f3, f4);
                    }
                    if (this.renderImages || !this.parserOptions.isPageContent()) {
                        this.gs.x = f;
                        this.gs.y = f2;
                        this.current.drawImage(this.parserOptions.getPageNumber(), bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                    }
                    if (!this.parserOptions.renderDirectly() && this.parserOptions.isPageContent() && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                        string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                        if (string2 == null) {
                            string2 = "jpg";
                        }
                        this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, false, string2);
                    }
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    public void generateTransformedImageSingle(BufferedImage bufferedImage, String string) {
        if (bufferedImage != null) {
            boolean bl;
            Area area = this.gs.getClippingShape();
            ImageTransformer imageTransformer = new ImageTransformer(this.gs, bufferedImage, true);
            float f = imageTransformer.getImageX();
            float f2 = imageTransformer.getImageY();
            float f3 = imageTransformer.getImageW();
            float f4 = imageTransformer.getImageH();
            bufferedImage = imageTransformer.getImage();
            if (bufferedImage != null && this.customImageHandler != null && area != null && area.getBounds().getWidth() > 1.0 && area.getBounds().getHeight() > 1.0 && !this.customImageHandler.imageHasBeenScaled() && !(bl = area.contains(f, f2, f3, f4))) {
                imageTransformer.clipImage(area);
                f = imageTransformer.getImageX();
                f2 = imageTransformer.getImageY();
                f3 = imageTransformer.getImageW();
                f4 = imageTransformer.getImageH();
            }
            if ((bufferedImage = imageTransformer.getImage()) != null) {
                if (this.finalImagesExtracted || this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), f, f2, f3, f4);
                }
                if (this.renderImages || !this.parserOptions.isPageContent()) {
                    this.gs.x = f;
                    this.gs.y = f2;
                    this.current.drawImage(this.parserOptions.getPageNumber(), bufferedImage, this.gs, false, string, this.optionsApplied, -1);
                }
                if (this.parserOptions.isPageContent() && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                    String string2 = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, false, string2);
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    BufferedImage processImage(GenericColorSpace genericColorSpace, String string, ImageData imageData, boolean bl, PdfObject pdfObject, boolean bl2) throws PdfException {
        this.cache.put(1, genericColorSpace.getID(), (Object)"x");
        int n = imageData.getDepth();
        int n2 = 1;
        float[] fArray = pdfObject.getFloatArray(859785322);
        boolean bl3 = ArrayUtils.isArrayInverted(fArray);
        PdfArrayIterator pdfArrayIterator = imageData.getFilter(pdfObject);
        boolean bl4 = false;
        BufferedImage bufferedImage = null;
        if (this.customImageHandler instanceof ImageDataHandler) {
            bufferedImage = this.customImageHandler.processImageData(this.gs, pdfObject);
        }
        byte[] byArray = new byte[4];
        if (bl) {
            ImageCommands.getMaskColor(byArray, this.gs);
        }
        if (this.parserOptions.isRenderPage() && this.streamType != 1 && !this.current.avoidDownSamplingImage()) {
            this.setDownsampledImageSize(imageData, pdfObject, this.multiplyer, genericColorSpace);
        }
        if (!(!this.parserOptions.isRenderPage() || genericColorSpace.getID() == 1247168582 || !bl3 && fArray != null && fArray.length != 0 || imageData.getDepth() != 1 && imageData.getDepth() != 8 || imageData.getpX() <= 0 || imageData.getpY() <= 0 || !SamplingFactory.isPrintDownsampleEnabled && this.isPrinting || (n2 = this.setSampling(imageData, genericColorSpace)) <= 1 || !(this.multiplyer > 1.0f))) {
            n2 = (int)((float)n2 / this.multiplyer);
        }
        if (this.getSamplingOnly) {
            int n3 = imageData.getWidth();
            int n4 = imageData.getHeight();
            if (imageData.getpX() > 0 && imageData.getpY() > 0) {
                float f;
                float f2 = (float)n3 / (float)imageData.getpX();
                if (f2 < (f = (float)n4 / (float)imageData.getpY())) {
                    this.parserOptions.setSamplingUsed(f2);
                } else {
                    this.parserOptions.setSamplingUsed(f);
                }
            }
            return null;
        }
        byte[] byArray2 = genericColorSpace.getIndexedMap();
        if (n2 > 1) {
            bl4 = true;
            boolean bl5 = false;
            if (bl && imageData.getWidth() > 2000 && imageData.getHeight() > 2000 && imageData.getDepth() == 1 && genericColorSpace.getID() == 1785221209 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[1][1] > 0.0f) {
                bl5 = true;
            }
            if (imageData.getDepth() == 1 && (genericColorSpace.getID() != 1785221209 || byArray2 == null)) {
                if (this.formLevel < 2 && (bl5 || !bl && bl2 && genericColorSpace.getID() == 1568372915)) {
                    this.saveRawOneBitDataForResampling(bl5, imageData, byArray2, bl3, genericColorSpace, byArray, pdfObject);
                }
                if (byArray2 != null) {
                    byArray2 = genericColorSpace.convertIndexToRGB(byArray2);
                }
                genericColorSpace = OneBitDownSampler.downSample(n2, imageData, bl, bl3, byArray, byArray2, genericColorSpace);
            } else if (imageData.getDepth() == 8 && (pdfArrayIterator == null || !imageData.isDCT() && !imageData.isJPX())) {
                genericColorSpace = EightBitDownSampler.downSample(imageData, genericColorSpace, n2, byArray2);
            }
        }
        return this.convertImageDataToJavaImage(bufferedImage, imageData, fArray, pdfArrayIterator, byArray2, genericColorSpace, bl, bl4, byArray, string, bl3, pdfObject, n);
    }

    private BufferedImage convertImageDataToJavaImage(BufferedImage bufferedImage, ImageData imageData, float[] fArray, PdfArrayIterator pdfArrayIterator, byte[] byArray, GenericColorSpace genericColorSpace, boolean bl, boolean bl2, byte[] byArray2, String string, boolean bl3, PdfObject pdfObject, int n) throws RuntimeException, PdfException {
        BufferedImage bufferedImage2;
        Object object;
        Object object2;
        PdfObject pdfObject2;
        PdfObject pdfObject3;
        int n2 = imageData.getWidth();
        int n3 = imageData.getHeight();
        int n4 = imageData.getDepth();
        byte[] byArray3 = imageData.getObjectData();
        if (fArray != null && fArray.length != 0 && (pdfArrayIterator == null || !imageData.isJPX() && !imageData.isDCT()) && byArray == null) {
            ImageCommands.applyDecodeArray(byArray3, n4, fArray, genericColorSpace.getID());
        }
        if (bl) {
            bufferedImage = this.makeMaskImage(n3, n2, bufferedImage, n4, byArray3, bl2, imageData, bl, genericColorSpace, byArray2, string);
        } else if (bufferedImage == null) {
            if (pdfArrayIterator == null) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Image " + string + ' ' + n2 + "W * " + n3 + "H with No Compression at BPC " + n4);
                }
                bufferedImage = this.makeImage(genericColorSpace, n2, n3, n4, byArray3, imageData.getCompCount());
            } else if (imageData.isDCT()) {
                if (genericColorSpace.getID() == 1498837125 && this.extractRawCMYK) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Raw CMYK image " + string + " saved.");
                    }
                    if (!this.objectStoreStreamRef.saveRawCMYKImage(byArray3, string)) {
                        this.errorTracker.addPageFailureMessage("Problem saving Raw CMYK image " + string);
                    }
                }
                bufferedImage = JPegImageDecoder.decode(string, n2, n3, bl3, genericColorSpace, byArray3, fArray, imageData, pdfObject, this.errorTracker, this.parserOptions);
                if (!this.isHTML) {
                    this.optionsApplied = ImageDecoder.setRotationOptionsOnJPEGImage(this.gs, this.imageStatus, this.optionsApplied);
                }
            } else if (imageData.isJPX()) {
                bufferedImage = JPeg2000ImageDecoder.decode(string, n2, n3, genericColorSpace, byArray3, fArray, imageData, n4);
                if (!this.isHTML) {
                    this.optionsApplied = ImageDecoder.setRotationOptionsOnJPEGImage(this.gs, this.imageStatus, this.optionsApplied);
                }
            } else {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog(string + ' ' + n2 + "W * " + n3 + "H BPC=" + n4 + ' ' + genericColorSpace);
                }
                bufferedImage = this.makeImage(genericColorSpace, n2, n3, n4, byArray3, imageData.getCompCount());
            }
        }
        if (bufferedImage != null) {
            if ((bufferedImage = this.addOverPrint(genericColorSpace, byArray3, bufferedImage, imageData)) == null) {
                return null;
            }
            if (!this.current.isHTMLorSVG() && !this.parserOptions.renderDirectly() && (this.finalImagesExtracted || this.rawImagesExtracted)) {
                this.saveImage(string, this.createScaledVersion, bufferedImage, "jpg");
            }
        }
        if (bufferedImage == null && !imageData.isRemoved()) {
            this.parserOptions.imagesProcessedFully = false;
        }
        if ((pdfObject3 = this.gs.getTR()) != null) {
            bufferedImage = ImageCommands.applyTR(bufferedImage, pdfObject3, this.currentPdfFile);
        }
        if ((pdfObject2 = pdfObject.getDictionary(1888135062)) != null && pdfObject2.getInt(1010122310) != -1 && this.current.hasObjectsBehind(this.gs.CTM) && bufferedImage != null && bufferedImage.getType() != 2 && bufferedImage.getType() != 1 && (!imageData.isDCT() || pdfObject2.getInt(862279027) == 0)) {
            bufferedImage = ImageCommands.makeBlackandWhiteTransparent(bufferedImage);
        }
        if (n == 1 && imageData.getpX() > 0 && imageData.getpY() > 0 && ImageCommands.sharpenDownsampledImages && (genericColorSpace.getID() == 1568372915 || genericColorSpace.getID() == 1785221209)) {
            object2 = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            object = new ConvolveOp((Kernel)object2);
            bufferedImage = object.filter(bufferedImage, null);
        }
        if (!allowPrintTransparency && imageData.getMode() == 0 && this.isPrinting && bufferedImage != null && n4 == 1 && byArray2 != null && byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0) {
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(n5, n6, 10);
            bufferedImage2.getGraphics().setColor(Color.WHITE);
            bufferedImage2.getGraphics().fillRect(0, 0, n5, n6);
            bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
            bufferedImage = bufferedImage2;
        }
        if (bl && this.gs.nonstrokeColorSpace.getColor().isTexture()) {
            object2 = this.gs.CTM;
            object = new AffineTransform(object2[0][0], object2[0][1], object2[1][0], object2[1][1], object2[2][0], object2[2][1]);
            bufferedImage2 = ((PatternColorSpace)this.gs.nonstrokeColorSpace).getRawImage(n2, n3, (AffineTransform)object);
            BufferedImage bufferedImage3 = new BufferedImage(n2, n3, 2);
            if (bufferedImage2 != null) {
                TexturePaint texturePaint = new TexturePaint(bufferedImage2, new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                Graphics2D graphics2D = bufferedImage3.createGraphics();
                graphics2D.setPaint(texturePaint);
                Rectangle rectangle = new Rectangle(0, 0, n2, n3);
                graphics2D.fill(rectangle);
            }
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (bufferedImage.getRGB(j, i) != -16777216) continue;
                    int n7 = bufferedImage3.getRGB(j, i);
                    bufferedImage.setRGB(j, i, n7);
                }
            }
        }
        return bufferedImage;
    }

    private BufferedImage makeMaskImage(int n, int n2, BufferedImage bufferedImage, int n3, byte[] byArray, boolean bl, ImageData imageData, boolean bl2, GenericColorSpace genericColorSpace, byte[] byArray2, String string) {
        float f = (float)n / (float)n2;
        if (this.isPrinting && f < 0.1f && n2 > 4000 && n > 1 || f < 0.001f && n2 > 4000 && n > 1 || n2 == 1 && n == 1) {
            ConvertMaskToShape.convert(this.gs, this.current, this.parserOptions);
            bufferedImage = null;
        } else if (n == 2 && n3 == 1 && ImageCommands.isRepeatingLine(byArray, n)) {
            ConvertImageToShape.convert(byArray, n, this.gs, this.current, this.parserOptions);
            bufferedImage = null;
        } else {
            bufferedImage = MaskDecoder.createMaskImage(bl, this.isPrinting && !allowPrintTransparency, this.gs, this.isType3Font, this.current, byArray, bufferedImage, n2, n, imageData, bl2, n3, genericColorSpace, byArray2, string);
        }
        return bufferedImage;
    }

    private BufferedImage addOverPrint(GenericColorSpace genericColorSpace, byte[] byArray, BufferedImage bufferedImage, ImageData imageData) throws PdfException {
        int n = genericColorSpace.getID();
        if (bufferedImage != null) {
            bufferedImage = ImageCommands.simulateOverprint(genericColorSpace, byArray, imageData.isDCT(), imageData.isJPX(), bufferedImage, n, this.current, this.gs);
        }
        return bufferedImage;
    }

    public void saveRawOneBitDataForResampling(boolean bl, ImageData imageData, byte[] byArray, boolean bl2, GenericColorSpace genericColorSpace, byte[] byArray2, PdfObject pdfObject) {
        boolean bl3;
        byte[] byArray3 = imageData.getObjectData();
        int n = byArray3.length;
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        boolean bl4 = !bl && (this.parserOptions.renderDirectly() || this.useHiResImageForDisplay) && RenderUtils.isInverted(this.gs.CTM);
        boolean bl5 = bl3 = !bl && (this.parserOptions.renderDirectly() || this.useHiResImageForDisplay) && RenderUtils.isRotated(this.gs.CTM);
        if (this.parserOptions.renderDirectly()) {
            bl4 = false;
            bl3 = false;
        }
        if (bl3) {
            byArray4 = ImageOps.rotateImage(byArray4, imageData.getWidth(), imageData.getHeight(), imageData.getDepth(), 1, byArray);
            imageData.swapValues();
        }
        if (bl4) {
            byArray4 = ImageOps.invertImage(byArray4, imageData.getWidth(), imageData.getHeight(), imageData.getDepth(), 1, byArray);
        }
        if (bl2) {
            for (int i = 0; i < n; ++i) {
                byArray4[i] = (byte)(byArray4[i] ^ 0xFF);
            }
        }
        if (!(genericColorSpace.getID() == 1785221209 && byArray2 != null && imageData.getDepth() == 1 || (imageData.getWidth() >= 4000 || imageData.getHeight() >= 4000) && genericColorSpace.getID() != 1568372915 || pdfObject instanceof MaskObject)) {
            String string = this.parserOptions.getPageNumber() + String.valueOf(this.imageCount);
            if (bl) {
                this.current.getObjectStore().saveRawImageData(string, byArray4, imageData.getWidth(), imageData.getHeight(), imageData.getpX(), imageData.getpY(), byArray2, genericColorSpace.getID());
            } else {
                this.current.getObjectStore().saveRawImageData(string, byArray4, imageData.getWidth(), imageData.getHeight(), imageData.getpX(), imageData.getpY(), null, genericColorSpace.getID());
            }
        }
        if (bl3) {
            imageData.swapValues();
        }
    }

    private int setSampling(ImageData imageData, GenericColorSpace genericColorSpace) {
        int n;
        int n2;
        int n3 = 1;
        int n4 = imageData.getWidth();
        int n5 = imageData.getHeight();
        int n6 = n4;
        int n7 = n5;
        int n8 = imageData.getpX();
        int n9 = imageData.getpY();
        if (this.multiplyer <= 1.0f && !this.isPrinting) {
            n2 = 1000;
            if (genericColorSpace.getID() == 1568372915) {
                n2 = 4000;
            }
            if (n8 > n2) {
                n8 = n2;
            }
            if (n9 > n2) {
                n9 = n2;
            }
        }
        n2 = n9 << 2;
        int n10 = n8 << 2;
        while (n6 > n10 && n7 > n2) {
            n3 <<= 1;
            n6 >>= 1;
            n7 >>= 1;
        }
        int n11 = n4 / n8;
        if (n11 < 1) {
            n11 = 1;
        }
        if ((n = n5 / n9) < 1) {
            n = 1;
        }
        if ((n3 = n11) > n) {
            n3 = n;
        }
        imageData.setpX(n8);
        imageData.setpY(n9);
        return n3;
    }

    private void setDownsampledImageSize(ImageData imageData, PdfObject pdfObject, float f, GenericColorSpace genericColorSpace) {
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        if (this.isPrinting && SamplingFactory.isPrintDownsampleEnabled && n < 4000) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()) * 4);
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()) * 4);
        } else if (SamplingFactory.downsampleLevel == 2 || this.getSamplingOnly) {
            float[][] fArray = new float[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    fArray[i][j] = this.gs.CTM[i][j] < 0.0f ? -this.gs.CTM[i][j] : this.gs.CTM[i][j];
                }
            }
            if (fArray[0][0] == 0.0f || fArray[0][0] < fArray[0][1]) {
                imageData.setpX((int)fArray[0][1]);
            } else {
                imageData.setpX((int)fArray[0][0]);
            }
            if (fArray[1][1] == 0.0f || fArray[1][1] < fArray[1][0]) {
                imageData.setpY((int)fArray[1][0]);
            } else {
                imageData.setpY((int)fArray[1][1]);
            }
            if (!this.getSamplingOnly && (n < 500 || n2 < 600 && (n < 1000 || imageData.isJPX()))) {
                imageData.setpX(0);
                imageData.setpX(0);
            }
        } else if (SamplingFactory.downsampleLevel == 1) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()));
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()));
        }
        if (this.current.avoidDownSamplingImage() || n < 4000 && n2 < 4000 && this.current.isHTMLorSVG() && (imageData.getDepth() != 1 || pdfObject.getRawObjectType() != 489767739)) {
            imageData.setpX(-1);
            imageData.setpY(1);
        }
        if ((imageData.isDCT() || imageData.isJPX()) && f > 1.0f) {
            imageData.setpX((int)((float)imageData.getpX() * f));
            imageData.setpY((int)((float)imageData.getpX() * f));
        }
        if (imageData.getDepth() == 1 && pdfObject.getObjectType() != 489767739 && genericColorSpace.getID() == 1568372915 && imageData.getHeight() < 300) {
            imageData.setpX(0);
            imageData.setpY(0);
        }
    }

    static int setRotationOptionsOnJPEGImage(GraphicsState graphicsState, int n, int n2) {
        if (n > 0 && graphicsState.CTM[0][0] > 0.0f && graphicsState.CTM[0][1] > 0.0f && graphicsState.CTM[1][1] > 0.0f && graphicsState.CTM[1][0] < 0.0f) {
            if (n == 1) {
                graphicsState.CTM[0][1] = -graphicsState.CTM[0][1];
                graphicsState.CTM[1][1] = -graphicsState.CTM[1][1];
                float[] fArray = graphicsState.CTM[2];
                fArray[1] = fArray[1] - graphicsState.CTM[1][1];
            }
        } else if (n2 > 0 && graphicsState.CTM[0][0] < 0.0f && graphicsState.CTM[1][1] < 0.0f && graphicsState.CTM[0][1] == 0.0f && graphicsState.CTM[1][0] == 0.0f) {
            graphicsState.CTM[1][1] = -graphicsState.CTM[1][1];
            graphicsState.CTM[2][1] = graphicsState.CTM[2][1] - graphicsState.CTM[1][1] + graphicsState.CTM[1][0];
            float[] fArray = graphicsState.CTM[2];
            fArray[0] = fArray[0] - graphicsState.CTM[0][1];
        }
        return n2;
    }

    private void saveImage(String string, boolean bl, BufferedImage bufferedImage, String string2) {
        if (bufferedImage != null && bufferedImage.getSampleModel().getNumBands() == 1) {
            string2 = "tif";
        }
        if (this.parserOptions.isPageContent() && (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted)) {
            this.objectStoreStreamRef.saveStoredImage(string, ImageCommands.addBackgroundToMask(bufferedImage, this.isMask), false, bl, string2);
        }
    }

    private BufferedImage makeImage(GenericColorSpace genericColorSpace, int n, int n2, int n3, byte[] byArray, int n4) {
        byte[] byArray2;
        boolean bl;
        if (genericColorSpace.getID() == 1568372915) {
            byArray = ImageDecoder.correctDataArraySize(n3, n, n2, byArray);
        }
        int n5 = genericColorSpace.getID();
        BufferedImage bufferedImage = null;
        byte[] byArray3 = genericColorSpace.getIndexedMap();
        this.optionsApplied = 0;
        boolean bl2 = this.useHiResImageForDisplay && RenderUtils.isInverted(this.gs.CTM) && !this.isHTML;
        boolean bl3 = bl = this.useHiResImageForDisplay && RenderUtils.isRotated(this.gs.CTM) && !this.isHTML;
        if (bl2) {
            byArray = this.invertRawImageData(n4, n5, genericColorSpace, byArray, n, n2, n3, byArray3);
        }
        if (bl && (byArray2 = ImageOps.rotateImage(byArray, n, n2, n3, genericColorSpace.getColorComponentCount(), byArray3)) != null) {
            byArray = byArray2;
            this.optionsApplied += 2;
            int n6 = n2;
            n2 = n;
            n = n6;
        }
        if (byArray3 != null) {
            bufferedImage = IndexedImage.make(n, n2, genericColorSpace, byArray3, n3, byArray);
        } else if (n3 == 1) {
            bufferedImage = BinaryImage.make(n, n2, byArray, genericColorSpace, n3);
        } else if (n5 == -2073385820 || n5 == 960981604) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            }
            bufferedImage = genericColorSpace.dataToRGB(byArray, n, n2);
        } else {
            switch (n4) {
                case 4: {
                    if (genericColorSpace.getID() == 1785221209) {
                        bufferedImage = ColorSpaceConvertor.createARGBImage(n, n2, byArray);
                        break;
                    }
                    bufferedImage = ColorSpaceConvertor.convertFromICCCMYK(n, n2, byArray);
                    break;
                }
                case 3: {
                    bufferedImage = ThreeComponentImage.make(n3, byArray, byArray3, n, n2);
                    break;
                }
                case 1: {
                    bufferedImage = OneBitImage.make(n3, n, n2, byArray);
                }
            }
        }
        return bufferedImage;
    }

    byte[] invertRawImageData(int n, int n2, GenericColorSpace genericColorSpace, byte[] byArray, int n3, int n4, int n5, byte[] byArray2) {
        int n6 = n;
        if (n2 == -2073385820) {
            n6 = 1;
        } else if (n2 == 960981604) {
            n6 = genericColorSpace.getColorComponentCount();
        }
        byte[] byArray3 = ImageOps.invertImage(byArray, n3, n4, n5, n6, byArray2);
        if (byArray3 != null) {
            byArray = byArray3;
            ++this.optionsApplied;
        }
        return byArray;
    }

    static byte[] correctDataArraySize(int n, int n2, int n3, byte[] byArray) {
        int n4;
        int n5;
        if (n == 1) {
            int n6 = byArray.length;
            int n7 = (n2 + 7 >> 3) * n3;
            if (n6 < n7) {
                byte[] byArray2 = byArray;
                byArray = new byte[n7];
                System.arraycopy(byArray2, 0, byArray, 0, n6);
                for (int i = n6; i < n7; ++i) {
                    byArray[i] = -1;
                }
            }
        } else if (n == 8 && (n5 = byArray.length) < (n4 = n2 * n3)) {
            byte[] byArray3 = byArray;
            byArray = new byte[n4];
            System.arraycopy(byArray3, 0, byArray, 0, n5);
        }
        return byArray;
    }

    static boolean allBytesZero(byte[] byArray) {
        boolean bl = true;
        for (byte by : byArray) {
            if (by == 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setRes(PdfObjectCache pdfObjectCache) {
        this.cache = pdfObjectCache;
    }

    public int processImage(String string, int n, PdfObject pdfObject) throws Exception {
        return 0;
    }

    public int processImage(int n, int n2, byte[] byArray, int n3) throws Exception {
        return 0;
    }
}

