/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ImageUtils {
    public static BufferedImage rotateImage(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2;
        if (n == 180) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
            affineTransform.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        } else {
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(n3, n2, bufferedImage.getType());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.rotate(Math.toRadians(n), n2 / 2, n3 / 2);
            int n4 = (n2 - n3) / 2;
            if (n == 90) {
                graphics2D.drawImage((Image)bufferedImage, n4, n4, null);
            } else if (n == 270) {
                graphics2D.drawImage((Image)bufferedImage, -n4, -n4, null);
            }
        }
        return bufferedImage2;
    }

    public static BufferedImage invertImage(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage.getHeight(null));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }
}

