/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.data.ImageData;

class MaskDataDecoder {
    MaskDataDecoder() {
    }

    static byte[] applyMask(ImageData imageData, GenericColorSpace genericColorSpace, PdfObject pdfObject, PdfObject pdfObject2, byte[] byArray) {
        int[] nArray = pdfObject.getIntArray(489767739);
        byte[] byArray2 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        byArray2 = MaskDataDecoder.convertData(genericColorSpace, byArray2, n, n2, imageData, n3, 1, null);
        pdfObject2.setIntNumber(-1344207655, 8);
        byArray2 = nArray != null ? MaskDataDecoder.applyMaskArray(n, n2, byArray2, nArray) : MaskDataDecoder.applyMaskStream(byArray, imageData, genericColorSpace, pdfObject, pdfObject2);
        float[] fArray = pdfObject.getFloatArray(859785322);
        if (fArray != null) {
            ImageCommands.applyDecodeArray(byArray2, fArray.length / 2, fArray, 1785221209);
        }
        return byArray2;
    }

    static BufferedImage applyMaskArray(ImageData imageData, int[] nArray) {
        int n = imageData.getDepth();
        int n2 = nArray.length / 2;
        int n3 = imageData.getWidth() * imageData.getHeight();
        BufferedImage bufferedImage = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        byte[] byArray = imageData.getObjectData();
        switch (n) {
            case 1: 
            case 2: 
            case 4: {
                BitReader bitReader = new BitReader(byArray, true);
                for (int i = 0; i < n3; ++i) {
                    boolean bl;
                    if (n2 == 1) {
                        int n4 = bitReader.getPositive(n);
                        boolean bl2 = bl = n4 >= nArray[0] && n4 <= nArray[1];
                        if (bl) continue;
                        nArray2[i] = 0xFF000000 | (n4 ^= 0xFF) << 16 | n4 << 8 | n4;
                        continue;
                    }
                    int n5 = bitReader.getPositive(n);
                    int n6 = bitReader.getPositive(n);
                    int n7 = bitReader.getPositive(n);
                    boolean bl3 = bl = n5 >= nArray[0] && n5 <= nArray[1] && n6 >= nArray[2] && n6 <= nArray[3] && n7 >= nArray[4] && n7 <= nArray[5];
                    if (bl) continue;
                    nArray2[i] = 0xFF000000 | (n5 ^= 0xFF) << 16 | (n6 ^= 0xFF) << 8 | (n7 ^= 0xFF);
                }
                break;
            }
            case 8: {
                int n8 = 0;
                if (n2 == 1) {
                    for (int i = 0; i < n3; ++i) {
                        int n9;
                        boolean bl;
                        boolean bl4 = bl = (n9 = byArray[n8++] & 0xFF) >= nArray[0] && n9 <= nArray[1];
                        if (bl) continue;
                        nArray2[i] = 0xFF000000 | n9 << 16 | n9 << 8 | n9;
                    }
                } else if (n2 == 3) {
                    for (int i = 0; i < n3; ++i) {
                        boolean bl;
                        int n10 = byArray[n8++] & 0xFF;
                        int n11 = byArray[n8++] & 0xFF;
                        int n12 = byArray[n8++] & 0xFF;
                        boolean bl5 = bl = n10 >= nArray[0] && n10 <= nArray[1] && n11 >= nArray[2] && n11 <= nArray[3] && n12 >= nArray[4] && n12 <= nArray[5];
                        if (bl) continue;
                        nArray2[i] = 0xFF000000 | n10 << 16 | n11 << 8 | n12;
                    }
                } else {
                    if (n2 != 4) break;
                    EnumeratedSpace enumeratedSpace = new EnumeratedSpace();
                    for (int i = 0; i < n3; ++i) {
                        boolean bl;
                        int n13 = byArray[n8++] & 0xFF;
                        int n14 = byArray[n8++] & 0xFF;
                        int n15 = byArray[n8++] & 0xFF;
                        int n16 = byArray[n8++] & 0xFF;
                        boolean bl6 = bl = n13 >= nArray[0] && n13 <= nArray[1] && n14 >= nArray[2] && n14 <= nArray[3] && n15 >= nArray[4] && n15 <= nArray[5] && n16 >= nArray[4] && n16 <= nArray[5];
                        if (bl) continue;
                        byte[] byArray2 = enumeratedSpace.getRGB((byte)n13, (byte)n14, (byte)n15, (byte)n16);
                        int n17 = byArray2[0] & 0xFF;
                        int n18 = byArray2[1] & 0xFF;
                        int n19 = byArray2[2] & 0xFF;
                        nArray2[i] = 0xFF000000 | n17 << 16 | n18 << 8 | n19;
                    }
                }
                break;
            }
        }
        return bufferedImage;
    }

    static byte[] applySMask(byte[] byArray, ImageData imageData, GenericColorSpace genericColorSpace, PdfObject pdfObject, PdfObject pdfObject2) {
        byte[] byArray2 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        int n4 = pdfObject.getInt(959726687);
        int n5 = pdfObject.getInt(959926393);
        int n6 = pdfObject.getInt(-1344207655);
        byArray2 = MaskDataDecoder.convertData(genericColorSpace, byArray2, n, n2, imageData, n3, n6, byArray);
        if (n6 != 8) {
            byArray = ColorSpaceConvertor.normaliseTo8Bit(n6, n4, n5, byArray);
        }
        if (n == n4 && n2 == n5) {
            byArray2 = MaskDataDecoder.buildUnscaledByteArray(n, n2, byArray2, byArray);
        } else if (n < n4) {
            byArray2 = MaskDataDecoder.upScaleImageToMask(n, n2, n4, n5, byArray2, byArray);
            pdfObject2.setIntNumber(959726687, n4);
            pdfObject2.setIntNumber(959926393, n5);
        } else {
            byArray2 = MaskDataDecoder.upScaleMaskToImage(n, n2, n4, n5, byArray2, byArray);
        }
        pdfObject2.setIntNumber(-1344207655, 8);
        return byArray2;
    }

    static byte[] applyMaskStream(byte[] byArray, ImageData imageData, GenericColorSpace genericColorSpace, PdfObject pdfObject, PdfObject pdfObject2) {
        byte[] byArray2 = imageData.getObjectData();
        int n = imageData.getWidth();
        int n2 = imageData.getHeight();
        int n3 = imageData.getDepth();
        int n4 = pdfObject.getInt(959726687);
        int n5 = pdfObject.getInt(959926393);
        int n6 = pdfObject.getInt(-1344207655);
        if (n6 != 8) {
            byArray = ColorSpaceConvertor.normaliseTo8Bit(n6, n4, n5, byArray);
        }
        if (n == n4 && n2 == n5) {
            byArray2 = MaskDataDecoder.buildUnscaledByteArray(n, n2, byArray2, byArray);
        } else if (n < n4) {
            byArray2 = MaskDataDecoder.upScaleImageToMask(n, n2, n4, n5, byArray2, byArray);
            pdfObject2.setIntNumber(959726687, n4);
            pdfObject2.setIntNumber(959926393, n5);
        } else {
            byArray2 = MaskDataDecoder.upScaleMaskToImage(n, n2, n4, n5, byArray2, byArray);
        }
        pdfObject2.setIntNumber(-1344207655, 8);
        return byArray2;
    }

    static byte[] convertSmaskData(GenericColorSpace genericColorSpace, byte[] byArray, int n, int n2, ImageData imageData, int n3, int n4, byte[] byArray2, PdfObject pdfObject) {
        byte[] byArray3 = genericColorSpace.getIndexedMap();
        if (byArray3 != null) {
            byArray3 = genericColorSpace.convertIndexToRGB(byArray3);
            byArray = ColorSpaceConvertor.convertIndexToRGBByte(byArray3, n, n2, imageData.getCompCount(), imageData.getDepth(), byArray, false, false);
        } else if (genericColorSpace.getID() != 1008872003) {
            if (genericColorSpace.getID() == 1785221209) {
                float[] fArray;
                if (n3 == 8) {
                    MaskDataDecoder.check4BitData(byArray);
                }
                if ((fArray = pdfObject.getFloatArray(859785322)) != null && fArray[0] == 1.0f && fArray[1] == 0.0f) {
                    int n5 = 0;
                    while (n5 < byArray2.length) {
                        int n6 = n5++;
                        byArray2[n6] = (byte)(byArray2[n6] ^ 0xFF);
                    }
                }
            } else if (genericColorSpace.getID() == 1568372915 && imageData.isJPX()) {
                if (byArray2 != null && n4 == 1) {
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                    }
                }
            } else if (!imageData.isDCT() && !imageData.isJPX()) {
                byArray = genericColorSpace.dataToRGBByteArray(byArray, n, n2, false);
            }
        }
        return byArray;
    }

    static byte[] convertData(GenericColorSpace genericColorSpace, byte[] byArray, int n, int n2, ImageData imageData, int n3, int n4, byte[] byArray2) {
        byte[] byArray3 = genericColorSpace.getIndexedMap();
        if (byArray3 != null) {
            byArray3 = genericColorSpace.convertIndexToRGB(byArray3);
            byArray = ColorSpaceConvertor.convertIndexToRGBByte(byArray3, n, n2, imageData.getCompCount(), imageData.getDepth(), byArray, false, false);
        } else if (genericColorSpace.getID() != 1008872003) {
            if (genericColorSpace.getID() == 1785221209) {
                if (n3 == 8) {
                    MaskDataDecoder.check4BitData(byArray);
                }
                if (byArray2 != null && n4 == 1) {
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                    }
                }
            } else if (genericColorSpace.getID() == 1568372915 && imageData.isJPX()) {
                if (byArray2 != null && n4 == 1) {
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                    }
                }
            } else if (!imageData.isDCT() && !imageData.isJPX()) {
                byArray = genericColorSpace.dataToRGBByteArray(byArray, n, n2, false);
            }
        }
        return byArray;
    }

    static void check4BitData(byte[] byArray) {
        int n = byArray.length;
        boolean bl = true;
        for (byte by : byArray) {
            if (by >= 0 && by <= 15) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = (byte)(byArray[i] << 4);
            }
        }
    }

    private static byte[] upScaleMaskToImage(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n3 / (float)n;
        float f2 = (float)n4 / (float)n2;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n7 = byArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        if (n5 < n7) {
                            byArray3[n6 + k] = byArray[n5];
                        }
                        ++n5;
                    }
                    int n8 = (int)((float)j * f) + (int)((float)i * f2) * n;
                    byArray3[n6 + 3] = byArray2[n8];
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    private static byte[] upScaleImageToMask(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2) {
        int n5 = 0;
        int n6 = 0;
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        byte[] byArray3 = new byte[n3 * n4 * 4];
        int n7 = byArray.length;
        int n8 = byArray2.length;
        try {
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n9 = (int)((float)j * f) * 3 + (int)((float)i * f2) * n * 3;
                    for (int k = 0; k < 3; ++k) {
                        if (n9 < n7) {
                            byArray3[n6 + k] = byArray[n9];
                        }
                        ++n9;
                    }
                    if (n5 < n8) {
                        byArray3[n6 + 3] = byArray2[n5];
                        ++n5;
                    }
                    n6 += 4;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }

    static byte[] getSMaskData(byte[] byArray, ImageData imageData, PdfObject pdfObject, GenericColorSpace genericColorSpace) {
        imageData.getFilter(pdfObject);
        if (imageData.isDCT()) {
            byArray = JPEGDecoder.getBytesFromJPEG(byArray, genericColorSpace, pdfObject);
            pdfObject.setMixedArray(1011108731, null);
            pdfObject.setDecodedStream(byArray);
        } else if (imageData.isJPX()) {
            byArray = JPeg2000ImageDecoder.getBytesFromJPEG2000(byArray, genericColorSpace, pdfObject);
            pdfObject.setMixedArray(1011108731, null);
            pdfObject.setDecodedStream(byArray);
        }
        return byArray;
    }

    private static byte[] applyMaskArray(int n, int n2, byte[] byArray, int[] nArray) {
        int n3 = n * n2 * 4;
        int n4 = 0;
        byte[] byArray2 = new byte[n * n2 * 4];
        int n5 = byArray.length;
        float f = 0.0f;
        if (nArray != null && (f = (float)(nArray[1] - nArray[0])) > 1.0f) {
            f /= 255.0f;
        }
        try {
            for (int i = 0; i < n3; i += 4) {
                for (int j = 0; j < 3; ++j) {
                    if (n4 < n5) {
                        byArray2[i + j] = f > 0.0f ? (byte)((float)byArray[n4] * f) : byArray[n4];
                    }
                    ++n4;
                }
                byArray2[i + 3] = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    private static byte[] buildUnscaledByteArray(int n, int n2, byte[] byArray, byte[] byArray2) {
        int n3 = n * n2 * 4;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray3 = new byte[n * n2 * 4];
        int n6 = byArray.length;
        int n7 = byArray2.length;
        try {
            for (int i = 0; i < n3; i += 4) {
                for (int j = 0; j < 3; ++j) {
                    if (n4 < n6) {
                        byArray3[i + j] = byArray[n4];
                    }
                    ++n4;
                }
                if (n5 >= n7) continue;
                byArray3[i + 3] = byArray2[n5];
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray3;
    }
}

