/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import org.jpedal.images.ImageOps;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.utils.LogWriter;

class ThreeComponentImage {
    ThreeComponentImage() {
    }

    public static BufferedImage make(int n, byte[] byArray, byte[] byArray2, int n2, int n3) {
        BufferedImage bufferedImage;
        if (n == 16) {
            int n4 = byArray.length;
            int n5 = n4 / 2;
            byte[] byArray3 = new byte[n5];
            for (int i = 0; i < n5; ++i) {
                byArray3[i] = byArray[i * 2];
            }
            byArray = byArray3;
            n = 8;
        }
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Converting 3 comp colorspace to sRGB index=" + Arrays.toString(byArray2));
        }
        if (n2 * n3 == byArray.length) {
            bufferedImage = ThreeComponentImage.makeIndexImage(n, byArray2, n2, n3, byArray);
        } else {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Converting data to sRGB " + byArray.length + " depth=" + n);
            }
            bufferedImage = ThreeComponentImage.makeImage(n, byArray, n2, n3);
        }
        return bufferedImage;
    }

    static BufferedImage makeImage(int n, byte[] byArray, int n2, int n3) {
        if (n == 4) {
            byArray = ThreeComponentImage.expand4bitData(byArray, n2, n3);
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        byArray = ImageOps.checkSize(byArray, n2, n3, 3);
        Raster raster = ColorSpaceConvertor.createInterleavedRaster(byArray, n2, n3);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    static byte[] expand4bitData(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        int n4 = n * n2 * 3;
        boolean bl = (n & 1) == 1;
        int n5 = n * 3 + 1 >> 1;
        byte[] byArray2 = new byte[n4];
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            ++n7;
            byArray2[n6] = (byte)(by & 0xF0);
            if (byArray2[n6] == -16) {
                byArray2[n6] = -1;
            }
            ++n6;
            if (n7 == n5 && bl) {
                n7 = 0;
            } else {
                byArray2[n6] = (byte)((by & 0xF) << 4);
                if (byArray2[n6] == -16) {
                    byArray2[n6] = -1;
                }
                ++n6;
            }
            if (n6 != n4) continue;
            i = n3;
        }
        byArray = byArray2;
        return byArray;
    }

    static BufferedImage makeIndexImage(int n, byte[] byArray, int n2, int n3, byte[] byArray2) {
        BufferedImage bufferedImage;
        if (n == 8 && byArray != null) {
            bufferedImage = ColorSpaceConvertor.convertIndexedToFlat(n, n2, n3, byArray2, byArray, false, false);
        } else {
            DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
            int[] nArray = new int[]{0};
            bufferedImage = new BufferedImage(n2, n3, 10);
            WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n2, n3, n2, 1, nArray, null);
            bufferedImage.setData(writableRaster);
        }
        return bufferedImage;
    }
}

