/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jpedal.color.ColorSpaces;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.ImageDisplay;

public class PDFtoImageConvertorSwing
extends PDFtoImageConvertor {
    public PDFtoImageConvertorSwing(float f, DecoderOptions decoderOptions) {
        super(f, decoderOptions);
    }

    @Override
    public DynamicVectorRenderer getDisplay(int n, ObjectStore objectStore) {
        this.imageDisplay = new ImageDisplay(n, true, 5000, objectStore);
        return this.imageDisplay;
    }

    public static AffineTransform setPageParametersForImage(float f, int n, PdfPageData pdfPageData) {
        AffineTransform affineTransform = new AffineTransform();
        int n2 = pdfPageData.getCropBoxWidth(n);
        int n3 = pdfPageData.getCropBoxHeight(n);
        int n4 = pdfPageData.getCropBoxX(n);
        int n5 = pdfPageData.getCropBoxY(n);
        int n6 = (int)((float)n2 * f);
        int n7 = (int)((float)n3 * f);
        int n8 = pdfPageData.getRotation(n);
        affineTransform.translate((float)(-n4) * f, (float)n5 * f);
        if (n8 == 270) {
            affineTransform.rotate(-1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d2 = affineTransform.getTranslateY();
            affineTransform.translate((double)n7 - d2, -d);
            if (n5 < 0) {
                affineTransform.translate((float)(2 * n5) * f, (float)(2 * n5) * f);
            } else {
                affineTransform.translate((float)(2 * n5) * f, 0.0);
            }
            affineTransform.translate(0.0, -f * (float)(pdfPageData.getCropBoxHeight(n) - pdfPageData.getMediaBoxHeight(n)));
        } else if (n8 == 180) {
            affineTransform.rotate(Math.PI, n6 / 2, n7 / 2);
        } else if (n8 == 90) {
            affineTransform.rotate(1.5707963267948966, n6 / 2, n7 / 2);
            double d = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            affineTransform.translate(-d3, (double)n6 - d);
        }
        affineTransform.translate(n6, n7);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(-n6, 0.0);
        affineTransform.scale(f, f);
        return affineTransform;
    }

    @Override
    public BufferedImage pageToImage(boolean bl, PdfStreamDecoder pdfStreamDecoder, float f, PdfObject pdfObject) throws PdfException {
        BufferedImage bufferedImage = new BufferedImage(this.w, this.h, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!bl) {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.w, this.h);
        }
        if (this.rotation == 180) {
            graphics2D.translate(this.crx * 2.0f * this.multiplyer, -(this.cry * 2.0f * this.multiplyer));
        }
        this.imageDisplay.setScalingValues(this.crx * this.multiplyer, this.crh * this.multiplyer + this.cry, this.multiplyer * f);
        graphics2D.setRenderingHints(ColorSpaces.hints);
        graphics2D.transform(this.imageScaling);
        if (this.rotated) {
            if (this.rotation == 90) {
                if (this.multiplyer < 1.0f) {
                    this.cry = (int)(this.imageScaling.getTranslateX() + (double)this.cry);
                    this.crx = (int)(this.imageScaling.getTranslateY() + (double)this.crx);
                } else {
                    this.cry = (int)(this.imageScaling.getTranslateX() / (double)this.multiplyer + (double)this.cry);
                    this.crx = (int)(this.imageScaling.getTranslateY() / (double)this.multiplyer + (double)this.crx);
                }
                this.crx /= f;
                this.cry /= f;
                graphics2D.translate(-this.crx, -this.cry);
            } else if (this.cry < 0.0f) {
                graphics2D.translate(-(this.crx / f), ((float)this.mediaH - this.crh + this.cry) / f);
            } else {
                graphics2D.translate(-(this.crx / f), ((float)this.mediaH - this.crh - this.cry) / f);
            }
        }
        pdfStreamDecoder.setObjectValue(-7, graphics2D);
        this.imageDisplay.setG2(graphics2D);
        pdfStreamDecoder.decodePageContent(pdfObject);
        graphics2D.setClip(null);
        return bufferedImage;
    }
}

