/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;

public class GlyphData {
    private boolean firstTime = true;
    private int textLength;
    private int numOfPrefixes;
    private float fontScale;
    private char lastChar;
    private char openChar;
    private int fontSize;
    private int charSize = 2;
    private String displayValue;
    private String unicodeValue;
    private boolean isHorizontal;
    private boolean inText;
    private char rawChar;
    private float actualWidth;
    private int rawInt;
    private int valueForHTML = -1;
    private boolean isXMLExtraction = true;
    private float leading;
    private float width;
    private float spacingAdded;

    public int getRawInt() {
        return this.rawInt;
    }

    public void setRawInt(int n) {
        this.rawInt = n;
    }

    public void setRaw(int n) {
        this.rawInt = n;
        this.rawChar = (char)n;
    }

    public float getLeading() {
        return this.leading;
    }

    public void setLeading(float f) {
        this.leading = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getSpacingAdded() {
        return this.spacingAdded;
    }

    public void setSpacingAdded(float f) {
        this.spacingAdded = f;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String string) {
        this.displayValue = string;
    }

    public String getUnicodeValue() {
        return this.unicodeValue;
    }

    public void setUnicodeValue(String string) {
        this.unicodeValue = string;
    }

    void resetValues() {
        this.inText = false;
        this.isHorizontal = false;
    }

    void reset() {
        this.firstTime = true;
        this.textLength = 0;
        this.rawChar = (char)32;
        this.displayValue = "";
        this.unicodeValue = "";
        this.spacingAdded = 0.0f;
        this.leading = 0.0f;
        this.width = 0.0f;
        this.rawInt = 0;
        this.actualWidth = 0.0f;
        this.valueForHTML = -1;
        this.lastChar = (char)32;
        this.openChar = (char)32;
        this.numOfPrefixes = 0;
    }

    void set(String string) {
        this.displayValue = string;
        this.unicodeValue = string;
    }

    boolean isText() {
        return this.inText;
    }

    void setText(boolean bl) {
        this.inText = bl;
    }

    boolean isHorizontal() {
        return this.isHorizontal;
    }

    void setHorizontal(boolean bl) {
        this.isHorizontal = bl;
    }

    void setXMLExtraction(boolean bl) {
        this.isXMLExtraction = bl;
    }

    boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    void updateGlyphSettings(float f, char c) {
        this.width += f;
        this.leading += f;
        this.spacingAdded += this.leading;
        this.rawChar = c;
    }

    void subtractLeading(float f) {
        this.leading -= f;
    }

    void addToWidth(float f) {
        ++this.textLength;
        this.width += f;
    }

    char getRawChar() {
        return this.rawChar;
    }

    void setRawChar(char c) {
        this.rawChar = c;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float f) {
        this.fontScale = f;
    }

    void setActualWidth(float f) {
        this.actualWidth = f;
    }

    float getActualWidth() {
        return this.actualWidth;
    }

    public int getValueForHTML() {
        return this.valueForHTML;
    }

    public void setValueForHTML(int n) {
        this.valueForHTML = n;
    }

    void setDefaultCharSize(PdfFont pdfFont) {
        this.setCharSize(2);
        if (pdfFont.isCIDFont() && !pdfFont.isSingleByte()) {
            this.setCharSize(4);
        }
    }

    public int getCharSize() {
        return this.charSize;
    }

    public void setCharSize(int n) {
        this.charSize = n;
    }

    int getFontSize() {
        return this.fontSize;
    }

    void setFontSize(int n) {
        this.fontSize = n;
    }

    void setLastChar(char c) {
        this.lastChar = c;
    }

    char getLastChar() {
        return this.lastChar;
    }

    char getOpenChar() {
        return this.openChar;
    }

    void setOpenChar(char c) {
        this.openChar = c;
    }

    void updatePrefixCount(char c) {
        if (c == '(') {
            ++this.numOfPrefixes;
        } else if (c == ')') {
            if (this.numOfPrefixes <= 0) {
                this.inText = false;
            } else {
                --this.numOfPrefixes;
            }
        }
    }

    void setLastChar() {
        this.lastChar = this.lastChar == '\\' && this.rawChar == '\\' ? (char)120 : this.rawChar;
    }

    int getTextLength() {
        return this.textLength;
    }

    boolean isfirstTime() {
        return this.firstTime;
    }

    void setFirstTime(boolean bl) {
        this.firstTime = bl;
    }
}

