/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.parser.ParserOptions;
import org.jpedal.parser.text.GlyphData;
import org.jpedal.parser.text.TD;

class HexTextUtils {
    HexTextUtils() {
    }

    static int getHexValue(byte[] byArray, int n, GlyphData glyphData, PdfFont pdfFont, ParserOptions parserOptions) {
        int n2 = 0;
        int n3 = glyphData.getCharSize();
        for (int i = 1; i < n3; ++i) {
            byte by = byArray[n + i];
            if (by == 62) {
                i = 4;
                n3 = 2;
                glyphData.setCharSize(2);
                continue;
            }
            if (by == 10 || by == 13) {
                ++n;
                --i;
                continue;
            }
            ++n2;
        }
        return HexTextUtils.setValue(glyphData, HexTextUtils.getValue(n2, byArray, n), n, n3, pdfFont, parserOptions);
    }

    static int getHexCIDValue(byte[] byArray, int n, GlyphData glyphData, PdfFont pdfFont, ParserOptions parserOptions) {
        char c;
        int n2;
        int n3 = 2;
        int n4 = HexTextUtils.getValue(1, byArray, n);
        HexTextUtils.setValue(glyphData, n4, n, n3, pdfFont, parserOptions);
        if (StandardFonts.CMAP == null) {
            StandardFonts.readCMAP();
        }
        boolean bl = glyphData.getRawInt() > 0 && pdfFont.CMapName != null && pdfFont.getFontType() == -1684566726 && pdfFont.getGlyphData().getCharStrings().containsKey(String.valueOf(glyphData.getRawInt()));
        boolean bl2 = false;
        if (!(pdfFont.CMapName != null && pdfFont.CMapName.equals("OneByteIdentityH") || byArray[n] == 62 || bl || (n2 = pdfFont.isDoubleBytes(n4, (c = (char)HexTextUtils.getValue(3, byArray, n)) & 0xFF, false)) != 1 && pdfFont.glyphs.getEmbeddedGlyph(new T1GlyphFactory(false), null, null, c, "", -1.0f, null) == null)) {
            bl2 = true;
            n4 = c;
            n3 = 4;
        }
        if (bl2) {
            return HexTextUtils.setValue(glyphData, n4, n, n3, pdfFont, parserOptions);
        }
        return n + 1;
    }

    private static int setValue(GlyphData glyphData, int n, int n2, int n3, PdfFont pdfFont, ParserOptions parserOptions) {
        glyphData.setRawInt(n);
        n2 = n2 + n3 - 1;
        glyphData.setRawChar((char)n);
        glyphData.setDisplayValue(pdfFont.getGlyphValue(n));
        if (pdfFont.isCIDFont() && pdfFont.getCMAP() != null && pdfFont.getUnicodeMapping(n) == null) {
            glyphData.setRawChar(glyphData.getDisplayValue().charAt(0));
            glyphData.setRawInt(glyphData.getRawChar());
        }
        if (parserOptions.isTextExtracted()) {
            glyphData.setUnicodeValue(pdfFont.getUnicodeValue(glyphData.getDisplayValue(), glyphData.getRawInt()));
        }
        return n2;
    }

    private static int getValue(int n, byte[] byArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n + 1; ++i) {
            int n5 = byArray[n2 + n - i];
            if (n5 >= 65 && n5 <= 70) {
                n5 -= 55;
            } else if (n5 >= 97 && n5 <= 102) {
                n5 -= 87;
            } else {
                if (n5 < 48 || n5 > 57) continue;
                n5 -= 48;
            }
            n4 += n5 << TD.multiply16[n3];
            ++n3;
        }
        return n4;
    }
}

