/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.objects.TextState;
import org.jpedal.utils.Matrix;

public class TD {
    static final int[] multiply8 = new int[]{0, 3, 6, 9, 12, 15};
    static final int[] multiply16 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};

    public static void execute(boolean bl, float f, float f2, TextState textState) {
        TD.relativeMove(f, f2, textState);
        if (!bl) {
            float f3 = -f2;
            textState.setLeading(f3);
        }
    }

    public static void relativeMove(float f, float f2, TextState textState) {
        float[][] fArray = new float[3][3];
        textState.Tm = textState.getTMAtLineStart();
        fArray[0][0] = 1.0f;
        fArray[0][1] = 0.0f;
        fArray[0][2] = 0.0f;
        fArray[1][0] = 0.0f;
        fArray[1][1] = 1.0f;
        fArray[1][2] = 0.0f;
        fArray[2][0] = f;
        fArray[2][1] = f2;
        fArray[2][2] = 1.0f;
        textState.Tm = Matrix.multiply(fArray, textState.Tm);
        textState.setTMAtLineStart();
    }

    static int readEscapeValue(int n, int n2, int n3, byte[] byArray) {
        int n4;
        switch (n3) {
            case 8: {
                n4 = TD.getOctal(n, n2, byArray);
                break;
            }
            case 16: {
                n4 = TD.getHex(n, n2, byArray);
                break;
            }
            default: {
                n4 = TD.getGeneral(n, n2, n3, byArray);
            }
        }
        return n4;
    }

    private static int getGeneral(int n, int n2, int n3, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(10);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append((char)byArray[n + i]);
        }
        return Integer.parseInt(stringBuilder.toString(), n3);
    }

    private static int getHex(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i < n2 + 1; ++i) {
            int n5 = byArray[n + n2 - i];
            if (n5 >= 65 && n5 <= 70) {
                n5 -= 55;
            } else if (n5 >= 97 && n5 <= 102) {
                n5 -= 87;
            } else {
                if (n5 < 48 || n5 > 57) continue;
                n5 -= 48;
            }
            n3 += n5 << multiply16[n4];
            ++n4;
        }
        return n3;
    }

    private static int getOctal(int n, int n2, byte[] byArray) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i < n2 + 1; ++i) {
            int n5 = byArray[n + n2 - i];
            if (n5 < 48 || n5 > 55) continue;
            n4 += (n5 -= 48) << multiply8[n3];
            ++n3;
        }
        return n4;
    }

    static String getString(int n, int n2, byte[] byArray) {
        while (byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10) {
            --n2;
        }
        int n3 = n2 - n + 1;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i <= 0 || byArray[n + i] != 32 && byArray[n + i] != 13 && byArray[n + i] != 10 || byArray[n + i - 1] != 32 && byArray[n + i - 1] != 13 && byArray[n + i - 1] != 10) continue;
            ++n4;
        }
        char[] cArray = new char[n3 - n4];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i > 0 && (byArray[n + i] == 32 || byArray[n + i] == 13 || byArray[n + i] == 10) && (byArray[n + i - 1] == 32 || byArray[n + i - 1] == 13 || byArray[n + i - 1] == 10)) continue;
            cArray[n5] = byArray[n + i] == 10 || byArray[n + i] == 13 ? 32 : (char)byArray[n + i];
            ++n5;
        }
        String string = String.copyValueOf(cArray);
        return string;
    }
}

